import matplotlib as mpl

from . import distinctipy

colors = {
    "normal": [
        (0.8567401647718771, 0.005665213328508778, 0.9347769926511403),
        (0.0, 1.0, 0.0),
        (0.006640993017987151, 0.5745449885858733, 0.9561049108599794),
        (0.9479660083234648, 0.5313054609750606, 0.0038526653428854196),
        (0.04898783995914846, 0.0015506210739167914, 0.7230939530897698),
        (0.28596849831841153, 0.4892901736230746, 0.2884578976658141),
        (0.7340865348903434, 0.0046544427034181934, 0.14817615595945544),
        (0.6544134883372197, 0.9822675366047239, 0.33992994848483815),
        (0.7000380856280771, 0.5319549478821787, 0.8472785522473714),
        (0.0007486371992666552, 0.991754858259391, 0.623838173249438),
        (0.45718161393566903, 0.9395229206901177, 0.9977273969871439),
        (0.9908933959131556, 0.2563429059128336, 0.48919705278097847),
        (0.38912705424756067, 0.22050581204861375, 0.9906310028414881),
        (0.9906073238311253, 0.7191574537772417, 0.5016828017740506),
        (0.45468522965515723, 0.16171949931171425, 0.4994584664609437),
        (1.0, 1.0, 0.0),
        (0.5384909410215842, 0.6929307102481495, 0.004194109398447776),
        (0.3752203856273857, 0.7564216658005983, 0.601357472389723),
        (0.004828693458973188, 0.2080603661113063, 0.34375124288485237),
        (0.5818648699542364, 0.33990349224241523, 0.0003049998354711647),
        (0.7044578875698103, 0.48474092418614945, 0.3882606044081929),
        (0.022375314729641604, 0.6619470572431797, 0.026545140976459103),
        (0.13183988718627904, 0.3981814300369996, 0.6480902575513249),
        (0.012458480322754983, 0.9123040931572093, 0.9989096109455471),
        (0.999631320374923, 0.3388077864412964, 0.9392093670178895),
        (0.25443231305504466, 0.9215069502721477, 0.29100011379267854),
        (0.739863820874968, 0.8948456781362333, 0.7259108912508359),
        (0.17708527305855304, 0.29366425742373126, 0.0009338369238219846),
        (0.009231403806075233, 0.6695191340625722, 0.48411168299683616),
        (0.9874206144451185, 0.21114814385327774, 0.028212141230080867),
        (0.9829703497891651, 0.690520112279313, 0.9716476246548381),
        (0.6927097874145065, 0.2405157433244386, 0.7753155356039206),
        (0.5, 1.0, 0.0),
        (0.3918466502202065, 0.0076624329257254375, 0.02693391919900312),
        (0.7807607865408734, 0.017976414663609663, 0.5503063823913174),
        (0.002905533829364093, 0.28202073412013773, 0.9887055931098837),
        (0.3988921701991185, 0.6466942652646179, 0.9863701682446284),
        (1.0, 1.0, 0.5),
        (0.8448286199658375, 0.7725870006527064, 0.18379333788877206),
        (0.45997324941801765, 0.011890582720997411, 0.7817738176336759),
        (0.2767497611719306, 0.0006479624966205799, 0.3245120735126059),
        (0.4570489079878668, 0.47312326339238975, 0.6129950331013163),
        (0.9584196792847922, 0.47632556292223216, 0.6453109168721669),
        (0.5773185859801653, 0.7296847847859498, 0.3459691239667605),
        (0.7206227848080444, 0.2193734337327461, 0.32421624049951336),
        (0.37984954466578214, 0.9939569179337614, 0.7078106722568822),
        (0.07518591414362963, 0.761812190399373, 0.7509159580266213),
        (0.0, 0.0, 1.0),
        (0.9970129779919075, 0.02940985606857538, 0.3122694154531085),
        (0.30301130570377555, 0.5323249678525694, 0.002143992981387788),
        (0.4041482486934278, 0.24639639471914676, 0.2153722749769449),
        (0.32201831298757355, 0.4361210601337957, 0.8744502065876786),
        (0.9979074506055765, 0.4778140572736008, 0.31743746423354513),
        (0.6905964314096978, 0.7662572319113271, 0.9889948998452361),
        (0.23880012436399323, 0.8454945231136562, 0.026244215102918966),
        (0.21149174210506339, 0.19836779310460584, 0.76897682718218),
        (0.732895090196672, 0.6613218853410909, 0.5911180805006573),
        (0.20425861523324085, 0.708206940953201, 0.23244501324813927),
        (0.009650382034612659, 0.4255856397666752, 0.4142712055251291),
        (0.021868292505932474, 0.013544621096037046, 0.4667310079253254),
        (0.006414412482937171, 0.4616652606502585, 0.11321493946287775),
        (0.9750223777675746, 0.1371280113277672, 0.7430991309168682),
        (0.8313980918757051, 0.36138308760722804, 0.13984519480910773),
        (0.9885521908406414, 0.8490523714106682, 0.7391247801495607),
        (0.2908076428874746, 0.014795188979523255, 0.9917427964324297),
        (1.0, 0.0, 0.0),
        (0.7602614515645822, 0.9618642663227569, 0.08125409316039756),
        (0.5476152142085375, 0.5103166390351667, 0.16109027723753355),
        (0.005265054947602099, 0.8765172522818846, 0.41837258363346097),
        (0.2836912585501603, 0.3339603660503804, 0.4524680600910227),
        (0.5799804406259388, 0.0006715546133980732, 0.3774485003536706),
        (0.6309263802320567, 0.08964910227315814, 0.9950947836254628),
        (0.5674906003952811, 0.3801818861517311, 0.9856851898144219),
        (0.25169269087401247, 0.585871892476988, 0.6995080049124208),
        (0.7148918630840949, 0.9966269992264677, 0.958266841326834),
        (0.18469487186258482, 0.12004511836983811, 0.12819520911767135),
        (0.023403998459900266, 0.20246885383313418, 0.5864813462129783),
        (0.544247140443485, 0.693950481954476, 0.7785732546968176),
        (0.2813612756667969, 0.021624588600397288, 0.5679193891948688),
        (0.010938711580785965, 0.8498611022669282, 0.166198277395605),
        (0.28885307092626467, 0.8160303096070854, 0.8893115411919501),
        (0.42755920843703976, 0.9237534905334385, 0.476705593757923),
        (0.6329355423241689, 0.3416971023220159, 0.5485111765990612),
        (0.47341175899679033, 0.8680184560334802, 0.18382505061059873),
        (0.4482819225428607, 0.28964342442456825, 0.7333530133535822),
        (0.5852567162137479, 0.1326531938223079, 0.03498999549366999),
        (0.8147813322250974, 0.8562503273632989, 0.4607667691948658),
        (0.16545766768656722, 0.9930954145271584, 0.8317686550426934),
        (0.7447597019735162, 0.6069922651417138, 0.04992521470015565),
        (0.004787507663429391, 0.003522415606316831, 0.22046638879024139),
        (0.4172384491882488, 0.6063882518876772, 0.45048424871020554),
        (0.9036303035853439, 0.5117439756177168, 0.9620900912409118),
        (0.013429549178896716, 0.5870744617761952, 0.28745612401350484),
        (0.8235991865726615, 0.2044436319329086, 0.9902312258781991),
        (0.9985395678095201, 0.9188344265721189, 0.247720784145265),
        (0.8475472195425976, 0.6262726422845127, 0.32800087668230604),
        (0.20660320810825605, 0.8911027665164128, 0.5992460142573325),
        (0.8282648736091335, 0.7351832503208816, 0.800094767894846),
        (0.0002768617443222876, 0.5602950004983808, 0.7121449977216052),
        (0.17358798681680843, 0.30101010090143643, 0.2308397554856476),
        (0.4993314311585496, 0.3876588955818303, 0.3501344791155323),
        (0.5843590983230768, 0.8210652286225594, 0.5821947746514159),
        (0.20563783325101936, 0.5133755940379933, 0.48843856669934205),
        (0.0023176564936087107, 0.40014544916621064, 0.8342513131947172),
        (0.2283766984618949, 0.7791214650705545, 0.4291476983978304),
        (0.7701453039408167, 0.19771013068258037, 0.556541842980416),
        (0.9910395345052916, 0.6402742511147412, 0.7292942984257827),
        (0.9966304943210872, 0.8156518582017726, 0.014188041298620724),
        (0.6968736365781659, 0.06059634050319673, 0.7676906979207834),
        (0.10642855412760877, 0.73554921797003, 0.9943467375783809),
        (0.8819406395892355, 0.3102836852436467, 0.733785088182626),
        (0.5132681823591703, 0.8668753059083185, 0.8001857414800285),
        (0.8830447655719056, 0.8474610732927292, 0.9913396073606908),
        (0.9875782770680537, 0.0011896867923114618, 0.5853487408105418),
        (0.7963827827880703, 0.18444490385556112, 0.11179042905833736),
        (0.9993397878584396, 0.658306745238307, 0.17074792391740357),
        (0.36872567396241607, 0.3783166099173001, 0.07035781441921185),
        (0.9495825507081956, 0.19406163557528877, 0.26599936067705066),
        (0.6090402945378464, 0.9948165055362687, 0.5749181051411516),
        (0.24755161780450452, 0.16821516174581863, 0.37666932769425776),
        (0.4100658844946138, 0.6538687183151912, 0.18876977877545909),
        (0.7416548094950045, 0.4819017136370509, 0.6281086672047421),
        (0.14103890808347475, 0.14182434381962428, 0.969400853706323),
        (0.7657810530748299, 0.365949572107255, 0.936287427349806),
        (0.0068653141667849304, 0.9935677843064677, 0.26949478256874804),
        (0.8516599012523922, 0.3731226568817313, 0.4210526598634119),
        (0.5528721165106811, 0.017920151273456475, 0.5892692773723294),
        (0.46054187022512894, 0.05296995374174396, 0.21717692190718652),
        (0.3653891145971826, 0.18036375645506675, 0.0034461500809976897),
        (0.003305106131504143, 0.22944846166085986, 0.11349019391271498),
        (0.31608063838810796, 0.9997058826683757, 0.11182463583144775),
        (0.6505193917597593, 0.7872831757444185, 0.1357139918047071),
        (0.4852682878686727, 0.5282484775237127, 0.8057012652565229),
        (0.13520031132086652, 0.4387678638058581, 0.9996301249555591),
        (0.817802446944251, 0.07085149641276145, 0.33882857890261864),
        (0.998699937870031, 0.13854678409656995, 0.9732810236081627),
        (0.8971366211941908, 0.9847300626039303, 0.7822267938061704),
        (0.25411262329922846, 0.010374733175049666, 0.7940649125891471),
        (0.2562261618247651, 0.19826035448837398, 0.5647538734809026),
        (0.6437085380916047, 0.3412314221730297, 0.2108771112629747),
        (0.4441017180968614, 0.9980570525618856, 0.2967575539696835),
        (0.004747615835443808, 0.16002592016413386, 0.8049212010560297),
        (0.8551002584627323, 0.9964534778633064, 0.34636226563665673),
        (0.6043602579456874, 0.38468161677963786, 0.7603755057451419),
        (0.22822008709007235, 0.5797356541653912, 0.902194217169326),
        (0.18740446667412436, 0.996335311197853, 0.4623289995277673),
        (0.5721029687603397, 0.5410638641468105, 0.9984503726037607),
        (0.9798388078462801, 0.37496661931110997, 0.004721793914773231),
        (0.306888309372235, 0.697481899878147, 0.01681305666978372),
        (0.5036130432791825, 0.16506195938143875, 0.848052703622427),
        (0.8142510373953492, 0.9933121786635457, 0.5752387905729057),
        (0.5917965777316209, 0.5633050304041848, 0.5265237836002946),
        (0.20425357633870733, 0.30796679442112984, 0.9022837681941119),
        (0.6012187948011141, 0.16194124030273327, 0.6354021141409203),
        (0.5377459694057046, 0.16724101428183147, 0.3275053231456836),
        (0.7267581192136644, 0.44127249717116845, 0.006424200349601228),
        (0.47840383322033075, 0.7863187781744461, 0.9678132319898294),
        (0.6791970178239223, 0.6203449599345707, 0.24264569188735496),
        (0.03948926425410537, 0.7966602749958398, 0.5748209981986503),
        (0.7987406507838926, 0.5014084941729732, 0.20785314389890475),
        (0.4295656923113903, 0.8238201147953507, 0.005232201414348658),
        (0.17056487487339766, 0.5632822351825824, 0.14934608544842498),
        (0.20079787528898319, 0.6923948560187027, 0.5733577115187529),
        (0.2812720252043823, 0.9961231059829553, 0.9913858808639525),
        (0.8690103930734184, 0.5689472456448514, 0.5186670335986254),
        (0.0285335604720518, 0.7404227257684687, 0.3231766105160261),
        (0.39605629205890613, 0.7785157808769111, 0.32472582982158815),
        (0.354584956760964, 0.7048807018972184, 0.7861981497109795),
        (0.3978674968537489, 0.13524271493346096, 0.6760034834008628),
        (0.0058077771936067, 0.8974453168066456, 0.8063484856675998),
        (0.8049664985017949, 0.6426937148266915, 0.9622870357465432),
        (0.7866612797931676, 0.8257320084477816, 0.00042104228945527566),
        (0.43918712855066844, 0.6181031593428422, 0.6522217976316783),
        (0.598188802766169, 0.9998484976003075, 0.8163278962185967),
        (0.08740964683053443, 0.2900557451780489, 0.4661113308341721),
        (0.6502783226776833, 0.24425928290294485, 0.9978833968342203),
        (0.9989755711251083, 0.3321497537728457, 0.23256102270264134),
        (0.2312442494034248, 0.6355498914034728, 0.3951330547364985),
        (0.8926901210334308, 0.06372002374823771, 0.1317964707291196),
        (0.9167521744222082, 0.11932073923161879, 0.4890834571401699),
        (0.9690526578502437, 0.7850863930159485, 0.31950559338983286),
        (0.6586654456796318, 0.1174134763611463, 0.4483149715049024),
        (0.9041738231323428, 0.6948499393284544, 0.006565247540112562),
        (0.8324432022499151, 0.5880492966615459, 0.7354230987675922),
        (0.8798990373033592, 0.02010735374264505, 0.7403895808120401),
        (0.6025322855586764, 0.9761238241590631, 0.15933183878286528),
        (0.7105302143358232, 0.8245548122169146, 0.3118551508496059),
        (0.47602476044408537, 0.006933534627766358, 0.9711710691478848),
        (0.45315360470384825, 0.3081385356846602, 0.5525801604731378),
        (0.8792373055321954, 0.7910568149215165, 0.6165811511903153),
        (0.3305139260700791, 0.11999226953818176, 0.8742025214518278),
        (0.13028248988002122, 0.975082084254913, 0.1408055311858346),
        (0.02632450944370268, 0.4891408961453384, 0.55794443075197),
        (0.3165616005246772, 0.38392485133399046, 0.6163378955220643),
        (0.8497595778807386, 0.44500062211049696, 0.7891902307814675),
        (0.09442024515356706, 0.4283442151901996, 0.2666551316987086),
        (0.16006538902344436, 0.47735442916318804, 0.7983539740970976),
        (0.04000358839942497, 0.7997592656098971, 0.009682975473020217),
        (0.07249943699659456, 0.6429995355562614, 0.8291988799918233),
        (0.989710876524571, 0.8601964948887509, 0.5029405462962544),
    ],
    "deuteranomaly": [
        (0.0, 0.5, 1.0),
        (0.9985062447652775, 0.45138426675928545, 0.028293454016457997),
        (0.696454204924131, 0.004235994366918905, 0.5305344158994824),
        (0.0004235333646877004, 0.8693891329754455, 0.5466645016256577),
        (0.0, 0.5, 0.0),
        (0.9831379874388849, 0.24928088145111993, 0.9922648262371336),
        (0.9870972524865755, 0.8493398509825678, 0.03766788328068893),
        (0.0037542566279819, 0.03484950512305973, 0.5916512444418194),
        (0.0, 1.0, 1.0),
        (0.9715677863480809, 0.3561522594194201, 0.5274368261399943),
        (0.015690902418207475, 0.9182922100562635, 0.036990842503427324),
        (0.00519216326209937, 0.5508592185539465, 0.6443466319058677),
        (0.9887143642521825, 0.6588752634300501, 0.8238857898622535),
        (0.8611377154638409, 0.009927557421517297, 0.1866071635706099),
        (0.044726451261751565, 0.17943765274823442, 0.9883883793260705),
        (0.017462613912823666, 0.7261705415394972, 0.9793050385132843),
        (0.3884038696113803, 0.08233603568983894, 0.17379798471052488),
        (0.055603619709647445, 0.6637401903746838, 0.32060403853681674),
        (0.8233913062035417, 0.05545108182636049, 0.9924089248890243),
        (0.5, 1.0, 0.5),
        (0.0048598456813391255, 0.37906138125266464, 0.35866218726353316),
        (0.9928083985082705, 0.7520516463392238, 0.0005274432307339483),
        (0.7257016451225552, 0.708696733479522, 0.29663323740727554),
        (0.39093223736972027, 0.6285852338701257, 0.0058202937371073515),
        (0.9620718332715781, 0.009804129497304359, 0.7496164418880857),
        (0.5098268572123551, 0.7062955203654828, 0.8504782813511416),
        (0.6494466272579984, 0.34338667114348387, 0.3505939946708415),
        (0.22285610378911058, 0.9998959927730942, 0.0322662470601065),
        (0.633595523390748, 0.5073980171667801, 0.6786500132555306),
        (0.5731926294258983, 0.19141638577633657, 0.6933060752161401),
        (0.5784432147900349, 0.9534018925353315, 0.9119762349071269),
        (0.8708102049966526, 0.42079140551822314, 0.2582254204876048),
        (0.5435670187615925, 0.19824821698623962, 0.03737626986427611),
        (0.7090192594914476, 0.7248400823796096, 0.5648875604414875),
        (0.47142725727022206, 0.49984526062651824, 0.8844293295936476),
        (0.18413645776210086, 0.014747736326709115, 0.21531006184054824),
        (0.9884571857242705, 0.8830685151182496, 0.7486767266398351),
        (0.12793529270307125, 0.9481493437537262, 0.7417554068872045),
        (0.4626741826753781, 0.0631523529949285, 0.5244604531435919),
        (0.05310878317141998, 0.44740130839703074, 0.7670128876192913),
        (0.8286532595347789, 0.31589436701461115, 0.014833778706778933),
        (0.37159316111286456, 0.4242275131665879, 0.5036094607417704),
        (0.9889147447468057, 0.44522327075081314, 0.745437601328356),
        (0.008933413422124059, 0.7269721287689832, 0.6916207339012188),
        (0.6174494321349068, 0.11159184283379109, 0.2711570281802125),
        (0.17891998116552732, 0.8069539151529214, 0.33449736702463573),
        (1.0, 1.0, 0.0),
        (1.0, 0.0, 0.5),
        (0.0014858527581839143, 0.28031748004045764, 0.5409630779785249),
        (0.7058263731014567, 0.28289676241591033, 0.7801608829477111),
        (0.6394617625192204, 0.8803442847755981, 0.02527966056907993),
        (0.2578308436365747, 0.023001194751217757, 0.00852279305204695),
        (0.0029236324324178886, 0.31506364516289864, 0.010619513749094978),
        (0.9993739871085681, 0.7511150835289668, 0.597811741441615),
        (1.0, 0.5, 1.0),
        (0.06507414390753197, 0.5137386651747529, 0.25124103314523516),
        (0.5804669493472306, 0.7390504462454283, 0.029449278152175018),
        (0.5348446172519226, 0.6401826680516137, 0.5039310489442572),
        (0.5351366241096307, 0.40064626589970764, 0.14558186995959788),
        (0.283107907373199, 0.558800581714119, 0.9960400286798577),
        (0.17896509012394535, 0.19397090906706005, 0.31261023080574557),
        (0.6077198847174038, 0.8040226899625285, 0.9961726409320573),
        (0.037185815555111024, 0.8543589240296255, 0.940270219012393),
        (0.7902342357611458, 0.2612658368539069, 0.5736642913708769),
        (0.09063626342600062, 0.6453971968575745, 0.5218425346240371),
        (0.6194968107733885, 0.8610974018101778, 0.4125656219339401),
        (0.6462985487741242, 0.5528719503610486, 0.9960738496785344),
        (0.922398881691461, 0.01762487933093526, 0.968807901539597),
        (0.454340921343074, 0.6434663572163315, 0.24883154406129848),
        (0.9700839152745191, 0.6322772421255967, 0.1603402982905653),
        (0.00475361552897291, 0.42399992477910875, 0.551045138047588),
        (0.14834749754845755, 0.3563651552810755, 0.1896230123881828),
        (0.4958725338568488, 0.014236562754151194, 0.36346505796301276),
        (0.5791060390458544, 0.6796589176355079, 0.6832143964786099),
        (0.9941592833829609, 0.0978288893723025, 0.31395016784933016),
        (0.013184116121931044, 0.640100163272804, 0.13390405301984798),
        (0.5822138727445376, 0.007925929848149438, 0.9996087004280059),
        (0.06668352562779878, 0.996970702679464, 0.48744037404737517),
        (0.0183685510071101, 0.7820565432021732, 0.11156922512593204),
        (0.9979162445071315, 0.5474800021744042, 0.472978521292162),
        (0.09367777417432177, 0.007426083044616005, 0.8791053543514455),
        (0.697979071931319, 0.986104523577362, 0.0296812597227869),
        (0.4586534611517127, 0.2998933451919872, 0.3780314096455041),
        (0.8150207356174626, 0.010442094504767074, 0.39397381457228053),
        (0.9504436248734972, 0.7386292376892526, 0.9851406787736895),
        (0.7410076159945448, 0.022159991365235054, 0.6965919442467984),
        (0.4718769087624999, 0.0025069521936106343, 9.375099070330073e-05),
        (0.52548682344184, 0.384909747037788, 0.9657291904151232),
        (0.5000953612970577, 0.5147390456334139, 0.44484701194412835),
        (0.5901277378464962, 0.8387903582388555, 0.7100296943091212),
        (0.9861977822116426, 0.25698767089115626, 0.8161282426888983),
        (0.9548155146887451, 0.7225689044776962, 0.3001705331375598),
        (0.0023997012124334915, 0.19562224005032358, 0.11331838315869658),
        (0.7681718691139564, 0.15529559563472284, 0.0010043836106882198),
        (0.6415727669183541, 0.5115679011441663, 0.8409351120505324),
        (0.790944233662668, 0.5483884071290347, 0.3838652216258236),
        (0.4528709637671693, 0.3730964126872066, 0.7703818494566848),
        (0.030799829333404194, 0.8441791809635124, 0.7501621757249306),
        (0.9850630748621991, 0.8691253574106099, 0.969056503732479),
        (0.30989309085262684, 0.8805376003737624, 0.24915188982460956),
        (0.48276001408971125, 0.2247605377739662, 0.5323615864175792),
        (0.46227816501047403, 0.016911583755948922, 0.852836378022449),
        (0.08378906239477624, 0.6878284695428913, 0.8381172981440492),
        (0.31514346259988035, 0.86243514724044, 0.454127802914698),
        (0.7966553070869917, 0.39363534301910996, 0.3888167391267162),
        (1.0, 0.0, 0.0),
        (0.7652775014912951, 0.4994769171131581, 0.09883259072666095),
        (0.07987121479100545, 0.7464771118414442, 0.4452981118580286),
        (0.4130298913612699, 0.49593109236666977, 0.6241105728567727),
        (0.8768880492620686, 0.48027989378341507, 0.8648433210880074),
        (0.028865746044478113, 0.5686479025176541, 0.40974362863891167),
        (0.9891596167121541, 0.20144080668144582, 0.6453491553786526),
        (0.044050802728591076, 0.36111579158636875, 0.6264241109926985),
        (0.6936755653553865, 0.7508534548566757, 0.8571466201375951),
        (0.9932014136098234, 0.49177502731050093, 0.2703927149551858),
        (0.7610725361705438, 0.007084216467926785, 0.839767720415429),
        (0.4147003672522508, 0.5320974894953147, 0.2394391828122021),
        (0.0921393951583529, 0.31755203460643233, 0.47977983285956183),
        (0.8254026391960902, 0.28028066183159206, 0.1871609983519975),
        (0.8264641004544305, 0.2426485283916464, 0.9906563460895266),
        (0.7034591804508166, 0.6173361720325793, 0.19427736726897016),
        (0.43994238733039337, 0.31350423241759773, 0.14193139191495474),
        (0.7865376188995952, 0.8494718657778527, 0.8119453927627746),
        (0.7918843626510983, 0.9987593800154831, 0.8016080280926362),
        (0.6649008588304823, 0.8557235529716474, 0.5733139088050926),
        (0.9934345634335062, 0.8833766195285582, 0.2673598571431268),
        (0.3511851120911228, 0.9945579515193996, 0.7606789560044329),
        (0.2799358740516231, 0.9564166486573549, 0.8953655423100965),
        (0.7467915185066438, 0.44211226776603885, 0.5633052694600884),
        (0.23300242897534407, 0.7325521789825339, 0.5891659557820512),
        (0.04579574736054137, 0.5495997695920933, 0.788713833783413),
        (0.984055926027593, 0.5852624819982168, 0.696799500618871),
        (0.853746075410976, 0.5410308943440161, 0.5914813967410684),
        (0.27422057471515937, 0.5803768729107868, 0.7295436931336893),
        (0.6210690688749033, 0.0042164703534243175, 0.14974715680045558),
        (0.005370785846435355, 0.15478757790415298, 0.3040172338412158),
        (0.23223496568268498, 0.17803796733542965, 0.5010877551427538),
        (0.47439473492030204, 0.3731149751835767, 0.004835222112197224),
        (0.2845543579572948, 0.5420470336277214, 0.002414557055313349),
        (0.9719689931310436, 0.6940659600839988, 0.4709571090701814),
        (0.8854347089382305, 0.6514432359929213, 0.00677491879195069),
        (0.6147801914108071, 0.7106298094041037, 0.42447825696253716),
        (0.9296096571516504, 0.13025042774985718, 0.8579988093057458),
        (0.9999730295710713, 0.2584183140516949, 0.16240043777580637),
        (0.7477233592395266, 0.1934245193548788, 0.2630031716597425),
        (0.6286420692445271, 0.2947287210031353, 0.633722530424449),
        (0.46565200308723576, 0.2547777856498633, 0.8147533814019291),
        (0.0020301506562980798, 0.0890271657713041, 0.07186288664638862),
        (0.6137879060019457, 0.6923900469061925, 0.9979348499067461),
        (0.9624374543937497, 0.5504018931426774, 0.8469403201452558),
        (0.3891679274220017, 0.8275239904275021, 0.6082072132631857),
        (0.9932014873657905, 0.7726614220317293, 0.00284521229704493),
        (0.8365294667921204, 0.0034764091386879636, 0.6032148639873035),
        (0.3297993678125817, 0.7906526590365709, 0.16294642660664538),
        (0.8073181527966841, 0.9918406450248101, 0.4737329630097884),
        (0.0001325328557055805, 0.32190540769592135, 0.9959234399415449),
        (0.3720050138242095, 0.9648026840693401, 0.42280908677317064),
        (0.27118086939515174, 0.8505131716304842, 0.8557051199486181),
        (0.6953205090404871, 0.21479888055936414, 0.46628218298431745),
        (0.33724059070496626, 0.21471366723583363, 0.4038156832125839),
        (0.5403506751682898, 0.9417931426491388, 0.009395252830256107),
        (0.34191670652029194, 0.4060788813659624, 0.6194719720519576),
        (0.31170576391901783, 0.016534139364401623, 0.25732755358886616),
        (0.8004906975785236, 0.27771029404019676, 0.7064177638101139),
        (0.009317454391922109, 0.2868380286611427, 0.19156730521675058),
        (0.3666564327986106, 0.44828042730157747, 0.37838159709757424),
        (0.3870167668883965, 0.8068124234881819, 0.7354069609572715),
        (0.8085766509808684, 0.869286587404912, 0.6807531148124263),
        (0.2474917842296348, 0.3462818088106898, 0.009009717194556899),
        (0.6432856882122011, 0.00032345334354799693, 0.39866345238613765),
        (0.3069758644783952, 0.7212527622965718, 0.9119721936709323),
        (0.7983508287371736, 0.31258735148927574, 0.9044015522640344),
        (0.03051852642923325, 0.4689074762305413, 0.4214810847816396),
        (0.39436659749081526, 0.8789778926698997, 0.01084598975978801),
        (0.4219381453113107, 0.6598312933316463, 0.7453764632979766),
        (0.4577328401162849, 0.36772298924998903, 0.24843517704187157),
        (0.8618473921470673, 0.4887435177760391, 0.997339808474295),
        (0.3570886802451936, 0.2130363558428663, 0.2615705699533497),
        (0.5525587268544909, 0.010850467363169303, 0.48739198183793264),
        (0.4259529694417208, 0.5646197369994116, 0.9834876947111122),
        (0.9854080088025121, 0.3455782534751203, 0.3917536574240301),
        (0.6113250032800556, 0.48704205762392705, 0.1391884867715234),
        (0.8491215636507027, 0.004389809086080332, 0.8405322023715593),
        (0.006042301604219702, 0.9249272513754185, 0.3539900453764121),
        (0.39801523516700144, 0.19039763372519636, 0.08460731828693846),
        (0.26949235777674285, 0.1940001362612781, 0.733576084955049),
        (0.5770374546562931, 0.00033093015281349114, 0.6363864595739553),
        (0.2549712668776193, 2.109383252069108e-06, 0.14392913699838894),
        (0.001465134174537197, 0.45300350518250976, 0.6622054372673083),
        (0.5464227268469125, 0.23077609115888076, 0.9954207702949898),
        (0.31187527348935973, 0.6821558418467925, 0.35973078118509794),
        (0.7136865904055162, 0.7864195261300665, 0.005529613370755082),
        (0.7135057777809531, 0.9968980856136032, 0.9905694058533177),
        (0.39224626578193367, 0.005363050009909998, 0.4247103181589278),
        (0.15561124964018225, 0.41661018888199775, 0.9886788149116885),
        (0.8723753843192796, 0.19352038876057887, 0.401390055052525),
        (0.6787951318023185, 0.2134870442332325, 0.14937018111937928),
        (0.21505199472701686, 0.18510879155698756, 0.029342207569108325),
        (0.5700998430463599, 0.43565587927333105, 0.00808247582488042),
        (0.014027405771646961, 0.5393516014047881, 0.5213707770928082),
    ],
}


def list_colorsets():
    """
    Get a list of the names of built-in distinctipy colours.
    :return: A tuple of keys present in the dictionary distinctipy.colorsets.colors
    """
    return tuple(["colorblind"] + list(colors.keys()))


def __process_name(name):
    """map the name colorblind to deuteranomaly (most common type of common blindness)"""
    if name == "colorblind":
        return "deuteranomaly"
    else:
        return name


def get_colormap(name="normal"):
    """
    Get a matplotlib colormap of built-in colours generated with distinctipy.

    :param name: The name of a colour set present in
    distinctipy.colorsets.list_colorsets()

    :return: A matplotlib ListedColorMap for the colors in
    distinctipy.colorsets.colors[name].
    """
    name = __process_name(name)
    assert name in list_colorsets(), "name should exist in " + str(list_colorsets())

    return distinctipy.get_colormap(colors[name], name="distinctipy_" + name)


def get_colors(name="normal"):
    """
    Return a list of built-in colours generated with distinctipy.

    :param name: The name of a colour set present in
    distinctipy.colorsets.list_colorsets()

    :return: A list of (r,g,b) colour tuples, where r, g and b are floats between 0
    and 1.
    """
    name = __process_name(name)
    assert name in list_colorsets(), "name should exist in " + str(list_colorsets())

    return colors[name]


def set_palette(name="normal"):
    """
    Set the default colour palette used by matplotlib to distinctipy colours.

    :param name: The name of a colour set present in
    distinctipy.colorsets.list_colorsets()
    """
    name = __process_name(name)
    assert name in list_colorsets(), "name should exist in " + str(list_colorsets())

    mpl.rcParams["axes.prop_cycle"] = mpl.cycler(color=colors[name])
    mpl.rcParams["patch.facecolor"] = colors[name][0]
