"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const scalingcommon = require("@aws-cdk/aws-autoscaling-common");
const fc = require("fast-check");
const appscaling = require("../lib");
function createScalableTarget(scope) {
    return new appscaling.ScalableTarget(scope, 'Target', {
        serviceNamespace: appscaling.ServiceNamespace.DYNAMODB,
        scalableDimension: 'test:TestCount',
        resourceId: 'test:this/test',
        minCapacity: 1,
        maxCapacity: 20,
    });
}
exports.createScalableTarget = createScalableTarget;
class ArbitraryInputIntervals extends fc.Arbitrary {
    generate(mrng) {
        const ret = scalingcommon.generateArbitraryIntervals(mrng);
        return new fc.Shrinkable(ret.intervals);
    }
}
exports.ArbitraryInputIntervals = ArbitraryInputIntervals;
function arbitrary_input_intervals() {
    return new ArbitraryInputIntervals();
}
exports.arbitrary_input_intervals = arbitrary_input_intervals;
//# sourceMappingURL=data:application/json;base64,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