import { Construct } from '@aws-cdk/core';
/**
 * Represents a GitHub OIDC provider.
 *
 * @stability stable
 */
export interface IGitHubOidcProvider {
    /**
     * The ARN of the OIDC provider.
     *
     * @stability stable
     */
    readonly providerArn: string;
}
/**
 * Defines an OIDC provider for GitHub workflows.
 *
 * This provider can be
 *
 * @stability stable
 */
export declare class GitHubOidcProvider extends Construct implements IGitHubOidcProvider {
    /**
     * The OIDC domain for GitHub.
     *
     * @stability stable
     */
    static readonly DOMAIN = "token.actions.githubusercontent.com";
    /**
     * The OIDC domain thumbprint for GitHub.
     *
     * @stability stable
     */
    static readonly THUMBPRINT = "a031c46782e6e6c662c2c87c76da9aa62ccabd8e";
    /**
     * @param account The AWS account for which you want to obtain the OIDC provider.
     * @returns The singleton GitHub OIDC provider for an account.
     * @stability stable
     */
    static forAccount(account?: string): IGitHubOidcProvider;
    /**
     * The ARN of the OIDC provider.
     *
     * @stability stable
     */
    readonly providerArn: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string);
}
