import { AwsCdkConstructLibrary } from 'projen';

const project = new AwsCdkConstructLibrary({
  name: 'cdk-github-role',
  description: 'IAM Role that can be assumed by GitHub workflows',

  author: 'Amazon Web Services',
  authorAddress: 'https://aws.amazon.com',
  authorOrganization: true,

  githubOptions: { mergify: false },

  repositoryUrl: 'https://github.com:/dklabs/cdk-github-role.git',
  keywords: ['github', 'oidc', 'iam', 'role', 'workflows'],

  cdkVersion: '1.127.0',
  defaultReleaseBranch: 'main',
  projenrcTs: true,

  cdkDependencies: [
    '@aws-cdk/core',
    '@aws-cdk/aws-iam',
  ],

  cdkTestDependencies: [
    '@aws-cdk/aws-s3',
  ],

  publishToMaven: {
    javaPackage: 'io.github.cdklabs.githubrole',
    mavenGroupId: 'io.github.cdklabs',
    mavenArtifactId: 'cdk-github-role',
    mavenEndpoint: 'https://s01.oss.sonatype.org',
  },

  publishToNuget: {
    dotNetNamespace: 'Cdklabs.GitHubRole',
    packageId: 'Cdklabs.GitHubRole',
  },

  publishToPypi: {
    distName: 'cdk-github-role',
    module: 'cdk_github_role',
  },

  autoApproveOptions: {
    allowedUsernames: ['cdklabs-automation'],
    secret: 'GITHUB_TOKEN',
  },

  autoApproveUpgrades: true,
});

project.synth();