"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const cloudfront = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-cloudfront-custom');
new cloudfront.CloudFrontWebDistribution(stack, 'AnAmazingWebsiteProbably', {
    originConfigs: [
        {
            originHeaders: {
                'X-Custom-Header': 'somevalue',
            },
            customOriginSource: {
                domainName: 'brelandm.a2z.com',
            },
            behaviors: [
                {
                    isDefaultBehavior: true,
                },
            ],
        },
    ],
    aliasConfiguration: {
        acmCertRef: 'arn:aws:acm:us-east-1:1111111:certificate/11-3336f1-44483d-adc7-9cd375c5169d',
        names: ['test.test.com'],
        sslMethod: cloudfront.SSLMethod.SNI,
        securityPolicy: cloudfront.SecurityPolicyProtocol.TLS_V1,
    },
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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