import utime

from the_pad.ili934xhax import ILI9341, color565, color565n

import the_pad.mcpnew as mcpnew

from machine import ADC, Pin, SPI, I2C

from math import sqrt, tan, cos, sin, floor, pi


import array as arr

import ustruct as struct

import framebuf


spi = SPI(
    2,
    baudrate=40000000,
    miso=Pin(19),
    mosi=Pin(23),
    sck=Pin(18))
display = ILI9341(spi,
    cs=Pin(0),
    dc=Pin(15),
    rst=Pin(5))

I2C_SCL = 27
I2C_SDA = 32

i2c = I2C(scl = Pin(I2C_SCL), sda = Pin(I2C_SDA))

BUTTON_LEFT = 5
BUTTON_RIGHT = 6
BUTTON_UP = 7
BUTTON_DOWN = 4

PIN_LEFT = 9
PIN_RIGHT = 10
PIN_UP = 8
PIN_DOWN = 11

pinz = [PIN_LEFT, PIN_RIGHT, PIN_UP, PIN_DOWN, BUTTON_LEFT, BUTTON_RIGHT, BUTTON_UP, BUTTON_DOWN]

DIR_LEFT = 3
DIR_RIGHT = 4
DIR_UP = 5
DIR_DOWN = 6

directions = [(-1, 0), (1, 0), (0, -1), (0, 1)]

io = mcpnew.MCP23017(i2c, address=0x20)



class field(object):
    def __init__(self):
        self.omraad = []
        self.height = 16
        self.width = 16
        for a in range(0, self.height*self.width):
            self.omraad.append(0)

    def getpoint(self, x, y):
        return self.omraad[x+y*self.width]

    def setpoint(self, x, y, pt):
        self.omraad[x+y*self.width] = pt

    def initfield(self):
        gp = 0
        self.omraad = [1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,
                       1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,
                       1,2,4,0,0,0,0,0,0,0,0,0,0,3,0,2,
                       1,0,0,0,0,0,0,1,0,0,0,0,0,3,0,2,
                       1,0,0,0,2,2,0,1,0,0,0,0,0,3,0,2,
                       1,0,0,0,2,2,0,1,0,0,0,0,0,0,0,2,
                       1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,
                       1,1,1,0,1,1,1,1,2,2,2,2,2,2,2,2,
                       1,1,1,0,1,1,1,1,2,2,2,2,2,2,2,2,
                       1,4,4,0,4,0,0,1,0,0,0,0,0,0,0,2,
                       1,2,4,0,0,0,0,0,0,0,0,0,0,0,0,2,
                       1,0,4,4,4,4,0,1,0,0,0,5,0,0,0,2,
                       1,0,0,0,4,4,0,1,0,0,0,0,0,0,0,2,
                       1,0,0,0,4,4,0,1,0,0,0,2,2,0,0,2,
                       1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,
                       1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2]


class character(object):

    def __init__(self, area, io):
        self.posx = 2.0
        self.posy = 5.0

        self.area = area

        self.io = io
        self.flosy = 5.0
        self.flosx = 2.0

        self.retningx = 0.0
        self.retningy = 1.0

        self.rotat = 0.0

        self.crotat = 0.0
        self.srotat = 0.0

        self.topi = pi * 2.0



    # @timed_function
    def checkinput(self):
        self.flosx = self.posx
        self.flosy = self.posy

        if io.input(BUTTON_UP):
            if not io.input(PIN_LEFT):
                self.rotat += 0.15

            if not io.input(PIN_RIGHT):
                self.rotat -= 0.15

            if not io.input(PIN_DOWN):
                self.posy -= 0.4 * cos(self.rotat)
                self.posx += 0.4 * sin(self.rotat)

            if not io.input(PIN_UP):
                self.posy += 0.4 * cos(self.rotat)
                self.posx -= 0.4 * sin(self.rotat)

        #sjekke om posx eller posy er out of bounds? tja

        if self.area.getpoint(floor(self.posx), floor(self.posy)) > 0:
            self.posx = self.flosx
            self.posy = self.flosy

        if self.rotat < 0.0:
            self.rotat += self.topi

        if self.rotat > self.topi:
            self.rotat -= self.topi

        self.crotat = cos(self.rotat)

        self.srotat = sin(self.rotat)


class rtrac(object):
    def __init__(self, disp, io):
        self.vres = 128

        self.xres = 128

        self.buf = bytearray(self.xres * 128 * 2)
        self.fbuf = framebuf.FrameBuffer(self.buf, self.xres, 128, framebuf.RGB565)#, framebuf.RGB565)

        self.display = disp
        self.io = io

        self.area = field()
        self.area.initfield()

        #self.c.display.contrast(15)

        self.fov = 0.85
        self.diry = 0.0

        self.fisheye = False

        self.offset = 0

        self.dividendo = 2

        self.char = character(self.area, self.io)

        self.setfov()

        self.disto = []
        self.gfx = arr.array('B')

        self.colurs = []

        for f in range(0, (self.vres//4)+2, 1):
            self.colurs.append(color565(16 + int(2*f), 16 + int(2*f), 16 + int(1*f)))

        for a in range(0, self.xres//4):
            self.disto.append(0.0)
            self.gfx.append(0)

        self.colors = arr.array('B', [0,0,0, 2,2,2, 2,0,3, 3,0,1, 1,3,2, 0,3,0])

        self.map = arr.array('H', [0]*len(self.area.omraad))
        for i, v in enumerate(self.area.omraad):
            q = color565(*[self.colors[self.area.omraad[i]*3+o]*64 for o in range(3)])
            self.map[i] = q

        self.map_scaled = arr.array('H', [0]*len(self.map)*4)

        self.mapbuf = framebuf.FrameBuffer(self.map_scaled, 32, 32, framebuf.RGB565)#, framebuf.RGB565)

        for x in range(16):
            for y in range(16):
                kalbu = self.map[y+16*x]
                self.map_scaled[(x*2)+32*(y*2)] = kalbu
                self.map_scaled[1+((x) * 2) + 32 * (y * 2)] = kalbu
                self.map_scaled[1+((x) * 2) + 32 * (1+((y) * 2))] = kalbu
                self.map_scaled[(x * 2) + 32 * (1+((y) * 2))] = kalbu


    def changevres(self):
        if self.vres == 64:
            self.vres = 128
        else:
            self.vres = 64

        self.fbuf.fill(0)
        # for i in range(0, 128*128*2):
        #     self.fbuf[i] = 0

        self.dividendo = self.vres // 64

        gassper = 0

        for f in range(0, 34, 128//self.vres):
            self.colurs[gassper] = color565(16 + int(2*f), 16 + int(2*f), 16 + int(1*f))
            gassper+=1

    def setfov(self):
        self.diry = 32.0 / tan(self.fov)

    def systeminput(self):
        if not io.input(BUTTON_UP):
            if not io.input(PIN_RIGHT):
                self.fov += 0.01

            if not io.input(PIN_LEFT):
                self.fov -= 0.01

            if not io.input(PIN_DOWN):
                self.fisheye = True

            if not io.input(PIN_UP):
                self.fisheye = False

            #if not io.input(BUTTON_DOWN):
            #    self.changevres()

            self.setfov()

    def gameloop(self):
        while True:
            self.char.checkinput()

            self.systeminput()

            self.tracebackground()
            self.drawbackground()

            self.render()

    def tracebackground(self):
        cpx = self.char.posx
        cpy = self.char.posy
        cpcr = self.char.crotat
        cpsr = self.char.srotat
        diry = self.diry

        grafix = self.gfx

        distix = self.disto

        areix = self.area

        fish = self.fisheye

        fdirx = (cpsr * diry)
        fdiry = (cpcr * diry)

        midleng = sqrt(fdirx * fdirx + fdiry * fdiry)

        for z in range(0, 32):
            dposx = cpx
            dposy = cpy

            dirx = float(z) - 16.0

            fdirx = (cpcr * dirx) - (cpsr * diry)
            fdiry = (cpcr * diry) + (cpsr * dirx)
            width = areix.width

            # normalize

            if fish:
                midleng = sqrt(fdirx * fdirx + fdiry * fdiry)

            fdirx /= midleng
            fdiry /= midleng

            # reuse
            lengo = 0.05

            tx = 0
            ty = 0

            while True:
                dposx = cpx + fdirx * lengo
                dposy = cpy + fdiry * lengo

                lengo += 0.1

                if lengo > 6.0:
                    distix[z] = lengo
                    grafix[z] = 0
                    break

                ttx = tx
                tty = ty

                tx = floor(dposx)
                ty = floor(dposy)

                if ttx != tx or tty != ty:

                    if tx < 0 or tx > 15 or ty < 0 or ty > 15:
                        distix[z] = lengo
                        grafix[z] = 1
                        break

                    taipo = areix.omraad[tx+ty*width]

                    if taipo > 0:
                        distix[z] = lengo
                        grafix[z] = taipo
                        break

            if distix[z] < 1.0:
                distix[z] = 1.0


    def drawbackground(self):

        vres = self.vres
        distix = self.disto
        grafix = self.gfx
        colix = self.colors

        divid = self.dividendo
        bivid = 2//divid

        colur = self.colurs

        if bivid == 2:
            if self.offset == 0:
                self.offset = 1
            else:
                self.offset = 0

        offset = self.offset

        ruffer = self.fbuf
        # ruffer.fill(0)

        torch = True
        # color = 0x0000

        for c in range(0,127,4):
            color = colur[abs(c - (vres // 2)) // 2]
            ruffer.fill_rect(0, (c*1), self.xres, (c*1)+4, color)

        for a in range(0, self.xres // 4):
            taipo = int(vres / distix[a])

            colop = grafix[a] * 3

            tx = (vres - taipo) // 2
            ty = vres - tx * 2 - 1

            taipo //= 2

            if torch:
                c = color565(taipo*colix[colop],taipo*colix[colop+1], taipo*colix[colop+2])
            else:
                c = color565(taipo*colix[colop]//2,taipo*colix[colop+1]//2, taipo*colix[colop+2]//2)

            ruffer.fill_rect(a * 4, tx, 4, ty, c)
        #ruffer.blit(self.mapbuf, 0, 0)
        #ruffer.fill_rect(floor(self.char.posy)*2, floor(self.char.posx)*2, 2, 2, 0xFFFF)


        self.display._writeblock(48, 150, 79, 181, self.map_scaled)


    def render(self):
        self.display._writeblock(0, 0, self.xres-1, 127, self.buf)






def run():
    for a in pinz:
        io.setup(a, mcpnew.IN)
        io.pullup(a, True)

    display.erase()
    display.set_pos(0,0)
    display.width = 240
    display.height = 320

    display.fill_rectangle(0, 0, 240, 320, color565n(0, 0, 30))

    kepp = rtrac(display, io)
    kepp.gameloop()
