# coding: utf-8

"""
    Emby Server API

    Explore the Emby Server API  # noqa: E501

    OpenAPI spec version: 4.1.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from embyapi.api_client import ApiClient


class SearchServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_search_hints(self, search_term, **kwargs):  # noqa: E501
        """Gets search hints based on a search term  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_search_hints(search_term, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str search_term: The search term to filter on (required)
        :param int start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :param int limit: Optional. The maximum number of records to return
        :param str user_id: Optional. Supply a user id to search within a user's library or omit to search all.
        :param bool include_people:
        :param bool include_media:
        :param bool include_genres:
        :param bool include_studios:
        :param bool include_artists:
        :param str include_item_types: Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimeted.
        :param str exclude_item_types: Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimeted.
        :param str media_types: Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimeted.
        :param bool is_movie: Optional filter for movies.
        :param bool is_series: Optional filter for movies.
        :param bool is_news: Optional filter for news.
        :param bool is_kids: Optional filter for kids.
        :param bool is_sports: Optional filter for sports.
        :return: SearchSearchHintResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_search_hints_with_http_info(search_term, **kwargs)  # noqa: E501
        else:
            (data) = self.get_search_hints_with_http_info(search_term, **kwargs)  # noqa: E501
            return data

    def get_search_hints_with_http_info(self, search_term, **kwargs):  # noqa: E501
        """Gets search hints based on a search term  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_search_hints_with_http_info(search_term, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str search_term: The search term to filter on (required)
        :param int start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :param int limit: Optional. The maximum number of records to return
        :param str user_id: Optional. Supply a user id to search within a user's library or omit to search all.
        :param bool include_people:
        :param bool include_media:
        :param bool include_genres:
        :param bool include_studios:
        :param bool include_artists:
        :param str include_item_types: Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimeted.
        :param str exclude_item_types: Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimeted.
        :param str media_types: Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimeted.
        :param bool is_movie: Optional filter for movies.
        :param bool is_series: Optional filter for movies.
        :param bool is_news: Optional filter for news.
        :param bool is_kids: Optional filter for kids.
        :param bool is_sports: Optional filter for sports.
        :return: SearchSearchHintResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['search_term', 'start_index', 'limit', 'user_id', 'include_people', 'include_media', 'include_genres', 'include_studios', 'include_artists', 'include_item_types', 'exclude_item_types', 'media_types', 'is_movie', 'is_series', 'is_news', 'is_kids', 'is_sports']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_search_hints" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'search_term' is set
        if ('search_term' not in params or
                params['search_term'] is None):
            raise ValueError("Missing the required parameter `search_term` when calling `get_search_hints`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'start_index' in params:
            query_params.append(('StartIndex', params['start_index']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('Limit', params['limit']))  # noqa: E501
        if 'user_id' in params:
            query_params.append(('UserId', params['user_id']))  # noqa: E501
        if 'search_term' in params:
            query_params.append(('SearchTerm', params['search_term']))  # noqa: E501
        if 'include_people' in params:
            query_params.append(('IncludePeople', params['include_people']))  # noqa: E501
        if 'include_media' in params:
            query_params.append(('IncludeMedia', params['include_media']))  # noqa: E501
        if 'include_genres' in params:
            query_params.append(('IncludeGenres', params['include_genres']))  # noqa: E501
        if 'include_studios' in params:
            query_params.append(('IncludeStudios', params['include_studios']))  # noqa: E501
        if 'include_artists' in params:
            query_params.append(('IncludeArtists', params['include_artists']))  # noqa: E501
        if 'include_item_types' in params:
            query_params.append(('IncludeItemTypes', params['include_item_types']))  # noqa: E501
        if 'exclude_item_types' in params:
            query_params.append(('ExcludeItemTypes', params['exclude_item_types']))  # noqa: E501
        if 'media_types' in params:
            query_params.append(('MediaTypes', params['media_types']))  # noqa: E501
        if 'is_movie' in params:
            query_params.append(('IsMovie', params['is_movie']))  # noqa: E501
        if 'is_series' in params:
            query_params.append(('IsSeries', params['is_series']))  # noqa: E501
        if 'is_news' in params:
            query_params.append(('IsNews', params['is_news']))  # noqa: E501
        if 'is_kids' in params:
            query_params.append(('IsKids', params['is_kids']))  # noqa: E501
        if 'is_sports' in params:
            query_params.append(('IsSports', params['is_sports']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikeyauth', 'embyauth']  # noqa: E501

        return self.api_client.call_api(
            '/Search/Hints', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SearchSearchHintResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
