# Agilent HPLC tools

Authors: Lars Yunker, Henry Situ

This repository contains tools and code for exporting data from report files generated by an Agilent ChemStation installation.
Additional tools have been built to facilitate laboratory automation and scripting which involve an HPLC component.
This code has been developed by the [Hein Group](https://groups.chem.ubc.ca/jhein/) at the University of British Columbia 
and is not an Agilent product. 

This code base is under active development and is in a beta development stage. 

## General overview
Currently, the tools for this package are located in the `aghplctools.hplc` module. The code in this package requires 
either that the Agilent Chemstation is installed in the default location (`C:\Chem32`) or that a `hplcfolder` environment 
variable be set which points to the installation path. A warning will be printed if neither of these are true, and 
functionality will be reduced. 

The methods in this module retrieve data from report files and return it in dictionary format with the following 
structure: 
```
{
    wavelength (float): {
        retention time (float): {
            'height': value (float),  # height of the peak
            'width': value (float),  # width of the peak
            'area': value (float),  # area of the peak
        },
        ...
    },
    ...
}
```

