# Generated by Django 3.2 on 2021-04-26 20:15

import calaccess_raw.annotations.documents
import calaccess_raw.annotations.forms
import calaccess_raw.fields
from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ("calaccess_raw", "0017_auto_20210422_0047"),
    ]

    operations = [
        migrations.AlterField(
            model_name="cvr2campaigndisclosurecd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ATR", "Assistant treasurer"),
                    ("BNM", "Ballot measure's name/title"),
                    ("CAO", "Candidate/officeholder"),
                    ("COM", "Committee"),
                    ("CTL", "Controlled committee"),
                    ("OFF", "Officer"),
                    ("POF", "Principal officer"),
                    ("PRO", "Proponent"),
                    ("RCP", "Recipient committee"),
                    ("FIL", "Unknown"),
                    ("PEX", "Unknown"),
                    ("RDP", "Unknown"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=9, id="2712033", start_page=8
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=11, id="2712034", start_page=9
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=32
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=24, id="2712033", start_page=23
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=32
                    ),
                ],
                help_text="Entity code used to identify the type of entity being described with in the record.",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2campaigndisclosurecd",
            name="f460_part",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("3", "Part 3: Committee Information"),
                    ("4a", "Part 4a: Officeholder or Candidate Controlled Committee"),
                    ("4A", "Part 4a: Officeholder or Candidate Controlled Committee"),
                    (
                        "4b",
                        "Part 4b: Related Committees Not Included in this Statement",
                    ),
                    (
                        "4B",
                        "Part 4b: Related Committees Not Included in this Statement",
                    ),
                    ("5a", "Part 5a: Officeholder or Candidate Controlled Committee"),
                    ("5A", "Part 5a: Officeholder or Candidate Controlled Committee"),
                    (
                        "5b",
                        "Part 5b: Related Committees Not Included in this Statement",
                    ),
                    (
                        "5B",
                        "Part 5b: Related Committees Not Included in this Statement",
                    ),
                    ("6", "Part 6: Primarily Formed Committee"),
                    ("6a", "Part 6a: Name of Ballot Measure"),
                    ("6A", "Part 6a: Name of Ballot Measure"),
                    ("6b", "Part 6b: Name of Officeholder, Candidate, or Proponent"),
                    ("6B", "Part 6b: Name of Officeholder, Candidate, or Proponent"),
                    ("7", "Part 7: Primarily Formed Committee"),
                ],
                db_column="F460_PART",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=32
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=24
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=32
                    ),
                ],
                help_text="Part of 460 cover page coded on ths cvr2 record",
                max_length=2,
            ),
        ),
        migrations.AlterField(
            model_name="cvr2campaigndisclosurecd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F425",
                        "Form 425 (Semi-Annual Statement of No Activity (Recipient Committee)): Part 1, Committee Information",
                    ),
                    (
                        "F450",
                        "Form 450 (Campaign Disclosure Statement, Short Form (Recipient Committee)): Part 3, Committee Information",
                    ),
                    (
                        "F460",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Cover Page, Part 2",
                    ),
                    (
                        "F465",
                        "Form 465 (Supplemental Independent Expenditure Report): Part 5, Filing Officers",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=23
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=31
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="cvr2campaigndisclosurecd",
            name="juris_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ASM", "Assembly District"),
                    ("BOE", "Board of Equalization District"),
                    ("CIT", "City"),
                    ("CTY", "County"),
                    ("LOC", "Local"),
                    ("OTH", "Other"),
                    ("SEN", "Senate District"),
                    ("STW", "Statewide"),
                    ("sen", "Senate District"),
                    ("SD", "Assembly District"),
                    ("se", "Senate District"),
                    ("F", "Assembly District"),
                    ("LBC", "City"),
                    ("CA", "Statewide"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=24
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=33
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=35
                    ),
                ],
                help_text="Office jurisdiction code",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="cvr2campaigndisclosurecd",
            name="off_s_h_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("S", "SOUGHT"),
                    ("H", "HELD"),
                    ("s", "SOUGHT"),
                    ("F", "SOUGHT"),
                    ("T", "HELD"),
                ],
                db_column="OFF_S_H_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=35
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=24
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=34
                    ),
                ],
                help_text="Office is sought or held code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="cvr2campaigndisclosurecd",
            name="office_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("APP", "State Appellate Court Justice"),
                    ("ASM", "State Assembly Person"),
                    ("ASR", "Assessor"),
                    ("ATT", "Attorney General"),
                    ("BED", "Board of Education"),
                    ("BOE", "Board of Equalization Member"),
                    ("BSU", "Board of Supervisors"),
                    ("CAT", "City Attorney"),
                    ("CCB", "Community College Board"),
                    ("CCM", "City Council Member"),
                    ("CON", "State Controller"),
                    ("COU", "County Counsel"),
                    ("CSU", "County Supervisor"),
                    ("CTR", "Local Controller"),
                    ("DAT", "District Attorney"),
                    ("GOV", "Governor"),
                    ("INS", "Insurance Commissioner"),
                    ("LTG", "Lieutenant Governor"),
                    ("MAY", "Mayor"),
                    ("OTH", "Other"),
                    ("PDR", "Public Defender"),
                    ("PER", "Public Employees Retirement System"),
                    ("PLN", "Planning Commissioner"),
                    ("SCJ", "Superior Court Judge"),
                    ("SEN", "State Senator"),
                    ("SHC", "Sheriff-Coroner"),
                    ("SOS", "Secretary of State"),
                    ("SPM", "Supreme Court Justice"),
                    ("SUP", "Superintendent of Public Instruction"),
                    ("TRE", "State Treasurer"),
                    ("TRS", "Local Treasurer"),
                    ("CIT", "State Assembly Person"),
                    ("CTL", "State Assembly Person"),
                    ("F", "State Assembly Person"),
                    ("ST", "State Assembly Person"),
                    ("PAC", "Unknown"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=10
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=12
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712032", start_page=2
                    ),
                ],
                help_text="Identifies the office being sought",
                max_length=3,
                verbose_name="office code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2campaigndisclosurecd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("CVR2", "Cover, Page 2")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711614", start_page=41
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=32
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=23
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=31
                    ),
                ],
                help_text="Record Type Value: CVR2",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2campaigndisclosurecd",
            name="sup_opp_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("S", "SUPPORT"),
                    ("O", "OPPOSITION"),
                    ("s", "SUPPORT"),
                    ("o", "OPPOSITION"),
                ],
                db_column="SUP_OPP_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711614", start_page=41
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=35
                    ),
                ],
                help_text="Support or opposition code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="cvr2lobbydisclosurecd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("EMP", "Employer"),
                    ("OFF", "Officer"),
                    ("OWN", "Owner"),
                    ("PTN", "Partner"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=57
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=71
                    ),
                ],
                help_text="Entity code of the entity described by the record",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2lobbydisclosurecd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("", "Form 625: Report of Lobbying Firm"),
                    (
                        "",
                        "Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=57
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=71
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="cvr2lobbydisclosurecd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("CVR2", "CVR2")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=57
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=71
                    ),
                ],
                help_text="Record Type Value: CVR2",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2registrationcd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("AGY", "State Agency"),
                    ("EMP", "Employer"),
                    ("FRM", "Lobbying Firm"),
                    ("LBY", "Lobbyist (an individual)"),
                    ("MBR", "Member of Associaton"),
                    ("SCL", "Subcontracted Client"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=72
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=87
                    ),
                ],
                help_text="Entity code of the entity described by the record",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2registrationcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("", "Form 601: Lobbying Firm Registration Statement"),
                    ("", "Form 602: Lobbying Firm Activity Authorization"),
                    (
                        "",
                        "Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=72
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=87
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="cvr2registrationcd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("CVR2", "CVR2")],
                db_column="REC_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=72
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=87
                    ),
                ],
                help_text="Record Type Value: CVR2",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2socd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ATH", "Authorizing individual"),
                    ("ATR", "Assistant treasurer"),
                    ("BNM", "Ballot measure's name/title"),
                    ("CAO", "Candidate/officeholder"),
                    ("COM", "Committee"),
                    ("CTL", "Controlled committee"),
                    ("OFF", "Officer"),
                    ("POF", "Principal officer"),
                    ("PRO", "Proponent"),
                    ("SPO", "Sponsor"),
                    ("BMN", "Unknown"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=9, id="2712033", start_page=8
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=11, id="2712034", start_page=9
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=38
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=48
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=62
                    ),
                ],
                help_text="Entity code of the entity described by the record.",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2socd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "",
                        "Form 400 (Statement of Organization (Slate Mailer Organization)): Part 3, Individuals Who Authorize Contents Of Slate Mailers",
                    ),
                    (
                        "",
                        "Form 410 (Statement of Organization (Recipient Committee)): Part 4, Type of Committee",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=38
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=46, id="2712033", start_page=45
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=59, id="2712034", start_page=58
                    ),
                ],
                help_text="Form type of the filing the record is included in. This must equal the form_type of the parent filing's cover (CVR) record.",
                max_length=4,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2socd",
            name="item_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ATR", "Assistant Treasurer (F410)"),
                    ("CAO", "Candidate/officeholder"),
                    ("CTL", "Controlled Committee (F410)"),
                    ("P5B", "Unknown"),
                    ("PFC", "Primarily Formed Committee Item (F410)"),
                    ("Pfc", "Primarily Formed Committee Item (F410)"),
                    ("POF", "Principal Officer (F400, F410"),
                    ("PRO", "Proponent"),
                    ("SMA", "Slate Mailer Authorizer (F400)"),
                    ("SPO", "Sponsored Committee Itemization (F410)"),
                    ("n/a", "Not Applicable"),
                    ("CON", "Unknown"),
                    ("CST", "Unknown"),
                ],
                db_column="ITEM_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=8
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=10
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=48
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=62
                    ),
                ],
                help_text="Section of the Statement of Organization this itemization relates to. See CAL document for the definition of legal values for this column.",
                max_length=4,
                verbose_name="item code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2socd",
            name="juris_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ASM", "Assembly District"),
                    ("BOE", "Board of Equalization District"),
                    ("CIT", "City"),
                    ("CTY", "County"),
                    ("LOC", "Local"),
                    ("OTH", "Other"),
                    ("SEN", "Senate District"),
                    ("STW", "Statewide"),
                    ("FED", "N/A"),
                    ("JR", "N/A"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=39
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=49
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=63
                    ),
                ],
                help_text="Office jurisdiction code. See CAL document for a list of legal values.",
                max_length=4,
                verbose_name="jurisdiction code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2socd",
            name="off_s_h_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("H", "HELD"), ("S", "SOUGHT")],
                db_column="OFF_S_H_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711614", start_page=46
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=39
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=49
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=63
                    ),
                ],
                help_text='Office sought/held code. Legal values are "S" for sought and "H" for held',
                max_length=1,
                verbose_name="office is sought or held code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2socd",
            name="office_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("APP", "State Appellate Court Justice"),
                    ("ASM", "State Assembly Person"),
                    ("ASR", "Assessor"),
                    ("ATT", "Attorney General"),
                    ("BED", "Board of Education"),
                    ("BOE", "Board of Equalization Member"),
                    ("BSU", "Board of Supervisors"),
                    ("CAT", "City Attorney"),
                    ("CCB", "Community College Board"),
                    ("CCM", "City Council Member"),
                    ("CON", "State Controller"),
                    ("COU", "County Counsel"),
                    ("CSU", "County Supervisor"),
                    ("CTR", "Local Controller"),
                    ("DAT", "District Attorney"),
                    ("GOV", "Governor"),
                    ("INS", "Insurance Commissioner"),
                    ("LTG", "Lieutenant Governor"),
                    ("MAY", "Mayor"),
                    ("OTH", "Other"),
                    ("PDR", "Public Defender"),
                    ("PER", "Public Employees Retirement System"),
                    ("PLN", "Planning Commissioner"),
                    ("SCJ", "Superior Court Judge"),
                    ("SEN", "State Senator"),
                    ("SHC", "Sheriff-Coroner"),
                    ("SOS", "Secretary of State"),
                    ("SPM", "Supreme Court Justice"),
                    ("SUP", "Superintendent of Public Instruction"),
                    ("TRE", "State Treasurer"),
                    ("TRS", "Local Treasurer"),
                    ("Asm", "State Assembly Person"),
                    ("LEG", "State Assembly Person"),
                    ("OF", "State Assembly Person"),
                    ("REP", "State Assembly Person"),
                    ("05", "State Assembly Person"),
                    ("H", "N/A"),
                    ("PRO", "N/A"),
                    ("PAC", "Unknown"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=10
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=12
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712032", start_page=2
                    ),
                ],
                help_text="Identifies the office being sought",
                max_length=3,
                verbose_name="office code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2socd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("CVR2", "Cover Page; Additional Names & Addresses")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=38
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711614", start_page=46
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=45
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=58
                    ),
                ],
                help_text='Type of record. This column will always contain "CVR2".',
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="cvr2socd",
            name="sup_opp_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("O", "OPPOSITION"), ("S", "SUPPORT")],
                db_column="SUP_OPP_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711614", start_page=46
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=40
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=49
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=64
                    ),
                ],
                help_text="Support or opposition code",
                max_length=1,
                verbose_name="support or opposition code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr3verificationinfocd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ATR", "Assistant treasurer"),
                    ("CAO", "Candidate/officeholder"),
                    ("TRE", "Treasurer"),
                    ("OFF", "Officer"),
                    ("PRO", "Proponent"),
                    ("SPO", "Sponsor"),
                    ("atr", "Treasurer"),
                    ("tre", "Assistant treasurer"),
                    ("cao", "Candidate/officeholder"),
                    ("MDI", "Major Donor/Ind Expenditure"),
                    ("POF", "Principal officer"),
                    ("RCP", "Recipient committee"),
                    ("COA", "Candidate/officeholder"),
                    ("0", "Unknown"),
                    ("BBB", "Unknown"),
                    ("CON", "Unknown"),
                    ("MAI", "Unknown"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=9
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=25
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=11
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=34
                    ),
                ],
                help_text="Entity Code",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvr3verificationinfocd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F400",
                        "Form 400 (Statement of Organization (Slate Mailer Organization)): Part 5, Verification",
                    ),
                    (
                        "F401",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Cover Page",
                    ),
                    (
                        "F402",
                        "Form 402 (Statement of Termination (Slate Mailer Organization)): Verification",
                    ),
                    (
                        "F410",
                        "Form 410 (Statement of Organization (Recipient Committee)): Part 3, Verification",
                    ),
                    (
                        "F425",
                        "Form 425 (Semi-Annual Statement of No Activity (Recipient Committee)): Part 3, Verification",
                    ),
                    (
                        "F450",
                        "Form 450 (Campaign Disclosure Statement, Short Form (Recipient Committee)): Part 4, Verification",
                    ),
                    (
                        "F460",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Cover Page, Part 1",
                    ),
                    (
                        "F461",
                        "Form 461 (Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)): Part 4, Verification",
                    ),
                    (
                        "F465",
                        "Form 465 (Supplemental Independent Expenditure Report): Part 6, Verification",
                    ),
                    ("F511", "Form 511: Paid Spokesperson Report"),
                    (
                        "F900",
                        "Form 900: Campaign Disclosure Statement (Public employee retirement board candidate)",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=50
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=64
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="cvr3verificationinfocd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("CVR3", "Cover Page 3, Verification Information")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=25
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=50
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=34
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=64
                    ),
                ],
                help_text="Record Type Value: CVR3",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="cmtte_type",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("C", "Candidate or officeholder controlled committee"),
                    ("P", "Candidate or officeholder primarily formed committee"),
                    ("B", "Ballot-measure committee"),
                    ("G", "General-purpose committee"),
                ],
                db_column="CMTTE_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=10
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=19
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=24
                    ),
                ],
                help_text="Type of Recipient Committee. Applies to the 450/460.",
                max_length=1,
                verbose_name="Committee type",
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("BMC", "Ballot measure committee"),
                    ("CAO", "Candidate/officeholder"),
                    ("COM", "Committee"),
                    ("CTL", "Controlled committee"),
                    ("IND", "Individual"),
                    ("MDI", "Major Donor/Ind Expenditure"),
                    ("OTH", "Other"),
                    ("PTY", "Political Party"),
                    ("RCP", "Recipient committee"),
                    ("SCC", "Small Contributor Committee"),
                    ("SMO", "Slate-mailer organization"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=9, id="2712033", start_page=8
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=11, id="2712034", start_page=9
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=6
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=18
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=22
                    ),
                ],
                help_text="The entity type of the filer. These codes vary by form type.",
                max_length=4,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F401",
                        "Form 401: Campaign Disclosure Statement (Slate Mailer Organization)",
                    ),
                    (
                        "F425",
                        "Form 425: Semi-Annual Statement of No Activity (Recipient Committee)",
                    ),
                    (
                        "F450",
                        "Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "F460",
                        "Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "F461",
                        "Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    ("F465", "Form 465: Supplemental Independent Expenditure Report"),
                    ("F496", "Form 496: Late Independent Expenditure Report"),
                    ("F497", "Form 497: Late Contribution Report"),
                    (
                        "F498",
                        "Form 498: Late Payment Report (Slate Mailer Organization)",
                    ),
                    ("F511", "Form 511: Paid Spokesperson Report"),
                    (
                        "F900",
                        "Form 900: Campaign Disclosure Statement (Public employee retirement board candidate)",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=18
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=22
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="juris_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ASM", "Assembly District"),
                    ("BOE", "Board of Equalization District"),
                    ("CIT", "City"),
                    ("CTY", "County"),
                    ("LOC", "Local"),
                    ("OTH", "Other"),
                    ("SEN", "Senate District"),
                    ("STW", "Statewide"),
                    ("sen", "Senate District"),
                    ("Gov", "Statewide"),
                    ("ATT", "Statewide"),
                    ("CON", "Statewide"),
                    ("GOV", "Statewide"),
                    ("SOS", "Statewide"),
                    ("SPM", "Statewide"),
                    ("46", "Assembly District"),
                    ("55", "Assembly District"),
                    ("BSU", "County"),
                    ("CSU", "County"),
                    ("DAT", "County"),
                    ("SHC", "County"),
                    ("MAY", "City"),
                    ("CCM", "City"),
                    ("APP", "Other"),
                    ("BED", "Other"),
                    ("SCJ", "Other"),
                    ("SD", "Other"),
                    ("OC", "County"),
                    ("AD", "Assembly District"),
                    ("CA", "Unknown"),
                    ("F", "Unknown"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=13
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=22, id="2712033", start_page=21
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=29, id="2712034", start_page=28
                    ),
                ],
                help_text="Office jurisdiction code",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="off_s_h_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("S", "SOUGHT"),
                    ("H", "HELD"),
                    ("s", "SOUGHT"),
                    ("h", "HELD"),
                    ("F", "UNKNOWN"),
                    ("O", "UNKNOWN"),
                ],
                db_column="OFF_S_H_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=21
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=28
                    ),
                ],
                help_text="Office is sought or held code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="office_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("APP", "State Appellate Court Justice"),
                    ("ASM", "State Assembly Person"),
                    ("ASR", "Assessor"),
                    ("ATT", "Attorney General"),
                    ("BED", "Board of Education"),
                    ("BOE", "Board of Equalization Member"),
                    ("BSU", "Board of Supervisors"),
                    ("CAT", "City Attorney"),
                    ("CCB", "Community College Board"),
                    ("CCM", "City Council Member"),
                    ("CON", "State Controller"),
                    ("COU", "County Counsel"),
                    ("CSU", "County Supervisor"),
                    ("CTR", "Local Controller"),
                    ("DAT", "District Attorney"),
                    ("GOV", "Governor"),
                    ("INS", "Insurance Commissioner"),
                    ("LTG", "Lieutenant Governor"),
                    ("MAY", "Mayor"),
                    ("OTH", "Other"),
                    ("PDR", "Public Defender"),
                    ("PER", "Public Employees Retirement System"),
                    ("PLN", "Planning Commissioner"),
                    ("SCJ", "Superior Court Judge"),
                    ("SEN", "State Senator"),
                    ("SHC", "Sheriff-Coroner"),
                    ("SOS", "Secretary of State"),
                    ("SPM", "Supreme Court Justice"),
                    ("SUP", "Superintendent of Public Instruction"),
                    ("TRE", "State Treasurer"),
                    ("TRS", "Local Treasurer"),
                    ("Gov", "Governor"),
                    ("Sen", "State Senator"),
                    ("LOC", "Community College Board"),
                    ("LEG", "State Senator"),
                    ("REP", "State Assembly Person"),
                    ("Mem", "Other"),
                    ("CIT", "State Assembly Person"),
                    ("PAC", "Unknown"),
                    ("F", "Unknown"),
                    ("COM", "Unknown"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=10
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=12
                    ),
                ],
                help_text="Identifies the office being sought",
                max_length=3,
                verbose_name="office code",
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("CVR", "Cover Page")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711614", start_page=25
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=6
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=18
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=22
                    ),
                ],
                help_text="Record Type Value: CVR",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="reportname",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    (
                        "450",
                        "Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "460",
                        "Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "461",
                        "Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                ],
                db_column="REPORTNAME",
                documentcloud_pages=(
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=15
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=20
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=19
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=26
                    ),
                ),
                help_text="Attached campaign disclosure statement type. Legal values are 450, 460, and 461.",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="stmt_type",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("PE", "Pre-Election (F450, F460)"),
                    ("QT", "Quarterly Stmt (F450,F460)"),
                    ("SA", "Semi-annual (F450, F460)"),
                    ("SE", "Supplemental Pre-elect (F450, F460, F495)"),
                    ("SY", "Special Odd-Yr. Campaign (F450, F460)"),
                    ("S1", "Semi-Annual (Jan1-Jun30) (F425)"),
                    ("S2", "Semi-Annual (Jul1-Dec31) (F425)"),
                    ("TS", "Termination Statement (F450, F460)"),
                    ("pe", "Pre-Election (F450, F460)"),
                    ("qt", "Quarterly Stmt (F450,F460)"),
                    ("sa", "Semi-annual (F450, F460)"),
                    ("se", "Supplemental Pre-elect (F450, F460, F495)"),
                    ("sy", "Special Odd-Yr. Campaign (F450, F460)"),
                    ("ts", "Termination Statement (F450, F460)"),
                    ("**", "Amendment"),
                    ("1", "Unknown"),
                    ("2", "Unknown"),
                    ("CA", "Unknown"),
                    ("MD", "Unknown"),
                    ("NA", "Unknown"),
                    ("PR", "Unknown"),
                    ("QS", "Unknown"),
                    ("S", "Unknown"),
                    ("x", "Unknown"),
                    ("YE", "Unknown"),
                ],
                db_column="STMT_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=7
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=18
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=23
                    ),
                ],
                help_text="Type of statement",
                max_length=2,
            ),
        ),
        migrations.AlterField(
            model_name="cvrcampaigndisclosurecd",
            name="sup_opp_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("S", "SUPPORT"),
                    ("O", "OPPOSITION"),
                    ("s", "SUPPORT"),
                    ("o", "OPPOSITION"),
                ],
                db_column="SUP_OPP_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711614", start_page=28
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=14
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=21
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=28
                    ),
                ],
                help_text="Support or opposition code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="cvre530cd",
            name="district_cd",
            field=calaccess_raw.fields.IntegerField(
                choices=[
                    (0, "N/A"),
                    (17001, "01"),
                    (17002, "13"),
                    (17003, "24"),
                    (17004, "35"),
                    (17005, "46"),
                    (17006, "57"),
                    (17007, "68"),
                    (17008, "79"),
                    (17009, "02"),
                    (17010, "05"),
                    (17011, "04"),
                    (17013, "06"),
                    (17014, "07"),
                    (17015, "08"),
                    (17016, "19"),
                    (17017, "10"),
                    (17018, "11"),
                    (17019, "12"),
                    (17020, "14"),
                    (17021, "15"),
                    (17022, "16"),
                    (17023, "17"),
                    (17024, "18"),
                    (17026, "20"),
                    (17027, "21"),
                    (17028, "22"),
                    (17029, "23"),
                    (17030, "25"),
                    (17031, "26"),
                    (17032, "27"),
                    (17033, "28"),
                    (17034, "29"),
                    (17035, "30"),
                    (17036, "31"),
                    (17037, "32"),
                    (17038, "33"),
                    (17039, "34"),
                    (17040, "36"),
                    (17041, "37"),
                    (17042, "38"),
                    (17043, "39"),
                    (17044, "40"),
                    (17045, "41"),
                    (17046, "42"),
                    (17047, "43"),
                    (17048, "44"),
                    (17049, "45"),
                    (17050, "47"),
                    (17051, "48"),
                    (17052, "49"),
                    (17053, "50"),
                    (17054, "51"),
                    (17055, "52"),
                    (17056, "53"),
                    (17057, "54"),
                    (17058, "55"),
                    (17059, "56"),
                    (17060, "03"),
                    (17061, "59"),
                    (17062, "60"),
                    (17063, "61"),
                    (17064, "62"),
                    (17065, "63"),
                    (17066, "64"),
                    (17067, "65"),
                    (17068, "66"),
                    (17069, "67"),
                    (17070, "69"),
                    (17071, "70"),
                    (17072, "71"),
                    (17073, "72"),
                    (17074, "73"),
                    (17075, "74"),
                    (17076, "75"),
                    (17077, "76"),
                    (17078, "77"),
                    (17079, "78"),
                    (17080, "80"),
                    (17081, "09"),
                    (17090, "58"),
                ],
                db_column="DISTRICT_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=13, id="2774529", start_page=11
                    )
                ],
                help_text="District Code",
            ),
        ),
        migrations.AlterField(
            model_name="cvre530cd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ATH", "Authorizing individual"),
                    ("ATR", "Assistant treasurer"),
                    ("BMC", "Ballot measure committee"),
                    ("BNM", "Ballot measure's name/title"),
                    ("CAO", "Candidate/officeholder"),
                    ("COM", "Committee"),
                    ("CTL", "Controlled committee"),
                    ("IND", "Individual"),
                    ("MDI", "Major Donor/Ind Expenditure"),
                    ("OFF", "Officer"),
                    ("OTH", "Other"),
                    ("POF", "Principal officer"),
                    ("PRO", "Proponent"),
                    ("PTY", "Political Party"),
                    ("RCP", "Recipient committee"),
                    ("SCC", "Small Contributor Committee"),
                    ("SMO", "Slate-mailer organization"),
                    ("SPO", "Sponsor"),
                    ("TRE", "Treasurer"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=9, id="2712033", start_page=8
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=11, id="2712034", start_page=9
                    ),
                ],
                help_text="entity code",
                max_length=32,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvre530cd",
            name="office_cd",
            field=calaccess_raw.fields.IntegerField(
                choices=[
                    (30001, "PRESIDENT"),
                    (30002, "GOVERNOR"),
                    (30003, "LIEUTENANT GOVERNOR"),
                    (30004, "SECRETARY OF STATE"),
                    (30005, "CONTROLLER"),
                    (30006, "TREASURER"),
                    (30007, "ATTORNEY GENERAL"),
                    (30008, "SUPERINTENDENT OF PUBLIC INSTRUCTION"),
                    (30009, "MEMBER BOARD OF EQUALIZATION"),
                    (30010, "OXNARD HARBOR COMMISSIONER"),
                    (30011, "CITY CONTROLLER"),
                    (30012, "STATE SENATE"),
                    (30013, "ASSEMBLY"),
                    (30014, "INSURANCE COMMISSIONER"),
                    (30015, "JUDGE"),
                    (30016, "BOARD MEMBER"),
                    (30017, "TAX COLLECTOR"),
                    (30018, "TRUSTEE"),
                    (30019, "SUPERVISOR"),
                    (30020, "SHERIFF"),
                    (30021, "CORONER"),
                    (30022, "MARSHALL"),
                    (30023, "CITY CLERK"),
                    (30024, "SCHOOL BOARD"),
                    (30025, "HARBOR COMMISSIONER"),
                    (30026, "DISTRICT ATTORNEY"),
                    (30027, "COUNTY CLERK"),
                    (30028, "AUDITOR"),
                    (30029, "MAYOR"),
                    (30030, "CITY ATTORNEY"),
                    (30031, "DEMOCRATIC COUNTY CENTRAL COMMITTEE"),
                    (30032, "TOWN COUNCIL"),
                    (30033, "ASSESSOR"),
                    (30034, "CITY TREASURER"),
                    (30035, "CITY COUNCIL"),
                    (30036, "COMMISSIONER"),
                    (30037, "REPUBLICAN COUNTY CENTRAL COMMITTEE"),
                    (30038, "DIRECTOR"),
                    (30039, "DIRECTOR OF ZONE 7"),
                    (30040, "COMMUNITY COLLEGE BOARD"),
                    (30041, "POLICE CHIEF"),
                    (30042, "CHIEF OF POLICE"),
                    (30043, "CENTRAL COMMITTEE"),
                    (30044, "BOARD OF EDUCATION"),
                    (30045, "BOARD OF DIRECTORS"),
                    (30046, "COLLEGE BOARD"),
                    (30047, "BART BOARD DIRECTOR"),
                    (30048, "BOARD OF TRUSTEES"),
                    (30049, "IRRIGATION"),
                    (30050, "WATER BOARD"),
                    (30051, "COMMUNITY PLANNING GROUP"),
                    (30052, "BOARD OF SUPERVISORS"),
                    (30053, "SUPERIOR COURT JUDGE"),
                    (30054, "DISTRICT ATTORNEY/PUBLIC DEFENDER"),
                    (30055, "MEASURE"),
                    (30056, "CITY PROSECUTOR"),
                    (30057, "SUPREME COURT JUDGE"),
                    (30058, "PUBLIC EMPLOYEES RETIREMENT BOARD"),
                    (30059, "APPELLATE COURT JUDGE"),
                    (50001, "Ag"),
                    (50002, "Assembly"),
                    (50003, "Assessor"),
                    (50004, "Assessor/Clerk/Recorder"),
                    (50005, "Assessor/County Clerk/Recorder"),
                    (50006, "Assessor/Recorder"),
                    (50007, "Associate Justice"),
                    (50008, "Auditor"),
                    (50009, "Auditor/Controller"),
                    (50010, "Auditor/Controller/Clerk/Recorder"),
                    (50011, "Auditor/Controller/Recorder"),
                    (50012, "Auditor/Controller/Treasurer/Tax Collector"),
                    (50013, "Auditor/Recorder"),
                    (50014, "Board Member"),
                    (50015, "Board Of Director"),
                    (50016, "Board Of Supervisor"),
                    (50017, "Boe"),
                    (50018, "Chief Justice"),
                    (50019, "City"),
                    (50020, "City Attorney"),
                    (50021, "City Auditor"),
                    (50022, "City Clerk"),
                    (50023, "City Council"),
                    (50024, "City Of Los Angeles"),
                    (50025, "City Of South El Monte"),
                    (50026, "City Prosecutor"),
                    (50027, "City Treasurer"),
                    (50028, "Clerk/Auditor"),
                    (50029, "Clerk/Record/Public Admin"),
                    (50030, "Clerk/Recorder"),
                    (50031, "Clerk/Recorder/Registar"),
                    (50032, "Clerk/Recorder/Registrar"),
                    (50033, "Commissioner"),
                    (50034, "Controller"),
                    (50035, "Costa Mesa"),
                    (50036, "Council Member"),
                    (50037, "County Clerk"),
                    (50038, "County Clerk/Auditor"),
                    (50039, "County Clerk/Auditor/Controller"),
                    (50040, "County Clerk/Recorder"),
                    (50041, "County Clerk/Recorder/Assessor"),
                    (50042, "County Clerk/Recorder/Public Admin"),
                    (50043, "Democratic County Central Committee"),
                    (50044, "Director"),
                    (50045, "District Attorney"),
                    (50046, "District Attorney/Public Administrator"),
                    (50047, "Gccc"),
                    (50048, "Governor"),
                    (50049, "Harbor Commissioner"),
                    (50050, "Ic"),
                    (50051, "Irrigation Dist"),
                    (50052, "Judge"),
                    (50053, "Justice"),
                    (50054, "Legislature"),
                    (50055, "Lieutenant Governor"),
                    (50056, "Mayor"),
                    (50057, "N/A"),
                    (50058, "Placentia"),
                    (50059, "Public Administrator"),
                    (50060, "Public Administrator/Guardian"),
                    (50061, "Rent Stabilization Board"),
                    (50062, "Republican Central Committee"),
                    (50063, "San Francisco Dccc"),
                    (50064, "Sanger"),
                    (50065, "School Board"),
                    (50066, "Secretary Of State"),
                    (50067, "Senator"),
                    (50068, "Sheriff"),
                    (50069, "Sheriff/Coroner"),
                    (50070, "Sheriff/Coroner/Marshall"),
                    (50071, "Sheriff/Coroner/Public Administrator"),
                    (50072, "Solana Beach"),
                    (50073, "Superintendent"),
                    (50074, "Supervisor"),
                    (50075, "Supt Of Schools"),
                    (50076, "Tax Collector"),
                    (50077, "Town Council"),
                    (50078, "Treasurer"),
                    (50079, "Treasurer/Tax Collector"),
                    (50080, "Treasurer/Tax Collector/Clerk"),
                    (50081, "Treasurer/Tax Collector/Public Administrator"),
                    (
                        50082,
                        "Treasurer/Tax Collector/Public Administrator/County Clerk",
                    ),
                    (50083, "Treasurer/Tax Collector/Recorder"),
                    (50084, "Trustee"),
                    (50085, "Weed Recreation Board Member"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=18, id="2774529", start_page=16
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=22, id="2774529", start_page=20
                    ),
                ],
                help_text="Identifies the office being sought",
                verbose_name="office code",
            ),
        ),
        migrations.AlterField(
            model_name="cvrf470cd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("CAO", "Candidate/officeholder")],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=22
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=29
                    ),
                ],
                help_text="The filer's entity code. The value of this column will always be Candidate/Office Holder (CAO) for this table.",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="cvrf470cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "",
                        "Form 470: Campaign Disclosure Statement, Short Form (Officeholders and Candidates)",
                    )
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=22
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=29
                    ),
                ],
                help_text="Type of Filing or Formset. The value of this column will always be equal to F470.",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="cvrf470cd",
            name="juris_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ASM", "Assembly District"),
                    ("BOE", "Board of Equalization District"),
                    ("CIT", "City"),
                    ("CTY", "County"),
                    ("LOC", "Local"),
                    ("OTH", "Other"),
                    ("SEN", "Senate District"),
                    ("STW", "Statewide"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=22
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=29
                    ),
                ],
                help_text="Office Jurisdiction Code",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="cvrf470cd",
            name="off_s_h_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("H", "HELD"), ("S", "SOUGHT")],
                db_column="OFF_S_H_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=22
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=30
                    ),
                ],
                help_text='Office Sought/Held code. Legal values are "S" for sought and "H" for held.',
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="cvrf470cd",
            name="office_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("APP", "State Appellate Court Justice"),
                    ("ASM", "State Assembly Person"),
                    ("ASR", "Assessor"),
                    ("ATT", "Attorney General"),
                    ("BED", "Board of Education"),
                    ("BOE", "Board of Equalization Member"),
                    ("BSU", "Board of Supervisors"),
                    ("CAT", "City Attorney"),
                    ("CCB", "Community College Board"),
                    ("CCM", "City Council Member"),
                    ("CON", "State Controller"),
                    ("COU", "County Counsel"),
                    ("CSU", "County Supervisor"),
                    ("CTR", "Local Controller"),
                    ("DAT", "District Attorney"),
                    ("GOV", "Governor"),
                    ("INS", "Insurance Commissioner"),
                    ("LTG", "Lieutenant Governor"),
                    ("MAY", "Mayor"),
                    ("OTH", "Other"),
                    ("PDR", "Public Defender"),
                    ("PER", "Public Employees Retirement System"),
                    ("PLN", "Planning Commissioner"),
                    ("SCJ", "Superior Court Judge"),
                    ("SEN", "State Senator"),
                    ("SHC", "Sheriff-Coroner"),
                    ("SOS", "Secretary of State"),
                    ("SPM", "Supreme Court Justice"),
                    ("SUP", "Superintendent of Public Instruction"),
                    ("TRE", "State Treasurer"),
                    ("TRS", "Local Treasurer"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=22
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=29
                    ),
                ],
                help_text="Code that identifies the office being sought. See the CAL document for a list of valid codes.",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="cvrf470cd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("CVR", "Cover Page")],
                db_column="REC_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=22
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=29
                    ),
                ],
                help_text="Type of CAL record. This column will always contain CVR.",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="cvrlobbydisclosurecd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("CLI", "Unknown"),
                    ("FRM", "Lobbying Firm"),
                    ("IND", "Person (spending > $5000)"),
                    ("LBY", "Lobbyist (an individual)"),
                    ("LCO", "Lobbying Coalition"),
                    ("LEM", "Lobbying Employer"),
                    ("OTH", "Other"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=53
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=67
                    ),
                ],
                help_text="Entity Code describing the filer",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvrlobbydisclosurecd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("", "Form 615: Lobbyist Report"),
                    ("", "Form 625: Report of Lobbying Firm"),
                    (
                        "",
                        "Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    ("", "Form 645: Report of Person Spending $5,000 or More"),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=53
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=66
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="cvrlobbydisclosurecd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("CVR", "CVR")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=53
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=66
                    ),
                ],
                help_text="Record Type Value: CVR",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="cvrregistrationcd",
            name="bus_class",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ENT", "Entertainment/Recreation"),
                    ("FIN", "Finance/Insurance"),
                    ("LOG", "Lodging/Restaurants"),
                    ("MAN", "Manufacturing/Industrial"),
                    ("MER", "Merchandise/Retail"),
                    ("OIL", "Oil and Gas"),
                    ("OTH", "Other"),
                    ("PRO", "Professional/Trade"),
                    ("REA", "Real Estate"),
                    ("TRN", "Transportation"),
                ],
                db_column="BUS_CLASS",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=70
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=82
                    ),
                ],
                help_text="Classifiction values of business related entities. This field is exclusive of the business class field. One these must be populated but not both.",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="cvrregistrationcd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("BUS", "Unknown"),
                    ("FRM", "Lobbying Firm"),
                    ("LBY", "Lobbyist (an individual)"),
                    ("LCO", "Lobbying Coalition"),
                    ("LEM", "Lobbying Employer"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=82
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=68
                    ),
                ],
                help_text="Entity Code describing the filer",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvrregistrationcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("", "Form 601: Lobbying Firm Registration Statement"),
                    ("", "Form 602: Lobbying Firm Activity Authorization"),
                    (
                        "",
                        "Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                    ),
                    ("", "Form 604: Lobbyist Certification Statement"),
                    ("", "Form 606: Notice of Termination"),
                    ("", "Form 607: Notice of Withdrawal"),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=68
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=82
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="cvrregistrationcd",
            name="ind_class",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("AGR", "Agriculture"),
                    ("EDU", "Education"),
                    ("GOV", "Government"),
                    ("HEA", "Health"),
                    ("LAB", "Labor Unions"),
                    ("LEG", "Legal"),
                    ("OTH", "Other"),
                    ("POL", "Political Organizations"),
                    ("PUB", "Public Employees"),
                    ("UTL", "Utilities"),
                ],
                db_column="IND_CLASS",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=85
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=70
                    ),
                ],
                help_text="Classification values to category industry related entities. This field is exclusive of the business class field. One these must be populated but not both.",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="cvrregistrationcd",
            name="influen_yn",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("Y", "Yes"),
                    ("y", "Yes"),
                    ("N", "No"),
                    ("n", "No"),
                    ("X", "Yes"),
                ],
                db_column="INFLUEN_YN",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=86
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=71
                    ),
                ],
                help_text="Attempt to influence state legislation",
                max_length=1,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="cvrregistrationcd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("CVR", "CVR")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=68
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=82
                    ),
                ],
                help_text="Record Type Value: CVR",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="cvrregistrationcd",
            name="st_leg_yn",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("Y", "Yes"),
                    ("y", "Yes"),
                    ("N", "No"),
                    ("n", "No"),
                    ("X", "Yes"),
                    ("x", "Yes"),
                ],
                db_column="ST_LEG_YN",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=86
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=71
                    ),
                ],
                help_text="Will lobby state legislature checkbox. Applies to Form 604.",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="cvrsocd",
            name="actvty_lvl",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("CI", "City"),
                    ("CO", "County"),
                    ("ST", "State"),
                    ("St", "State"),
                    ("st", "State"),
                ],
                db_column="ACTVTY_LVL",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=30
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=47
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=60
                    ),
                ],
                help_text="Organization's level of activity",
                max_length=2,
                verbose_name="activity level",
            ),
        ),
        migrations.AlterField(
            model_name="cvrsocd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("BMC", "Ballot measure committee"),
                    ("CAO", "Candidate/officeholder"),
                    ("COM", "Committee"),
                    ("CTL", "Controlled committee"),
                    ("RCP", "Recipient committee"),
                    ("SMO", "Slate-mailer organization"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=9, id="2712033", start_page=8
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=11, id="2712034", start_page=9
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=46
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=59
                    ),
                ],
                help_text="Entity Code of the Filer. Values: SMO - Slate Mailer Organization (F400,402) [COM|RCP] - Recipient Committee (F410)",
                max_length=3,
                verbose_name="Entity code",
            ),
        ),
        migrations.AlterField(
            model_name="cvrsocd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F400",
                        "Form 400: Statement of Organization (Slate Mailer Organization)",
                    ),
                    (
                        "F402",
                        "Form 402: Statement of Termination (Slate Mailer Organization)",
                    ),
                    (
                        "F410",
                        "Form 410: Statement of Organization (Recipient Committee)",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=46
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=59
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="cvrsocd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "CVR",
                        "Cover Page for Stmt of Organization / Slate Mailer Org, Stmt of Termination / Slate Mailer Org or Stmt of Organization / Recipient Committee",
                    )
                ],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=28
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=46
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=59
                    ),
                ],
                help_text="Record Type Value: CVR",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="debtcd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("BNM", "Ballot measure's name/title"),
                    ("COM", "Committee"),
                    ("IND", "Individual"),
                    ("OTH", "Other"),
                    ("PTY", "Political Party"),
                    ("RCP", "Recipient committee"),
                    ("SCC", "Small Contributor Committee"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=9, id="2712033", start_page=8
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=11, id="2712034", start_page=9
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=33
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=45
                    ),
                ],
                help_text="Entity code describing the payee",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="debtcd",
            name="expn_code",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("CMP", "campaign paraphernalia/miscellaneous"),
                    ("CNS", "campaign consultants"),
                    ("CTB", "contribution (if nonmonetary, explain)*"),
                    ("CVC", "civic donations"),
                    ("FIL", "candidate filing/ballot feeds"),
                    ("FND", "fundraising events"),
                    ("IKD", "In-kind contribution (nonmonetary)"),
                    (
                        "IND",
                        "independent expenditure supporting/opposing others (explain)*",
                    ),
                    ("LEG", "legal defense"),
                    ("LIT", "campaign literature and mailings"),
                    ("LON", "loan"),
                    ("MBR", "member communications"),
                    ("MON", "monetary contribution"),
                    ("MTG", "meetings and appearances"),
                    ("OFC", "office expenses"),
                    ("PET", "petition circulating"),
                    ("PHO", "phone banks"),
                    ("POL", "polling and survey research"),
                    ("POS", "postage, delivery and messenger services"),
                    ("PRO", "professional services (legal, accounting)"),
                    ("PRT", "print ads"),
                    ("RAD", "radio airtime and production costs"),
                    ("RFD", "returned contributions"),
                    ("SAL", "campaign workers salaries"),
                    ("TEL", "T.V. or cable airtime and production costs"),
                    ("TRC", "candidate travel, lodging and meals (explain)"),
                    ("TRS", "staff/spouse travel, lodging and meals (explain)"),
                    (
                        "TSF",
                        "transfer between committees of the same candidate/sponsor",
                    ),
                    ("VOT", "voter registration"),
                    ("WEB", "information technology costs (internet, e-mail)"),
                    ("Fnd", "fundraising events"),
                    ("ofc", "office expenses"),
                    ("'CN", "campaign consultants"),
                    ("*", "Unknown"),
                    ("AIR", "Unknown"),
                    ("BUS", "Unknown"),
                    ("C", "Unknown"),
                    ("CAM", "Unknown"),
                    ("CC", "Unknown"),
                    ("COM", "Unknown"),
                    ("CON", "Unknown"),
                    ("CSN", "Unknown"),
                    ("DEP", "Unknown"),
                    ("EVE", "Unknown"),
                    ("F", "Unknown"),
                    ("FED", "Unknown"),
                    ("fns", "Unknown"),
                    ("G", "Unknown"),
                    ("GGG", "Unknown"),
                    ("HOT", "Unknown"),
                    ("L", "Unknown"),
                    ("LDF", "Unknown"),
                    ("MEE", "Unknown"),
                    ("N", "Unknown"),
                    ("O", "Unknown"),
                    ("OTH", "Unknown"),
                    ("P", "Unknown"),
                    ("PEN", "Unknown"),
                    ("S", "Unknown"),
                    ("SPE", "Unknown"),
                    ("STA", "Unknown"),
                    ("T", "Unknown"),
                    ("TAX", "Unknown"),
                    ("TRA", "Unknown"),
                    ("V", "Unknown"),
                    ("X", "Unknown"),
                ],
                db_column="EXPN_CODE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=11
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=14, id="2712034", start_page=13
                    ),
                ],
                help_text="Expense Code",
                max_length=4,
                verbose_name="expense code",
            ),
        ),
        migrations.AlterField(
            model_name="debtcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule F, Accrued Expenses (Unpaid Bills)",
                    )
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=33
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=45
                    ),
                ],
                help_text="Schedule Name/ID: (F - Sched F / Accrued Expenses)",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="debtcd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("DEBT", "DEBT")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=34, id="2712033", start_page=33
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=46, id="2712034", start_page=45
                    ),
                ],
                help_text="Record type value: DEBT",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="expncd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("COM", "Committee"),
                    ("IND", "Individual"),
                    ("RCP", "Recipient committee"),
                    ("OTH", "Other"),
                    ("PTY", "Political Party"),
                    ("SCC", "Small Contributor Committee"),
                    ("BNM", "Ballot measure's name/title"),
                    ("CAO", "Candidate/officeholder"),
                    ("MBR", "Member of Associaton"),
                    ("OFF", "Officer"),
                    ("0", "Unknown"),
                    ("PTH", "Unknown"),
                    ("RFD", "Unknown"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=9, id="2712033", start_page=8
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=11, id="2712034", start_page=9
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=31
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=42
                    ),
                ],
                help_text="Entity Code describing payee",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="expncd",
            name="expn_code",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("CMP", "campaign paraphernalia/miscellaneous"),
                    ("CNS", "campaign consultants"),
                    ("CTB", "contribution (if nonmonetary, explain)*"),
                    ("CVC", "civic donations"),
                    ("FIL", "candidate filing/ballot feeds"),
                    ("FND", "fundraising events"),
                    ("IKD", "In-kind contribution (nonmonetary)"),
                    (
                        "IND",
                        "independent expenditure supporting/opposing others (explain)*",
                    ),
                    ("LEG", "legal defense"),
                    ("LIT", "campaign literature and mailings"),
                    ("LON", "loan"),
                    ("MBR", "member communications"),
                    ("MON", "monetary contribution"),
                    ("MTG", "meetings and appearances"),
                    ("OFC", "office expenses"),
                    ("PET", "petition circulating"),
                    ("PHO", "phone banks"),
                    ("POL", "polling and survey research"),
                    ("POS", "postage, delivery and messenger services"),
                    ("PRO", "professional services (legal, accounting)"),
                    ("PRT", "print ads"),
                    ("RAD", "radio airtime and production costs"),
                    ("RFD", "returned contributions"),
                    ("SAL", "campaign workers salaries"),
                    ("TEL", "T.V. or cable airtime and production costs"),
                    ("TRC", "candidate travel, lodging and meals (explain)"),
                    ("TRS", "staff/spouse travel, lodging and meals (explain)"),
                    (
                        "TSF",
                        "transfer between committees of the same candidate/sponsor",
                    ),
                    ("VOT", "voter registration"),
                    ("WEB", "information technology costs (internet, e-mail)"),
                    ("ctb", "contribution (if nonmonetary, explain)*"),
                    ("ikd", "In-kind contribution (nonmonetary)"),
                    ("Mon", "monetary contribution"),
                    ("ofc", "office expenses"),
                    ("OFc", "office expenses"),
                    ("Ofc", "office expenses"),
                    ("", "Unknown"),
                    ("*", "Unknown"),
                    ("0", "Unknown"),
                    ("001", "Unknown"),
                    ("011", "Unknown"),
                    ("200", "Unknown"),
                    ("401", "Unknown"),
                    ("ADV", "Unknown"),
                    ("ANN", "Unknown"),
                    ("APR", "Unknown"),
                    ("AUG", "Unknown"),
                    ("AUT", "Unknown"),
                    ("Ban", "Unknown"),
                    ("BAN", "Unknown"),
                    ("BOO", "Unknown"),
                    ("BOX", "Unknown"),
                    ("C", "Unknown"),
                    ("CAT", "Unknown"),
                    ("CC", "Unknown"),
                    ("CHE", "Unknown"),
                    ("CIV", "Unknown"),
                    ("CNT", "Unknown"),
                    ("CON", "Unknown"),
                    ("COP", "Unknown"),
                    ("CRE", "Unknown"),
                    ("CSN", "Unknown"),
                    ("CT", "Unknown"),
                    (",CT", "Unknown"),
                    (".CT", "Unknown"),
                    ("CTN", "Unknown"),
                    ("CVD", "Unknown"),
                    ("DAT", "Unknown"),
                    ("DEC", "Unknown"),
                    ("Dem", "Unknown"),
                    ("DIN", "Unknown"),
                    ("Don", "Unknown"),
                    ("DON", "Unknown"),
                    ("Ear", "Unknown"),
                    ("EIM", "Unknown"),
                    ("EMP", "Unknown"),
                    ("F", "Unknown"),
                    ("FAX", "Unknown"),
                    ("FDN", "Unknown"),
                    ("FED", "Unknown"),
                    ("FEE", "Unknown"),
                    ("FIN", "Unknown"),
                    ("Fun", "Unknown"),
                    ("FUN", "Unknown"),
                    ("G", "Unknown"),
                    ("GEN", "Unknown"),
                    ("GGG", "Unknown"),
                    ("GOT", "Unknown"),
                    ("IEs", "Unknown"),
                    ("IN-", "Unknown"),
                    ("Ina", "Unknown"),
                    ("INK", "Unknown"),
                    ("INS", "Unknown"),
                    ("ITE", "Unknown"),
                    ("JAN", "Unknown"),
                    ("JUL", "Unknown"),
                    ("JUN", "Unknown"),
                    ("KIC", "Unknown"),
                    ("L", "Unknown"),
                    ("LEV", "Unknown"),
                    ("Lit", "Unknown"),
                    ("LN#", "Unknown"),
                    ("LOG", "Unknown"),
                    ("M", "Unknown"),
                    ("MAI", "Unknown"),
                    ("Mar", "Unknown"),
                    ("MAR", "Unknown"),
                    ("MAY", "Unknown"),
                    ("MED", "Unknown"),
                    ("MEE", "Unknown"),
                    ("MGT", "Unknown"),
                    ("Mis", "Unknown"),
                    ("MRB", "Unknown"),
                    ("NGP", "Unknown"),
                    ("NON", "Unknown"),
                    ("NOT", "Unknown"),
                    ("NOV", "Unknown"),
                    ("O", "Unknown"),
                    ("OCT", "Unknown"),
                    (".OF", "Unknown"),
                    ("OFF", "Unknown"),
                    ("OPE", "Unknown"),
                    ("OTH", "Unknown"),
                    ("P", "Unknown"),
                    ("Pac", "Unknown"),
                    ("PAI", "Unknown"),
                    ("PAR", "Unknown"),
                    ("PAY", "Unknown"),
                    ("PEN", "Unknown"),
                    ("PMT", "Unknown"),
                    (".PO", "Unknown"),
                    ("Pos", "Unknown"),
                    ("PRE", "Unknown"),
                    ("PRI", "Unknown"),
                    ("PRP", "Unknown"),
                    ("R", "Unknown"),
                    (".Re", "Unknown"),
                    (".RE", "Unknown"),
                    ("REF", "Unknown"),
                    ("REI", "Unknown"),
                    ("RFP", "Unknown"),
                    ("S", "Unknown"),
                    ("S-A", "Unknown"),
                    ("SA", "Unknown"),
                    ("Sal", "Unknown"),
                    ("S C", "Unknown"),
                    ("S.C", "Unknown"),
                    ("SCU", "Unknown"),
                    ("SEE", "Unknown"),
                    ("SEN", "Unknown"),
                    ("SEP", "Unknown"),
                    ("S.M.", "Unknown"),
                    ("SOF", "Unknown"),
                    ("SWI", "Unknown"),
                    ("T", "Unknown"),
                    ("TAX", "Unknown"),
                    ("TB", "Unknown"),
                    ("TB,", "Unknown"),
                    ("TIC", "Unknown"),
                    ("Tor", "Unknown"),
                    ("TRA", "Unknown"),
                    ("TRF", "Unknown"),
                    ("TRV", "Unknown"),
                    ("UN", "Unknown"),
                    ("UTI", "Unknown"),
                    ("V", "Unknown"),
                    ("VEN", "Unknown"),
                    ("-VO", "Unknown"),
                    ("VOI", "Unknown"),
                    ("VOY", "Unknown"),
                    ("WI", "Unknown"),
                    ("x", "Unknown"),
                    ("X", "Unknown"),
                    ("S-6", "Unknown"),
                    ("S.M", "Unknown"),
                    ("S-4", "Unknown"),
                    ("SA:", "Unknown"),
                    ("100", "Unknown"),
                    ("RFN", "Unknown"),
                    ("REN", "Unknown"),
                    ("003", "Unknown"),
                    ("S-1", "Unknown"),
                    ("08", "Unknown"),
                ],
                db_column="EXPN_CODE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=11
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=14, id="2712034", start_page=13
                    ),
                ],
                help_text="The type of expenditure",
                max_length=4,
                verbose_name="expense code",
            ),
        ),
        migrations.AlterField(
            model_name="expncd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F450P5",
                        "Form 450 (Campaign Disclosure Statement, Short Form (Recipient Committee)): Part 5, Payments Made",
                    ),
                    (
                        "D",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule D, Summary of Expenditures Supporting / Opposing Other Candidates, Measures and Committees",
                    ),
                    (
                        "E",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule E, Payments Made",
                    ),
                    (
                        "G",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule G, Payments Made by an Agent or Independent Contractor (on Behalf of This Committee)",
                    ),
                    (
                        "F461P5",
                        "Form 461 (Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)): Part 5, Contributions (Including Loans, Forgiveness of Loans, and LoanGuarantees) and Expenditures Made",
                    ),
                    (
                        "F465P3",
                        "Form 465 (Supplemental Independent Expenditure Report): Part 3, Independent Expenditures Made",
                    ),
                    (
                        "",
                        "Form 900: Campaign Disclosure Statement (Public employee retirement board candidate)",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=31
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=42
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=6,
            ),
        ),
        migrations.AlterField(
            model_name="expncd",
            name="juris_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ASM", "Assembly District"),
                    ("BOE", "Board of Equalization District"),
                    ("CIT", "City"),
                    ("CTY", "County"),
                    ("LOC", "Local"),
                    ("OTH", "Other"),
                    ("SEN", "Senate District"),
                    ("STW", "Statewide"),
                    ("Cit", "City"),
                    ("sen", "Senate District"),
                    ("Sen", "Senate District"),
                    ("stw", "Statewide"),
                    ("APP", "Statewide"),
                    ("ASR", "County"),
                    ("ATT", "Statewide"),
                    ("GOV", "Statewide"),
                    ("LTG", "Statewide"),
                    ("SOS", "Statewide"),
                    ("SUP", "Statewide"),
                    ("TRE", "Statewide"),
                    ("BSU", "County"),
                    ("CSU", "County"),
                    ("ES", "City"),
                    ("SM", "City"),
                    ("BED", "Other"),
                    ("CCB", "Other"),
                    ("CCM", "Other"),
                    ("PDR", "Other"),
                    ("12", "Senate District"),
                    ("4", "Statewide"),
                    ("8", "Statewide"),
                    ("27", "Statewide"),
                    ("93", "Statewide"),
                    ("98", "Statewide"),
                    ("CLB", "Unknown"),
                    ("PER", "Unknown"),
                    ("Boa", "Board of Equalization District"),
                    ("Sta", "Unknown"),
                    ("STA", "Unknown"),
                    ("CA", "Unknown"),
                    ("SAN", "Unknown"),
                    ("ES ", "Unknown"),
                    ("CON", "Unknown"),
                    ("LA", "Unknown"),
                    ("LBC", "Unknown"),
                    ("OR", "Unknown"),
                    ("SB", "Unknown"),
                    ("WES", "Unknown"),
                    ("BM", "Unknown"),
                    ("(Lo", "Unknown"),
                    ("(Ci", "Unknown"),
                    ("vty", "Unknown"),
                    ("OC", "Unknown"),
                    ("SM ", "Unknown"),
                    ("ASS", "Unknown"),
                    ("JR", "Unknown"),
                    ("O", "Unknown"),
                    ("ADM", "Unknown"),
                    ("SAC", "Unknown"),
                    ("US", "Unknown"),
                    ("J", "Unknown"),
                    ("LOS", "Unknown"),
                    ("IRV", "Unknown"),
                    ("CO", "Unknown"),
                    ("JRS", "Unknown"),
                    ("NEV", "Unknown"),
                    ("IB", "Unknown"),
                    ("A", "Unknown"),
                    ("Ass", "Unknown"),
                    ("SD", "Unknown"),
                    ("D", "Unknown"),
                    ("SEC", "Unknown"),
                    ("SC", "Unknown"),
                    ("RB", "Unknown"),
                    ("GEN", "Unknown"),
                    ("CC", "Unknown"),
                    ("FED", "Unknown"),
                    ("FM", "Unknown"),
                    ("R", "Unknown"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=32
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=44
                    ),
                ],
                help_text="Office Jurisdiction Code",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="expncd",
            name="off_s_h_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("H", "HELD"),
                    ("S", "SOUGHT"),
                    ("s", "SOUGHT"),
                    ("h", "HELD"),
                    ("A", "UNKNOWN"),
                    ("a", "UNKNOWN"),
                    ("8", "UNKNOWN"),
                    ("O", "UNKNOWN"),
                ],
                db_column="OFF_S_H_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=32
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=44
                    ),
                ],
                help_text="Office is sought or held code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="expncd",
            name="office_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("APP", "State Appellate Court Justice"),
                    ("ASM", "State Assembly Person"),
                    ("ASR", "Assessor"),
                    ("ATT", "Attorney General"),
                    ("BED", "Board of Education"),
                    ("BOE", "Board of Equalization Member"),
                    ("BSU", "Board of Supervisors"),
                    ("CAT", "City Attorney"),
                    ("CCB", "Community College Board"),
                    ("CCM", "City Council Member"),
                    ("CON", "State Controller"),
                    ("COU", "County Counsel"),
                    ("CSU", "County Supervisor"),
                    ("CTR", "Local Controller"),
                    ("DAT", "District Attorney"),
                    ("GOV", "Governor"),
                    ("INS", "Insurance Commissioner"),
                    ("LTG", "Lieutenant Governor"),
                    ("MAY", "Mayor"),
                    ("OTH", "Other"),
                    ("PDR", "Public Defender"),
                    ("PER", "Public Employees Retirement System"),
                    ("PLN", "Planning Commissioner"),
                    ("SCJ", "Superior Court Judge"),
                    ("SEN", "State Senator"),
                    ("SHC", "Sheriff-Coroner"),
                    ("SOS", "Secretary of State"),
                    ("SPM", "Supreme Court Justice"),
                    ("SUP", "Superintendent of Public Instruction"),
                    ("TRE", "State Treasurer"),
                    ("TRS", "Local Treasurer"),
                    ("Cou", "County Counsel"),
                    ("sen", "State Senator"),
                    ("AtT", "Attorney General"),
                    ("May", "Mayor"),
                    ("Sen", "State Senator"),
                    ("asm", "State Assembly Person"),
                    ("gov", "Governor"),
                    ("Gov", "Governor"),
                    ("LA", "Unknown"),
                    ("HOU", "Unknown"),
                    ("LAD", "Unknown"),
                    ("11A", "Unknown"),
                    ("001", "Unknown"),
                    ("BM", "Unknown"),
                    ("AS1", "Unknown"),
                    ("ASS", "Unknown"),
                    ("73", "Unknown"),
                    ("CIT", "Unknown"),
                    ("HSE", "Unknown"),
                    ("LT", "Unknown"),
                    ("CTY", "Unknown"),
                    ("STA", "Unknown"),
                    ("GO", "Unknown"),
                    ("CO", "Unknown"),
                    ("A", "Unknown"),
                    ("PAC", "Unknown"),
                    ("REP", "Unknown"),
                    ("OFF", "Unknown"),
                    ("SE", "Unknown"),
                    ("031", "Unknown"),
                    ("COM", "Unknown"),
                    ("ASB", "Unknown"),
                    ("OT", "Unknown"),
                    ("NAT", "Unknown"),
                    ("CC", "Unknown"),
                    ("SWE", "Unknown"),
                    ("FED", "Unknown"),
                    ("STE", "Unknown"),
                    ("H", "Unknown"),
                    ("DA", "Unknown"),
                    ("S", "Unknown"),
                    ("AS", "Unknown"),
                    ("OF", "Unknown"),
                    ("LEG", "Unknown"),
                    ("STW", "Unknown"),
                    ("ST", "Unknown"),
                    ("PRE", "Unknown"),
                    ("/S", "Unknown"),
                    ("U S", "Unknown"),
                    ("O", "Unknown"),
                    ("8", "Unknown"),
                    ("C:S", "Unknown"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=10
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=12
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712032", start_page=2
                    ),
                ],
                help_text="Identifies the office being sought",
                max_length=3,
                verbose_name="office code",
            ),
        ),
        migrations.AlterField(
            model_name="expncd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("EXPN", "Expense")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=31
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=42
                    ),
                ],
                help_text="Record Type Value: EXPN",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="expncd",
            name="sup_opp_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("O", "OPPOSITION"),
                    ("S", "SUPPORT"),
                    ("s", "SUPPORT"),
                    ("o", "OPPOSITION"),
                    ("H", "UNKNOWN"),
                    ("N", "UNKNOWN"),
                    ("X", "UNKNOWN"),
                    ("Y", "UNKNOWN"),
                ],
                db_column="SUP_OPP_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=32
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=44
                    ),
                ],
                help_text="Support or opposition code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="f495p2cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "",
                        "Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "",
                        "Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "",
                        "Form 495: Supplemental Pre-Election Campaign Statement (Recipient Committee)",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=26
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=35
                    ),
                ],
                help_text="Name of the source filing form to which the Form 495 is attached (must equal Form_Type in CVR record)",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="f495p2cd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("F495", "F495")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=26
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=35
                    ),
                ],
                help_text="Record Type Value: F495",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="f501502cd",
            name="district_cd",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (0, "N/A"),
                    (17001, "01"),
                    (17002, "13"),
                    (17003, "24"),
                    (17004, "35"),
                    (17005, "46"),
                    (17006, "57"),
                    (17007, "68"),
                    (17008, "79"),
                    (17009, "02"),
                    (17010, "05"),
                    (17011, "04"),
                    (17013, "06"),
                    (17014, "07"),
                    (17015, "08"),
                    (17016, "19"),
                    (17017, "10"),
                    (17018, "11"),
                    (17019, "12"),
                    (17020, "14"),
                    (17021, "15"),
                    (17022, "16"),
                    (17023, "17"),
                    (17024, "18"),
                    (17026, "20"),
                    (17027, "21"),
                    (17028, "22"),
                    (17029, "23"),
                    (17030, "25"),
                    (17031, "26"),
                    (17032, "27"),
                    (17033, "28"),
                    (17034, "29"),
                    (17035, "30"),
                    (17036, "31"),
                    (17037, "32"),
                    (17038, "33"),
                    (17039, "34"),
                    (17040, "36"),
                    (17041, "37"),
                    (17042, "38"),
                    (17043, "39"),
                    (17044, "40"),
                    (17045, "41"),
                    (17046, "42"),
                    (17047, "43"),
                    (17048, "44"),
                    (17049, "45"),
                    (17050, "47"),
                    (17051, "48"),
                    (17052, "49"),
                    (17053, "50"),
                    (17054, "51"),
                    (17055, "52"),
                    (17056, "53"),
                    (17057, "54"),
                    (17058, "55"),
                    (17059, "56"),
                    (17060, "03"),
                    (17061, "59"),
                    (17062, "60"),
                    (17063, "61"),
                    (17064, "62"),
                    (17065, "63"),
                    (17066, "64"),
                    (17067, "65"),
                    (17068, "66"),
                    (17069, "67"),
                    (17070, "69"),
                    (17071, "70"),
                    (17072, "71"),
                    (17073, "72"),
                    (17074, "73"),
                    (17075, "74"),
                    (17076, "75"),
                    (17077, "76"),
                    (17078, "77"),
                    (17079, "78"),
                    (17080, "80"),
                    (17081, "09"),
                    (17090, "58"),
                    (17012, "Unknown"),
                    (17082, "Unknown"),
                    (17025, "Unknown"),
                ],
                db_column="DISTRICT_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=13, id="2774529", start_page=11
                    )
                ],
                help_text="District number for the office being sought. Populated for Senate, Assembly, or Board of Equalization races.",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="f501502cd",
            name="elec_type",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (0, "N/A"),
                    (3001, "GENERAL"),
                    (3002, "PRIMARY"),
                    (3003, "RECALL"),
                    (3004, "SPECIAL ELECTION"),
                    (3005, "OFFICEHOLDER"),
                    (3006, "SPECIAL RUNOFF"),
                    (3007, "UNKNOWN"),
                ],
                db_column="ELEC_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=4, id="2774529", start_page=3
                    )
                ],
                help_text="Election type",
                null=True,
                verbose_name="Election type",
            ),
        ),
        migrations.AlterField(
            model_name="f501502cd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ATH", "Authorizing individual"),
                    ("ATR", "Assistant treasurer"),
                    ("BMC", "Ballot measure committee"),
                    ("BNM", "Ballot measure's name/title"),
                    ("CAO", "Candidate/officeholder"),
                    ("COM", "Committee"),
                    ("CTL", "Controlled committee"),
                    ("IND", "Individual"),
                    ("MDI", "Major Donor/Ind Expenditure"),
                    ("OFF", "Officer"),
                    ("OTH", "Other"),
                    ("POF", "Principal officer"),
                    ("PRO", "Proponent"),
                    ("PTY", "Political Party"),
                    ("RCP", "Recipient committee"),
                    ("SCC", "Small Contributor Committee"),
                    ("SMO", "Slate-mailer organization"),
                    ("SPO", "Sponsor"),
                    ("TRE", "Treasurer"),
                    ("8", "Unknown"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=9, id="2712033", start_page=8
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=11, id="2712034", start_page=9
                    ),
                ],
                help_text="Entity code",
                max_length=9,
            ),
        ),
        migrations.AlterField(
            model_name="f501502cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("", "Form 501: Candidate Intention Statement"),
                    ("", "Form 502: Campaign Bank Account Statement"),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711614", start_page=58
                    )
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="f501502cd",
            name="juris_cd",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (0, "N/A"),
                    (40501, "LOCAL"),
                    (40502, "STATE"),
                    (40503, "COUNTY"),
                    (40504, "MULTI-COUNTY"),
                    (40505, "CITY"),
                    (40507, "SUPERIOR COURT JUDGE"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=20, id="2774529", start_page=19
                    )
                ],
                help_text="Office jurisdiction code",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="f501502cd",
            name="office_cd",
            field=calaccess_raw.fields.IntegerField(
                choices=[
                    (0, "N/A"),
                    (30001, "PRESIDENT"),
                    (30002, "GOVERNOR"),
                    (30003, "LIEUTENANT GOVERNOR"),
                    (30004, "SECRETARY OF STATE"),
                    (30005, "CONTROLLER"),
                    (30006, "TREASURER"),
                    (30007, "ATTORNEY GENERAL"),
                    (30008, "SUPERINTENDENT OF PUBLIC INSTRUCTION"),
                    (30009, "MEMBER BOARD OF EQUALIZATION"),
                    (30010, "OXNARD HARBOR COMMISSIONER"),
                    (30011, "CITY CONTROLLER"),
                    (30012, "STATE SENATE"),
                    (30013, "ASSEMBLY"),
                    (30014, "INSURANCE COMMISSIONER"),
                    (30015, "JUDGE"),
                    (30016, "BOARD MEMBER"),
                    (30017, "TAX COLLECTOR"),
                    (30018, "TRUSTEE"),
                    (30019, "SUPERVISOR"),
                    (30020, "SHERIFF"),
                    (30021, "CORONER"),
                    (30022, "MARSHALL"),
                    (30023, "CITY CLERK"),
                    (30024, "SCHOOL BOARD"),
                    (30025, "HARBOR COMMISSIONER"),
                    (30026, "DISTRICT ATTORNEY"),
                    (30027, "COUNTY CLERK"),
                    (30028, "AUDITOR"),
                    (30029, "MAYOR"),
                    (30030, "CITY ATTORNEY"),
                    (30031, "DEMOCRATIC COUNTY CENTRAL COMMITTEE"),
                    (30032, "TOWN COUNCIL"),
                    (30033, "ASSESSOR"),
                    (30034, "CITY TREASURER"),
                    (30035, "CITY COUNCIL"),
                    (30036, "COMMISSIONER"),
                    (30037, "REPUBLICAN COUNTY CENTRAL COMMITTEE"),
                    (30038, "DIRECTOR"),
                    (30039, "DIRECTOR OF ZONE 7"),
                    (30040, "COMMUNITY COLLEGE BOARD"),
                    (30041, "POLICE CHIEF"),
                    (30042, "CHIEF OF POLICE"),
                    (30043, "CENTRAL COMMITTEE"),
                    (30044, "BOARD OF EDUCATION"),
                    (30045, "BOARD OF DIRECTORS"),
                    (30046, "COLLEGE BOARD"),
                    (30047, "BART BOARD DIRECTOR"),
                    (30048, "BOARD OF TRUSTEES"),
                    (30049, "IRRIGATION"),
                    (30050, "WATER BOARD"),
                    (30051, "COMMUNITY PLANNING GROUP"),
                    (30052, "BOARD OF SUPERVISORS"),
                    (30053, "SUPERIOR COURT JUDGE"),
                    (30054, "DISTRICT ATTORNEY/PUBLIC DEFENDER"),
                    (30055, "MEASURE"),
                    (30056, "CITY PROSECUTOR"),
                    (30057, "SUPREME COURT JUDGE"),
                    (30058, "PUBLIC EMPLOYEES RETIREMENT BOARD"),
                    (30059, "APPELLATE COURT JUDGE"),
                    (50001, "Ag"),
                    (50002, "Assembly"),
                    (50003, "Assessor"),
                    (50004, "Assessor/Clerk/Recorder"),
                    (50005, "Assessor/County Clerk/Recorder"),
                    (50006, "Assessor/Recorder"),
                    (50007, "Associate Justice"),
                    (50008, "Auditor"),
                    (50009, "Auditor/Controller"),
                    (50010, "Auditor/Controller/Clerk/Recorder"),
                    (50011, "Auditor/Controller/Recorder"),
                    (50012, "Auditor/Controller/Treasurer/Tax Collector"),
                    (50013, "Auditor/Recorder"),
                    (50014, "Board Member"),
                    (50015, "Board Of Director"),
                    (50016, "Board Of Supervisor"),
                    (50017, "Boe"),
                    (50018, "Chief Justice"),
                    (50019, "City"),
                    (50020, "City Attorney"),
                    (50021, "City Auditor"),
                    (50022, "City Clerk"),
                    (50023, "City Council"),
                    (50024, "City Of Los Angeles"),
                    (50025, "City Of South El Monte"),
                    (50026, "City Prosecutor"),
                    (50027, "City Treasurer"),
                    (50028, "Clerk/Auditor"),
                    (50029, "Clerk/Record/Public Admin"),
                    (50030, "Clerk/Recorder"),
                    (50031, "Clerk/Recorder/Registar"),
                    (50032, "Clerk/Recorder/Registrar"),
                    (50033, "Commissioner"),
                    (50034, "Controller"),
                    (50035, "Costa Mesa"),
                    (50036, "Council Member"),
                    (50037, "County Clerk"),
                    (50038, "County Clerk/Auditor"),
                    (50039, "County Clerk/Auditor/Controller"),
                    (50040, "County Clerk/Recorder"),
                    (50041, "County Clerk/Recorder/Assessor"),
                    (50042, "County Clerk/Recorder/Public Admin"),
                    (50043, "Democratic County Central Committee"),
                    (50044, "Director"),
                    (50045, "District Attorney"),
                    (50046, "District Attorney/Public Administrator"),
                    (50047, "Gccc"),
                    (50048, "Governor"),
                    (50049, "Harbor Commissioner"),
                    (50050, "Ic"),
                    (50051, "Irrigation Dist"),
                    (50052, "Judge"),
                    (50053, "Justice"),
                    (50054, "Legislature"),
                    (50055, "Lieutenant Governor"),
                    (50056, "Mayor"),
                    (50057, "N/A"),
                    (50058, "Placentia"),
                    (50059, "Public Administrator"),
                    (50060, "Public Administrator/Guardian"),
                    (50061, "Rent Stabilization Board"),
                    (50062, "Republican Central Committee"),
                    (50063, "San Francisco Dccc"),
                    (50064, "Sanger"),
                    (50065, "School Board"),
                    (50066, "Secretary Of State"),
                    (50067, "Senator"),
                    (50068, "Sheriff"),
                    (50069, "Sheriff/Coroner"),
                    (50070, "Sheriff/Coroner/Marshall"),
                    (50071, "Sheriff/Coroner/Public Administrator"),
                    (50072, "Solana Beach"),
                    (50073, "Superintendent"),
                    (50074, "Supervisor"),
                    (50075, "Supt Of Schools"),
                    (50076, "Tax Collector"),
                    (50077, "Town Council"),
                    (50078, "Treasurer"),
                    (50079, "Treasurer/Tax Collector"),
                    (50080, "Treasurer/Tax Collector/Clerk"),
                    (50081, "Treasurer/Tax Collector/Public Administrator"),
                    (
                        50082,
                        "Treasurer/Tax Collector/Public Administrator/County Clerk",
                    ),
                    (50083, "Treasurer/Tax Collector/Recorder"),
                    (50084, "Trustee"),
                    (50085, "Weed Recreation Board Member"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=22, id="2774529", start_page=20
                    )
                ],
                help_text="Identifies the office being sought",
                verbose_name="office code",
            ),
        ),
        migrations.AlterField(
            model_name="f501502cd",
            name="party_cd",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (0, "N/A"),
                    (16001, "DEMOCRATIC"),
                    (16002, "REPUBLICAN"),
                    (16003, "GREEN PARTY"),
                    (16004, "REFORM PARTY"),
                    (16005, "AMERICAN INDEPENDENT PARTY"),
                    (16006, "PEACE AND FREEDOM"),
                    (16007, "INDEPENDENT"),
                    (16008, "LIBERTARIAN"),
                    (16009, "NON PARTISAN"),
                    (16010, "NATURAL LAW"),
                    (16011, "UNKNOWN"),
                    (16012, "NO PARTY PREFERENCE"),
                    (16013, "AMERICANS ELECT"),
                    (16014, "UNKNOWN"),
                    (16020, "PEACE AND FREEDOM"),
                ],
                db_column="PARTY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=11, id="2774529", start_page=10
                    )
                ],
                help_text="Party code",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="f501502cd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("CVR", "CVR")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711614", start_page=58
                    )
                ],
                help_text="Record Type",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="f501502cd",
            name="stmt_type",
            field=calaccess_raw.fields.IntegerField(
                choices=[
                    (10001, "ORIGINAL/INITIAL"),
                    (10002, "AMENDMENT"),
                    (10003, "TERMINATION"),
                    (
                        10004,
                        "REDESIGNATE THE ACCOUNT FOR FUTURE ELECTION TO THE SAME OFFICE",
                    ),
                    (10005, "LOG"),
                    (10006, "LOG/AMENDMENT"),
                    (10007, "AS FILED BY COMMITTEE"),
                ],
                db_column="STMT_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774529", start_page=6
                    )
                ],
                help_text="Type of statement",
                verbose_name="statement type",
            ),
        ),
        migrations.AlterField(
            model_name="f690p2cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("", "Form 615: Lobbyist Report"),
                    ("", "Form 625: Report of Lobbying Firm"),
                    (
                        "",
                        "Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    ("", "Form 645: Report of Person Spending $5,000 or More"),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=58
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=72
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="f690p2cd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("F690", "F690")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=58
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=72
                    ),
                ],
                help_text="Record Type Value: F690",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="fileraddresscd",
            name="add_type",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (51, "PERMANENT"),
                    (7026, "BUSINESS"),
                    (7027, "HOME"),
                    (7050, "NOT IN USE"),
                    (7051, "PERMANENT"),
                    (7082, "MAILING ADDRESS"),
                ],
                db_column="ADD_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774529", start_page=5
                    )
                ],
                help_text="Address type",
                null=True,
                verbose_name="Address type",
            ),
        ),
        migrations.AlterField(
            model_name="filerfilingscd",
            name="filing_type",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[(0, "N/A"), (22001, "Electronic"), (22006, "Cal Online")],
                db_column="FILING_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711615", start_page=2
                    )
                ],
                help_text="The type of filing",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="filerfilingscd",
            name="form_id",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "",
                        "Form 400: Statement of Organization (Slate Mailer Organization)",
                    ),
                    (
                        "",
                        "Form 401: Campaign Disclosure Statement (Slate Mailer Organization)",
                    ),
                    (
                        "",
                        "Form 402: Statement of Termination (Slate Mailer Organization)",
                    ),
                    ("", "Form 405: Amendment to Campaign Disclosure Statement"),
                    ("", "Form 410: Statement of Organization (Recipient Committee)"),
                    ("", "Form 415: Title Unknown"),
                    ("", "Form 416: Title Unknown"),
                    (
                        "",
                        "Form 419: Campaign Disclosure Statement, Long Form (Ballot Measure Committee)",
                    ),
                    (
                        "",
                        "Form 420: Campaign Disclosure Statement, Long Form (Recipient Committee)",
                    ),
                    (
                        "",
                        "Form 425: Semi-Annual Statement of No Activity (Recipient Committee)",
                    ),
                    ("", "Form 430: Title Unknown"),
                    (
                        "",
                        "Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "",
                        "Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "",
                        "Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    ("", "Form 465: Supplemental Independent Expenditure Report"),
                    (
                        "",
                        "Form 470: Campaign Disclosure Statement, Short Form (Officeholders and Candidates)",
                    ),
                    (
                        "",
                        "Form 490: Campaign Disclosure Statement, Long Form (Officeholders and Candidates)",
                    ),
                    (
                        "",
                        "Form 495: Supplemental Pre-Election Campaign Statement (Recipient Committee)",
                    ),
                    ("", "Form 496: Late Independent Expenditure Report"),
                    ("", "Form 497: Late Contribution Report"),
                    ("", "Form 498: Late Payment Report (Slate Mailer Organization)"),
                    ("", "Form 501: Candidate Intention Statement"),
                    ("", "Form 502: Campaign Bank Account Statement"),
                    ("", "Form 511: Paid Spokesperson Report"),
                    ("", "Electronic Form 530: Electronic Issue Advocacy Report"),
                    ("", "Form 601: Lobbying Firm Registration Statement"),
                    ("", "Form 602: Lobbying Firm Activity Authorization"),
                    (
                        "",
                        "Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                    ),
                    ("", "Form 604: Lobbyist Certification Statement"),
                    (
                        "",
                        "Form 605: Amendment to Registration, Lobbying Firm, Lobbyist Employer, Lobbying Coalition",
                    ),
                    ("", "Form 606: Notice of Termination"),
                    ("", "Form 607: Notice of Withdrawal"),
                    ("", "Form 615: Lobbyist Report"),
                    ("", "Form 625: Report of Lobbying Firm"),
                    (
                        "",
                        "Schedule 630: Payments Made to Lobbying Coalitions (Attachment to Form 625 or 635)",
                    ),
                    (
                        "",
                        "Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    (
                        "S635-C",
                        "Schedule 635C: Payments Received by Lobbying Coalitions",
                    ),
                    (
                        "",
                        "Schedule 640: Governmental Agencies Reporting (Attachment to Form 635 or Form 645)",
                    ),
                    ("", "Form 645: Report of Person Spending $5,000 or More"),
                    ("", "Form 690: Amendment to Lobbying Disclosure Report"),
                    ("", "Form 700: Statement of Economic Interest"),
                    (
                        "",
                        "Form 900: Campaign Disclosure Statement (Public employee retirement board candidate)",
                    ),
                    ("F111", "Unknown"),
                    ("F410 AT", "Unknown"),
                    ("F410ATR", "Unknown"),
                    ("F421", "Unknown"),
                    ("F440", "Unknown"),
                    (
                        "F470S",
                        "Form 470: Campaign Disclosure Statement, Short Form (Officeholders and Candidates)",
                    ),
                    ("F480", "Unknown"),
                    ("F500", "Unknown"),
                    (
                        "F501502",
                        "Forms 501 and/or 502 (Candidate Intention and/or Bank Account Statements)",
                    ),
                    ("F555", "Unknown"),
                    ("F666", "Unknown"),
                    ("F777", "Unknown"),
                    ("F888", "Unknown"),
                    ("F999", "Unknown"),
                ],
                db_column="FORM_ID",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711614", start_page=65
                    )
                ],
                help_text="Form identification code",
                max_length=7,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="filerfilingscd",
            name="stmnt_status",
            field=calaccess_raw.fields.IntegerField(
                choices=[
                    (11001, "COMPLETE"),
                    (11002, "INCOMPLETE"),
                    (11003, "NEEDS REVIEW"),
                ],
                db_column="STMNT_STATUS",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774529", start_page=6
                    )
                ],
                help_text="The status of the statement. If the filing has been reviewed or not reviewed.",
                null=True,
                verbose_name="statement status",
            ),
        ),
        migrations.AlterField(
            model_name="filerfilingscd",
            name="stmnt_type",
            field=calaccess_raw.fields.IntegerField(
                choices=[
                    (0, "N/A"),
                    (10001, "ORIGINAL/INITIAL"),
                    (10002, "AMENDMENT"),
                    (10003, "TERMINATION"),
                    (
                        10004,
                        "REDESIGNATE THE ACCOUNT FOR FUTURE ELECTION TO THE SAME OFFICE",
                    ),
                    (10005, "LOG"),
                    (10006, "LOG/AMENDMENT"),
                    (10007, "AS FILED BY COMMITTEE"),
                ],
                db_column="STMNT_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774529", start_page=6
                    )
                ],
                help_text="Type of statement",
                verbose_name="statement type",
            ),
        ),
        migrations.AlterField(
            model_name="filerinterestscd",
            name="interest_cd",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (0, "N/A"),
                    (40301, "AGRICULTURE"),
                    (40302, "EDUCATION"),
                    (40303, "ENTERTAINMENT/RECREATION"),
                    (40304, "FINANCE/INSURANCE"),
                    (40305, "GOVERNMENT"),
                    (40306, "HEALTH"),
                    (40307, "LABOR UNIONS"),
                    (40308, "LEGAL"),
                    (40309, "LODGING/RESTAURANTS"),
                    (40310, "MANUFACTURING/INDUSTRIAL"),
                    (40311, "MERCHANDISE/RETAIL"),
                    (40312, "MISCELLANEOUS"),
                    (40313, "OIL AND GAS"),
                    (40314, "POLITICAL ORGANIZATIONS"),
                    (40315, "PROFESSIONAL/TRADE"),
                    (40316, "PUBLIC EMPLOYEES"),
                    (40317, "REAL ESTATE"),
                    (40318, "TRANSPORTATION"),
                    (40319, "UTILITIES"),
                ],
                db_column="INTEREST_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774529", start_page=19
                    )
                ],
                help_text="Interest code linked to the filer",
                null=True,
                verbose_name="interest code",
            ),
        ),
        migrations.AlterField(
            model_name="filerlinkscd",
            name="link_type",
            field=calaccess_raw.fields.IntegerField(
                choices=[
                    (-12019, "CANDIDATE CONTROLLED CAUCUS COMMITTEE"),
                    (-12018, "PROPONENT"),
                    (-12016, "TREASURER/RESPONSIBLE OFFICER FOR"),
                    (-12015, "ASSOCIATED"),
                    (-12014, "SUPPORT"),
                    (-12013, "OPPOSE"),
                    (-12011, "CONTROLLING CANDIDATE"),
                    (-12008, "FIRM OF A LOBBYIST"),
                    (-12005, "FIRM OF A CLIENT (WHO IS ALSO A FIRM)"),
                    (-12004, "FIRM OF A CLIENT (WHO IS AN EMPLOYER)"),
                    (-12002, "EMPLOYER OF  AN IN-HOUSE LOBBYIST"),
                    (-12001, "CLIENT OF A FIRM"),
                    (0, "N/A"),
                    (12001, "FIRM OF A CLIENT"),
                    (12002, "IN-HOUSE LOBBYIST OF AN EMPLOYER"),
                    (12004, "CLIENT (WHO IS AN EMPLOYER) OF A FIRM"),
                    (12005, "CLIENT (WHO IS ALSO A FIRM) OF ANOTHER FIRM"),
                    (12008, "LOBBYIST OF A FIRM"),
                    (12011, "CANDIDATE CONTROLS THIS COMMITTEE"),
                    (12013, "OPPOSE"),
                    (12014, "SUPPORT"),
                    (12015, "ASSOCIATED"),
                    (12016, "TREASURER/RESPONSIBLE OFFICER"),
                    (12018, "PROPONENT"),
                    (12019, "CANDIDATE CONTROLLED CAUCUS COMMITTEE"),
                ],
                db_column="LINK_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=7, id="2774529", start_page=6
                    )
                ],
                help_text="Denotes the type of the link",
                verbose_name="link type",
            ),
        ),
        migrations.AlterField(
            model_name="filernamecd",
            name="filer_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("NOT DEFINED", "Undefined"),
                    ("ALL FILERS", "All filers"),
                    ("CANDIDATE/OFFICEHOLDER", "Candidate/officeholder"),
                    ("CLIENT", "Client"),
                    ("EMPLOYER", "Employer"),
                    ("FIRM", "Firm"),
                    ("INDIVIDUAL", "Individual"),
                    ("INITIATIVE", "Initiative"),
                    ("LOBBYIST", "Lobbyist"),
                    (
                        "MAJOR DONOR/INDEPENDENT EXPENDITURE COMMITTEE",
                        "Major donor or indenpendent expenditure committee",
                    ),
                    ("PAYMENT TO INFLUENCE", "Payment to influence"),
                    ("PREPAID ACCOUNT", "Prepaid account"),
                    ("PROPONENT", "Proponent"),
                    ("PROPOSITION", "Proposition"),
                    ("RECIPIENT COMMITTEE", "Recipient committee"),
                    ("SLATE MAILER ORGANIZATIONS", "Slate mailer organization"),
                    ("TREASURER/RESPONSIBLE OFFICER", "Treasurer/responsible officer"),
                ],
                db_column="FILER_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774536", start_page=1
                    )
                ],
                help_text="The type of filer. These values are found FILER_TYPES_CD.DESCRIPTION",
                max_length=45,
            ),
        ),
        migrations.AlterField(
            model_name="filernamecd",
            name="status",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("", "Undefined"),
                    ("A", "ACTIVE"),
                    ("P", "PENDING"),
                    ("R", "REVOKED"),
                    ("S", "SUSPENDED"),
                    ("W", "WITHDRAWN"),
                    ("Y", "ACTIVE"),
                    ("N", "INACTIVE"),
                    ("T", "TERMINATED"),
                    ("ACTIVE", "ACTIVE"),
                    ("INACTIVE", "INACTIVE"),
                    ("TERMINATED", "TERMINATED"),
                ],
                db_column="STATUS",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774537", start_page=1
                    )
                ],
                help_text="The status of the filer. Includes a mixture of values found in the STATUS_TYPE and STATUS_DESC columns on FILER_STATUS_TYPES_CD",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="filertofilertypecd",
            name="category",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (0, "N/A"),
                    (40000, "CATEGORY"),
                    (40001, "JOINTLY CONTROLLED"),
                    (40002, "CONTROLLED"),
                    (40003, "CAUCUS COMMITTEE"),
                    (40004, "Unknown"),
                ],
                db_column="CATEGORY",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774529", start_page=18
                    )
                ],
                help_text="Defines the filer's category such as controlled, jointly controlled, etc. (subset of filer's type)",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="filertofilertypecd",
            name="category_type",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (0, "N/A"),
                    (40501, "LOCAL"),
                    (40502, "STATE"),
                    (40503, "COUNTY"),
                    (40504, "MULTI-COUNTY"),
                    (40505, "CITY"),
                    (40506, "FEDERAL"),
                    (40507, "SUPERIOR COURT JUDGE"),
                ],
                db_column="CATEGORY_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=20, id="2774529", start_page=19
                    )
                ],
                help_text="When applicable, the category type specifies additional information about the category. (e.g. state, local, etc.)",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="filertofilertypecd",
            name="county_cd",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (0, "N/A"),
                    (18001, "01"),
                    (18002, "12"),
                    (18003, "23"),
                    (18004, "34"),
                    (18005, "45"),
                    (18006, "55"),
                    (18007, "56"),
                    (18008, "57"),
                    (18009, "58"),
                    (18010, "02"),
                    (18011, "03"),
                    (18012, "04"),
                    (18013, "05"),
                    (18014, "06"),
                    (18015, "07"),
                    (18016, "08"),
                    (18017, "09"),
                    (18018, "10"),
                    (18019, "11"),
                    (18020, "13"),
                    (18021, "14"),
                    (18022, "15"),
                    (18023, "16"),
                    (18024, "17"),
                    (18025, "18"),
                    (18026, "19"),
                    (18027, "20"),
                    (18028, "21"),
                    (18029, "22"),
                    (18030, "24"),
                    (18031, "25"),
                    (18032, "26"),
                    (18033, "27"),
                    (18034, "28"),
                    (18035, "29"),
                    (18036, "30"),
                    (18037, "31"),
                    (18038, "32"),
                    (18039, "33"),
                    (18040, "35"),
                    (18041, "36"),
                    (18042, "37"),
                    (18043, "38"),
                    (18044, "39"),
                    (18045, "40"),
                    (18046, "41"),
                    (18047, "42"),
                    (18048, "43"),
                    (18049, "44"),
                    (18050, "46"),
                    (18051, "47"),
                    (18052, "48"),
                    (18053, "49"),
                    (18054, "50"),
                    (18055, "51"),
                    (18056, "52"),
                    (18057, "53"),
                    (18058, "54"),
                ],
                db_column="COUNTY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=15, id="2774529", start_page=13
                    )
                ],
                help_text="Filer's county code",
                null=True,
                verbose_name="county code",
            ),
        ),
        migrations.AlterField(
            model_name="filertofilertypecd",
            name="district_cd",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (0, "N/A"),
                    (17001, "01"),
                    (17002, "13"),
                    (17003, "24"),
                    (17004, "35"),
                    (17005, "46"),
                    (17006, "57"),
                    (17007, "68"),
                    (17008, "79"),
                    (17009, "02"),
                    (17010, "05"),
                    (17011, "04"),
                    (17013, "06"),
                    (17014, "07"),
                    (17015, "08"),
                    (17016, "19"),
                    (17017, "10"),
                    (17018, "11"),
                    (17019, "12"),
                    (17020, "14"),
                    (17021, "15"),
                    (17022, "16"),
                    (17023, "17"),
                    (17024, "18"),
                    (17026, "20"),
                    (17027, "21"),
                    (17028, "22"),
                    (17029, "23"),
                    (17030, "25"),
                    (17031, "26"),
                    (17032, "27"),
                    (17033, "28"),
                    (17034, "29"),
                    (17035, "30"),
                    (17036, "31"),
                    (17037, "32"),
                    (17038, "33"),
                    (17039, "34"),
                    (17040, "36"),
                    (17041, "37"),
                    (17042, "38"),
                    (17043, "39"),
                    (17044, "40"),
                    (17045, "41"),
                    (17046, "42"),
                    (17047, "43"),
                    (17048, "44"),
                    (17049, "45"),
                    (17050, "47"),
                    (17051, "48"),
                    (17052, "49"),
                    (17053, "50"),
                    (17054, "51"),
                    (17055, "52"),
                    (17056, "53"),
                    (17057, "54"),
                    (17058, "55"),
                    (17059, "56"),
                    (17060, "03"),
                    (17061, "59"),
                    (17062, "60"),
                    (17063, "61"),
                    (17064, "62"),
                    (17065, "63"),
                    (17066, "64"),
                    (17067, "65"),
                    (17068, "66"),
                    (17069, "67"),
                    (17070, "69"),
                    (17071, "70"),
                    (17072, "71"),
                    (17073, "72"),
                    (17074, "73"),
                    (17075, "74"),
                    (17076, "75"),
                    (17077, "76"),
                    (17078, "77"),
                    (17079, "78"),
                    (17080, "80"),
                    (17081, "09"),
                    (17090, "58"),
                    (17091, "Unknown"),
                    (17083, "Unknown"),
                    (17093, "Unknown"),
                    (17094, "Unknown"),
                    (17088, "Unknown"),
                    (17096, "Unknown"),
                    (17012, "Unknown"),
                    (17095, "Unknown"),
                    (17092, "Unknown"),
                    (17086, "Unknown"),
                    (17099, "Unknown"),
                    (17082, "Unknown"),
                    (17025, "Unknown"),
                    (17085, "Unknown"),
                    (17084, "Unknown"),
                    (17087, "Unknown"),
                    (17098, "Unknown"),
                    (17089, "Unknown"),
                ],
                db_column="DISTRICT_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=13, id="2774529", start_page=11
                    )
                ],
                help_text="Filer's district number for the office being sought. Populated for Senate, Assembly or Board of Equalization races",
                null=True,
                verbose_name="county code",
            ),
        ),
        migrations.AlterField(
            model_name="filertofilertypecd",
            name="election_type",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (0, "N/A"),
                    (3001, "GENERAL"),
                    (3002, "PRIMARY"),
                    (3003, "RECALL"),
                    (3004, "SPECIAL ELECTION"),
                    (3005, "OFFICEHOLDER"),
                    (3006, "SPECIAL RUNOFF"),
                    (3010, "Unknown"),
                    (3007, "Unknown"),
                ],
                db_column="ELECTION_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=4, id="2774529", start_page=3
                    )
                ],
                help_text="Indicates type of election (general, primary, special)",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="filertofilertypecd",
            name="party_cd",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (16001, "DEMOCRATIC"),
                    (16002, "REPUBLICAN"),
                    (16003, "GREEN PARTY"),
                    (16004, "REFORM PARTY"),
                    (16005, "AMERICAN INDEPENDENT PARTY"),
                    (16006, "PEACE AND FREEDOM"),
                    (16007, "INDEPENDENT"),
                    (16008, "LIBERTARIAN"),
                    (16009, "NON PARTISAN"),
                    (16010, "NATURAL LAW"),
                    (16011, "UNKNOWN"),
                    (16012, "NO PARTY PREFERENCE"),
                    (16013, "AMERICANS ELECT"),
                    (16020, "PEACE AND FREEDOM"),
                    (16014, "UNKNOWN"),
                    (0, "UNKNOWN"),
                    (None, "NONE"),
                ],
                db_column="PARTY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=11, id="2774529", start_page=10
                    )
                ],
                help_text="Filer's political party",
                null=True,
                verbose_name="party code",
            ),
        ),
        migrations.AlterField(
            model_name="filertofilertypecd",
            name="race",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (0, "N/A"),
                    (30002, "GOVERNOR"),
                    (30003, "LIEUTENANT GOVERNOR"),
                    (30004, "SECRETARY OF STATE"),
                    (30005, "CONTROLLER"),
                    (30006, "TREASURER"),
                    (30007, "ATTORNEY GENERAL"),
                    (30008, "SUPERINTENDENT OF PUBLIC INSTRUCTION"),
                    (30009, "MEMBER BOARD OF EQUALIZATION"),
                    (30010, "OXNARD HARBOR COMMISSIONER"),
                    (30011, "CITY CONTROLLER"),
                    (30012, "STATE SENATE"),
                    (30013, "ASSEMBLY"),
                    (30014, "INSURANCE COMMISSIONER"),
                    (30015, "JUDGE"),
                    (30016, "BOARD MEMBER"),
                    (30017, "TAX COLLECTOR"),
                    (30018, "TRUSTEE"),
                    (30019, "SUPERVISOR"),
                    (30020, "SHERIFF"),
                    (30021, "CORONER"),
                    (30022, "MARSHALL"),
                    (30023, "CITY CLERK"),
                    (30024, "SCHOOL BOARD"),
                    (30025, "HARBOR COMMISSIONER"),
                    (30026, "DISTRICT ATTORNEY"),
                    (30027, "COUNTY CLERK"),
                    (30028, "AUDITOR"),
                    (30029, "MAYOR"),
                    (30030, "CITY ATTORNEY"),
                    (30031, "DEMOCRATIC COUNTY CENTRAL COMMITTEE"),
                    (30032, "TOWN COUNCIL"),
                    (30033, "ASSESSOR"),
                    (30034, "CITY TREASURER"),
                    (30035, "CITY COUNCIL"),
                    (30036, "COMMISSIONER"),
                    (30037, "REPUBLICAN COUNTY CENTRAL COMMITTEE"),
                    (30038, "DIRECTOR"),
                    (30039, "DIRECTOR OF ZONE 7"),
                    (30040, "COMMUNITY COLLEGE BOARD"),
                    (30041, "POLICE CHIEF"),
                    (30042, "CHIEF OF POLICE"),
                    (30043, "CENTRAL COMMITTEE"),
                    (30044, "BOARD OF EDUCATION"),
                    (30045, "BOARD OF DIRECTORS"),
                    (30046, "COLLEGE BOARD"),
                    (30047, "BART BOARD DIRECTOR"),
                    (30048, "BOARD OF TRUSTEES"),
                    (30049, "IRRIGATION"),
                    (30050, "WATER BOARD"),
                    (30051, "COMMUNITY PLANNING GROUP"),
                    (30052, "BOARD OF SUPERVISORS"),
                    (30053, "SUPERIOR COURT JUDGE"),
                    (30054, "DISTRICT ATTORNEY/PUBLIC DEFENDER"),
                    (30055, "MEASURE"),
                    (30056, "CITY PROSECUTOR"),
                    (30057, "SUPREME COURT JUDGE"),
                    (30058, "PUBLIC EMPLOYEES RETIREMENT BOARD"),
                    (30059, "APPELLATE COURT JUDGE"),
                    (50001, "Ag"),
                    (50002, "Assembly"),
                    (50003, "Assessor"),
                    (50004, "Assessor/Clerk/Recorder"),
                    (50005, "Assessor/County Clerk/Recorder"),
                    (50006, "Assessor/Recorder"),
                    (50007, "Associate Justice"),
                    (50008, "Auditor"),
                    (50009, "Auditor/Controller"),
                    (50010, "Auditor/Controller/Clerk/Recorder"),
                    (50011, "Auditor/Controller/Recorder"),
                    (50012, "Auditor/Controller/Treasurer/Tax Collector"),
                    (50013, "Auditor/Recorder"),
                    (50014, "Board Member"),
                    (50015, "Board Of Director"),
                    (50016, "Board Of Supervisor"),
                    (50017, "Boe"),
                    (50018, "Chief Justice"),
                    (50019, "City"),
                    (50020, "City Attorney"),
                    (50021, "City Auditor"),
                    (50022, "City Clerk"),
                    (50023, "City Council"),
                    (50024, "City Of Los Angeles"),
                    (50025, "City Of South El Monte"),
                    (50026, "City Prosecutor"),
                    (50027, "City Treasurer"),
                    (50028, "Clerk/Auditor"),
                    (50029, "Clerk/Record/Public Admin"),
                    (50030, "Clerk/Recorder"),
                    (50031, "Clerk/Recorder/Registar"),
                    (50032, "Clerk/Recorder/Registrar"),
                    (50033, "Commissioner"),
                    (50034, "Controller"),
                    (50035, "Costa Mesa"),
                    (50036, "Council Member"),
                    (50037, "County Clerk"),
                    (50038, "County Clerk/Auditor"),
                    (50039, "County Clerk/Auditor/Controller"),
                    (50040, "County Clerk/Recorder"),
                    (50041, "County Clerk/Recorder/Assessor"),
                    (50042, "County Clerk/Recorder/Public Admin"),
                    (50043, "Democratic County Central Committee"),
                    (50044, "Director"),
                    (50045, "District Attorney"),
                    (50046, "District Attorney/Public Administrator"),
                    (50047, "Gccc"),
                    (50048, "Governor"),
                    (50049, "Harbor Commissioner"),
                    (50050, "Ic"),
                    (50051, "Irrigation Dist"),
                    (50052, "Judge"),
                    (50053, "Justice"),
                    (50054, "Legislature"),
                    (50055, "Lieutenant Governor"),
                    (50056, "Mayor"),
                    (50057, "N/A"),
                    (50058, "Placentia"),
                    (50059, "Public Administrator"),
                    (50060, "Public Administrator/Guardian"),
                    (50061, "Rent Stabilization Board"),
                    (50062, "Republican Central Committee"),
                    (50063, "San Francisco Dccc"),
                    (50064, "Sanger"),
                    (50065, "School Board"),
                    (50066, "Secretary Of State"),
                    (50067, "Senator"),
                    (50068, "Sheriff"),
                    (50069, "Sheriff/Coroner"),
                    (50070, "Sheriff/Coroner/Marshall"),
                    (50071, "Sheriff/Coroner/Public Administrator"),
                    (50072, "Solana Beach"),
                    (50073, "Superintendent"),
                    (50074, "Supervisor"),
                    (50075, "Supt Of Schools"),
                    (50076, "Tax Collector"),
                    (50077, "Town Council"),
                    (50078, "Treasurer"),
                    (50079, "Treasurer/Tax Collector"),
                    (50080, "Treasurer/Tax Collector/Clerk"),
                    (50081, "Treasurer/Tax Collector/Public Administrator"),
                    (
                        50082,
                        "Treasurer/Tax Collector/Public Administrator/County Clerk",
                    ),
                    (50083, "Treasurer/Tax Collector/Recorder"),
                    (50084, "Trustee"),
                    (50085, "Weed Recreation Board Member"),
                ],
                db_column="RACE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=18, id="2774529", start_page=16
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=22, id="2774529", start_page=20
                    ),
                ],
                help_text="If applicable indicates the race in which the filer is running",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="filertofilertypecd",
            name="sub_category",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (0, "N/A"),
                    (40101, "PRIMARILY FORMED MEASURE"),
                    (40102, "PRIMARILY FORMED CANDIDATE"),
                    (40103, "GENERAL PURPOSE"),
                    (40104, "GENERAL PURPOSE POLITICAL PARTY"),
                    (40105, "GENERAL PURPOSE MEASURE"),
                    (40112, "Unknown"),
                ],
                db_column="SUB_CATEGORY",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774529", start_page=18
                    )
                ],
                help_text="When applicable specifies general purpose, primarily formed, etc.",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="filertofilertypecd",
            name="sub_category_type",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (0, "N/A"),
                    (40202, "BROAD-BASED"),
                    (40203, "SMALL CONTRIBUTOR"),
                    (40204, "MPO - NON PROFIT"),
                    (40205, "MPO - NON PROFIT CY"),
                    (40206, "MPO - OTHER"),
                    (40207, "MPO - OTHER CY"),
                    (40208, "FEDERAL PAC"),
                    (40209, "OUT OF STATE PAC"),
                ],
                db_column="SUB_CATEGORY_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=19, id="2774529", start_page=18
                    )
                ],
                help_text="When applicable specifies broad based or small contributor",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="filertypeperiodscd",
            name="election_type",
            field=calaccess_raw.fields.IntegerField(
                choices=[
                    (0, "N/A"),
                    (3001, "GENERAL"),
                    (3002, "PRIMARY"),
                    (3003, "RECALL"),
                    (3004, "SPECIAL ELECTION"),
                    (3005, "OFFICEHOLDER"),
                    (3006, "SPECIAL RUNOFF"),
                ],
                db_column="ELECTION_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=4, id="2774529", start_page=3
                    )
                ],
                help_text="Election type",
            ),
        ),
        migrations.AlterField(
            model_name="filertypescd",
            name="grp_type",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (58, "LOBBY PERIODS"),
                    (59, "CAMPAIGN PERIODS"),
                    (60, "DEFAULT PERIOD FOR ERRONEOUS DATA"),
                    (61, "Unknown"),
                ],
                db_column="GRP_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774529", start_page=4
                    )
                ],
                help_text="Group type assocated with the filer type",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="filingperiodcd",
            name="per_grp_type",
            field=calaccess_raw.fields.IntegerField(
                choices=[(1500, "STANDARD PERIOD")],
                db_column="PER_GRP_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774529", start_page=3
                    )
                ],
                help_text="Period group type",
            ),
        ),
        migrations.AlterField(
            model_name="filingperiodcd",
            name="period_type",
            field=calaccess_raw.fields.IntegerField(
                choices=[(1500, "Standard period")],
                db_column="PERIOD_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774529", start_page=3
                    )
                ],
                help_text="Type of filing period",
            ),
        ),
        migrations.AlterField(
            model_name="filingscd",
            name="filing_type",
            field=calaccess_raw.fields.IntegerField(
                choices=[
                    (22001, "Electronic"),
                    (22002, "Key data entry"),
                    (22003, "Historical lobby"),
                    (22004, "Historical campaign"),
                    (22005, "AMS"),
                    (22006, "Cal Online"),
                ],
                db_column="FILING_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711615", start_page=2
                    )
                ],
                help_text="The type of filing",
            ),
        ),
        migrations.AlterField(
            model_name="hdrcd",
            name="ef_type",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("CAL", ".CAL format")],
                db_column="EF_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=4
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=5
                    ),
                ],
                help_text='Electronic filing type. This will always have the         value of "CAL".',
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="hdrcd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("HDR", "HDR")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=4
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=5
                    ),
                ],
                help_text="Record Type. Value: HDR",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="hdrcd",
            name="state_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("CA", "California")],
                db_column="STATE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=4
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=5
                    ),
                ],
                help_text="The state code value entered in the electronic filing",
                max_length=2,
                verbose_name="State code",
            ),
        ),
        migrations.AlterField(
            model_name="imagelinkscd",
            name="img_link_type",
            field=calaccess_raw.fields.IntegerField(
                choices=[(6501, "FILING ID"), (6502, "FILER ID")],
                db_column="IMG_LINK_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774529", start_page=5
                    )
                ],
                help_text="Type of image link",
                verbose_name="Image link type",
            ),
        ),
        migrations.AlterField(
            model_name="imagelinkscd",
            name="img_type",
            field=calaccess_raw.fields.IntegerField(
                choices=[
                    (6001, "FAX"),
                    (6002, "PERSONAL PHOTO"),
                    (6004, "SCANNED CHECK"),
                    (6005, "SCANNED LETTER"),
                    (6007, "IMAGE TYPES"),
                ],
                db_column="IMG_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774529", start_page=4
                    )
                ],
                help_text="Type of image",
                verbose_name="Image type",
            ),
        ),
        migrations.AlterField(
            model_name="lattcd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("FRM", "Lobbying Firm"),
                    ("IND", "Person (spending > $5000)"),
                    ("LBY", "Lobbyist (an individual)"),
                    ("LCO", "Lobbying Coalition"),
                    ("LEM", "Lobbying Employer"),
                    ("OTH", "Other"),
                    ("RCP", "Recipient Committee"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=65
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=80
                    ),
                ],
                help_text="Entity Code of the Payment Recipient/Payee",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="lattcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "",
                        "Schedule 630: Payments Made to Lobbying Coalitions (Attachment to Form 625 or 635)",
                    ),
                    (
                        "S635-C",
                        "Schedule 635C: Payments Received by Lobbying Coalitions",
                    ),
                    (
                        "",
                        "Schedule 640: Governmental Agencies Reporting (Attachment to Form 635 or Form 645)",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=52
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=65
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=79
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=6,
            ),
        ),
        migrations.AlterField(
            model_name="lattcd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("LATT", "LATT")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=65
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=79
                    ),
                ],
                help_text="Record Type Value: LATT",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="lccmcd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("COM", "Committee"),
                    ("RCP", "Recipient Committee"),
                    ("CTL", "Controlled committee"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=64
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=78
                    ),
                ],
                help_text="Entity Code for Recipient of the Campaign Contribution Value",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="lccmcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F615P2",
                        "Form 615 (Lobbyist Report): Part 2, Campaign Contributions Made or Delivered",
                    ),
                    (
                        "F625P4B",
                        "Form 625 (Report of Lobbying Firm): Part 4, Campaign Contributions Made",
                    ),
                    (
                        "F635P4B",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 4, Campaign Contributions Made",
                    ),
                    (
                        "F645P3B",
                        "Form 645 (Report of Person Spending $5,000 or More): Part 3, Campaign Contributions Made",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=64
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=79, id="2712034", start_page=78
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=7,
            ),
        ),
        migrations.AlterField(
            model_name="lccmcd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("LCCM", "LCCM")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=64
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=78
                    ),
                ],
                help_text="Record Type Value: LCCM",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="lempcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F601P2A",
                        "Form 601 (Lobbying Firm Registration Statement): Part 2, Section A, Lobbyist Employers",
                    ),
                    (
                        "F601P2B",
                        "Form 601 (Lobbying Firm Registration Statement): Part 2, Section B, Subcontracted Clients",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=75
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=90
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=7,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="lempcd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("LEMP", "LEMP")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=75
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=90
                    ),
                ],
                help_text="Record Type Value: LEMP",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="lexpcd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("IND", "Person (spending > $5000)"), ("OTH", "Other")],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=61
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=75
                    ),
                ],
                help_text="Entity Code of the Payee",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="lexpcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F615P1",
                        "Form 615 (Lobbyist Report): Part 1, Activity Expenses Paid, Incurred, Arranged or Provided by the Lobbyist",
                    ),
                    (
                        "F625P3A",
                        "Form 625 (Report of Lobbying Firm): Part 3, Payments Made In Connection With Lobbying Activities, Section A, Activity Expenses",
                    ),
                    (
                        "F635P3C",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section C, Activity Expenses",
                    ),
                    (
                        "F645P2A",
                        "Form 645 (Report of Person Spending $5,000 or More): Part 2, Payments Made this Period, Section A, Activity Expenses",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=61
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=74
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=7,
            ),
        ),
        migrations.AlterField(
            model_name="lexpcd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("LEXP", "LEXP")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=61
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=74
                    ),
                ],
                help_text="Record Type Value: LEXP",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="lexpcd",
            name="recsubtype",
            field=calaccess_raw.fields.CharField(
                choices=[("1", "Main"), ("2", "Detail")],
                db_column="RECSUBTYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=61
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=74
                    ),
                ],
                help_text="Record Subtype",
                max_length=1,
                verbose_name="record subtype",
            ),
        ),
        migrations.AlterField(
            model_name="loancd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("COM", "Committee"),
                    ("IND", "Individual"),
                    ("OTH", "Other"),
                    ("PTY", "Political Party"),
                    ("RCP", "Recipient committee"),
                    ("SCC", "Small Contributor Committee"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=35
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=47
                    ),
                ],
                help_text="Entity code describing the lender",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="loancd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "B1",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 1, Loans Received",
                    ),
                    (
                        "B2",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 2, Loan Guarantors",
                    ),
                    (
                        "B3",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 3, Outstanding Balance",
                    ),
                    (
                        "H",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Loans Made to Others",
                    ),
                    (
                        "H1",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Part 1, Loans Made",
                    ),
                    (
                        "H2",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Part 2, Repayments Rcvd",
                    ),
                    (
                        "H3",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Part 3, Outstanding Loans",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=35
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=47
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=2,
            ),
        ),
        migrations.AlterField(
            model_name="loancd",
            name="loan_type",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("H2T", "Third party payment"),
                    ("H2F", "Forgiven"),
                    ("H2R", "Repay"),
                    ("B2T", "Third party payment"),
                    ("B2F", "Forgiven"),
                    ("B2R", "Repay"),
                    ("B1G", "Guarantor"),
                    ("B1L", "Lender"),
                ],
                db_column="LOAN_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=35
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=47
                    ),
                ],
                help_text="Type of loan",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="loancd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("LOAN", "LOAN")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=35
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=47
                    ),
                ],
                help_text="Record Type Value: LOAN",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="lobbyamendmentscd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("", "Form 601: Lobbying Firm Registration Statement"),
                    (
                        "",
                        "Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=74
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=88
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=9,
            ),
        ),
        migrations.AlterField(
            model_name="lobbyamendmentscd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("F605", "F605")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=74
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=88
                    ),
                ],
                help_text="Record Type Value: F605",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="lobbyistemployer1cd",
            name="interest_cd",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (40301, "AGRICULTURE"),
                    (40302, "EDUCATION"),
                    (40303, "ENTERTAINMENT/RECREATION"),
                    (40304, "FINANCE/INSURANCE"),
                    (40305, "GOVERNMENT"),
                    (40306, "HEALTH"),
                    (40307, "LABOR UNIONS"),
                    (40308, "LEGAL"),
                    (40309, "LODGING/RESTAURANTS"),
                    (40310, "MANUFACTURING/INDUSTRIAL"),
                    (40311, "MERCHANDISE/RETAIL"),
                    (40312, "MISCELLANEOUS"),
                    (40313, "OIL AND GAS"),
                    (40314, "POLITICAL ORGANIZATIONS"),
                    (40315, "PROFESSIONAL/TRADE"),
                    (40316, "PUBLIC EMPLOYEES"),
                    (40317, "REAL ESTATE"),
                    (40318, "TRANSPORTATION"),
                    (40319, "UTILITIES"),
                ],
                db_column="INTEREST_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774529", start_page=19
                    )
                ],
                help_text="Interest Code",
                null=True,
                verbose_name="interest code",
            ),
        ),
        migrations.AlterField(
            model_name="lobbyistemployer2cd",
            name="interest_cd",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (40301, "AGRICULTURE"),
                    (40302, "EDUCATION"),
                    (40303, "ENTERTAINMENT/RECREATION"),
                    (40304, "FINANCE/INSURANCE"),
                    (40305, "GOVERNMENT"),
                    (40306, "HEALTH"),
                    (40307, "LABOR UNIONS"),
                    (40308, "LEGAL"),
                    (40309, "LODGING/RESTAURANTS"),
                    (40310, "MANUFACTURING/INDUSTRIAL"),
                    (40311, "MERCHANDISE/RETAIL"),
                    (40312, "MISCELLANEOUS"),
                    (40313, "OIL AND GAS"),
                    (40314, "POLITICAL ORGANIZATIONS"),
                    (40315, "PROFESSIONAL/TRADE"),
                    (40316, "PUBLIC EMPLOYEES"),
                    (40317, "REAL ESTATE"),
                    (40318, "TRANSPORTATION"),
                    (40319, "UTILITIES"),
                ],
                db_column="INTEREST_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774529", start_page=19
                    )
                ],
                help_text="Interest Code",
                null=True,
                verbose_name="interest code",
            ),
        ),
        migrations.AlterField(
            model_name="lobbyistemployer3cd",
            name="interest_cd",
            field=calaccess_raw.fields.IntegerField(
                blank=True,
                choices=[
                    (40301, "AGRICULTURE"),
                    (40302, "EDUCATION"),
                    (40303, "ENTERTAINMENT/RECREATION"),
                    (40304, "FINANCE/INSURANCE"),
                    (40305, "GOVERNMENT"),
                    (40306, "HEALTH"),
                    (40307, "LABOR UNIONS"),
                    (40308, "LEGAL"),
                    (40309, "LODGING/RESTAURANTS"),
                    (40310, "MANUFACTURING/INDUSTRIAL"),
                    (40311, "MERCHANDISE/RETAIL"),
                    (40312, "MISCELLANEOUS"),
                    (40313, "OIL AND GAS"),
                    (40314, "POLITICAL ORGANIZATIONS"),
                    (40315, "PROFESSIONAL/TRADE"),
                    (40316, "PUBLIC EMPLOYEES"),
                    (40317, "REAL ESTATE"),
                    (40318, "TRANSPORTATION"),
                    (40319, "UTILITIES"),
                ],
                db_column="INTEREST_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774529", start_page=19
                    )
                ],
                help_text="Interest Code",
                null=True,
                verbose_name="interest code",
            ),
        ),
        migrations.AlterField(
            model_name="lobbyistemployerhistorycd",
            name="interest_cd",
            field=calaccess_raw.fields.IntegerField(
                choices=[
                    (40301, "AGRICULTURE"),
                    (40302, "EDUCATION"),
                    (40303, "ENTERTAINMENT/RECREATION"),
                    (40304, "FINANCE/INSURANCE"),
                    (40305, "GOVERNMENT"),
                    (40306, "HEALTH"),
                    (40307, "LABOR UNIONS"),
                    (40308, "LEGAL"),
                    (40309, "LODGING/RESTAURANTS"),
                    (40310, "MANUFACTURING/INDUSTRIAL"),
                    (40311, "MERCHANDISE/RETAIL"),
                    (40312, "MISCELLANEOUS"),
                    (40313, "OIL AND GAS"),
                    (40314, "POLITICAL ORGANIZATIONS"),
                    (40315, "PROFESSIONAL/TRADE"),
                    (40316, "PUBLIC EMPLOYEES"),
                    (40317, "REAL ESTATE"),
                    (40318, "TRANSPORTATION"),
                    (40319, "UTILITIES"),
                ],
                db_column="INTEREST_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774529", start_page=19
                    )
                ],
                help_text="Interest Code",
                verbose_name="interest code",
            ),
        ),
        migrations.AlterField(
            model_name="lothcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F625P3B",
                        "Form 625 (Report of Lobbying Firm): Part 3, Payments Made In Connection With Lobbying Activities, Section B, Payments Made",
                    )
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=63
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=77
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=7,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="lothcd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("LOTH", "LOTH")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=63
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=77
                    ),
                ],
                help_text="Record Type Value: LOTH",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="lpaycd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("FRM", "Lobbying Firm"),
                    ("LCO", "Lobbying Coalition"),
                    ("LEM", "Lobbying Employer"),
                    ("OTH", "Other"),
                    ("128", "Unknown"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=62
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=76
                    ),
                ],
                help_text="Entity Code of the Employer Values",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="lpaycd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F625P2",
                        "Form 625 (Report of Lobbying Firm): Part 2, Payments Received in Connection with Lobbying Activity",
                    ),
                    (
                        "F635P3B",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section B, Payments To Lobbying Firms",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=62
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=76
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=7,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="lpaycd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("LPAY", "LPAY")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=62
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=76
                    ),
                ],
                help_text="Record Type Value: LPAY",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="rcptcd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("COM", "Committee"),
                    ("IND", "Individual"),
                    ("PTY", "Political Party"),
                    ("OTH", "Other"),
                    ("RCP", "Recipient committee"),
                    ("SCC", "Small Contributor Committee"),
                    ("Com", "Committee"),
                    ("CAO", "Candidate/officeholder"),
                    ("BNM", "Ballot measure's name/title"),
                    ("OFF", "Officer"),
                    ("0", "Unknown"),
                    ("PTH", "Unknown"),
                    ("RFD", "Unknown"),
                    ("MBR", "Unknown"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=71
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=29
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=37
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=9, id="2712033", start_page=8
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=11, id="2712034", start_page=9
                    ),
                ],
                help_text="Entity Code describing the contributor",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="rcptcd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("", "Electronic Form 530: Electronic Issue Advocacy Report"),
                    (
                        "",
                        "Form 900: Campaign Disclosure Statement (Public employee retirement board candidate)",
                    ),
                    (
                        "F401A",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule A, Payments Received",
                    ),
                    (
                        "A",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule A, Monetary Contributions Received",
                    ),
                    (
                        "A-1",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule A-1, Contributions Transferred to Special Election Commitee",
                    ),
                    (
                        "C",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule C, Non-Monetary Contributions Received",
                    ),
                    (
                        "I",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule I, Miscellanous increases to cash",
                    ),
                    (
                        "F496P3",
                        "Form 496 (Late Independent Expenditure Report): Part 3, Contributions > $100 Received",
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=29
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=37
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=9,
            ),
        ),
        migrations.AlterField(
            model_name="rcptcd",
            name="juris_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ASM", "Assembly District"),
                    ("BOE", "Board of Equalization District"),
                    ("CIT", "City"),
                    ("CTY", "County"),
                    ("LOC", "Local"),
                    ("OTH", "Other"),
                    ("SEN", "Senate District"),
                    ("STW", "Statewide"),
                    ("BED", "Other"),
                    ("CLB", "Other"),
                    ("COU", "County"),
                    ("CO", "Other"),
                    ("SAC", "Unknown"),
                    ("PER", "Unknown"),
                    ("SF", "Unknown"),
                    ("OR", "Unknown"),
                    ("AL", "Unknown"),
                    ("4", "Unknown"),
                    ("CA", "Unknown"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=74
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=30
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=40
                    ),
                ],
                help_text="Office jurisdiction code. See the CAL document for the list of legal values. Used on Form 401 Schedule A",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="rcptcd",
            name="off_s_h_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("S", "SOUGHT"), ("H", "HELD")],
                db_column="OFF_S_H_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=75
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=30
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=40
                    ),
                ],
                help_text="Office is sought or held code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="rcptcd",
            name="office_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("APP", "State Appellate Court Justice"),
                    ("ASM", "State Assembly Person"),
                    ("ASR", "Assessor"),
                    ("ATT", "Attorney General"),
                    ("BED", "Board of Education"),
                    ("BOE", "Board of Equalization Member"),
                    ("BSU", "Board of Supervisors"),
                    ("CAT", "City Attorney"),
                    ("CCB", "Community College Board"),
                    ("CCM", "City Council Member"),
                    ("CON", "State Controller"),
                    ("COU", "County Counsel"),
                    ("CSU", "County Supervisor"),
                    ("CTR", "Local Controller"),
                    ("DAT", "District Attorney"),
                    ("GOV", "Governor"),
                    ("INS", "Insurance Commissioner"),
                    ("LTG", "Lieutenant Governor"),
                    ("MAY", "Mayor"),
                    ("OTH", "Other"),
                    ("PDR", "Public Defender"),
                    ("PER", "Public Employees Retirement System"),
                    ("PLN", "Planning Commissioner"),
                    ("SCJ", "Superior Court Judge"),
                    ("SEN", "State Senator"),
                    ("SHC", "Sheriff-Coroner"),
                    ("SOS", "Secretary of State"),
                    ("SPM", "Supreme Court Justice"),
                    ("SUP", "Superintendent of Public Instruction"),
                    ("TRE", "State Treasurer"),
                    ("TRS", "Local Treasurer"),
                    ("asm", "State Assembly Person"),
                    ("gov", "Governor"),
                    ("OTh", "Other"),
                    ("oth", "Other"),
                    ("csu", "County Supervisor"),
                    ("H", "Unknown"),
                    ("HOU", "Unknown"),
                    ("ASS", "Unknown"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=10
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=12
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712032", start_page=2
                    ),
                ],
                help_text="Identifies the office being sought",
                max_length=3,
                verbose_name="office code",
            ),
        ),
        migrations.AlterField(
            model_name="rcptcd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("E530", "Electronic Form 530: Electronic Issue Advocacy Report"),
                    ("RCPT", "Receipt"),
                ],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=71
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=37
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=29
                    ),
                ],
                help_text="Record Type Value: CVR",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="rcptcd",
            name="sup_opp_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("S", "SUPPORT"), ("O", "OPPOSITION"), ("F", "Unknown")],
                db_column="SUP_OPP_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=74
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=30
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=40
                    ),
                ],
                help_text="Support or opposition code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="rcptcd",
            name="tran_type",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("F", "Forgiven Loan"),
                    ("I", "Intermediary"),
                    ("R", "Returned"),
                    ("T", "Third Party Repayment"),
                    ("X", "Transfer"),
                    ("0", "Unknown"),
                    ("M", "Unknown"),
                    ("N", "Unknown"),
                ],
                db_column="TRAN_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=72
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=29
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=38
                    ),
                ],
                help_text="Transaction Type",
                max_length=1,
                verbose_name="transaction type",
            ),
        ),
        migrations.AlterField(
            model_name="receivedfilingscd",
            name="form_id",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    (
                        "",
                        "Form 400: Statement of Organization (Slate Mailer Organization)",
                    ),
                    (
                        "",
                        "Form 401: Campaign Disclosure Statement (Slate Mailer Organization)",
                    ),
                    (
                        "",
                        "Form 402: Statement of Termination (Slate Mailer Organization)",
                    ),
                    ("", "Form 410: Statement of Organization (Recipient Committee)"),
                    (
                        "",
                        "Form 425: Semi-Annual Statement of No Activity (Recipient Committee)",
                    ),
                    (
                        "",
                        "Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "",
                        "Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "",
                        "Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    ("", "Form 465: Supplemental Independent Expenditure Report"),
                    ("", "Form 496: Late Independent Expenditure Report"),
                    ("", "Form 497: Late Contribution Report"),
                    ("", "Form 498: Late Payment Report (Slate Mailer Organization)"),
                    ("", "Form 601: Lobbying Firm Registration Statement"),
                    ("", "Form 602: Lobbying Firm Activity Authorization"),
                    (
                        "",
                        "Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                    ),
                    ("", "Form 604: Lobbyist Certification Statement"),
                    ("", "Form 606: Notice of Termination"),
                    ("", "Form 607: Notice of Withdrawal"),
                    ("", "Form 615: Lobbyist Report"),
                    ("", "Form 625: Report of Lobbying Firm"),
                    (
                        "",
                        "Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    ("", "Form 645: Report of Person Spending $5,000 or More"),
                ],
                db_column="FORM_ID",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=8, id="2711624", start_page=4
                    )
                ],
                help_text="Form identification code",
                max_length=7,
                verbose_name="form identification code",
            ),
        ),
        migrations.AlterField(
            model_name="reportscd",
            name="rpt_type",
            field=calaccess_raw.fields.IntegerField(
                choices=[
                    (401, "PUBLIC REPORTS"),
                    (402, "AUDITS"),
                    (403, "FINANCIAL REPORTS"),
                    (404, "AUDITS"),
                    (405, "MAILING LABELS"),
                    (406, "OTHER REPORTS"),
                    (0, "N/A"),
                ],
                db_column="RPT_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2774529", start_page=2
                    )
                ],
                help_text="Type of the report",
            ),
        ),
        migrations.AlterField(
            model_name="s401cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    (
                        "F401B",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule B, Payments Made",
                    ),
                    (
                        "F401B-1",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule B-1, Payments Made by Agent or Independent Contractor",
                    ),
                    (
                        "F401C",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule C, Persons Receiving $1,000 or More",
                    ),
                    (
                        "F401D",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule D, Candidates and Measures Not Listed on Schedule A",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=39
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=51
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=7,
            ),
        ),
        migrations.AlterField(
            model_name="s401cd",
            name="juris_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ASM", "Assembly District"),
                    ("BOE", "Board of Equalization District"),
                    ("CIT", "City"),
                    ("CTY", "County"),
                    ("LOC", "Local"),
                    ("OTH", "Other"),
                    ("SEN", "Senate District"),
                    ("STW", "Statewide"),
                    ("SAC", "Unknown"),
                    ("CT", "Unknown"),
                    ("ca", "Unknown"),
                    ("CAL", "Unknown"),
                    ("OR", "Unknown"),
                    ("AL", "Unknown"),
                    ("CA", "Unknown"),
                    ("10", "Unknown"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=77
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=39
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=52
                    ),
                ],
                help_text="Office jurisdiction code",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="s401cd",
            name="off_s_h_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("S", "SOUGHT"), ("H", "HELD")],
                db_column="OFF_S_H_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=39
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=52
                    ),
                ],
                help_text="Office is sought or held code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="s401cd",
            name="office_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("APP", "State Appellate Court Justice"),
                    ("ASM", "State Assembly Person"),
                    ("ASR", "Assessor"),
                    ("ATT", "Attorney General"),
                    ("BED", "Board of Education"),
                    ("BOE", "Board of Equalization Member"),
                    ("BSU", "Board of Supervisors"),
                    ("CAT", "City Attorney"),
                    ("CCB", "Community College Board"),
                    ("CCM", "City Council Member"),
                    ("CON", "State Controller"),
                    ("COU", "County Counsel"),
                    ("CSU", "County Supervisor"),
                    ("CTR", "Local Controller"),
                    ("DAT", "District Attorney"),
                    ("GOV", "Governor"),
                    ("INS", "Insurance Commissioner"),
                    ("LTG", "Lieutenant Governor"),
                    ("MAY", "Mayor"),
                    ("OTH", "Other"),
                    ("PDR", "Public Defender"),
                    ("PER", "Public Employees Retirement System"),
                    ("PLN", "Planning Commissioner"),
                    ("SCJ", "Superior Court Judge"),
                    ("SEN", "State Senator"),
                    ("SHC", "Sheriff-Coroner"),
                    ("SOS", "Secretary of State"),
                    ("SPM", "Supreme Court Justice"),
                    ("SUP", "Superintendent of Public Instruction"),
                    ("TRE", "State Treasurer"),
                    ("TRS", "Local Treasurer"),
                    ("asm", "State Assembly Person"),
                    ("ltg", "Lieutenant Governor"),
                    ("OTh", "Other"),
                    ("att", "Attorney General"),
                    ("oth", "Other"),
                    ("tre", "State Treasurer"),
                    ("con", "State Controller"),
                    ("boe", "Board of Equalization Member"),
                    ("sos", "Secretary of State"),
                    ("sup", "Superintendent of Public Instruction"),
                    ("H", "Unknown"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=10
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=12
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712032", start_page=2
                    ),
                ],
                help_text="Identifies the office being sought",
                max_length=3,
                verbose_name="office code",
            ),
        ),
        migrations.AlterField(
            model_name="s401cd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("S401", "S401")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=39
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=51
                    ),
                ],
                help_text="Record Type Value: S401",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="s401cd",
            name="sup_opp_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("S", "SUPPORT"), ("O", "OPPOSITION")],
                db_column="SUP_OPP_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=39
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=52
                    ),
                ],
                help_text="Support or opposition code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="s496cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("", "Form 496: Late Independent Expenditure Report")],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=40
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=53
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="s496cd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("S496", "S496")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=40
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=53
                    ),
                ],
                help_text="Record Type Value: S496",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="s497cd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("BNM", "Ballot measure's name/title"),
                    ("CAO", "Candidate/officeholder"),
                    ("CTL", "Controlled committee"),
                    ("COM", "Committee"),
                    ("com", "Committee"),
                    ("IND", "Individual"),
                    ("OFF", "Officer"),
                    ("OTH", "Other"),
                    ("PTY", "Political Party"),
                    ("RCP", "Recipient committee"),
                    ("SCC", "Small Contributor Committee"),
                    ("0", "Unknown"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=9, id="2712033", start_page=8
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=11, id="2712034", start_page=9
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=41
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=54
                    ),
                ],
                help_text="Entity Code describing the Contributor/Recipient",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="s497cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "F497P1",
                        "Form 497 (Late Contribution Report): Part 1, Contributions Received",
                    ),
                    (
                        "F497P2",
                        "Form 497 (Late Contribution Report): Part 2, Contributions Made",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=41
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=54
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=6,
            ),
        ),
        migrations.AlterField(
            model_name="s497cd",
            name="juris_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ASM", "Assembly District"),
                    ("BOE", "Board of Equalization District"),
                    ("CIT", "City"),
                    ("CTY", "County"),
                    ("LOC", "Local"),
                    ("OTH", "Other"),
                    ("SEN", "Senate District"),
                    ("STW", "Statewide"),
                    ("asm", "Assembly District"),
                    ("sen", "Senate District"),
                    ("cit", "City"),
                    ("GOV", "Statewide"),
                    ("MAY", "City"),
                    ("BSU", "County"),
                    ("CSU", "County"),
                    ("SUP", "Statewide"),
                    ("BED", "Other"),
                    ("CCB", "Other"),
                    ("CCM", "Other"),
                    ("CLB", "Other"),
                    ("IRV", "City"),
                    ("Fon", "City"),
                    ("JRS", "Statewide"),
                    ("CO", "County"),
                    ("Riv", "County"),
                    ("SNE", "Senate District"),
                    ("83", "Statewide"),
                    ("PER", "Unknown"),
                    ("FED", "Unknown"),
                    ("CA", "Unknown"),
                    ("JR", "Unknown"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=42
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=55
                    ),
                ],
                help_text="Jurisdiction code describing the office being sought",
                max_length=3,
                verbose_name="jurisdiction code",
            ),
        ),
        migrations.AlterField(
            model_name="s497cd",
            name="off_s_h_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("H", "HELD"),
                    ("S", "SOUGHT"),
                    ("s", "SOUGHT"),
                    ("h", "HELD"),
                    ("F", "UNKNOWN"),
                    ("T", "UNKNOWN"),
                ],
                db_column="OFF_S_H_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=42
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=55
                    ),
                ],
                help_text="Office is sought or held code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="s497cd",
            name="office_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("APP", "State Appellate Court Justice"),
                    ("ASM", "State Assembly Person"),
                    ("ASR", "Assessor"),
                    ("ATT", "Attorney General"),
                    ("BED", "Board of Education"),
                    ("BOE", "Board of Equalization Member"),
                    ("BSU", "Board of Supervisors"),
                    ("CAT", "City Attorney"),
                    ("CCB", "Community College Board"),
                    ("CCM", "City Council Member"),
                    ("CON", "State Controller"),
                    ("COU", "County Counsel"),
                    ("CSU", "County Supervisor"),
                    ("CTR", "Local Controller"),
                    ("DAT", "District Attorney"),
                    ("GOV", "Governor"),
                    ("INS", "Insurance Commissioner"),
                    ("LTG", "Lieutenant Governor"),
                    ("MAY", "Mayor"),
                    ("OTH", "Other"),
                    ("PDR", "Public Defender"),
                    ("PER", "Public Employees Retirement System"),
                    ("PLN", "Planning Commissioner"),
                    ("SCJ", "Superior Court Judge"),
                    ("SEN", "State Senator"),
                    ("SHC", "Sheriff-Coroner"),
                    ("SOS", "Secretary of State"),
                    ("SPM", "Supreme Court Justice"),
                    ("SUP", "Superintendent of Public Instruction"),
                    ("TRE", "State Treasurer"),
                    ("TRS", "Local Treasurer"),
                    ("asm", "State Assembly Person"),
                    ("sen", "State Senator"),
                    ("Asm", "State Assembly Person"),
                    ("May", "Mayor"),
                    ("ASm", "State Assembly Person"),
                    ("oth", "Other"),
                    ("csu", "County Supervisor"),
                    ("Oth", "Other"),
                    ("H", "Unknown"),
                    ("S", "Unknown"),
                    ("OF", "Unknown"),
                    ("HOU", "Unknown"),
                    ("LOC", "Unknown"),
                    ("LEG", "Unknown"),
                    ("STW", "Unknown"),
                    ("P", "Unknown"),
                    ("LTV", "Unknown"),
                    ("LT", "Unknown"),
                    ("CTY", "Unknown"),
                    ("OFF", "Unknown"),
                    ("REP", "Unknown"),
                    ("COM", "Unknown"),
                    ("N/A", "Unknown"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=10
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=12
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712032", start_page=2
                    ),
                ],
                help_text="Identifies the office being sought",
                max_length=3,
                verbose_name="office code",
            ),
        ),
        migrations.AlterField(
            model_name="s497cd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("S497", "S497")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=41
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=54
                    ),
                ],
                help_text="Record Type Value: S497",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="s497cd",
            name="sup_opp_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("O", "OPPOSITION"), ("S", "SUPPORT")],
                db_column="SUP_OPP_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=82
                    )
                ],
                help_text="Support or opposition code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="s498cd",
            name="entity_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("CAO", "Candidate/officeholder"),
                    ("COM", "Committee"),
                    ("IND", "Individual"),
                    ("OTH", "Other"),
                    ("RCP", "Recipient committee"),
                ],
                db_column="ENTITY_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=9, id="2712033", start_page=8
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=11, id="2712034", start_page=9
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=43
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=56
                    ),
                ],
                help_text="Entity code",
                max_length=3,
                verbose_name="entity code",
            ),
        ),
        migrations.AlterField(
            model_name="s498cd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    (
                        "F498-A",
                        "Form 498 (Late Payment Report (Slate Mailer Organization)): Part A, Late Payments Attributed To",
                    ),
                    (
                        "F498-R",
                        "Form 498 (Late Payment Report (Slate Mailer Organization)): Part R, Late Payments Received From",
                    ),
                ],
                db_column="FORM_TYPE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=43
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=56
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=9,
            ),
        ),
        migrations.AlterField(
            model_name="s498cd",
            name="juris_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("ASM", "Assembly District"),
                    ("BOE", "Board of Equalization District"),
                    ("CIT", "City"),
                    ("CTY", "County"),
                    ("LOC", "Local"),
                    ("OTH", "Other"),
                    ("SEN", "Senate District"),
                    ("STW", "Statewide"),
                    ("GOV", "Statewide"),
                    ("COU", "County"),
                ],
                db_column="JURIS_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=43
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=57
                    ),
                ],
                help_text="Office jurisdiction code",
                max_length=3,
            ),
        ),
        migrations.AlterField(
            model_name="s498cd",
            name="off_s_h_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("H", "HELD"), ("S", "SOUGHT")],
                db_column="OFF_S_H_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=44
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=57
                    ),
                ],
                help_text="Office is sought or held code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="s498cd",
            name="office_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("APP", "State Appellate Court Justice"),
                    ("ASM", "State Assembly Person"),
                    ("ASR", "Assessor"),
                    ("ATT", "Attorney General"),
                    ("BED", "Board of Education"),
                    ("BOE", "Board of Equalization Member"),
                    ("BSU", "Board of Supervisors"),
                    ("CAT", "City Attorney"),
                    ("CCB", "Community College Board"),
                    ("CCM", "City Council Member"),
                    ("CON", "State Controller"),
                    ("COU", "County Counsel"),
                    ("CSU", "County Supervisor"),
                    ("CTR", "Local Controller"),
                    ("DAT", "District Attorney"),
                    ("GOV", "Governor"),
                    ("INS", "Insurance Commissioner"),
                    ("LTG", "Lieutenant Governor"),
                    ("MAY", "Mayor"),
                    ("OTH", "Other"),
                    ("PDR", "Public Defender"),
                    ("PER", "Public Employees Retirement System"),
                    ("PLN", "Planning Commissioner"),
                    ("SCJ", "Superior Court Judge"),
                    ("SEN", "State Senator"),
                    ("SHC", "Sheriff-Coroner"),
                    ("SOS", "Secretary of State"),
                    ("SPM", "Supreme Court Justice"),
                    ("SUP", "Superintendent of Public Instruction"),
                    ("TRE", "State Treasurer"),
                    ("TRS", "Local Treasurer"),
                    ("gov", "Governor"),
                    ("oth", "Other"),
                ],
                db_column="OFFICE_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=10
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=12
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712032", start_page=2
                    ),
                ],
                help_text="Identifies the office being sought",
                max_length=4,
                verbose_name="office code",
            ),
        ),
        migrations.AlterField(
            model_name="s498cd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("S498", "S498")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=43
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=56
                    ),
                ],
                help_text="Record Type Value: S498",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="s498cd",
            name="sup_opp_cd",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[("O", "OPPOSITION"), ("S", "SUPPORT")],
                db_column="SUP_OPP_CD",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=43
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=57
                    ),
                ],
                help_text="Support or opposition code",
                max_length=1,
            ),
        ),
        migrations.AlterField(
            model_name="smrycd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "",
                        "Form 401: Campaign Disclosure Statement (Slate Mailer Organization)",
                    ),
                    (
                        "F401A",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule A, Payments Received",
                    ),
                    (
                        "F401B",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule B, Payments Made",
                    ),
                    (
                        "F401B-1",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule B-1, Payments Made by Agent or Independent Contractor",
                    ),
                    (
                        "",
                        "Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "",
                        "Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "A",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule A, Monetary Contributions Received",
                    ),
                    (
                        "B1",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 1, Loans Received",
                    ),
                    (
                        "B2",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 2, Loan Guarantors",
                    ),
                    (
                        "B3",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 3, Outstanding Balance",
                    ),
                    (
                        "C",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule C, Non-Monetary Contributions Received",
                    ),
                    (
                        "D",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule D, Summary of Expenditures Supporting / Opposing Other Candidates, Measures and Committees",
                    ),
                    (
                        "E",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule E, Payments Made",
                    ),
                    (
                        "F",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule F, Accrued Expenses (Unpaid Bills)",
                    ),
                    (
                        "G",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule G, Payments Made by an Agent or Independent Contractor (on Behalf of This Committee)",
                    ),
                    (
                        "H",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Loans Made to Others",
                    ),
                    (
                        "H1",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Part 1, Loans Made",
                    ),
                    (
                        "H2",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Part 2, Repayments Rcvd",
                    ),
                    (
                        "H3",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Part 3, Outstanding Loans",
                    ),
                    (
                        "I",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule I, Miscellanous increases to cash",
                    ),
                    (
                        "",
                        "Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    ("", "Form 465: Supplemental Independent Expenditure Report"),
                    ("", "Form 625: Report of Lobbying Firm"),
                    (
                        "F625P2",
                        "Form 625 (Report of Lobbying Firm): Part 2, Payments Received in Connection with Lobbying Activity",
                    ),
                    (
                        "F625P3A",
                        "Form 625 (Report of Lobbying Firm): Part 3, Payments Made In Connection With Lobbying Activities, Section A, Activity Expenses",
                    ),
                    (
                        "F625P3B",
                        "Form 625 (Report of Lobbying Firm): Part 3, Payments Made In Connection With Lobbying Activities, Section B, Payments Made",
                    ),
                    (
                        "",
                        "Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    (
                        "F635P3A",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section A, Payments To In-house Employee Lobbyists",
                    ),
                    (
                        "F635P3B",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section B, Payments To Lobbying Firms",
                    ),
                    (
                        "F635P3C",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section C, Activity Expenses",
                    ),
                    (
                        "F635P3D",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section D, Other Payments to Influence Legislative or Administrative Action",
                    ),
                    (
                        "F635P3E",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section E, Payments in Connection with Administrative Testimony in Ratemaking Proceedings Before The California Public Utilities Commission",
                    ),
                    (
                        "",
                        "Schedule 640: Governmental Agencies Reporting (Attachment to Form 635 or Form 645)",
                    ),
                    ("", "Form 645: Report of Person Spending $5,000 or More"),
                    (
                        "F645P2A",
                        "Form 645 (Report of Person Spending $5,000 or More): Part 2, Payments Made this Period, Section A, Activity Expenses",
                    ),
                    (
                        "F645P2B",
                        "Form 645 (Report of Person Spending $5,000 or More): Part 2, Payments Made this Period, Section B, Other Payments to Influence Legislative or Administrative Action",
                    ),
                    (
                        "F645P2C",
                        "Form 645 (Report of Person Spending $5,000 or More): Part 2, Payments Made this Period, Section C, Payments in Connection with Administrative Testimony in Ratemaking Proceedings Before the California Public Utilities Commission",
                    ),
                    (
                        "",
                        "Form 900: Campaign Disclosure Statement (Public employee retirement board candidate)",
                    ),
                    (
                        "401A",
                        calaccess_raw.annotations.forms.FilingFormSection(
                            db_value="F401A",
                            documentcloud_id=None,
                            end_page="7",
                            form=calaccess_raw.annotations.forms.FilingForm(
                                db_value="",
                                description="Form 401 is filed by slate mailer organizations to disclose payments made and received in connection with producing slate mailers.",
                                documentcloud_id="2781366-401-2005-01",
                                group="CAMPAIGN",
                                id="F401",
                                title="Campaign Disclosure Statement (Slate Mailer Organization)",
                            ),
                            id="A",
                            start_page="5",
                            title="Schedule A, Payments Received",
                        ),
                    ),
                    (
                        "401B",
                        calaccess_raw.annotations.forms.FilingFormSection(
                            db_value="F401B",
                            documentcloud_id=None,
                            end_page="9",
                            form=calaccess_raw.annotations.forms.FilingForm(
                                db_value="",
                                description="Form 401 is filed by slate mailer organizations to disclose payments made and received in connection with producing slate mailers.",
                                documentcloud_id="2781366-401-2005-01",
                                group="CAMPAIGN",
                                id="F401",
                                title="Campaign Disclosure Statement (Slate Mailer Organization)",
                            ),
                            id="B",
                            start_page="8",
                            title="Schedule B, Payments Made",
                        ),
                    ),
                    (
                        "401B-1",
                        calaccess_raw.annotations.forms.FilingFormSection(
                            db_value="F401B-1",
                            documentcloud_id=None,
                            end_page="",
                            form=calaccess_raw.annotations.forms.FilingForm(
                                db_value="",
                                description="Form 401 is filed by slate mailer organizations to disclose payments made and received in connection with producing slate mailers.",
                                documentcloud_id="2781366-401-2005-01",
                                group="CAMPAIGN",
                                id="F401",
                                title="Campaign Disclosure Statement (Slate Mailer Organization)",
                            ),
                            id="B-1",
                            start_page="10",
                            title="Schedule B-1, Payments Made by Agent or Independent Contractor",
                        ),
                    ),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=86
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=28, id="2712033", start_page=27
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=60, id="2712033", start_page=59
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=37, id="2712034", start_page=36
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        end_page=74, id="2712034", start_page=73
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=8,
            ),
        ),
        migrations.AlterField(
            model_name="smrycd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[("SMRY", "SMRY")],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=27
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=59
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=35
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=72
                    ),
                ],
                help_text="Record Type Value: SMRY",
                max_length=4,
                verbose_name="record type",
            ),
        ),
        migrations.AlterField(
            model_name="spltcd",
            name="elec_code",
            field=calaccess_raw.fields.CharField(
                blank=True,
                choices=[
                    ("P", "Primary"),
                    ("G", "General"),
                    ("S", "Special"),
                    ("R", "Runoff"),
                    ("g", "General"),
                    ("p", "primary"),
                    ("C", "Unknown"),
                    ("D", "Unknown"),
                    ("F", "Unknown"),
                    ("M", "Unknown"),
                    ("N", "Unknown"),
                    ("X", "Unknown"),
                    ("O", "Unknown"),
                    ("0", "Unknown"),
                    ("1", "Unknown"),
                    ("2", "Unknown"),
                ],
                db_column="ELEC_CODE",
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=18
                    )
                ],
                help_text="per election to date code",
                max_length=2,
                verbose_name="election code",
            ),
        ),
        migrations.AlterField(
            model_name="spltcd",
            name="pform_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "A",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule A, Monetary Contributions Received",
                    ),
                    (
                        "B1",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 1, Loans Received",
                    ),
                    (
                        "B2",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule B, Part 2, Loan Guarantors",
                    ),
                    (
                        "C",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule C, Non-Monetary Contributions Received",
                    ),
                    (
                        "D",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule D, Summary of Expenditures Supporting / Opposing Other Candidates, Measures and Committees",
                    ),
                    (
                        "F450P5",
                        "Form 450 (Campaign Disclosure Statement, Short Form (Recipient Committee)): Part 5, Payments Made",
                    ),
                    (
                        "H",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule H, Loans Made to Others",
                    ),
                ],
                db_column="PFORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=18
                    )
                ],
                help_text="Parent Schedule Type",
                max_length=7,
            ),
        ),
        migrations.AlterField(
            model_name="textmemocd",
            name="form_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    (
                        "",
                        "Form 401: Campaign Disclosure Statement (Slate Mailer Organization)",
                    ),
                    ("", "Form 405: Amendment to Campaign Disclosure Statement"),
                    ("", "Form 410: Statement of Organization (Recipient Committee)"),
                    (
                        "",
                        "Form 425: Semi-Annual Statement of No Activity (Recipient Committee)",
                    ),
                    (
                        "",
                        "Form 450: Campaign Disclosure Statement, Short Form (Recipient Committee)",
                    ),
                    (
                        "",
                        "Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "",
                        "Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    ("", "Form 465: Supplemental Independent Expenditure Report"),
                    ("", "Form 496: Late Independent Expenditure Report"),
                    ("", "Form 497: Late Contribution Report"),
                    ("", "Form 498: Late Payment Report (Slate Mailer Organization)"),
                    ("", "Form 601: Lobbying Firm Registration Statement"),
                    ("", "Form 602: Lobbying Firm Activity Authorization"),
                    (
                        "",
                        "Form 603: Lobbyist Employer or Lobbying Coalition Registration Statement",
                    ),
                    ("", "Form 604: Lobbyist Certification Statement"),
                    (
                        "",
                        "Form 605: Amendment to Registration, Lobbying Firm, Lobbyist Employer, Lobbying Coalition",
                    ),
                    ("", "Form 606: Notice of Termination"),
                    ("", "Form 607: Notice of Withdrawal"),
                    ("", "Form 615: Lobbyist Report"),
                    ("", "Form 625: Report of Lobbying Firm"),
                    (
                        "",
                        "Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    ("", "Form 645: Report of Person Spending $5,000 or More"),
                    (
                        "",
                        "Schedule 630: Payments Made to Lobbying Coalitions (Attachment to Form 625 or 635)",
                    ),
                    (
                        "S635-C",
                        "Schedule 635C: Payments Received by Lobbying Coalitions",
                    ),
                    (
                        "",
                        "Schedule 640: Governmental Agencies Reporting (Attachment to Form 635 or Form 645)",
                    ),
                    (
                        "410",
                        "Form 410: Statement of Organization (Recipient Committee)",
                    ),
                    (
                        "460",
                        "Form 460: Campaign Disclosure Statement (Recipient Committee)",
                    ),
                    (
                        "461",
                        "Form 461: Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)",
                    ),
                    ("465", "Form 465: Supplemental Independent Expenditure Report"),
                    ("496", "Form 496: Late Independent Expenditure Report"),
                    ("497", "Form 497: Late Contribution Report"),
                    (
                        "497P1",
                        "Form 497 (Late Contribution Report): Part 1, Contributions Received",
                    ),
                    (
                        "497P2",
                        "Form 497 (Late Contribution Report): Part 2, Contributions Made",
                    ),
                    (
                        "F401A",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule A, Payments Received",
                    ),
                    (
                        "F401B",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule B, Payments Made",
                    ),
                    (
                        "F401B-1",
                        "Form 401 (Campaign Disclosure Statement (Slate Mailer Organization)): Schedule B-1, Payments Made by Agent or Independent Contractor",
                    ),
                    (
                        "F450P5",
                        "Form 450 (Campaign Disclosure Statement, Short Form (Recipient Committee)): Part 5, Payments Made",
                    ),
                    (
                        "F461P1",
                        "Form 461 (Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)): Part 1, Name and Address of Filer",
                    ),
                    (
                        "F461P2",
                        "Form 461 (Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)): Part 2, Nature and Interests of Filer",
                    ),
                    (
                        "F461P5",
                        "Form 461 (Campaign Disclosure Statement (Independent Expenditure Committee & Major Donor Committee)): Part 5, Contributions (Including Loans, Forgiveness of Loans, and LoanGuarantees) and Expenditures Made",
                    ),
                    (
                        "F465P3",
                        "Form 465 (Supplemental Independent Expenditure Report): Part 3, Independent Expenditures Made",
                    ),
                    (
                        "F496P3",
                        "Form 496 (Late Independent Expenditure Report): Part 3, Contributions > $100 Received",
                    ),
                    (
                        "F497P1",
                        "Form 497 (Late Contribution Report): Part 1, Contributions Received",
                    ),
                    (
                        "F497P2",
                        "Form 497 (Late Contribution Report): Part 2, Contributions Made",
                    ),
                    (
                        "F498-A",
                        "Form 498 (Late Payment Report (Slate Mailer Organization)): Part A, Late Payments Attributed To",
                    ),
                    (
                        "F498-R",
                        "Form 498 (Late Payment Report (Slate Mailer Organization)): Part R, Late Payments Received From",
                    ),
                    (
                        "F601P2A",
                        "Form 601 (Lobbying Firm Registration Statement): Part 2, Section A, Lobbyist Employers",
                    ),
                    (
                        "F601P2B",
                        "Form 601 (Lobbying Firm Registration Statement): Part 2, Section B, Subcontracted Clients",
                    ),
                    (
                        "F615P1",
                        "Form 615 (Lobbyist Report): Part 1, Activity Expenses Paid, Incurred, Arranged or Provided by the Lobbyist",
                    ),
                    (
                        "F615P2",
                        "Form 615 (Lobbyist Report): Part 2, Campaign Contributions Made or Delivered",
                    ),
                    (
                        "F625P2",
                        "Form 625 (Report of Lobbying Firm): Part 2, Payments Received in Connection with Lobbying Activity",
                    ),
                    (
                        "F625P3A",
                        "Form 625 (Report of Lobbying Firm): Part 3, Payments Made In Connection With Lobbying Activities, Section A, Activity Expenses",
                    ),
                    (
                        "F625P3B",
                        "Form 625 (Report of Lobbying Firm): Part 3, Payments Made In Connection With Lobbying Activities, Section B, Payments Made",
                    ),
                    (
                        "F625P4B",
                        "Form 625 (Report of Lobbying Firm): Part 4, Campaign Contributions Made",
                    ),
                    (
                        "S635",
                        "Form 635: Report of Lobbyist Employer or Report of Lobbying Coalition",
                    ),
                    (
                        "F635P3B",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section B, Payments To Lobbying Firms",
                    ),
                    (
                        "F635P3C",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 3, Payments Made in Connection with Lobbying Activities, Section C, Activity Expenses",
                    ),
                    (
                        "F635P4B",
                        "Form 635 (Report of Lobbyist Employer or Report of Lobbying Coalition): Part 4, Campaign Contributions Made",
                    ),
                    (
                        "F645P2A",
                        "Form 645 (Report of Person Spending $5,000 or More): Part 2, Payments Made this Period, Section A, Activity Expenses",
                    ),
                    (
                        "F645P3B",
                        "Form 645 (Report of Person Spending $5,000 or More): Part 3, Campaign Contributions Made",
                    ),
                    ("S497", "Form 497: Late Contribution Report"),
                    (
                        "S635C",
                        "Schedule 635C: Payments Received by Lobbying Coalitions",
                    ),
                    ("A", "Schedule A of any form (e.g., Forms 401 or 460)"),
                    ("A4", "Schedule A of any form (e.g., Forms 401 or 460)"),
                    ("A6", "Schedule A of any form (e.g., Forms 401 or 460)"),
                    ("B", "Schedule B of any form (e.g., Forms 401 or 460)"),
                    ("B1", "Schedule B, Part 1 of Forms 401 or 460"),
                    ("B2", "Schedule B, Part 2 of Forms 401 or 460"),
                    ("B3", "Schedule B, Part 3 of Forms 401 or 460"),
                    ("C", "Schedule C of any form (e.g., Forms 401 or F460)"),
                    ("COMMENTS", "Possibly comments by FPPC for any form?"),
                    ("CVR", "Cover page for any form (e.g., Forms 460, 461 or 497)"),
                    ("D", "Schedule D of any form (e.g., Forms 401, 460 or 461)"),
                    (
                        "DEBTF",
                        "Form 460 (Campaign Disclosure Statement (Recipient Committee)): Schedule F, Accrued Expenses (Unpaid Bills)",
                    ),
                    ("E", "Schedule E of any form (e.g., Forms 460, 461 or 465)"),
                    ("EXPNT", "Expenditures outlined on any form (e.g. Form 460)"),
                    ("F", "Schedule F of any form (e.g., Form 460)"),
                    ("G", "Schedule G of any form (e.g., Form 460)"),
                    ("H", "Schedule H of any form (e.g., Form 460)"),
                    ("H1", "Schedule H, Part 1 of any form (e.g., Form 460)"),
                    ("H2", "Schedule H2, Part 2 of any form (e.g., Form 460)"),
                    ("H3", "Schedule H3, Part 3 of any form (e.g., Form 460)"),
                    ("I", "Schedule I of any form (e.g., Form 460)"),
                    ("PT5", "Part 5 of any form (e.g., Form 461"),
                    ("RCPTB1", "Schedule B, Part 1 of any form (e.g., Form 460"),
                    ("RCPTC", "Schedule C of any form (e.g., Form 460)"),
                    ("RCPTI", "Schedule I of any form (e.g., Form 460)"),
                    ("SCH A", "Schedule A of any form (e.g., Form 460)"),
                    ("SF", "Schedule F of any form (e.g., Form 460)"),
                    ("SPLT", "A memo that applies to multiple items?"),
                    ("SMRY", "Summary section of any form (e.g., Form 460)"),
                    ("SUM", "Summary section of any form (e.g., Form 460)"),
                    ("SUMMARY", "Summary section of any form (e.g., Form 460)"),
                ],
                db_column="FORM_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2711616", start_page=90
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=16
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=13
                    ),
                ],
                help_text="Name of the source filing form or schedule",
                max_length=8,
                verbose_name="form type",
            ),
        ),
        migrations.AlterField(
            model_name="textmemocd",
            name="rec_type",
            field=calaccess_raw.fields.CharField(
                choices=[
                    ("TEXT", "TEXT"),
                    ("MEMO", "MEMO"),
                    ("trun", "Unknown"),
                    ("Unde", "Under"),
                    ("am", "Unknown"),
                    ("sele", "Unknown"),
                    ("Term", "Unknown"),
                    ("re", "Unknown"),
                    ("i", "Unknown"),
                ],
                db_column="REC_TYPE",
                db_index=True,
                documentcloud_pages=[
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712034", start_page=16
                    ),
                    calaccess_raw.annotations.documents.DocumentCloud(
                        id="2712033", start_page=13
                    ),
                ],
                help_text="Record Type Value: TEXT",
                max_length=4,
                verbose_name="record type",
            ),
        ),
    ]
