# -*- coding: utf-8 -*-
# Generated by Django 1.10.6 on 2017-05-02 09:27
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='EmailAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('filename', models.CharField(max_length=256, verbose_name='Filename')),
                ('mime', models.CharField(max_length=256, verbose_name='Mimetype')),
                ('path', models.FileField(upload_to=b'', verbose_name='Path')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EmailMessage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('efrom', models.EmailField(max_length=254, verbose_name='From')),
                ('eto', models.EmailField(max_length=254, verbose_name='To')),
                ('subject', models.CharField(max_length=256, verbose_name='Subject')),
                ('body', models.TextField(verbose_name='Body')),
                ('priority', models.PositiveIntegerField(default=5, verbose_name='Priority')),
                ('sending', models.BooleanField(default=False, verbose_name='Sending')),
                ('sent', models.BooleanField(default=False, verbose_name='Sent')),
                ('log', models.TextField(blank=True, null=True, verbose_name='Log')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EmailTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('cid', models.CharField(max_length=30, unique=True, verbose_name='CID')),
                ('subject', models.TextField(blank=True, verbose_name='Subject')),
                ('body', models.TextField(blank=True, verbose_name='Body')),
                ('efrom', models.TextField(blank=True, verbose_name='From')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='emailattachment',
            name='email',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='codenerix_email.EmailMessage'),
        ),
    ]
