# coding: utf-8

"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class JobResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'status': 'str'
    }

    attribute_map = {
        'id': 'id',
        'status': 'status'
    }

    def __init__(self, id=None, status=None):  # noqa: E501
        """JobResponse - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._status = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if status is not None:
            self.status = status

    @property
    def id(self):
        """Gets the id of this JobResponse.  # noqa: E501

        Job Identifier to be used in Job API  # noqa: E501

        :return: The id of this JobResponse.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this JobResponse.

        Job Identifier to be used in Job API  # noqa: E501

        :param id: The id of this JobResponse.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def status(self):
        """Gets the status of this JobResponse.  # noqa: E501

        Status of the Conversation  # noqa: E501

        :return: The status of this JobResponse.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this JobResponse.

        Status of the Conversation  # noqa: E501

        :param status: The status of this JobResponse.  # noqa: E501
        :type: str
        """

        self._status = status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(JobResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
