# coding: utf-8

"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from symbl_rest.api_client import ApiClient


class AsyncApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_audio(self, body, content_type, **kwargs):  # noqa: E501
        """Audio - Submit New Audio File (wav/mp3)  # noqa: E501

        # About this API Submit the New Request for processing the MP3 or WAV Audio file  ## Request Body Binary payload of MP3 or WAV file audio file.  ## Content-Type Header Must be set to `audio/mpeg` when using `mp3` file, and `audio/wav` when using `wav` file.  # Response In response, conversationId and jobId are returned.  `jobId` can be used to get updates on the job status.  `conversationId` can be used with the Conversation API to get all the insights, topics and processed messages etc.  Read More: [https://docs.symbl.ai/#text-api](https://docs.symbl.ai/#audio-api)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_audio(body, content_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Object body: (required)
        :param str content_type: (required)
        :param str name:
        :param str webhook_url:
        :param list[str] custom_vocabulary:
        :param float confidence_threshold:
        :param str entities:
        :param bool detect_entities:
        :param bool enable_all_trackers:
        :param bool detect_phrases:
        :param bool enable_separate_recognition_per_channel:
        :param str channel_metadata:
        :param str language_code:
        :param str mode:
        :param str trackers:
        :param bool enable_speaker_diarization:
        :param float diarization_speaker_count:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_audio_with_http_info(body, content_type, **kwargs)  # noqa: E501
        else:
            (data) = self.add_audio_with_http_info(body, content_type, **kwargs)  # noqa: E501
            return data

    def add_audio_with_http_info(self, body, content_type, **kwargs):  # noqa: E501
        """Audio - Submit New Audio File (wav/mp3)  # noqa: E501

        # About this API Submit the New Request for processing the MP3 or WAV Audio file  ## Request Body Binary payload of MP3 or WAV file audio file.  ## Content-Type Header Must be set to `audio/mpeg` when using `mp3` file, and `audio/wav` when using `wav` file.  # Response In response, conversationId and jobId are returned.  `jobId` can be used to get updates on the job status.  `conversationId` can be used with the Conversation API to get all the insights, topics and processed messages etc.  Read More: [https://docs.symbl.ai/#text-api](https://docs.symbl.ai/#audio-api)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_audio_with_http_info(body, content_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Object body: (required)
        :param str content_type: (required)
        :param str name:
        :param str webhook_url:
        :param list[str] custom_vocabulary:
        :param float confidence_threshold:
        :param str entities:
        :param bool detect_entities:
        :param bool enable_all_trackers:
        :param bool detect_phrases:
        :param bool enable_separate_recognition_per_channel:
        :param str channel_metadata:
        :param str language_code:
        :param str mode:
        :param str trackers:
        :param bool enable_speaker_diarization:
        :param float diarization_speaker_count:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'content_type', 'name', 'webhook_url', 'custom_vocabulary', 'confidence_threshold', 'entities', 'detect_entities', 'enable_all_trackers', 'detect_phrases', 'enable_separate_recognition_per_channel', 'channel_metadata', 'language_code', 'mode', 'trackers', 'enable_speaker_diarization', 'diarization_speaker_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_audio" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_audio`")  # noqa: E501
        # verify the required parameter 'content_type' is set
        if ('content_type' not in params or
                params['content_type'] is None):
            raise ValueError("Missing the required parameter `content_type` when calling `add_audio`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'webhook_url' in params:
            query_params.append(('webhookUrl', params['webhook_url']))  # noqa: E501
        if 'custom_vocabulary' in params:
            query_params.append(('customVocabulary', params['custom_vocabulary']))  # noqa: E501
            collection_formats['customVocabulary'] = 'multi'  # noqa: E501
        if 'confidence_threshold' in params:
            query_params.append(('confidenceThreshold', params['confidence_threshold']))  # noqa: E501
        if 'entities' in params:
            query_params.append(('entities', params['entities']))  # noqa: E501
        if 'detect_entities' in params:
            query_params.append(('detectEntities', params['detect_entities']))  # noqa: E501
        if 'enable_all_trackers' in params:
            query_params.append(('enableAllTrackers', params['enable_all_trackers']))  # noqa: E501
        if 'detect_phrases' in params:
            query_params.append(('detectPhrases', params['detect_phrases']))  # noqa: E501
        if 'enable_separate_recognition_per_channel' in params:
            query_params.append(('enableSeparateRecognitionPerChannel', params['enable_separate_recognition_per_channel']))  # noqa: E501
        if 'channel_metadata' in params:
            query_params.append(('channelMetadata', params['channel_metadata']))  # noqa: E501
        if 'language_code' in params:
            query_params.append(('languageCode', params['language_code']))  # noqa: E501
        if 'mode' in params:
            query_params.append(('mode', params['mode']))  # noqa: E501
        if 'trackers' in params:
            query_params.append(('trackers', params['trackers']))  # noqa: E501
        if 'enable_speaker_diarization' in params:
            query_params.append(('enableSpeakerDiarization', params['enable_speaker_diarization']))  # noqa: E501
        if 'diarization_speaker_count' in params:
            query_params.append(('diarizationSpeakerCount', params['diarization_speaker_count']))  # noqa: E501

        header_params = {}
        if 'content_type' in params:
            header_params['Content-Type'] = params['content_type']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        if 'content_type' in params:
            header_params['Content-Type'] = params['content_type']  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/process/audio', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_audio_url(self, **kwargs):  # noqa: E501
        """Audio(URL)  - Submit New Conversation  # noqa: E501

        # About this API:  The Async Audio URL API takes in a url link of your audio and returns the full text transcript along with conversational insights.  It can be utilized for any use case where you have access to recorded audio stored publicly as URL and want to extract insights and   other conversational attributes supported by Symbl's Conversation API.   # HTTP REQUEST POST https://api.symbl.ai/v1/process/audio/url  # Request Headers |Header Name   |Required|Value                           | <br/> --- |x-api-key        |Yes    |your_auth_token                 |<br/> |Content-Type      |Yes    |Accepted # value application/json | <br/>  # Request Body |Field            | Required|Type |Description # <br/> --- |url                |Yes      |String|A valid url string. The # URL must be a publicly accessible url. <br/> |customVocabulary   |No      |list #  |Contains a list of words and phrases that provide hints to the speech recognition # task. <br/> |confidenceThreshold|No      |double|Minimum required confidence # for the insight to be recognized. <br/>  # Query Params |Parameter |Required|Value # |<br/> --- |webhookUrl |No      | Webhook url on which job updates to # be sent. (This should be post API) |<br/>   WebhookUrl will be used to # send the status of job created for uploaded Audio url. Every time the status # of the job changes it will be  notified on the WebhookUrl.  # Response # Object on Success |Field         |Description <br/> --- |conversationId |ID # to be used with Conversation API <br/> |jobId         |ID to be used with # Job API <br/>  ## Webhook Payload |Field |Description| --- |jobId |ID # to be used with Job API|<br/> |status|Current status of the job. (Valid statuses # - [ scheduled, in_progress, completed, failed ])|<br/>  ## For more: https://docs.symbl.ai/#audio-api # (Please find POST Async Audio URL  API in Table of Contents)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_audio_url(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AsyncAudioUrlParameters body: Async Audio URL Payload
        :param bool enable_speaker_diarization:
        :param float diarization_speaker_count:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_audio_url_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.add_audio_url_with_http_info(**kwargs)  # noqa: E501
            return data

    def add_audio_url_with_http_info(self, **kwargs):  # noqa: E501
        """Audio(URL)  - Submit New Conversation  # noqa: E501

        # About this API:  The Async Audio URL API takes in a url link of your audio and returns the full text transcript along with conversational insights.  It can be utilized for any use case where you have access to recorded audio stored publicly as URL and want to extract insights and   other conversational attributes supported by Symbl's Conversation API.   # HTTP REQUEST POST https://api.symbl.ai/v1/process/audio/url  # Request Headers |Header Name   |Required|Value                           | <br/> --- |x-api-key        |Yes    |your_auth_token                 |<br/> |Content-Type      |Yes    |Accepted # value application/json | <br/>  # Request Body |Field            | Required|Type |Description # <br/> --- |url                |Yes      |String|A valid url string. The # URL must be a publicly accessible url. <br/> |customVocabulary   |No      |list #  |Contains a list of words and phrases that provide hints to the speech recognition # task. <br/> |confidenceThreshold|No      |double|Minimum required confidence # for the insight to be recognized. <br/>  # Query Params |Parameter |Required|Value # |<br/> --- |webhookUrl |No      | Webhook url on which job updates to # be sent. (This should be post API) |<br/>   WebhookUrl will be used to # send the status of job created for uploaded Audio url. Every time the status # of the job changes it will be  notified on the WebhookUrl.  # Response # Object on Success |Field         |Description <br/> --- |conversationId |ID # to be used with Conversation API <br/> |jobId         |ID to be used with # Job API <br/>  ## Webhook Payload |Field |Description| --- |jobId |ID # to be used with Job API|<br/> |status|Current status of the job. (Valid statuses # - [ scheduled, in_progress, completed, failed ])|<br/>  ## For more: https://docs.symbl.ai/#audio-api # (Please find POST Async Audio URL  API in Table of Contents)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_audio_url_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AsyncAudioUrlParameters body: Async Audio URL Payload
        :param bool enable_speaker_diarization:
        :param float diarization_speaker_count:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'enable_speaker_diarization', 'diarization_speaker_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_audio_url" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'enable_speaker_diarization' in params:
            query_params.append(('enableSpeakerDiarization', params['enable_speaker_diarization']))  # noqa: E501
        if 'diarization_speaker_count' in params:
            query_params.append(('diarizationSpeakerCount', params['diarization_speaker_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/process/audio/url', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_text(self, **kwargs):  # noqa: E501
        """Add new Text Messages  # noqa: E501

        # About this API Submit the Request with Text Conversation Payload.  ## Request Body JSON body with array of messages.  ## Response Body In response, conversationId and jobId are returned. `jobId` can be used to get updates on the job status. `conversationId` can be used with the Conversation API to get all the insights, topics and processed messages etc.  Read More: [https://docs.symbl.ai/#text-api](https://docs.symbl.ai/#text-api)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_text(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AsyncTextParameters body: Async Text API Payload
        :param str webhook_url:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_text_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.add_text_with_http_info(**kwargs)  # noqa: E501
            return data

    def add_text_with_http_info(self, **kwargs):  # noqa: E501
        """Add new Text Messages  # noqa: E501

        # About this API Submit the Request with Text Conversation Payload.  ## Request Body JSON body with array of messages.  ## Response Body In response, conversationId and jobId are returned. `jobId` can be used to get updates on the job status. `conversationId` can be used with the Conversation API to get all the insights, topics and processed messages etc.  Read More: [https://docs.symbl.ai/#text-api](https://docs.symbl.ai/#text-api)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_text_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AsyncTextParameters body: Async Text API Payload
        :param str webhook_url:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'webhook_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_text" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'webhook_url' in params:
            query_params.append(('webhookUrl', params['webhook_url']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/process/text', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_video(self, body, content_type, **kwargs):  # noqa: E501
        """Video - Submit New Video File (mp4)  # noqa: E501

        # About this API Submit the MP4 Video file for processing.  ## Request Body Binary payload of MP4 video file.  ## Content-Type Header Must be set to `video/mp4` when using `mp4` file.  # Response In response, conversationId and jobId are returned.  `jobId` can be used to get updates on the job status.  `conversationId` can be used with the Conversation API to get all the insights, topics and processed messages etc.  Read More: [https://docs.symbl.ai/#text-api](https://docs.symbl.ai/#video-api)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_video(body, content_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str content_type: (required)
        :param str name:
        :param str webhook_url:
        :param list[str] custom_vocabulary:
        :param float confidence_threshold:
        :param str entities:
        :param bool detect_entities:
        :param bool enable_all_trackers:
        :param bool detect_phrases:
        :param bool enable_separate_recognition_per_channel:
        :param str channel_metadata:
        :param str language_code:
        :param str mode:
        :param str trackers:
        :param bool enable_speaker_diarization:
        :param float diarization_speaker_count:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_video_with_http_info(body, content_type, **kwargs)  # noqa: E501
        else:
            (data) = self.add_video_with_http_info(body, content_type, **kwargs)  # noqa: E501
            return data

    def add_video_with_http_info(self, body, content_type, **kwargs):  # noqa: E501
        """Video - Submit New Video File (mp4)  # noqa: E501

        # About this API Submit the MP4 Video file for processing.  ## Request Body Binary payload of MP4 video file.  ## Content-Type Header Must be set to `video/mp4` when using `mp4` file.  # Response In response, conversationId and jobId are returned.  `jobId` can be used to get updates on the job status.  `conversationId` can be used with the Conversation API to get all the insights, topics and processed messages etc.  Read More: [https://docs.symbl.ai/#text-api](https://docs.symbl.ai/#video-api)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_video_with_http_info(body, content_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str content_type: (required)
        :param str name:
        :param str webhook_url:
        :param list[str] custom_vocabulary:
        :param float confidence_threshold:
        :param str entities:
        :param bool detect_entities:
        :param bool enable_all_trackers:
        :param bool detect_phrases:
        :param bool enable_separate_recognition_per_channel:
        :param str channel_metadata:
        :param str language_code:
        :param str mode:
        :param str trackers:
        :param bool enable_speaker_diarization:
        :param float diarization_speaker_count:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'content_type', 'name', 'webhook_url', 'custom_vocabulary', 'confidence_threshold', 'entities', 'detect_entities', 'enable_all_trackers', 'detect_phrases', 'enable_separate_recognition_per_channel', 'channel_metadata', 'language_code', 'mode', 'trackers', 'enable_speaker_diarization', 'diarization_speaker_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_video" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_video`")  # noqa: E501
        # verify the required parameter 'content_type' is set
        if ('content_type' not in params or
                params['content_type'] is None):
            raise ValueError("Missing the required parameter `content_type` when calling `add_video`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'webhook_url' in params:
            query_params.append(('webhookUrl', params['webhook_url']))  # noqa: E501
        if 'custom_vocabulary' in params:
            query_params.append(('customVocabulary', params['custom_vocabulary']))  # noqa: E501
            collection_formats['customVocabulary'] = 'multi'  # noqa: E501
        if 'confidence_threshold' in params:
            query_params.append(('confidenceThreshold', params['confidence_threshold']))  # noqa: E501
        if 'entities' in params:
            query_params.append(('entities', params['entities']))  # noqa: E501
        if 'detect_entities' in params:
            query_params.append(('detectEntities', params['detect_entities']))  # noqa: E501
        if 'enable_all_trackers' in params:
            query_params.append(('enableAllTrackers', params['enable_all_trackers']))  # noqa: E501
        if 'detect_phrases' in params:
            query_params.append(('detectPhrases', params['detect_phrases']))  # noqa: E501
        if 'enable_separate_recognition_per_channel' in params:
            query_params.append(('enableSeparateRecognitionPerChannel', params['enable_separate_recognition_per_channel']))  # noqa: E501
        if 'channel_metadata' in params:
            query_params.append(('channelMetadata', params['channel_metadata']))  # noqa: E501
        if 'language_code' in params:
            query_params.append(('languageCode', params['language_code']))  # noqa: E501
        if 'mode' in params:
            query_params.append(('mode', params['mode']))  # noqa: E501
        if 'trackers' in params:
            query_params.append(('trackers', params['trackers']))  # noqa: E501
        if 'enable_speaker_diarization' in params:
            query_params.append(('enableSpeakerDiarization', params['enable_speaker_diarization']))  # noqa: E501
        if 'diarization_speaker_count' in params:
            query_params.append(('diarizationSpeakerCount', params['diarization_speaker_count']))  # noqa: E501

        header_params = {}
        if 'content_type' in params:
            header_params['Content-Type'] = params['content_type']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['video/mp4'])  # noqa: E501

        if 'content_type' in params:
            header_params['Content-Type'] = params['content_type']  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/process/video', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_video_url(self, **kwargs):  # noqa: E501
        """Video (URL)  - Submit New Conversation  # noqa: E501

        # About this API:  The Async Video URL API allows you to process a mp4 video and return the full text transcript along with conversational insights.  It can be utilized for any use case where you have access to recorded video stored publicly as URL and want to extract insights and  other conversational attributes supported by Symbl's Conversation API.   # HTTP REQUEST POST https://api.symbl.ai/v1/process/video/url  # Request Headers |Header Name   |Required|Value                           | <br/> --- |x-api-key        |Yes    |your_auth_token                 |<br/> |Content-Type      |Yes    |Accepted value application/json | <br/>  # Request Body |Field            | Required|Type |Description |<br/> --- |url                |Yes      |String|A valid url string. The URL must be a publicly accessible url. |<br/> |customVocabulary   |No      |list  |Contains a list of words and phrases that provide hints to the speech recognition task. |<br/> |confidenceThreshold|No      |double|Minimum required confidence for the insight to be recognized. |<br/>  # Query Params |Parameter |Required|Value <br/> --- |webhookUrl |No      | Webhook url on which job updates to be sent. (This should be post API) <br/>   WebhookUrl will be used to send the status of job created for uploaded video url. Every time the status of the job changes it will be  notified on the WebhookUrl.  # Response Object on Success |Field         |Description |<br/> --- |conversationId |ID to be used with Conversation API| <br/> |jobId         |ID to be used with Job API |<br/>   ## Webhook Payload |Field |Description| --- |jobId |ID to be used with Job API|<br/> |status|Current status of the job. (Valid statuses - [ scheduled, in_progress, completed, failed ])|<br/>  ## For more: https://docs.symbl.ai/?shell#video-api (Please find POST Asnyc Video URL API in Table of Contents)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_video_url(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AsyncVideoUrlParameters body: Async Video URL Payload
        :param bool enable_speaker_diarization:
        :param float diarization_speaker_count:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_video_url_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.add_video_url_with_http_info(**kwargs)  # noqa: E501
            return data

    def add_video_url_with_http_info(self, **kwargs):  # noqa: E501
        """Video (URL)  - Submit New Conversation  # noqa: E501

        # About this API:  The Async Video URL API allows you to process a mp4 video and return the full text transcript along with conversational insights.  It can be utilized for any use case where you have access to recorded video stored publicly as URL and want to extract insights and  other conversational attributes supported by Symbl's Conversation API.   # HTTP REQUEST POST https://api.symbl.ai/v1/process/video/url  # Request Headers |Header Name   |Required|Value                           | <br/> --- |x-api-key        |Yes    |your_auth_token                 |<br/> |Content-Type      |Yes    |Accepted value application/json | <br/>  # Request Body |Field            | Required|Type |Description |<br/> --- |url                |Yes      |String|A valid url string. The URL must be a publicly accessible url. |<br/> |customVocabulary   |No      |list  |Contains a list of words and phrases that provide hints to the speech recognition task. |<br/> |confidenceThreshold|No      |double|Minimum required confidence for the insight to be recognized. |<br/>  # Query Params |Parameter |Required|Value <br/> --- |webhookUrl |No      | Webhook url on which job updates to be sent. (This should be post API) <br/>   WebhookUrl will be used to send the status of job created for uploaded video url. Every time the status of the job changes it will be  notified on the WebhookUrl.  # Response Object on Success |Field         |Description |<br/> --- |conversationId |ID to be used with Conversation API| <br/> |jobId         |ID to be used with Job API |<br/>   ## Webhook Payload |Field |Description| --- |jobId |ID to be used with Job API|<br/> |status|Current status of the job. (Valid statuses - [ scheduled, in_progress, completed, failed ])|<br/>  ## For more: https://docs.symbl.ai/?shell#video-api (Please find POST Asnyc Video URL API in Table of Contents)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_video_url_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AsyncVideoUrlParameters body: Async Video URL Payload
        :param bool enable_speaker_diarization:
        :param float diarization_speaker_count:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'enable_speaker_diarization', 'diarization_speaker_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_video_url" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'enable_speaker_diarization' in params:
            query_params.append(('enableSpeakerDiarization', params['enable_speaker_diarization']))  # noqa: E501
        if 'diarization_speaker_count' in params:
            query_params.append(('diarizationSpeakerCount', params['diarization_speaker_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/process/video/url', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def append_audio(self, body, content_type, conversation_id, **kwargs):  # noqa: E501
        """Audio - Submit New Audio File (wav/mp3)  # noqa: E501

        # About this API Submit the New Request for processing the MP3 or WAV Audio file  ## Request Body Binary payload of MP3 or WAV file audio file.  ## Content-Type Header Must be set to `audio/mpeg` when using `mp3` file, and `audio/wav` when using `wav` file.  # Response In response, conversationId and jobId are returned.  `jobId` can be used to get updates on the job status.  `conversationId` can be used with the Conversation API to get all the insights, topics and processed messages etc.  Read More: [https://docs.symbl.ai/#text-api](https://docs.symbl.ai/#audio-api)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.append_audio(body, content_type, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Object body: (required)
        :param str content_type: (required)
        :param str conversation_id: ID of the conversation (required)
        :param str name:
        :param str webhook_url:
        :param list[str] custom_vocabulary:
        :param float confidence_threshold:
        :param str entities:
        :param bool enable_all_trackers:
        :param bool detect_entities:
        :param bool detect_phrases:
        :param bool enable_separate_recognition_per_channel:
        :param str channel_metadata:
        :param str language_code:
        :param str mode:
        :param str trackers:
        :param bool enable_speaker_diarization:
        :param float diarization_speaker_count:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.append_audio_with_http_info(body, content_type, conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.append_audio_with_http_info(body, content_type, conversation_id, **kwargs)  # noqa: E501
            return data

    def append_audio_with_http_info(self, body, content_type, conversation_id, **kwargs):  # noqa: E501
        """Audio - Submit New Audio File (wav/mp3)  # noqa: E501

        # About this API Submit the New Request for processing the MP3 or WAV Audio file  ## Request Body Binary payload of MP3 or WAV file audio file.  ## Content-Type Header Must be set to `audio/mpeg` when using `mp3` file, and `audio/wav` when using `wav` file.  # Response In response, conversationId and jobId are returned.  `jobId` can be used to get updates on the job status.  `conversationId` can be used with the Conversation API to get all the insights, topics and processed messages etc.  Read More: [https://docs.symbl.ai/#text-api](https://docs.symbl.ai/#audio-api)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.append_audio_with_http_info(body, content_type, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Object body: (required)
        :param str content_type: (required)
        :param str conversation_id: ID of the conversation (required)
        :param str name:
        :param str webhook_url:
        :param list[str] custom_vocabulary:
        :param float confidence_threshold:
        :param str entities:
        :param bool enable_all_trackers:
        :param bool detect_entities:
        :param bool detect_phrases:
        :param bool enable_separate_recognition_per_channel:
        :param str channel_metadata:
        :param str language_code:
        :param str mode:
        :param str trackers:
        :param bool enable_speaker_diarization:
        :param float diarization_speaker_count:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'content_type', 'conversation_id', 'name', 'webhook_url', 'custom_vocabulary', 'confidence_threshold', 'entities', 'enable_all_trackers', 'detect_entities', 'detect_phrases', 'enable_separate_recognition_per_channel', 'channel_metadata', 'language_code', 'mode', 'trackers', 'enable_speaker_diarization', 'diarization_speaker_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method append_audio" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `append_audio`")  # noqa: E501
        # verify the required parameter 'content_type' is set
        if ('content_type' not in params or
                params['content_type'] is None):
            raise ValueError("Missing the required parameter `content_type` when calling `append_audio`")  # noqa: E501
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `append_audio`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'webhook_url' in params:
            query_params.append(('webhookUrl', params['webhook_url']))  # noqa: E501
        if 'custom_vocabulary' in params:
            query_params.append(('customVocabulary', params['custom_vocabulary']))  # noqa: E501
            collection_formats['customVocabulary'] = 'multi'  # noqa: E501
        if 'confidence_threshold' in params:
            query_params.append(('confidenceThreshold', params['confidence_threshold']))  # noqa: E501
        if 'entities' in params:
            query_params.append(('entities', params['entities']))  # noqa: E501
        if 'enable_all_trackers' in params:
            query_params.append(('enableAllTrackers', params['enable_all_trackers']))  # noqa: E501
        if 'detect_entities' in params:
            query_params.append(('detectEntities', params['detect_entities']))  # noqa: E501
        if 'detect_phrases' in params:
            query_params.append(('detectPhrases', params['detect_phrases']))  # noqa: E501
        if 'enable_separate_recognition_per_channel' in params:
            query_params.append(('enableSeparateRecognitionPerChannel', params['enable_separate_recognition_per_channel']))  # noqa: E501
        if 'channel_metadata' in params:
            query_params.append(('channelMetadata', params['channel_metadata']))  # noqa: E501
        if 'language_code' in params:
            query_params.append(('languageCode', params['language_code']))  # noqa: E501
        if 'mode' in params:
            query_params.append(('mode', params['mode']))  # noqa: E501
        if 'trackers' in params:
            query_params.append(('trackers', params['trackers']))  # noqa: E501
        if 'enable_speaker_diarization' in params:
            query_params.append(('enableSpeakerDiarization', params['enable_speaker_diarization']))  # noqa: E501
        if 'diarization_speaker_count' in params:
            query_params.append(('diarizationSpeakerCount', params['diarization_speaker_count']))  # noqa: E501

        header_params = {}
        if 'content_type' in params:
            header_params['Content-Type'] = params['content_type']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        if 'content_type' in params:
            header_params['Content-Type'] = params['content_type']  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/process/audio/{conversationId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def append_audio_url(self, conversation_id, **kwargs):  # noqa: E501
        """Audio(URL)  - Submit New Conversation  # noqa: E501

        # About this API:  The Async Audio URL API takes in a url link of your audio and returns the full text transcript along with conversational insights.  It can be utilized for any use case where you have access to recorded audio stored publicly as URL and want to extract insights and   other conversational attributes supported by Symbl's Conversation API.   # HTTP REQUEST POST https://api.symbl.ai/v1/process/audio/url  # Request Headers |Header Name   |Required|Value                           | <br/> --- |x-api-key        |Yes    |your_auth_token                 |<br/> |Content-Type      |Yes    |Accepted # value application/json | <br/>  # Request Body |Field            | Required|Type |Description # <br/> --- |url                |Yes      |String|A valid url string. The # URL must be a publicly accessible url. <br/> |customVocabulary   |No      |list #  |Contains a list of words and phrases that provide hints to the speech recognition # task. <br/> |confidenceThreshold|No      |double|Minimum required confidence # for the insight to be recognized. <br/>  # Query Params |Parameter |Required|Value # |<br/> --- |webhookUrl |No      | Webhook url on which job updates to # be sent. (This should be post API) |<br/>   WebhookUrl will be used to # send the status of job created for uploaded Audio url. Every time the status # of the job changes it will be  notified on the WebhookUrl.  # Response # Object on Success |Field         |Description <br/> --- |conversationId |ID # to be used with Conversation API <br/> |jobId         |ID to be used with # Job API <br/>  ## Webhook Payload |Field |Description| --- |jobId |ID # to be used with Job API|<br/> |status|Current status of the job. (Valid statuses # - [ scheduled, in_progress, completed, failed ])|<br/>  ## For more: https://docs.symbl.ai/#audio-api # (Please find POST Async Audio URL  API in Table of Contents)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.append_audio_url(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :param AsyncAudioUrlParameters body: Async Audio URL Payload
        :param bool enable_speaker_diarization:
        :param float diarization_speaker_count:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.append_audio_url_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.append_audio_url_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def append_audio_url_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Audio(URL)  - Submit New Conversation  # noqa: E501

        # About this API:  The Async Audio URL API takes in a url link of your audio and returns the full text transcript along with conversational insights.  It can be utilized for any use case where you have access to recorded audio stored publicly as URL and want to extract insights and   other conversational attributes supported by Symbl's Conversation API.   # HTTP REQUEST POST https://api.symbl.ai/v1/process/audio/url  # Request Headers |Header Name   |Required|Value                           | <br/> --- |x-api-key        |Yes    |your_auth_token                 |<br/> |Content-Type      |Yes    |Accepted # value application/json | <br/>  # Request Body |Field            | Required|Type |Description # <br/> --- |url                |Yes      |String|A valid url string. The # URL must be a publicly accessible url. <br/> |customVocabulary   |No      |list #  |Contains a list of words and phrases that provide hints to the speech recognition # task. <br/> |confidenceThreshold|No      |double|Minimum required confidence # for the insight to be recognized. <br/>  # Query Params |Parameter |Required|Value # |<br/> --- |webhookUrl |No      | Webhook url on which job updates to # be sent. (This should be post API) |<br/>   WebhookUrl will be used to # send the status of job created for uploaded Audio url. Every time the status # of the job changes it will be  notified on the WebhookUrl.  # Response # Object on Success |Field         |Description <br/> --- |conversationId |ID # to be used with Conversation API <br/> |jobId         |ID to be used with # Job API <br/>  ## Webhook Payload |Field |Description| --- |jobId |ID # to be used with Job API|<br/> |status|Current status of the job. (Valid statuses # - [ scheduled, in_progress, completed, failed ])|<br/>  ## For more: https://docs.symbl.ai/#audio-api # (Please find POST Async Audio URL  API in Table of Contents)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.append_audio_url_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :param AsyncAudioUrlParameters body: Async Audio URL Payload
        :param bool enable_speaker_diarization:
        :param float diarization_speaker_count:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'body', 'enable_speaker_diarization', 'diarization_speaker_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method append_audio_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `append_audio_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []
        if 'enable_speaker_diarization' in params:
            query_params.append(('enableSpeakerDiarization', params['enable_speaker_diarization']))  # noqa: E501
        if 'diarization_speaker_count' in params:
            query_params.append(('diarizationSpeakerCount', params['diarization_speaker_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/process/audio/url/{conversationId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def append_text(self, conversation_id, **kwargs):  # noqa: E501
        """Text - Append to Existing Conversation  # noqa: E501

        # About this API Append to existing Conversation with Text Conversation Payload.   ><h4>The conversationId of the conversation processed from any channels (Realtime, Audio/Video Files or Text Content) are allowed.</h4>  ## Request Body JSON body with array of messages.  # Response In response, conversationId and jobId are returned.  `jobId` can be used to get updates on the job status.  `conversationId` can be used with the Conversation API to get all the insights, topics and processed messages etc.  Read More: [https://docs.symbl.ai/#text-api](https://docs.symbl.ai/#text-api)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.append_text(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :param AsyncTextParameters body: Async Text API Payload
        :param str webhook_url:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.append_text_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.append_text_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def append_text_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Text - Append to Existing Conversation  # noqa: E501

        # About this API Append to existing Conversation with Text Conversation Payload.   ><h4>The conversationId of the conversation processed from any channels (Realtime, Audio/Video Files or Text Content) are allowed.</h4>  ## Request Body JSON body with array of messages.  # Response In response, conversationId and jobId are returned.  `jobId` can be used to get updates on the job status.  `conversationId` can be used with the Conversation API to get all the insights, topics and processed messages etc.  Read More: [https://docs.symbl.ai/#text-api](https://docs.symbl.ai/#text-api)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.append_text_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :param AsyncTextParameters body: Async Text API Payload
        :param str webhook_url:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'body', 'webhook_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method append_text" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `append_text`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []
        if 'webhook_url' in params:
            query_params.append(('webhookUrl', params['webhook_url']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/process/text/{conversationId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def append_video(self, body, content_type, conversation_id, **kwargs):  # noqa: E501
        """Video - Submit New Video File (mp4)  # noqa: E501

        # About this API Submit the MP4 Video file for processing.  ## Request Body Binary payload of MP4 video file.  ## Content-Type Header Must be set to `video/mp4` when using `mp4` file.  # Response In response, conversationId and jobId are returned.  `jobId` can be used to get updates on the job status.  `conversationId` can be used with the Conversation API to get all the insights, topics and processed messages etc.  Read More: [https://docs.symbl.ai/#text-api](https://docs.symbl.ai/#video-api)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.append_video(body, content_type, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str content_type: (required)
        :param str conversation_id: ID of the conversation (required)
        :param str name:
        :param str webhook_url:
        :param list[str] custom_vocabulary:
        :param float confidence_threshold:
        :param str entities:
        :param bool detect_entities:
        :param bool detect_phrases:
        :param bool enable_separate_recognition_per_channel:
        :param str channel_metadata:
        :param str language_code:
        :param str mode:
        :param str trackers:
        :param bool enable_speaker_diarization:
        :param float diarization_speaker_count:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.append_video_with_http_info(body, content_type, conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.append_video_with_http_info(body, content_type, conversation_id, **kwargs)  # noqa: E501
            return data

    def append_video_with_http_info(self, body, content_type, conversation_id, **kwargs):  # noqa: E501
        """Video - Submit New Video File (mp4)  # noqa: E501

        # About this API Submit the MP4 Video file for processing.  ## Request Body Binary payload of MP4 video file.  ## Content-Type Header Must be set to `video/mp4` when using `mp4` file.  # Response In response, conversationId and jobId are returned.  `jobId` can be used to get updates on the job status.  `conversationId` can be used with the Conversation API to get all the insights, topics and processed messages etc.  Read More: [https://docs.symbl.ai/#text-api](https://docs.symbl.ai/#video-api)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.append_video_with_http_info(body, content_type, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str content_type: (required)
        :param str conversation_id: ID of the conversation (required)
        :param str name:
        :param str webhook_url:
        :param list[str] custom_vocabulary:
        :param float confidence_threshold:
        :param str entities:
        :param bool detect_entities:
        :param bool detect_phrases:
        :param bool enable_separate_recognition_per_channel:
        :param str channel_metadata:
        :param str language_code:
        :param str mode:
        :param str trackers:
        :param bool enable_speaker_diarization:
        :param float diarization_speaker_count:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'content_type', 'conversation_id', 'name', 'webhook_url', 'custom_vocabulary', 'confidence_threshold', 'entities', 'detect_entities', 'detect_phrases', 'enable_separate_recognition_per_channel', 'channel_metadata', 'language_code', 'mode', 'trackers', 'enable_speaker_diarization', 'diarization_speaker_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method append_video" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `append_video`")  # noqa: E501
        # verify the required parameter 'content_type' is set
        if ('content_type' not in params or
                params['content_type'] is None):
            raise ValueError("Missing the required parameter `content_type` when calling `append_video`")  # noqa: E501
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `append_video`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'webhook_url' in params:
            query_params.append(('webhookUrl', params['webhook_url']))  # noqa: E501
        if 'custom_vocabulary' in params:
            query_params.append(('customVocabulary', params['custom_vocabulary']))  # noqa: E501
            collection_formats['customVocabulary'] = 'multi'  # noqa: E501
        if 'confidence_threshold' in params:
            query_params.append(('confidenceThreshold', params['confidence_threshold']))  # noqa: E501
        if 'entities' in params:
            query_params.append(('entities', params['entities']))  # noqa: E501
        if 'detect_entities' in params:
            query_params.append(('detectEntities', params['detect_entities']))  # noqa: E501
        if 'detect_phrases' in params:
            query_params.append(('detectPhrases', params['detect_phrases']))  # noqa: E501
        if 'enable_separate_recognition_per_channel' in params:
            query_params.append(('enableSeparateRecognitionPerChannel', params['enable_separate_recognition_per_channel']))  # noqa: E501
        if 'channel_metadata' in params:
            query_params.append(('channelMetadata', params['channel_metadata']))  # noqa: E501
        if 'language_code' in params:
            query_params.append(('languageCode', params['language_code']))  # noqa: E501
        if 'mode' in params:
            query_params.append(('mode', params['mode']))  # noqa: E501
        if 'trackers' in params:
            query_params.append(('trackers', params['trackers']))  # noqa: E501
        if 'enable_speaker_diarization' in params:
            query_params.append(('enableSpeakerDiarization', params['enable_speaker_diarization']))  # noqa: E501
        if 'diarization_speaker_count' in params:
            query_params.append(('diarizationSpeakerCount', params['diarization_speaker_count']))  # noqa: E501

        header_params = {}
        if 'content_type' in params:
            header_params['Content-Type'] = params['content_type']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['video/mp4'])  # noqa: E501

        if 'content_type' in params:
            header_params['Content-Type'] = params['content_type']  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/process/video/{conversationId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def append_video_url(self, conversation_id, **kwargs):  # noqa: E501
        """Video (URL)  - Submit New Conversation  # noqa: E501

        # About this API:  The Async Video URL API allows you to process a mp4 video and return the full text transcript along with conversational insights.  It can be utilized for any use case where you have access to recorded video stored publicly as URL and want to extract insights and  other conversational attributes supported by Symbl's Conversation API.   # HTTP REQUEST POST https://api.symbl.ai/v1/process/video/url  # Request Headers |Header Name   |Required|Value                           | <br/> --- |x-api-key        |Yes    |your_auth_token                 |<br/> |Content-Type      |Yes    |Accepted value application/json | <br/>  # Request Body |Field            | Required|Type |Description |<br/> --- |url                |Yes      |String|A valid url string. The URL must be a publicly accessible url. |<br/> |customVocabulary   |No      |list  |Contains a list of words and phrases that provide hints to the speech recognition task. |<br/> |confidenceThreshold|No      |double|Minimum required confidence for the insight to be recognized. |<br/>  # Query Params |Parameter |Required|Value <br/> --- |webhookUrl |No      | Webhook url on which job updates to be sent. (This should be post API) <br/>   WebhookUrl will be used to send the status of job created for uploaded video url. Every time the status of the job changes it will be  notified on the WebhookUrl.  # Response Object on Success |Field         |Description |<br/> --- |conversationId |ID to be used with Conversation API| <br/> |jobId         |ID to be used with Job API |<br/>   ## Webhook Payload |Field |Description| --- |jobId |ID to be used with Job API|<br/> |status|Current status of the job. (Valid statuses - [ scheduled, in_progress, completed, failed ])|<br/>  ## For more: https://docs.symbl.ai/?shell#video-api (Please find POST Asnyc Video URL API in Table of Contents)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.append_video_url(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :param AsyncVideoUrlParameters body: Async Video URL Payload
        :param bool enable_speaker_diarization:
        :param float diarization_speaker_count:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.append_video_url_with_http_info(conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.append_video_url_with_http_info(conversation_id, **kwargs)  # noqa: E501
            return data

    def append_video_url_with_http_info(self, conversation_id, **kwargs):  # noqa: E501
        """Video (URL)  - Submit New Conversation  # noqa: E501

        # About this API:  The Async Video URL API allows you to process a mp4 video and return the full text transcript along with conversational insights.  It can be utilized for any use case where you have access to recorded video stored publicly as URL and want to extract insights and  other conversational attributes supported by Symbl's Conversation API.   # HTTP REQUEST POST https://api.symbl.ai/v1/process/video/url  # Request Headers |Header Name   |Required|Value                           | <br/> --- |x-api-key        |Yes    |your_auth_token                 |<br/> |Content-Type      |Yes    |Accepted value application/json | <br/>  # Request Body |Field            | Required|Type |Description |<br/> --- |url                |Yes      |String|A valid url string. The URL must be a publicly accessible url. |<br/> |customVocabulary   |No      |list  |Contains a list of words and phrases that provide hints to the speech recognition task. |<br/> |confidenceThreshold|No      |double|Minimum required confidence for the insight to be recognized. |<br/>  # Query Params |Parameter |Required|Value <br/> --- |webhookUrl |No      | Webhook url on which job updates to be sent. (This should be post API) <br/>   WebhookUrl will be used to send the status of job created for uploaded video url. Every time the status of the job changes it will be  notified on the WebhookUrl.  # Response Object on Success |Field         |Description |<br/> --- |conversationId |ID to be used with Conversation API| <br/> |jobId         |ID to be used with Job API |<br/>   ## Webhook Payload |Field |Description| --- |jobId |ID to be used with Job API|<br/> |status|Current status of the job. (Valid statuses - [ scheduled, in_progress, completed, failed ])|<br/>  ## For more: https://docs.symbl.ai/?shell#video-api (Please find POST Asnyc Video URL API in Table of Contents)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.append_video_url_with_http_info(conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str conversation_id: ID of the conversation (required)
        :param AsyncVideoUrlParameters body: Async Video URL Payload
        :param bool enable_speaker_diarization:
        :param float diarization_speaker_count:
        :return: AsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'body', 'enable_speaker_diarization', 'diarization_speaker_count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method append_video_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `append_video_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []
        if 'enable_speaker_diarization' in params:
            query_params.append(('enableSpeakerDiarization', params['enable_speaker_diarization']))  # noqa: E501
        if 'diarization_speaker_count' in params:
            query_params.append(('diarizationSpeakerCount', params['diarization_speaker_count']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/process/video/url/{conversationId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
