# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['latex2pdfa']

package_data = \
{'': ['*'], 'latex2pdfa': ['binaries/ghostscript/*', 'resources/*']}

install_requires = \
['rich==12.4.4']

entry_points = \
{'console_scripts': ['latex2pdfa = latex2pdfa.latex2pdfa:main']}

setup_kwargs = {
    'name': 'latex2pdfa',
    'version': '1.0.2',
    'description': 'A command line utility to automate the process of compiling a LaTex project to a PDF complaint with the PDF/A standard',
    'long_description': '# latex2pdfa\n[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)\n\nA command line utility to automate the process of compiling a LaTex project to a PDF complaint with the PDF/A standard.\n\n\n## Setup \n_Assuming you are using a **Debian/Ubuntu** machine_:\n\n+ Python3\n  + Usually pre-installed\n+ [TeX Live](https://www.tug.org/texlive/)\n  ```bash \n    sudo apt install texlive-latex-base texlive-fonts-recommended texlive-latex-extra texlive-bibtex-extra\n    ```\n+ [ExifTool](https://exiftool.org/)\n  ```bash\n  sudo apt install exiftool\n  ```\n- [QPDF](https://qpdf.sourceforge.io/)\n    ```bash\n      sudo apt-get install qpdf\n   ```\n- [veraPDF](https://verapdf.org/) [Optional] (For validation)\n\n## Installation\n```bash\n\n```\n## Usage\nRun the following in your terminal and follow the instructions:\n```bash \nlatex2pdfa path/to/your/main_tex_file.tex \n```\nBy default, the generated PDF will comply with the `1b` standard which most universities require.\n\nYou can specify an output filename with `--output-filename`, otherwise the generated PDF will have the same name of your\n`main_tex_file` followed by `-PDFA-1b`. \n\n-----\nYou can get the exhaustive list of arguments by running:\n\n```bash\nlatex2pdfa --help\n```\n```\nusage: latex2pdfa.py [-h] [--version] [-cl CONFORMANCE_LEVEL] [-clv CONFORMANCE_LEVEL_VERSION] [-o OUTPUT_DIR] [-of OUTPUT_FILENAME] [-i]\n                     [-v] [-nc] [-ve] [--pdflatex-path PDFLATEX_PATH] [--pdflatex_extra_cmds PDFLATEX_EXTRA_CMDS] [--bibtex-path BIBTEX_PATH]\n                     [--gs-path GS_PATH] [--verapdf-path VERAPDF_PATH]\n                     tex_file\n\npositional arguments:\n  tex_file              The main tex file of your LaTex project\n\noptions:\n  -h, --help            show this help message and exit\n  --version             show program\'s version number and exit\n  -cl CONFORMANCE_LEVEL, --conformance-level CONFORMANCE_LEVEL\n                        The PDF/A standard conformance level (`a`, `b`, or `u`), default to `b`\n  -clv CONFORMANCE_LEVEL_VERSION, --conformance-level-version CONFORMANCE_LEVEL_VERSION\n                        The PDF/A standard conformance level version (`1`, `2`, or `3`), default to `1`\n  -o OUTPUT_DIR, --output-dir OUTPUT_DIR\n                        The directory where the generated PDF will be stored, default to the project directory\n  -of OUTPUT_FILENAME, --output-filename OUTPUT_FILENAME\n                        The filename of the generated PDF, default to the main LaTex filename with the suffix PDFA-`cl`clv` (for ex: thesis-\n                        PDFA-1b.pdf\n  -i, --ignore-metadata\n                        Ignore adding the metadata file to the project folder in case it is already done manually, default to false\n  -v, --verbose         show all under the hood commands and their output\n  -nc, --no-clean       Keep the temporary files generated from the compilation\n  -ve, --verify         Verify the generated PDF using veraPDF (veraPDF path must be provided in this case)\n  --pdflatex-path PDFLATEX_PATH\n                        pdflatex executable path, if it is not specified, the script will search on your environment variable PATH\n  --pdflatex_extra_cmds PDFLATEX_EXTRA_CMDS\n                        Add any extra commands to pdflatex (use quotation marks)\n  --bibtex-path BIBTEX_PATH\n                        bibtex executable path, if it is not specified, the script will search on your environment variable PATH\n  --gs-path GS_PATH     ghostscript executable path, if it is not specified, the script will consider the one inside the binaries folder\n  --verapdf-path VERAPDF_PATH\n                        veraPDF executable path, if it is not specified, the script will consider the one inside the binaries folder\n\n```\n\n## Motivation\nThis is quoted from the [pdf2archive](https://github.com/matteosecli/pdf2archive) repository. \n\n_(I can\'t say it better 😂)_\n\n<blockquote>\nThis script was born as a necessity, when I had to convert the LaTeX-produced PDF of my MSc Thesis into a PDF/A-1B.\n\nOnce upon a time, the delivery of the Thesis had to be done manually, by burning a CD-ROM with the Thesis PDF on it. I don\'t need to say that it was extremely old-fasioned and inefficient, as you had to deliver the CD-ROM to the secretariat in person. Finally, in 2015, my university decided to activate the online submission of the PDF: you just had to upload your PDF and you were done, completely hassle-free.\n\nThen one year ago, some _enlightened mind_ in whoever knows what administrative office, decided that a regular PDF was not easy enough; so, the university began to require the much more _satanic_ PDF/A-1B. Of course, they had to provide a set of instructions for us mere mortal, so that we could produce valid PDF/A-1B files; and indeed they did, by uploading a [_fantastic document_](http://www.biblioteca.unitn.it/282/tesi-di-laurea). If you took the (click)bait and read the PDF (not PDF/A-1B, eh!) instructions at the previous linked page, you might have noticed the _absolute completeness_ of the information contained in it: there are instructions to transform a PDF into a PDF/A-1B by either using a Windows-only free program (yeah, I know) or an obsolete OpenOffice plugin that doesn\'t work anymore or _paid_, commercial programs that work at most only on Windows and MacOS. No free, cross-platform alternative because hey, _everyone_ loves Windows! Naturally, you can directly produce a PDF/A-1B version of your Thesis. The document lists some easy instructions to perform a direct export into a PDF/A-1B from either Microsoft Word (or Excel, because there are people who of course write their thesis in Excel) or OpenOffice. Because _everyone_ on Earth, especially people who do Physics or Maths, write their thesis in Microsoft Word... they look _sooo beautiful_, in particular when you have to put footnotes, citations, table of contents, when Word spreads the text in a page in a zebra-style, and when you write those amazing equations in Comic Sans that get rendered as 10 DPI jpeg\'s. "And people who use LaTeX"? "Latex? What latex? I don\'t do that kind of dirty sex stuff"! - would say the guy who wrote that document. \n\nSo you could imagine me and my friends, on the last available day for the Thesis delivery, still struggling trying to figure out how to convert. There is a [nice site](https://docupub.com/pdfconvert/) that converts PDF\'s into PDF/A-1B files, but there are some points:\n+ your Thesis gets filled with metadata from that site, which is not nice for an official document\n+ the file size limit is 10 Mb, so if you do a more experimental Thesis which is full of images you\'re out\n+ this solution depends on someone else resources; if the site goes down tomorrow, you\'re in deep s***\n+ it only works online, no offline alternative if you\'re on the move\n+ you have to send personal data to an unknown site\n+ you don\'t know what operations are being performed on your file and your data on the other side of the line\n\nBy digging around on Google, you can find people saying that you can perform the conversion via Ghostscript by just turning on a couple of switches; unfortunately, this doesn\'t work (the online system, Esse3, keeps saying that the file is not valid) and the matter is slightly more complicated and poorly documented. The failure in producing a valid PDF/A-1B is connected to the complex set of requirements needed, especially font embedding, metadata and color space. This script is just a collection of all the things one should to in order to obtain (in most of the cases) a valid PDF/A-1B document [...]. \n\n</blockquote>\n\n## Discussion\n \n- The use of the `pdfx` package alone still produce validation errors!!\n- The use of `Ghostscript` alone to convert the PDF to PDF/A is not always successful. Sometimes the old versions does not work. Sometimes, the recent versions does not have the same arguments because it is always evolving, and even if it works, you may find that the links are not working, or the table of contents does not exist, etc.\nAfter a lot (I mean a lot) of trial and error, I found that the version `9.23` is giving the best results, I decided to include it with the project files.\n- The script uses both to produce a high quality PDF/A directly from the LaTex source files.\n- The script is only compatible with the `b` conformance level.\nUnfortunately, there is noway to generate a fully compatible `PDF/A-a` from LaTex until now (as of my knowledge).\n- More interesting information are available in the [FAQs](https://github.com/matteosecli/pdf2archive#faqs) section of [pdf2archive](https://github.com/matteosecli/pdf2archive).\n\n\n## License\n\nGPLv3 © [latex2pdfa](https://github.com/abdeladim-s/latex2pdfa). For more information see `LICENSE.md`.\n\n',
    'author': 'Abdeladim S.',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
