"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-5808
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from intersight.model.workflow_base_data_type import WorkflowBaseDataType
    from intersight.model.workflow_service_item_action_workflow_definition import WorkflowServiceItemActionWorkflowDefinition
    from intersight.model.workflow_service_item_definition_relationship import WorkflowServiceItemDefinitionRelationship
    from intersight.model.workflow_validation_information import WorkflowValidationInformation
    from intersight.model.workflow_workflow_definition_relationship import WorkflowWorkflowDefinitionRelationship
    globals()['WorkflowBaseDataType'] = WorkflowBaseDataType
    globals()['WorkflowServiceItemActionWorkflowDefinition'] = WorkflowServiceItemActionWorkflowDefinition
    globals()['WorkflowServiceItemDefinitionRelationship'] = WorkflowServiceItemDefinitionRelationship
    globals()['WorkflowValidationInformation'] = WorkflowValidationInformation
    globals()['WorkflowWorkflowDefinitionRelationship'] = WorkflowWorkflowDefinitionRelationship


class WorkflowServiceItemActionDefinitionAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'WORKFLOW.SERVICEITEMACTIONDEFINITION': "workflow.ServiceItemActionDefinition",
        },
        ('object_type',): {
            'WORKFLOW.SERVICEITEMACTIONDEFINITION': "workflow.ServiceItemActionDefinition",
        },
        ('action_type',): {
            'EXTERNAL': "External",
            'INTERNAL': "Internal",
            'REPETITIVE': "Repetitive",
        },
        ('allowed_instance_states',): {
            'None': None,
            'NOTCREATED': "NotCreated",
            'INPROGRESS': "InProgress",
            'FAILED': "Failed",
            'OKAY': "Okay",
            'DECOMMISSIONED': "Decommissioned",
        },
    }

    validations = {
        ('label',): {
            'regex': {
                'pattern': r'^[a-zA-Z0-9]+[\sa-zA-Z0-9_.:-]{1,92}$',  # noqa: E501
            },
        },
        ('name',): {
            'regex': {
                'pattern': r'^[a-zA-Z0-9_.:-]{1,64}$',  # noqa: E501
            },
        },
        ('periodicity',): {
            'inclusive_maximum': 604800,
            'inclusive_minimum': 0,
        },
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'action_type': (str,),  # noqa: E501
            'allowed_instance_states': ([str], none_type,),  # noqa: E501
            'core_workflows': ([WorkflowServiceItemActionWorkflowDefinition], none_type,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'input_definition': ([WorkflowBaseDataType], none_type,),  # noqa: E501
            'label': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'output_parameters': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'periodicity': (int,),  # noqa: E501
            'post_core_workflows': ([WorkflowServiceItemActionWorkflowDefinition], none_type,),  # noqa: E501
            'pre_core_workflows': ([WorkflowServiceItemActionWorkflowDefinition], none_type,),  # noqa: E501
            'stop_workflows': ([WorkflowServiceItemActionWorkflowDefinition], none_type,),  # noqa: E501
            'validation_information': (WorkflowValidationInformation,),  # noqa: E501
            'validation_workflows': ([WorkflowServiceItemActionWorkflowDefinition], none_type,),  # noqa: E501
            'service_item_definition': (WorkflowServiceItemDefinitionRelationship,),  # noqa: E501
            'workflow_definition': (WorkflowWorkflowDefinitionRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'action_type': 'ActionType',  # noqa: E501
        'allowed_instance_states': 'AllowedInstanceStates',  # noqa: E501
        'core_workflows': 'CoreWorkflows',  # noqa: E501
        'description': 'Description',  # noqa: E501
        'input_definition': 'InputDefinition',  # noqa: E501
        'label': 'Label',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'output_parameters': 'OutputParameters',  # noqa: E501
        'periodicity': 'Periodicity',  # noqa: E501
        'post_core_workflows': 'PostCoreWorkflows',  # noqa: E501
        'pre_core_workflows': 'PreCoreWorkflows',  # noqa: E501
        'stop_workflows': 'StopWorkflows',  # noqa: E501
        'validation_information': 'ValidationInformation',  # noqa: E501
        'validation_workflows': 'ValidationWorkflows',  # noqa: E501
        'service_item_definition': 'ServiceItemDefinition',  # noqa: E501
        'workflow_definition': 'WorkflowDefinition',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """WorkflowServiceItemActionDefinitionAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "workflow.ServiceItemActionDefinition", must be one of ["workflow.ServiceItemActionDefinition", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "workflow.ServiceItemActionDefinition", must be one of ["workflow.ServiceItemActionDefinition", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            action_type (str): Type of actionDefinition which decides on how to trigger the action. * `External` - External actions definition can be triggered by enduser to perform actions on the service item. Once action is completed successfully (eg. create/deploy), user cannot re-trigger that action again. * `Internal` - Internal action definition is used to trigger periodic actions on the service item instance. * `Repetitive` - Repetitive action definition is an external action that can be triggered by enduser to perform repetitive actions (eg. Edit/Update/Perform health check) on the created service item.. [optional] if omitted the server will use the default value of "External"  # noqa: E501
            allowed_instance_states ([str], none_type): [optional]  # noqa: E501
            core_workflows ([WorkflowServiceItemActionWorkflowDefinition], none_type): [optional]  # noqa: E501
            description (str): The description for this action which provides information on what are the pre-requisites to use this action on the service item and what features are supported by this action.. [optional]  # noqa: E501
            input_definition ([WorkflowBaseDataType], none_type): [optional]  # noqa: E501
            label (str): A user friendly short name to identify the action. Name can only contain letters (a-z, A-Z), numbers (0-9), hyphen (-), period (.), colon (:), space ( ) or an underscore (_).. [optional]  # noqa: E501
            name (str): The name for this action definition. Name can only contain letters (a-z, A-Z), numbers (0-9), hyphen (-), period (.), colon (:) or an underscore (_). Name of the action must be unique within a service item definition.. [optional]  # noqa: E501
            output_parameters (bool, date, datetime, dict, float, int, list, str, none_type): The output mappings from workflows in the action definition to the service item output definition. Any output from core or post-core workflow can be mapped to service item output definition. The output can be referred using the name of the workflow definition and the output name in the following format '${<ServiceItemActionWorkflowDefinition.Name>.output.<outputName>'.. [optional]  # noqa: E501
            periodicity (int): Value in seconds to specify the periodicity of the workflows. A zero value indicate the workflow will not execute periodically. A non-zero value indicate, the workflow will be executed periodically with this periodicity.. [optional]  # noqa: E501
            post_core_workflows ([WorkflowServiceItemActionWorkflowDefinition], none_type): [optional]  # noqa: E501
            pre_core_workflows ([WorkflowServiceItemActionWorkflowDefinition], none_type): [optional]  # noqa: E501
            stop_workflows ([WorkflowServiceItemActionWorkflowDefinition], none_type): [optional]  # noqa: E501
            validation_information (WorkflowValidationInformation): [optional]  # noqa: E501
            validation_workflows ([WorkflowServiceItemActionWorkflowDefinition], none_type): [optional]  # noqa: E501
            service_item_definition (WorkflowServiceItemDefinitionRelationship): [optional]  # noqa: E501
            workflow_definition (WorkflowWorkflowDefinitionRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "workflow.ServiceItemActionDefinition")
        object_type = kwargs.get('object_type', "workflow.ServiceItemActionDefinition")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
