"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-5808
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from intersight.model.organization_organization_relationship import OrganizationOrganizationRelationship
    from intersight.model.policy_abstract_config_profile_relationship import PolicyAbstractConfigProfileRelationship
    globals()['OrganizationOrganizationRelationship'] = OrganizationOrganizationRelationship
    globals()['PolicyAbstractConfigProfileRelationship'] = PolicyAbstractConfigProfileRelationship


class PowerPolicyAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'POWER.POLICY': "power.Policy",
        },
        ('object_type',): {
            'POWER.POLICY': "power.Policy",
        },
        ('dynamic_rebalancing',): {
            'ENABLED': "Enabled",
            'DISABLED': "Disabled",
        },
        ('power_priority',): {
            'LOW': "Low",
            'MEDIUM': "Medium",
            'HIGH': "High",
        },
        ('power_profiling',): {
            'ENABLED': "Enabled",
            'DISABLED': "Disabled",
        },
        ('power_restore_state',): {
            'ALWAYSOFF': "AlwaysOff",
            'ALWAYSON': "AlwaysOn",
            'LASTSTATE': "LastState",
        },
        ('power_save_mode',): {
            'ENABLED': "Enabled",
            'DISABLED': "Disabled",
        },
        ('redundancy_mode',): {
            'GRID': "Grid",
            'NOTREDUNDANT': "NotRedundant",
            'N+1': "N+1",
            'N+2': "N+2",
        },
    }

    validations = {
        ('allocated_budget',): {
            'inclusive_maximum': 65535,
            'inclusive_minimum': 0,
        },
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'allocated_budget': (int,),  # noqa: E501
            'dynamic_rebalancing': (str,),  # noqa: E501
            'power_priority': (str,),  # noqa: E501
            'power_profiling': (str,),  # noqa: E501
            'power_restore_state': (str,),  # noqa: E501
            'power_save_mode': (str,),  # noqa: E501
            'redundancy_mode': (str,),  # noqa: E501
            'organization': (OrganizationOrganizationRelationship,),  # noqa: E501
            'profiles': ([PolicyAbstractConfigProfileRelationship], none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'allocated_budget': 'AllocatedBudget',  # noqa: E501
        'dynamic_rebalancing': 'DynamicRebalancing',  # noqa: E501
        'power_priority': 'PowerPriority',  # noqa: E501
        'power_profiling': 'PowerProfiling',  # noqa: E501
        'power_restore_state': 'PowerRestoreState',  # noqa: E501
        'power_save_mode': 'PowerSaveMode',  # noqa: E501
        'redundancy_mode': 'RedundancyMode',  # noqa: E501
        'organization': 'Organization',  # noqa: E501
        'profiles': 'Profiles',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """PowerPolicyAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "power.Policy", must be one of ["power.Policy", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "power.Policy", must be one of ["power.Policy", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            allocated_budget (int): Sets the Allocated Power Budget of the System (in Watts). This field is only supported for Cisco UCS X series Chassis.. [optional] if omitted the server will use the default value of 0  # noqa: E501
            dynamic_rebalancing (str): Sets the Dynamic Power Rebalancing of the System. This option is only supported for Cisco UCS X series Chassis. * `Enabled` - Set the value to Enabled. * `Disabled` - Set the value to Disabled.. [optional] if omitted the server will use the default value of "Enabled"  # noqa: E501
            power_priority (str): Sets the Power Priority of the System. This field is only supported for Cisco UCS X series servers. * `Low` - Set the Power Priority to Low. * `Medium` - Set the Power Priority to Medium. * `High` - Set the Power Priority to High.. [optional] if omitted the server will use the default value of "Low"  # noqa: E501
            power_profiling (str): Sets the Power Profiling of the Server. This field is only supported for Cisco UCS X series servers. * `Enabled` - Set the value to Enabled. * `Disabled` - Set the value to Disabled.. [optional] if omitted the server will use the default value of "Enabled"  # noqa: E501
            power_restore_state (str): Sets the Power Restore State of the Server. This field is only supported for Cisco UCS X series servers. * `AlwaysOff` - Set the Power Restore Mode to Off. * `AlwaysOn` - Set the Power Restore Mode to On. * `LastState` - Set the Power Restore Mode to LastState.. [optional] if omitted the server will use the default value of "AlwaysOff"  # noqa: E501
            power_save_mode (str): Sets the Power Save mode of the System. This option is only supported for Cisco UCS X series Chassis. * `Enabled` - Set the value to Enabled. * `Disabled` - Set the value to Disabled.. [optional] if omitted the server will use the default value of "Enabled"  # noqa: E501
            redundancy_mode (str): Sets the Power Redundancy of the System. N+2 mode is only supported for Cisco UCS X series Chassis. * `Grid` - Grid Mode requires two power sources. If one source fails, the surviving PSUs connected to the other source provides power to the chassis. * `NotRedundant` - Power Manager turns on the minimum number of PSUs required to support chassis power requirements. No Redundant PSUs are maintained. * `N+1` - Power Manager turns on the minimum number of PSUs required to support chassis power requirements plus one additional PSU for redundancy. * `N+2` - Power Manager turns on the minimum number of PSUs required to support chassis power requirements plus two additional PSU for redundancy. This Mode is only supported for UCS X series Chassis.. [optional] if omitted the server will use the default value of "Grid"  # noqa: E501
            organization (OrganizationOrganizationRelationship): [optional]  # noqa: E501
            profiles ([PolicyAbstractConfigProfileRelationship], none_type): An array of relationships to policyAbstractConfigProfile resources.. [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "power.Policy")
        object_type = kwargs.get('object_type', "power.Policy")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
