"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-5808
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from intersight.model.aaa_audit_record_list import AaaAuditRecordList
    from intersight.model.aaa_retention_config_list import AaaRetentionConfigList
    from intersight.model.aaa_retention_policy_list import AaaRetentionPolicyList
    from intersight.model.access_policy_list import AccessPolicyList
    from intersight.model.adapter_config_policy_list import AdapterConfigPolicyList
    from intersight.model.adapter_ext_eth_interface_list import AdapterExtEthInterfaceList
    from intersight.model.adapter_host_eth_interface_list import AdapterHostEthInterfaceList
    from intersight.model.adapter_host_fc_interface_list import AdapterHostFcInterfaceList
    from intersight.model.adapter_host_iscsi_interface_list import AdapterHostIscsiInterfaceList
    from intersight.model.adapter_unit_expander_list import AdapterUnitExpanderList
    from intersight.model.adapter_unit_list import AdapterUnitList
    from intersight.model.appliance_app_status_list import ApplianceAppStatusList
    from intersight.model.appliance_auto_rma_policy_list import ApplianceAutoRmaPolicyList
    from intersight.model.appliance_backup_list import ApplianceBackupList
    from intersight.model.appliance_backup_policy_list import ApplianceBackupPolicyList
    from intersight.model.appliance_certificate_setting_list import ApplianceCertificateSettingList
    from intersight.model.appliance_data_export_policy_list import ApplianceDataExportPolicyList
    from intersight.model.appliance_device_certificate_list import ApplianceDeviceCertificateList
    from intersight.model.appliance_device_claim_list import ApplianceDeviceClaimList
    from intersight.model.appliance_device_upgrade_policy_list import ApplianceDeviceUpgradePolicyList
    from intersight.model.appliance_diag_setting_list import ApplianceDiagSettingList
    from intersight.model.appliance_external_syslog_setting_list import ApplianceExternalSyslogSettingList
    from intersight.model.appliance_file_gateway_list import ApplianceFileGatewayList
    from intersight.model.appliance_file_system_status_list import ApplianceFileSystemStatusList
    from intersight.model.appliance_group_status_list import ApplianceGroupStatusList
    from intersight.model.appliance_image_bundle_list import ApplianceImageBundleList
    from intersight.model.appliance_node_info_list import ApplianceNodeInfoList
    from intersight.model.appliance_node_status_list import ApplianceNodeStatusList
    from intersight.model.appliance_release_note_list import ApplianceReleaseNoteList
    from intersight.model.appliance_remote_file_import_list import ApplianceRemoteFileImportList
    from intersight.model.appliance_restore_list import ApplianceRestoreList
    from intersight.model.appliance_setup_info_list import ApplianceSetupInfoList
    from intersight.model.appliance_system_info_list import ApplianceSystemInfoList
    from intersight.model.appliance_system_status_list import ApplianceSystemStatusList
    from intersight.model.appliance_upgrade_list import ApplianceUpgradeList
    from intersight.model.appliance_upgrade_policy_list import ApplianceUpgradePolicyList
    from intersight.model.asset_cluster_member_list import AssetClusterMemberList
    from intersight.model.asset_deployment_device_list import AssetDeploymentDeviceList
    from intersight.model.asset_deployment_list import AssetDeploymentList
    from intersight.model.asset_device_configuration_list import AssetDeviceConfigurationList
    from intersight.model.asset_device_connector_manager_list import AssetDeviceConnectorManagerList
    from intersight.model.asset_device_contract_information_list import AssetDeviceContractInformationList
    from intersight.model.asset_device_registration_list import AssetDeviceRegistrationList
    from intersight.model.asset_subscription_account_list import AssetSubscriptionAccountList
    from intersight.model.asset_subscription_device_contract_information_list import AssetSubscriptionDeviceContractInformationList
    from intersight.model.asset_subscription_list import AssetSubscriptionList
    from intersight.model.asset_target_list import AssetTargetList
    from intersight.model.bios_boot_device_list import BiosBootDeviceList
    from intersight.model.bios_boot_mode_list import BiosBootModeList
    from intersight.model.bios_policy_list import BiosPolicyList
    from intersight.model.bios_system_boot_order_list import BiosSystemBootOrderList
    from intersight.model.bios_token_settings_list import BiosTokenSettingsList
    from intersight.model.bios_unit_list import BiosUnitList
    from intersight.model.bios_vf_select_memory_ras_configuration_list import BiosVfSelectMemoryRasConfigurationList
    from intersight.model.boot_cdd_device_list import BootCddDeviceList
    from intersight.model.boot_device_boot_mode_list import BootDeviceBootModeList
    from intersight.model.boot_device_boot_security_list import BootDeviceBootSecurityList
    from intersight.model.boot_hdd_device_list import BootHddDeviceList
    from intersight.model.boot_iscsi_device_list import BootIscsiDeviceList
    from intersight.model.boot_nvme_device_list import BootNvmeDeviceList
    from intersight.model.boot_pch_storage_device_list import BootPchStorageDeviceList
    from intersight.model.boot_precision_policy_list import BootPrecisionPolicyList
    from intersight.model.boot_pxe_device_list import BootPxeDeviceList
    from intersight.model.boot_san_device_list import BootSanDeviceList
    from intersight.model.boot_sd_device_list import BootSdDeviceList
    from intersight.model.boot_uefi_shell_device_list import BootUefiShellDeviceList
    from intersight.model.boot_usb_device_list import BootUsbDeviceList
    from intersight.model.boot_vmedia_device_list import BootVmediaDeviceList
    from intersight.model.bulk_export_list import BulkExportList
    from intersight.model.bulk_exported_item_list import BulkExportedItemList
    from intersight.model.bulk_request_list import BulkRequestList
    from intersight.model.bulk_sub_request_obj_list import BulkSubRequestObjList
    from intersight.model.capability_adapter_unit_descriptor_list import CapabilityAdapterUnitDescriptorList
    from intersight.model.capability_catalog_list import CapabilityCatalogList
    from intersight.model.capability_chassis_descriptor_list import CapabilityChassisDescriptorList
    from intersight.model.capability_chassis_manufacturing_def_list import CapabilityChassisManufacturingDefList
    from intersight.model.capability_cimc_firmware_descriptor_list import CapabilityCimcFirmwareDescriptorList
    from intersight.model.capability_equipment_physical_def_list import CapabilityEquipmentPhysicalDefList
    from intersight.model.capability_equipment_slot_array_list import CapabilityEquipmentSlotArrayList
    from intersight.model.capability_fan_module_descriptor_list import CapabilityFanModuleDescriptorList
    from intersight.model.capability_fan_module_manufacturing_def_list import CapabilityFanModuleManufacturingDefList
    from intersight.model.capability_fex_descriptor_list import CapabilityFexDescriptorList
    from intersight.model.capability_fex_manufacturing_def_list import CapabilityFexManufacturingDefList
    from intersight.model.capability_io_card_capability_def_list import CapabilityIoCardCapabilityDefList
    from intersight.model.capability_io_card_descriptor_list import CapabilityIoCardDescriptorList
    from intersight.model.capability_io_card_manufacturing_def_list import CapabilityIoCardManufacturingDefList
    from intersight.model.capability_port_group_aggregation_def_list import CapabilityPortGroupAggregationDefList
    from intersight.model.capability_psu_descriptor_list import CapabilityPsuDescriptorList
    from intersight.model.capability_psu_manufacturing_def_list import CapabilityPsuManufacturingDefList
    from intersight.model.capability_server_models_capability_def_list import CapabilityServerModelsCapabilityDefList
    from intersight.model.capability_server_schema_descriptor_list import CapabilityServerSchemaDescriptorList
    from intersight.model.capability_sioc_module_capability_def_list import CapabilitySiocModuleCapabilityDefList
    from intersight.model.capability_sioc_module_descriptor_list import CapabilitySiocModuleDescriptorList
    from intersight.model.capability_sioc_module_manufacturing_def_list import CapabilitySiocModuleManufacturingDefList
    from intersight.model.capability_switch_capability_list import CapabilitySwitchCapabilityList
    from intersight.model.capability_switch_descriptor_list import CapabilitySwitchDescriptorList
    from intersight.model.capability_switch_manufacturing_def_list import CapabilitySwitchManufacturingDefList
    from intersight.model.certificatemanagement_policy_list import CertificatemanagementPolicyList
    from intersight.model.chassis_config_change_detail_list import ChassisConfigChangeDetailList
    from intersight.model.chassis_config_import_list import ChassisConfigImportList
    from intersight.model.chassis_config_result_entry_list import ChassisConfigResultEntryList
    from intersight.model.chassis_config_result_list import ChassisConfigResultList
    from intersight.model.chassis_iom_profile_list import ChassisIomProfileList
    from intersight.model.chassis_profile_list import ChassisProfileList
    from intersight.model.cloud_aws_billing_unit_list import CloudAwsBillingUnitList
    from intersight.model.cloud_aws_key_pair_list import CloudAwsKeyPairList
    from intersight.model.cloud_aws_network_interface_list import CloudAwsNetworkInterfaceList
    from intersight.model.cloud_aws_organizational_unit_list import CloudAwsOrganizationalUnitList
    from intersight.model.cloud_aws_security_group_list import CloudAwsSecurityGroupList
    from intersight.model.cloud_aws_subnet_list import CloudAwsSubnetList
    from intersight.model.cloud_aws_virtual_machine_list import CloudAwsVirtualMachineList
    from intersight.model.cloud_aws_volume_list import CloudAwsVolumeList
    from intersight.model.cloud_aws_vpc_list import CloudAwsVpcList
    from intersight.model.cloud_regions_list import CloudRegionsList
    from intersight.model.cloud_sku_container_type_list import CloudSkuContainerTypeList
    from intersight.model.cloud_sku_database_type_list import CloudSkuDatabaseTypeList
    from intersight.model.cloud_sku_instance_type_list import CloudSkuInstanceTypeList
    from intersight.model.cloud_sku_network_type_list import CloudSkuNetworkTypeList
    from intersight.model.cloud_sku_region_rate_cards_list import CloudSkuRegionRateCardsList
    from intersight.model.cloud_sku_volume_type_list import CloudSkuVolumeTypeList
    from intersight.model.cloud_tfc_agentpool_list import CloudTfcAgentpoolList
    from intersight.model.cloud_tfc_organization_list import CloudTfcOrganizationList
    from intersight.model.cloud_tfc_workspace_list import CloudTfcWorkspaceList
    from intersight.model.comm_http_proxy_policy_list import CommHttpProxyPolicyList
    from intersight.model.compute_blade_identity_list import ComputeBladeIdentityList
    from intersight.model.compute_blade_list import ComputeBladeList
    from intersight.model.compute_board_list import ComputeBoardList
    from intersight.model.compute_mapping_list import ComputeMappingList
    from intersight.model.compute_physical_summary_list import ComputePhysicalSummaryList
    from intersight.model.compute_rack_unit_identity_list import ComputeRackUnitIdentityList
    from intersight.model.compute_rack_unit_list import ComputeRackUnitList
    from intersight.model.compute_server_power_policy_list import ComputeServerPowerPolicyList
    from intersight.model.compute_server_setting_list import ComputeServerSettingList
    from intersight.model.compute_vmedia_list import ComputeVmediaList
    from intersight.model.cond_alarm_aggregation_list import CondAlarmAggregationList
    from intersight.model.cond_alarm_list import CondAlarmList
    from intersight.model.cond_hcl_status_detail_list import CondHclStatusDetailList
    from intersight.model.cond_hcl_status_job_list import CondHclStatusJobList
    from intersight.model.cond_hcl_status_list import CondHclStatusList
    from intersight.model.connectorpack_connector_pack_upgrade_list import ConnectorpackConnectorPackUpgradeList
    from intersight.model.connectorpack_upgrade_impact_list import ConnectorpackUpgradeImpactList
    from intersight.model.console_console_config_list import ConsoleConsoleConfigList
    from intersight.model.convergedinfra_health_check_definition_list import ConvergedinfraHealthCheckDefinitionList
    from intersight.model.convergedinfra_health_check_execution_list import ConvergedinfraHealthCheckExecutionList
    from intersight.model.convergedinfra_pod_list import ConvergedinfraPodList
    from intersight.model.crd_custom_resource_list import CrdCustomResourceList
    from intersight.model.deviceconnector_policy_list import DeviceconnectorPolicyList
    from intersight.model.equipment_chassis_identity_list import EquipmentChassisIdentityList
    from intersight.model.equipment_chassis_list import EquipmentChassisList
    from intersight.model.equipment_chassis_operation_list import EquipmentChassisOperationList
    from intersight.model.equipment_device_summary_list import EquipmentDeviceSummaryList
    from intersight.model.equipment_expander_module_list import EquipmentExpanderModuleList
    from intersight.model.equipment_fan_control_list import EquipmentFanControlList
    from intersight.model.equipment_fan_list import EquipmentFanList
    from intersight.model.equipment_fan_module_list import EquipmentFanModuleList
    from intersight.model.equipment_fex_identity_list import EquipmentFexIdentityList
    from intersight.model.equipment_fex_list import EquipmentFexList
    from intersight.model.equipment_fex_operation_list import EquipmentFexOperationList
    from intersight.model.equipment_fru_list import EquipmentFruList
    from intersight.model.equipment_identity_summary_list import EquipmentIdentitySummaryList
    from intersight.model.equipment_io_card_list import EquipmentIoCardList
    from intersight.model.equipment_io_card_operation_list import EquipmentIoCardOperationList
    from intersight.model.equipment_io_expander_list import EquipmentIoExpanderList
    from intersight.model.equipment_locator_led_list import EquipmentLocatorLedList
    from intersight.model.equipment_psu_control_list import EquipmentPsuControlList
    from intersight.model.equipment_psu_list import EquipmentPsuList
    from intersight.model.equipment_rack_enclosure_list import EquipmentRackEnclosureList
    from intersight.model.equipment_rack_enclosure_slot_list import EquipmentRackEnclosureSlotList
    from intersight.model.equipment_shared_io_module_list import EquipmentSharedIoModuleList
    from intersight.model.equipment_switch_card_list import EquipmentSwitchCardList
    from intersight.model.equipment_system_io_controller_list import EquipmentSystemIoControllerList
    from intersight.model.equipment_tpm_list import EquipmentTpmList
    from intersight.model.equipment_transceiver_list import EquipmentTransceiverList
    from intersight.model.ether_host_port_list import EtherHostPortList
    from intersight.model.ether_network_port_list import EtherNetworkPortList
    from intersight.model.ether_physical_port_list import EtherPhysicalPortList
    from intersight.model.ether_port_channel_list import EtherPortChannelList
    from intersight.model.externalsite_authorization_list import ExternalsiteAuthorizationList
    from intersight.model.fabric_appliance_pc_role_list import FabricAppliancePcRoleList
    from intersight.model.fabric_appliance_role_list import FabricApplianceRoleList
    from intersight.model.fabric_config_change_detail_list import FabricConfigChangeDetailList
    from intersight.model.fabric_config_result_entry_list import FabricConfigResultEntryList
    from intersight.model.fabric_config_result_list import FabricConfigResultList
    from intersight.model.fabric_element_identity_list import FabricElementIdentityList
    from intersight.model.fabric_eth_network_control_policy_list import FabricEthNetworkControlPolicyList
    from intersight.model.fabric_eth_network_group_policy_list import FabricEthNetworkGroupPolicyList
    from intersight.model.fabric_eth_network_policy_list import FabricEthNetworkPolicyList
    from intersight.model.fabric_fc_network_policy_list import FabricFcNetworkPolicyList
    from intersight.model.fabric_fc_storage_role_list import FabricFcStorageRoleList
    from intersight.model.fabric_fc_uplink_pc_role_list import FabricFcUplinkPcRoleList
    from intersight.model.fabric_fc_uplink_role_list import FabricFcUplinkRoleList
    from intersight.model.fabric_fcoe_uplink_pc_role_list import FabricFcoeUplinkPcRoleList
    from intersight.model.fabric_fcoe_uplink_role_list import FabricFcoeUplinkRoleList
    from intersight.model.fabric_flow_control_policy_list import FabricFlowControlPolicyList
    from intersight.model.fabric_link_aggregation_policy_list import FabricLinkAggregationPolicyList
    from intersight.model.fabric_link_control_policy_list import FabricLinkControlPolicyList
    from intersight.model.fabric_multicast_policy_list import FabricMulticastPolicyList
    from intersight.model.fabric_pc_member_list import FabricPcMemberList
    from intersight.model.fabric_pc_operation_list import FabricPcOperationList
    from intersight.model.fabric_port_mode_list import FabricPortModeList
    from intersight.model.fabric_port_operation_list import FabricPortOperationList
    from intersight.model.fabric_port_policy_list import FabricPortPolicyList
    from intersight.model.fabric_server_role_list import FabricServerRoleList
    from intersight.model.fabric_switch_cluster_profile_list import FabricSwitchClusterProfileList
    from intersight.model.fabric_switch_control_policy_list import FabricSwitchControlPolicyList
    from intersight.model.fabric_switch_profile_list import FabricSwitchProfileList
    from intersight.model.fabric_system_qos_policy_list import FabricSystemQosPolicyList
    from intersight.model.fabric_uplink_pc_role_list import FabricUplinkPcRoleList
    from intersight.model.fabric_uplink_role_list import FabricUplinkRoleList
    from intersight.model.fabric_vlan_list import FabricVlanList
    from intersight.model.fabric_vsan_list import FabricVsanList
    from intersight.model.fault_instance_list import FaultInstanceList
    from intersight.model.fc_physical_port_list import FcPhysicalPortList
    from intersight.model.fc_port_channel_list import FcPortChannelList
    from intersight.model.fcpool_fc_block_list import FcpoolFcBlockList
    from intersight.model.fcpool_lease_list import FcpoolLeaseList
    from intersight.model.fcpool_pool_list import FcpoolPoolList
    from intersight.model.fcpool_pool_member_list import FcpoolPoolMemberList
    from intersight.model.fcpool_universe_list import FcpoolUniverseList
    from intersight.model.firmware_bios_descriptor_list import FirmwareBiosDescriptorList
    from intersight.model.firmware_board_controller_descriptor_list import FirmwareBoardControllerDescriptorList
    from intersight.model.firmware_chassis_upgrade_list import FirmwareChassisUpgradeList
    from intersight.model.firmware_cimc_descriptor_list import FirmwareCimcDescriptorList
    from intersight.model.firmware_dimm_descriptor_list import FirmwareDimmDescriptorList
    from intersight.model.firmware_distributable_list import FirmwareDistributableList
    from intersight.model.firmware_distributable_meta_list import FirmwareDistributableMetaList
    from intersight.model.firmware_drive_descriptor_list import FirmwareDriveDescriptorList
    from intersight.model.firmware_driver_distributable_list import FirmwareDriverDistributableList
    from intersight.model.firmware_eula_list import FirmwareEulaList
    from intersight.model.firmware_firmware_summary_list import FirmwareFirmwareSummaryList
    from intersight.model.firmware_gpu_descriptor_list import FirmwareGpuDescriptorList
    from intersight.model.firmware_hba_descriptor_list import FirmwareHbaDescriptorList
    from intersight.model.firmware_iom_descriptor_list import FirmwareIomDescriptorList
    from intersight.model.firmware_mswitch_descriptor_list import FirmwareMswitchDescriptorList
    from intersight.model.firmware_nxos_descriptor_list import FirmwareNxosDescriptorList
    from intersight.model.firmware_pcie_descriptor_list import FirmwarePcieDescriptorList
    from intersight.model.firmware_psu_descriptor_list import FirmwarePsuDescriptorList
    from intersight.model.firmware_running_firmware_list import FirmwareRunningFirmwareList
    from intersight.model.firmware_sas_expander_descriptor_list import FirmwareSasExpanderDescriptorList
    from intersight.model.firmware_server_configuration_utility_distributable_list import FirmwareServerConfigurationUtilityDistributableList
    from intersight.model.firmware_storage_controller_descriptor_list import FirmwareStorageControllerDescriptorList
    from intersight.model.firmware_switch_upgrade_list import FirmwareSwitchUpgradeList
    from intersight.model.firmware_unsupported_version_upgrade_list import FirmwareUnsupportedVersionUpgradeList
    from intersight.model.firmware_upgrade_impact_status_list import FirmwareUpgradeImpactStatusList
    from intersight.model.firmware_upgrade_list import FirmwareUpgradeList
    from intersight.model.firmware_upgrade_status_list import FirmwareUpgradeStatusList
    from intersight.model.forecast_catalog_list import ForecastCatalogList
    from intersight.model.forecast_definition_list import ForecastDefinitionList
    from intersight.model.forecast_instance_list import ForecastInstanceList
    from intersight.model.graphics_card_list import GraphicsCardList
    from intersight.model.graphics_controller_list import GraphicsControllerList
    from intersight.model.hcl_driver_image_list import HclDriverImageList
    from intersight.model.hcl_exempted_catalog_list import HclExemptedCatalogList
    from intersight.model.hcl_hyperflex_software_compatibility_info_list import HclHyperflexSoftwareCompatibilityInfoList
    from intersight.model.hcl_operating_system_list import HclOperatingSystemList
    from intersight.model.hcl_operating_system_vendor_list import HclOperatingSystemVendorList
    from intersight.model.hyperflex_alarm_list import HyperflexAlarmList
    from intersight.model.hyperflex_app_catalog_list import HyperflexAppCatalogList
    from intersight.model.hyperflex_auto_support_policy_list import HyperflexAutoSupportPolicyList
    from intersight.model.hyperflex_backup_cluster_list import HyperflexBackupClusterList
    from intersight.model.hyperflex_capability_info_list import HyperflexCapabilityInfoList
    from intersight.model.hyperflex_cluster_backup_policy_deployment_list import HyperflexClusterBackupPolicyDeploymentList
    from intersight.model.hyperflex_cluster_backup_policy_inventory_list import HyperflexClusterBackupPolicyInventoryList
    from intersight.model.hyperflex_cluster_backup_policy_list import HyperflexClusterBackupPolicyList
    from intersight.model.hyperflex_cluster_health_check_execution_snapshot_list import HyperflexClusterHealthCheckExecutionSnapshotList
    from intersight.model.hyperflex_cluster_list import HyperflexClusterList
    from intersight.model.hyperflex_cluster_network_policy_list import HyperflexClusterNetworkPolicyList
    from intersight.model.hyperflex_cluster_profile_list import HyperflexClusterProfileList
    from intersight.model.hyperflex_cluster_replication_network_policy_deployment_list import HyperflexClusterReplicationNetworkPolicyDeploymentList
    from intersight.model.hyperflex_cluster_replication_network_policy_list import HyperflexClusterReplicationNetworkPolicyList
    from intersight.model.hyperflex_cluster_storage_policy_list import HyperflexClusterStoragePolicyList
    from intersight.model.hyperflex_config_result_entry_list import HyperflexConfigResultEntryList
    from intersight.model.hyperflex_config_result_list import HyperflexConfigResultList
    from intersight.model.hyperflex_data_protection_peer_list import HyperflexDataProtectionPeerList
    from intersight.model.hyperflex_datastore_statistic_list import HyperflexDatastoreStatisticList
    from intersight.model.hyperflex_device_package_download_state_list import HyperflexDevicePackageDownloadStateList
    from intersight.model.hyperflex_drive_list import HyperflexDriveList
    from intersight.model.hyperflex_encryption_list import HyperflexEncryptionList
    from intersight.model.hyperflex_ext_fc_storage_policy_list import HyperflexExtFcStoragePolicyList
    from intersight.model.hyperflex_ext_iscsi_storage_policy_list import HyperflexExtIscsiStoragePolicyList
    from intersight.model.hyperflex_feature_limit_external_list import HyperflexFeatureLimitExternalList
    from intersight.model.hyperflex_feature_limit_internal_list import HyperflexFeatureLimitInternalList
    from intersight.model.hyperflex_health_check_definition_list import HyperflexHealthCheckDefinitionList
    from intersight.model.hyperflex_health_check_execution_list import HyperflexHealthCheckExecutionList
    from intersight.model.hyperflex_health_check_execution_snapshot_list import HyperflexHealthCheckExecutionSnapshotList
    from intersight.model.hyperflex_health_check_package_checksum_list import HyperflexHealthCheckPackageChecksumList
    from intersight.model.hyperflex_health_list import HyperflexHealthList
    from intersight.model.hyperflex_hxdp_version_list import HyperflexHxdpVersionList
    from intersight.model.hyperflex_hypervisor_host_list import HyperflexHypervisorHostList
    from intersight.model.hyperflex_hypervisor_virtual_machine_list import HyperflexHypervisorVirtualMachineList
    from intersight.model.hyperflex_key_encryption_key_list import HyperflexKeyEncryptionKeyList
    from intersight.model.hyperflex_license_list import HyperflexLicenseList
    from intersight.model.hyperflex_local_credential_policy_list import HyperflexLocalCredentialPolicyList
    from intersight.model.hyperflex_node_config_policy_list import HyperflexNodeConfigPolicyList
    from intersight.model.hyperflex_node_list import HyperflexNodeList
    from intersight.model.hyperflex_node_profile_list import HyperflexNodeProfileList
    from intersight.model.hyperflex_protected_cluster_list import HyperflexProtectedClusterList
    from intersight.model.hyperflex_proxy_setting_policy_list import HyperflexProxySettingPolicyList
    from intersight.model.hyperflex_server_firmware_version_entry_list import HyperflexServerFirmwareVersionEntryList
    from intersight.model.hyperflex_server_firmware_version_list import HyperflexServerFirmwareVersionList
    from intersight.model.hyperflex_server_model_list import HyperflexServerModelList
    from intersight.model.hyperflex_service_auth_token_list import HyperflexServiceAuthTokenList
    from intersight.model.hyperflex_software_distribution_component_list import HyperflexSoftwareDistributionComponentList
    from intersight.model.hyperflex_software_distribution_entry_list import HyperflexSoftwareDistributionEntryList
    from intersight.model.hyperflex_software_distribution_version_list import HyperflexSoftwareDistributionVersionList
    from intersight.model.hyperflex_software_version_policy_list import HyperflexSoftwareVersionPolicyList
    from intersight.model.hyperflex_storage_container_list import HyperflexStorageContainerList
    from intersight.model.hyperflex_sys_config_policy_list import HyperflexSysConfigPolicyList
    from intersight.model.hyperflex_ucsm_config_policy_list import HyperflexUcsmConfigPolicyList
    from intersight.model.hyperflex_vcenter_config_policy_list import HyperflexVcenterConfigPolicyList
    from intersight.model.hyperflex_vm_backup_info_list import HyperflexVmBackupInfoList
    from intersight.model.hyperflex_vm_import_operation_list import HyperflexVmImportOperationList
    from intersight.model.hyperflex_vm_restore_operation_list import HyperflexVmRestoreOperationList
    from intersight.model.hyperflex_vm_snapshot_info_list import HyperflexVmSnapshotInfoList
    from intersight.model.hyperflex_volume_list import HyperflexVolumeList
    from intersight.model.hyperflex_witness_configuration_list import HyperflexWitnessConfigurationList
    from intersight.model.iaas_connector_pack_list import IaasConnectorPackList
    from intersight.model.iaas_device_status_list import IaasDeviceStatusList
    from intersight.model.iaas_diagnostic_messages_list import IaasDiagnosticMessagesList
    from intersight.model.iaas_license_info_list import IaasLicenseInfoList
    from intersight.model.iaas_most_run_tasks_list import IaasMostRunTasksList
    from intersight.model.iaas_service_request_list import IaasServiceRequestList
    from intersight.model.iaas_ucsd_info_list import IaasUcsdInfoList
    from intersight.model.iaas_ucsd_managed_infra_list import IaasUcsdManagedInfraList
    from intersight.model.iaas_ucsd_messages_list import IaasUcsdMessagesList
    from intersight.model.iam_account_experience_list import IamAccountExperienceList
    from intersight.model.iam_account_list import IamAccountList
    from intersight.model.iam_api_key_list import IamApiKeyList
    from intersight.model.iam_app_registration_list import IamAppRegistrationList
    from intersight.model.iam_banner_message_list import IamBannerMessageList
    from intersight.model.iam_certificate_list import IamCertificateList
    from intersight.model.iam_certificate_request_list import IamCertificateRequestList
    from intersight.model.iam_domain_group_list import IamDomainGroupList
    from intersight.model.iam_end_point_privilege_list import IamEndPointPrivilegeList
    from intersight.model.iam_end_point_role_list import IamEndPointRoleList
    from intersight.model.iam_end_point_user_list import IamEndPointUserList
    from intersight.model.iam_end_point_user_policy_list import IamEndPointUserPolicyList
    from intersight.model.iam_end_point_user_role_list import IamEndPointUserRoleList
    from intersight.model.iam_idp_list import IamIdpList
    from intersight.model.iam_idp_reference_list import IamIdpReferenceList
    from intersight.model.iam_ip_access_management_list import IamIpAccessManagementList
    from intersight.model.iam_ip_address_list import IamIpAddressList
    from intersight.model.iam_ldap_group_list import IamLdapGroupList
    from intersight.model.iam_ldap_policy_list import IamLdapPolicyList
    from intersight.model.iam_ldap_provider_list import IamLdapProviderList
    from intersight.model.iam_local_user_password_policy_list import IamLocalUserPasswordPolicyList
    from intersight.model.iam_o_auth_token_list import IamOAuthTokenList
    from intersight.model.iam_permission_list import IamPermissionList
    from intersight.model.iam_private_key_spec_list import IamPrivateKeySpecList
    from intersight.model.iam_privilege_list import IamPrivilegeList
    from intersight.model.iam_privilege_set_list import IamPrivilegeSetList
    from intersight.model.iam_qualifier_list import IamQualifierList
    from intersight.model.iam_resource_limits_list import IamResourceLimitsList
    from intersight.model.iam_resource_permission_list import IamResourcePermissionList
    from intersight.model.iam_resource_roles_list import IamResourceRolesList
    from intersight.model.iam_role_list import IamRoleList
    from intersight.model.iam_security_holder_list import IamSecurityHolderList
    from intersight.model.iam_service_provider_list import IamServiceProviderList
    from intersight.model.iam_session_limits_list import IamSessionLimitsList
    from intersight.model.iam_session_list import IamSessionList
    from intersight.model.iam_system_list import IamSystemList
    from intersight.model.iam_trust_point_list import IamTrustPointList
    from intersight.model.iam_user_group_list import IamUserGroupList
    from intersight.model.iam_user_list import IamUserList
    from intersight.model.iam_user_preference_list import IamUserPreferenceList
    from intersight.model.inventory_device_info_list import InventoryDeviceInfoList
    from intersight.model.inventory_dn_mo_binding_list import InventoryDnMoBindingList
    from intersight.model.inventory_generic_inventory_holder_list import InventoryGenericInventoryHolderList
    from intersight.model.inventory_generic_inventory_list import InventoryGenericInventoryList
    from intersight.model.ipmioverlan_policy_list import IpmioverlanPolicyList
    from intersight.model.ippool_block_lease_list import IppoolBlockLeaseList
    from intersight.model.ippool_ip_lease_list import IppoolIpLeaseList
    from intersight.model.ippool_pool_list import IppoolPoolList
    from intersight.model.ippool_pool_member_list import IppoolPoolMemberList
    from intersight.model.ippool_shadow_block_list import IppoolShadowBlockList
    from intersight.model.ippool_shadow_pool_list import IppoolShadowPoolList
    from intersight.model.ippool_universe_list import IppoolUniverseList
    from intersight.model.iqnpool_block_list import IqnpoolBlockList
    from intersight.model.iqnpool_lease_list import IqnpoolLeaseList
    from intersight.model.iqnpool_pool_list import IqnpoolPoolList
    from intersight.model.iqnpool_pool_member_list import IqnpoolPoolMemberList
    from intersight.model.iqnpool_universe_list import IqnpoolUniverseList
    from intersight.model.iwotenant_tenant_status_list import IwotenantTenantStatusList
    from intersight.model.kubernetes_aci_cni_apic_list import KubernetesAciCniApicList
    from intersight.model.kubernetes_aci_cni_profile_list import KubernetesAciCniProfileList
    from intersight.model.kubernetes_aci_cni_tenant_cluster_allocation_list import KubernetesAciCniTenantClusterAllocationList
    from intersight.model.kubernetes_addon_definition_list import KubernetesAddonDefinitionList
    from intersight.model.kubernetes_addon_policy_list import KubernetesAddonPolicyList
    from intersight.model.kubernetes_addon_repository_list import KubernetesAddonRepositoryList
    from intersight.model.kubernetes_baremetal_node_profile_list import KubernetesBaremetalNodeProfileList
    from intersight.model.kubernetes_catalog_list import KubernetesCatalogList
    from intersight.model.kubernetes_cluster_addon_profile_list import KubernetesClusterAddonProfileList
    from intersight.model.kubernetes_cluster_list import KubernetesClusterList
    from intersight.model.kubernetes_cluster_profile_list import KubernetesClusterProfileList
    from intersight.model.kubernetes_config_result_entry_list import KubernetesConfigResultEntryList
    from intersight.model.kubernetes_config_result_list import KubernetesConfigResultList
    from intersight.model.kubernetes_container_runtime_policy_list import KubernetesContainerRuntimePolicyList
    from intersight.model.kubernetes_daemon_set_list import KubernetesDaemonSetList
    from intersight.model.kubernetes_deployment_list import KubernetesDeploymentList
    from intersight.model.kubernetes_ingress_list import KubernetesIngressList
    from intersight.model.kubernetes_network_policy_list import KubernetesNetworkPolicyList
    from intersight.model.kubernetes_node_group_profile_list import KubernetesNodeGroupProfileList
    from intersight.model.kubernetes_node_list import KubernetesNodeList
    from intersight.model.kubernetes_pod_list import KubernetesPodList
    from intersight.model.kubernetes_service_list import KubernetesServiceList
    from intersight.model.kubernetes_stateful_set_list import KubernetesStatefulSetList
    from intersight.model.kubernetes_sys_config_policy_list import KubernetesSysConfigPolicyList
    from intersight.model.kubernetes_trusted_registries_policy_list import KubernetesTrustedRegistriesPolicyList
    from intersight.model.kubernetes_version_list import KubernetesVersionList
    from intersight.model.kubernetes_version_policy_list import KubernetesVersionPolicyList
    from intersight.model.kubernetes_virtual_machine_infra_config_policy_list import KubernetesVirtualMachineInfraConfigPolicyList
    from intersight.model.kubernetes_virtual_machine_infrastructure_provider_list import KubernetesVirtualMachineInfrastructureProviderList
    from intersight.model.kubernetes_virtual_machine_instance_type_list import KubernetesVirtualMachineInstanceTypeList
    from intersight.model.kubernetes_virtual_machine_node_profile_list import KubernetesVirtualMachineNodeProfileList
    from intersight.model.kvm_policy_list import KvmPolicyList
    from intersight.model.kvm_session_list import KvmSessionList
    from intersight.model.kvm_tunnel_list import KvmTunnelList
    from intersight.model.kvm_tunneled_kvm_policy_list import KvmTunneledKvmPolicyList
    from intersight.model.license_account_license_data_list import LicenseAccountLicenseDataList
    from intersight.model.license_customer_op_list import LicenseCustomerOpList
    from intersight.model.license_iks_customer_op_list import LicenseIksCustomerOpList
    from intersight.model.license_iks_license_count_list import LicenseIksLicenseCountList
    from intersight.model.license_iwo_customer_op_list import LicenseIwoCustomerOpList
    from intersight.model.license_iwo_license_count_list import LicenseIwoLicenseCountList
    from intersight.model.license_license_info_list import LicenseLicenseInfoList
    from intersight.model.license_license_reservation_op_list import LicenseLicenseReservationOpList
    from intersight.model.license_smartlicense_token_list import LicenseSmartlicenseTokenList
    from intersight.model.ls_service_profile_list import LsServiceProfileList
    from intersight.model.macpool_id_block_list import MacpoolIdBlockList
    from intersight.model.macpool_lease_list import MacpoolLeaseList
    from intersight.model.macpool_pool_list import MacpoolPoolList
    from intersight.model.macpool_pool_member_list import MacpoolPoolMemberList
    from intersight.model.macpool_universe_list import MacpoolUniverseList
    from intersight.model.management_controller_list import ManagementControllerList
    from intersight.model.management_entity_list import ManagementEntityList
    from intersight.model.management_interface_list import ManagementInterfaceList
    from intersight.model.memory_array_list import MemoryArrayList
    from intersight.model.memory_persistent_memory_config_result_list import MemoryPersistentMemoryConfigResultList
    from intersight.model.memory_persistent_memory_configuration_list import MemoryPersistentMemoryConfigurationList
    from intersight.model.memory_persistent_memory_namespace_config_result_list import MemoryPersistentMemoryNamespaceConfigResultList
    from intersight.model.memory_persistent_memory_namespace_list import MemoryPersistentMemoryNamespaceList
    from intersight.model.memory_persistent_memory_policy_list import MemoryPersistentMemoryPolicyList
    from intersight.model.memory_persistent_memory_region_list import MemoryPersistentMemoryRegionList
    from intersight.model.memory_persistent_memory_unit_list import MemoryPersistentMemoryUnitList
    from intersight.model.memory_unit_list import MemoryUnitList
    from intersight.model.meta_definition_list import MetaDefinitionList
    from intersight.model.mo_aggregate_transform import MoAggregateTransform
    from intersight.model.mo_document_count import MoDocumentCount
    from intersight.model.mo_tag_summary import MoTagSummary
    from intersight.model.network_element_list import NetworkElementList
    from intersight.model.network_element_summary_list import NetworkElementSummaryList
    from intersight.model.network_fc_zone_info_list import NetworkFcZoneInfoList
    from intersight.model.network_feature_control_list import NetworkFeatureControlList
    from intersight.model.network_interface_list_list import NetworkInterfaceListList
    from intersight.model.network_license_file_list import NetworkLicenseFileList
    from intersight.model.network_supervisor_card_list import NetworkSupervisorCardList
    from intersight.model.network_vlan_port_info_list import NetworkVlanPortInfoList
    from intersight.model.network_vrf_list import NetworkVrfList
    from intersight.model.networkconfig_policy_list import NetworkconfigPolicyList
    from intersight.model.niaapi_apic_cco_post_list import NiaapiApicCcoPostList
    from intersight.model.niaapi_apic_field_notice_list import NiaapiApicFieldNoticeList
    from intersight.model.niaapi_apic_hweol_list import NiaapiApicHweolList
    from intersight.model.niaapi_apic_latest_maintained_release_list import NiaapiApicLatestMaintainedReleaseList
    from intersight.model.niaapi_apic_release_recommend_list import NiaapiApicReleaseRecommendList
    from intersight.model.niaapi_apic_sweol_list import NiaapiApicSweolList
    from intersight.model.niaapi_dcnm_cco_post_list import NiaapiDcnmCcoPostList
    from intersight.model.niaapi_dcnm_field_notice_list import NiaapiDcnmFieldNoticeList
    from intersight.model.niaapi_dcnm_hweol_list import NiaapiDcnmHweolList
    from intersight.model.niaapi_dcnm_latest_maintained_release_list import NiaapiDcnmLatestMaintainedReleaseList
    from intersight.model.niaapi_dcnm_release_recommend_list import NiaapiDcnmReleaseRecommendList
    from intersight.model.niaapi_dcnm_sweol_list import NiaapiDcnmSweolList
    from intersight.model.niaapi_file_downloader_list import NiaapiFileDownloaderList
    from intersight.model.niaapi_nia_metadata_list import NiaapiNiaMetadataList
    from intersight.model.niaapi_nib_file_downloader_list import NiaapiNibFileDownloaderList
    from intersight.model.niaapi_nib_metadata_list import NiaapiNibMetadataList
    from intersight.model.niaapi_version_regex_list import NiaapiVersionRegexList
    from intersight.model.niatelemetry_aaa_ldap_provider_details_list import NiatelemetryAaaLdapProviderDetailsList
    from intersight.model.niatelemetry_aaa_radius_provider_details_list import NiatelemetryAaaRadiusProviderDetailsList
    from intersight.model.niatelemetry_aaa_tacacs_provider_details_list import NiatelemetryAaaTacacsProviderDetailsList
    from intersight.model.niatelemetry_apic_app_plugin_details_list import NiatelemetryApicAppPluginDetailsList
    from intersight.model.niatelemetry_apic_core_file_details_list import NiatelemetryApicCoreFileDetailsList
    from intersight.model.niatelemetry_apic_dbgexp_rs_export_dest_list import NiatelemetryApicDbgexpRsExportDestList
    from intersight.model.niatelemetry_apic_dbgexp_rs_ts_scheduler_list import NiatelemetryApicDbgexpRsTsSchedulerList
    from intersight.model.niatelemetry_apic_fan_details_list import NiatelemetryApicFanDetailsList
    from intersight.model.niatelemetry_apic_fex_details_list import NiatelemetryApicFexDetailsList
    from intersight.model.niatelemetry_apic_flash_details_list import NiatelemetryApicFlashDetailsList
    from intersight.model.niatelemetry_apic_ntp_auth_list import NiatelemetryApicNtpAuthList
    from intersight.model.niatelemetry_apic_psu_details_list import NiatelemetryApicPsuDetailsList
    from intersight.model.niatelemetry_apic_realm_details_list import NiatelemetryApicRealmDetailsList
    from intersight.model.niatelemetry_apic_snmp_client_grp_details_list import NiatelemetryApicSnmpClientGrpDetailsList
    from intersight.model.niatelemetry_apic_snmp_community_access_details_list import NiatelemetryApicSnmpCommunityAccessDetailsList
    from intersight.model.niatelemetry_apic_snmp_community_details_list import NiatelemetryApicSnmpCommunityDetailsList
    from intersight.model.niatelemetry_apic_snmp_trap_details_list import NiatelemetryApicSnmpTrapDetailsList
    from intersight.model.niatelemetry_apic_snmp_trap_fwd_server_details_list import NiatelemetryApicSnmpTrapFwdServerDetailsList
    from intersight.model.niatelemetry_apic_snmp_version_three_details_list import NiatelemetryApicSnmpVersionThreeDetailsList
    from intersight.model.niatelemetry_apic_sys_log_grp_list import NiatelemetryApicSysLogGrpList
    from intersight.model.niatelemetry_apic_sys_log_src_list import NiatelemetryApicSysLogSrcList
    from intersight.model.niatelemetry_apic_transceiver_details_list import NiatelemetryApicTransceiverDetailsList
    from intersight.model.niatelemetry_apic_ui_page_counts_list import NiatelemetryApicUiPageCountsList
    from intersight.model.niatelemetry_app_details_list import NiatelemetryAppDetailsList
    from intersight.model.niatelemetry_common_policies_list import NiatelemetryCommonPoliciesList
    from intersight.model.niatelemetry_dcnm_fan_details_list import NiatelemetryDcnmFanDetailsList
    from intersight.model.niatelemetry_dcnm_fex_details_list import NiatelemetryDcnmFexDetailsList
    from intersight.model.niatelemetry_dcnm_module_details_list import NiatelemetryDcnmModuleDetailsList
    from intersight.model.niatelemetry_dcnm_psu_details_list import NiatelemetryDcnmPsuDetailsList
    from intersight.model.niatelemetry_dcnm_transceiver_details_list import NiatelemetryDcnmTransceiverDetailsList
    from intersight.model.niatelemetry_epg_list import NiatelemetryEpgList
    from intersight.model.niatelemetry_fabric_module_details_list import NiatelemetryFabricModuleDetailsList
    from intersight.model.niatelemetry_fabric_node_control_details_list import NiatelemetryFabricNodeControlDetailsList
    from intersight.model.niatelemetry_fabric_pod_profile_list import NiatelemetryFabricPodProfileList
    from intersight.model.niatelemetry_fabric_pod_ss_list import NiatelemetryFabricPodSsList
    from intersight.model.niatelemetry_fault_list import NiatelemetryFaultList
    from intersight.model.niatelemetry_https_acl_contract_details_list import NiatelemetryHttpsAclContractDetailsList
    from intersight.model.niatelemetry_https_acl_contract_filter_map_list import NiatelemetryHttpsAclContractFilterMapList
    from intersight.model.niatelemetry_https_acl_epg_contract_map_list import NiatelemetryHttpsAclEpgContractMapList
    from intersight.model.niatelemetry_https_acl_epg_details_list import NiatelemetryHttpsAclEpgDetailsList
    from intersight.model.niatelemetry_https_acl_filter_details_list import NiatelemetryHttpsAclFilterDetailsList
    from intersight.model.niatelemetry_insight_group_details_list import NiatelemetryInsightGroupDetailsList
    from intersight.model.niatelemetry_lc_list import NiatelemetryLcList
    from intersight.model.niatelemetry_leaf_pol_grp_details_list import NiatelemetryLeafPolGrpDetailsList
    from intersight.model.niatelemetry_mso_contract_details_list import NiatelemetryMsoContractDetailsList
    from intersight.model.niatelemetry_mso_epg_details_list import NiatelemetryMsoEpgDetailsList
    from intersight.model.niatelemetry_mso_schema_details_list import NiatelemetryMsoSchemaDetailsList
    from intersight.model.niatelemetry_mso_site_details_list import NiatelemetryMsoSiteDetailsList
    from intersight.model.niatelemetry_mso_tenant_details_list import NiatelemetryMsoTenantDetailsList
    from intersight.model.niatelemetry_nexus_dashboard_controller_details_list import NiatelemetryNexusDashboardControllerDetailsList
    from intersight.model.niatelemetry_nexus_dashboard_details_list import NiatelemetryNexusDashboardDetailsList
    from intersight.model.niatelemetry_nexus_dashboard_memory_details_list import NiatelemetryNexusDashboardMemoryDetailsList
    from intersight.model.niatelemetry_nexus_dashboards_list import NiatelemetryNexusDashboardsList
    from intersight.model.niatelemetry_nia_feature_usage_list import NiatelemetryNiaFeatureUsageList
    from intersight.model.niatelemetry_nia_inventory_dcnm_list import NiatelemetryNiaInventoryDcnmList
    from intersight.model.niatelemetry_nia_inventory_fabric_list import NiatelemetryNiaInventoryFabricList
    from intersight.model.niatelemetry_nia_inventory_list import NiatelemetryNiaInventoryList
    from intersight.model.niatelemetry_nia_license_state_list import NiatelemetryNiaLicenseStateList
    from intersight.model.niatelemetry_password_strength_check_list import NiatelemetryPasswordStrengthCheckList
    from intersight.model.niatelemetry_pod_comm_policies_list import NiatelemetryPodCommPoliciesList
    from intersight.model.niatelemetry_pod_snmp_policies_list import NiatelemetryPodSnmpPoliciesList
    from intersight.model.niatelemetry_pod_time_server_policies_list import NiatelemetryPodTimeServerPoliciesList
    from intersight.model.niatelemetry_site_inventory_list import NiatelemetrySiteInventoryList
    from intersight.model.niatelemetry_snmp_src_list import NiatelemetrySnmpSrcList
    from intersight.model.niatelemetry_spine_pol_grp_details_list import NiatelemetrySpinePolGrpDetailsList
    from intersight.model.niatelemetry_ssh_version_two_list import NiatelemetrySshVersionTwoList
    from intersight.model.niatelemetry_supervisor_module_details_list import NiatelemetrySupervisorModuleDetailsList
    from intersight.model.niatelemetry_syslog_remote_dest_list import NiatelemetrySyslogRemoteDestList
    from intersight.model.niatelemetry_syslog_sys_msg_fac_filter_list import NiatelemetrySyslogSysMsgFacFilterList
    from intersight.model.niatelemetry_syslog_sys_msg_list import NiatelemetrySyslogSysMsgList
    from intersight.model.niatelemetry_system_controller_details_list import NiatelemetrySystemControllerDetailsList
    from intersight.model.niatelemetry_tenant_list import NiatelemetryTenantList
    from intersight.model.notification_account_subscription_list import NotificationAccountSubscriptionList
    from intersight.model.ntp_policy_list import NtpPolicyList
    from intersight.model.oauth_access_token_list import OauthAccessTokenList
    from intersight.model.oauth_authorization_list import OauthAuthorizationList
    from intersight.model.oprs_deployment_list import OprsDeploymentList
    from intersight.model.oprs_sync_target_list_message_list import OprsSyncTargetListMessageList
    from intersight.model.organization_organization_list import OrganizationOrganizationList
    from intersight.model.os_bulk_install_info_list import OsBulkInstallInfoList
    from intersight.model.os_catalog_list import OsCatalogList
    from intersight.model.os_configuration_file_list import OsConfigurationFileList
    from intersight.model.os_distribution_list import OsDistributionList
    from intersight.model.os_install_list import OsInstallList
    from intersight.model.os_supported_version_list import OsSupportedVersionList
    from intersight.model.pci_coprocessor_card_list import PciCoprocessorCardList
    from intersight.model.pci_device_list import PciDeviceList
    from intersight.model.pci_link_list import PciLinkList
    from intersight.model.pci_switch_list import PciSwitchList
    from intersight.model.port_group_list import PortGroupList
    from intersight.model.port_mac_binding_list import PortMacBindingList
    from intersight.model.port_sub_group_list import PortSubGroupList
    from intersight.model.power_control_state_list import PowerControlStateList
    from intersight.model.power_policy_list import PowerPolicyList
    from intersight.model.processor_unit_list import ProcessorUnitList
    from intersight.model.rack_unit_personality_list import RackUnitPersonalityList
    from intersight.model.recommendation_capacity_runway_list import RecommendationCapacityRunwayList
    from intersight.model.recommendation_physical_item_list import RecommendationPhysicalItemList
    from intersight.model.recovery_backup_config_policy_list import RecoveryBackupConfigPolicyList
    from intersight.model.recovery_backup_profile_list import RecoveryBackupProfileList
    from intersight.model.recovery_config_result_entry_list import RecoveryConfigResultEntryList
    from intersight.model.recovery_config_result_list import RecoveryConfigResultList
    from intersight.model.recovery_on_demand_backup_list import RecoveryOnDemandBackupList
    from intersight.model.recovery_restore_list import RecoveryRestoreList
    from intersight.model.recovery_schedule_config_policy_list import RecoveryScheduleConfigPolicyList
    from intersight.model.resource_group_list import ResourceGroupList
    from intersight.model.resource_group_member_list import ResourceGroupMemberList
    from intersight.model.resource_license_resource_count_list import ResourceLicenseResourceCountList
    from intersight.model.resource_membership_holder_list import ResourceMembershipHolderList
    from intersight.model.resource_membership_list import ResourceMembershipList
    from intersight.model.resource_reservation_list import ResourceReservationList
    from intersight.model.resourcepool_lease_list import ResourcepoolLeaseList
    from intersight.model.resourcepool_lease_resource_list import ResourcepoolLeaseResourceList
    from intersight.model.resourcepool_pool_list import ResourcepoolPoolList
    from intersight.model.resourcepool_pool_member_list import ResourcepoolPoolMemberList
    from intersight.model.resourcepool_universe_list import ResourcepoolUniverseList
    from intersight.model.sdcard_policy_list import SdcardPolicyList
    from intersight.model.search_search_item_list import SearchSearchItemList
    from intersight.model.search_suggest_item_list import SearchSuggestItemList
    from intersight.model.search_tag_item_list import SearchTagItemList
    from intersight.model.security_unit_list import SecurityUnitList
    from intersight.model.server_config_change_detail_list import ServerConfigChangeDetailList
    from intersight.model.server_config_import_list import ServerConfigImportList
    from intersight.model.server_config_result_entry_list import ServerConfigResultEntryList
    from intersight.model.server_config_result_list import ServerConfigResultList
    from intersight.model.server_profile_list import ServerProfileList
    from intersight.model.server_profile_template_list import ServerProfileTemplateList
    from intersight.model.smtp_policy_list import SmtpPolicyList
    from intersight.model.snmp_policy_list import SnmpPolicyList
    from intersight.model.software_appliance_distributable_list import SoftwareApplianceDistributableList
    from intersight.model.software_download_history_list import SoftwareDownloadHistoryList
    from intersight.model.software_hcl_meta_list import SoftwareHclMetaList
    from intersight.model.software_hyperflex_bundle_distributable_list import SoftwareHyperflexBundleDistributableList
    from intersight.model.software_hyperflex_distributable_list import SoftwareHyperflexDistributableList
    from intersight.model.software_release_meta_list import SoftwareReleaseMetaList
    from intersight.model.software_solution_distributable_list import SoftwareSolutionDistributableList
    from intersight.model.software_ucsd_bundle_distributable_list import SoftwareUcsdBundleDistributableList
    from intersight.model.software_ucsd_distributable_list import SoftwareUcsdDistributableList
    from intersight.model.softwarerepository_authorization_list import SoftwarerepositoryAuthorizationList
    from intersight.model.softwarerepository_cached_image_list import SoftwarerepositoryCachedImageList
    from intersight.model.softwarerepository_catalog_list import SoftwarerepositoryCatalogList
    from intersight.model.softwarerepository_category_mapper_list import SoftwarerepositoryCategoryMapperList
    from intersight.model.softwarerepository_category_mapper_model_list import SoftwarerepositoryCategoryMapperModelList
    from intersight.model.softwarerepository_category_support_constraint_list import SoftwarerepositoryCategorySupportConstraintList
    from intersight.model.softwarerepository_download_spec_list import SoftwarerepositoryDownloadSpecList
    from intersight.model.softwarerepository_operating_system_file_list import SoftwarerepositoryOperatingSystemFileList
    from intersight.model.softwarerepository_release_list import SoftwarerepositoryReleaseList
    from intersight.model.sol_policy_list import SolPolicyList
    from intersight.model.ssh_policy_list import SshPolicyList
    from intersight.model.storage_controller_list import StorageControllerList
    from intersight.model.storage_disk_group_list import StorageDiskGroupList
    from intersight.model.storage_disk_slot_list import StorageDiskSlotList
    from intersight.model.storage_drive_group_list import StorageDriveGroupList
    from intersight.model.storage_enclosure_disk_list import StorageEnclosureDiskList
    from intersight.model.storage_enclosure_disk_slot_ep_list import StorageEnclosureDiskSlotEpList
    from intersight.model.storage_enclosure_list import StorageEnclosureList
    from intersight.model.storage_flex_flash_controller_list import StorageFlexFlashControllerList
    from intersight.model.storage_flex_flash_controller_props_list import StorageFlexFlashControllerPropsList
    from intersight.model.storage_flex_flash_physical_drive_list import StorageFlexFlashPhysicalDriveList
    from intersight.model.storage_flex_flash_virtual_drive_list import StorageFlexFlashVirtualDriveList
    from intersight.model.storage_flex_util_controller_list import StorageFlexUtilControllerList
    from intersight.model.storage_flex_util_physical_drive_list import StorageFlexUtilPhysicalDriveList
    from intersight.model.storage_flex_util_virtual_drive_list import StorageFlexUtilVirtualDriveList
    from intersight.model.storage_hitachi_array_list import StorageHitachiArrayList
    from intersight.model.storage_hitachi_controller_list import StorageHitachiControllerList
    from intersight.model.storage_hitachi_disk_list import StorageHitachiDiskList
    from intersight.model.storage_hitachi_host_list import StorageHitachiHostList
    from intersight.model.storage_hitachi_host_lun_list import StorageHitachiHostLunList
    from intersight.model.storage_hitachi_parity_group_list import StorageHitachiParityGroupList
    from intersight.model.storage_hitachi_pool_list import StorageHitachiPoolList
    from intersight.model.storage_hitachi_port_list import StorageHitachiPortList
    from intersight.model.storage_hitachi_volume_list import StorageHitachiVolumeList
    from intersight.model.storage_hyper_flex_storage_container_list import StorageHyperFlexStorageContainerList
    from intersight.model.storage_hyper_flex_volume_list import StorageHyperFlexVolumeList
    from intersight.model.storage_item_list import StorageItemList
    from intersight.model.storage_net_app_aggregate_event_list import StorageNetAppAggregateEventList
    from intersight.model.storage_net_app_aggregate_list import StorageNetAppAggregateList
    from intersight.model.storage_net_app_base_disk_list import StorageNetAppBaseDiskList
    from intersight.model.storage_net_app_cluster_event_list import StorageNetAppClusterEventList
    from intersight.model.storage_net_app_cluster_list import StorageNetAppClusterList
    from intersight.model.storage_net_app_disk_event_list import StorageNetAppDiskEventList
    from intersight.model.storage_net_app_ethernet_port_event_list import StorageNetAppEthernetPortEventList
    from intersight.model.storage_net_app_ethernet_port_list import StorageNetAppEthernetPortList
    from intersight.model.storage_net_app_export_policy_list import StorageNetAppExportPolicyList
    from intersight.model.storage_net_app_fc_interface_event_list import StorageNetAppFcInterfaceEventList
    from intersight.model.storage_net_app_fc_interface_list import StorageNetAppFcInterfaceList
    from intersight.model.storage_net_app_fc_port_event_list import StorageNetAppFcPortEventList
    from intersight.model.storage_net_app_fc_port_list import StorageNetAppFcPortList
    from intersight.model.storage_net_app_initiator_group_list import StorageNetAppInitiatorGroupList
    from intersight.model.storage_net_app_ip_interface_event_list import StorageNetAppIpInterfaceEventList
    from intersight.model.storage_net_app_ip_interface_list import StorageNetAppIpInterfaceList
    from intersight.model.storage_net_app_license_list import StorageNetAppLicenseList
    from intersight.model.storage_net_app_lun_event_list import StorageNetAppLunEventList
    from intersight.model.storage_net_app_lun_list import StorageNetAppLunList
    from intersight.model.storage_net_app_lun_map_list import StorageNetAppLunMapList
    from intersight.model.storage_net_app_node_event_list import StorageNetAppNodeEventList
    from intersight.model.storage_net_app_node_list import StorageNetAppNodeList
    from intersight.model.storage_net_app_ntp_server_list import StorageNetAppNtpServerList
    from intersight.model.storage_net_app_sensor_list import StorageNetAppSensorList
    from intersight.model.storage_net_app_storage_vm_list import StorageNetAppStorageVmList
    from intersight.model.storage_net_app_svm_event_list import StorageNetAppSvmEventList
    from intersight.model.storage_net_app_volume_event_list import StorageNetAppVolumeEventList
    from intersight.model.storage_net_app_volume_list import StorageNetAppVolumeList
    from intersight.model.storage_net_app_volume_snapshot_list import StorageNetAppVolumeSnapshotList
    from intersight.model.storage_physical_disk_extension_list import StoragePhysicalDiskExtensionList
    from intersight.model.storage_physical_disk_list import StoragePhysicalDiskList
    from intersight.model.storage_physical_disk_usage_list import StoragePhysicalDiskUsageList
    from intersight.model.storage_pure_array_list import StoragePureArrayList
    from intersight.model.storage_pure_controller_list import StoragePureControllerList
    from intersight.model.storage_pure_disk_list import StoragePureDiskList
    from intersight.model.storage_pure_host_group_list import StoragePureHostGroupList
    from intersight.model.storage_pure_host_list import StoragePureHostList
    from intersight.model.storage_pure_host_lun_list import StoragePureHostLunList
    from intersight.model.storage_pure_port_list import StoragePurePortList
    from intersight.model.storage_pure_protection_group_list import StoragePureProtectionGroupList
    from intersight.model.storage_pure_protection_group_snapshot_list import StoragePureProtectionGroupSnapshotList
    from intersight.model.storage_pure_replication_schedule_list import StoragePureReplicationScheduleList
    from intersight.model.storage_pure_snapshot_schedule_list import StoragePureSnapshotScheduleList
    from intersight.model.storage_pure_volume_list import StoragePureVolumeList
    from intersight.model.storage_pure_volume_snapshot_list import StoragePureVolumeSnapshotList
    from intersight.model.storage_sas_expander_list import StorageSasExpanderList
    from intersight.model.storage_sas_port_list import StorageSasPortList
    from intersight.model.storage_span_list import StorageSpanList
    from intersight.model.storage_storage_policy_list import StorageStoragePolicyList
    from intersight.model.storage_vd_member_ep_list import StorageVdMemberEpList
    from intersight.model.storage_virtual_drive_container_list import StorageVirtualDriveContainerList
    from intersight.model.storage_virtual_drive_extension_list import StorageVirtualDriveExtensionList
    from intersight.model.storage_virtual_drive_identity_list import StorageVirtualDriveIdentityList
    from intersight.model.storage_virtual_drive_list import StorageVirtualDriveList
    from intersight.model.syslog_policy_list import SyslogPolicyList
    from intersight.model.tam_advisory_count_list import TamAdvisoryCountList
    from intersight.model.tam_advisory_definition_list import TamAdvisoryDefinitionList
    from intersight.model.tam_advisory_info_list import TamAdvisoryInfoList
    from intersight.model.tam_advisory_instance_list import TamAdvisoryInstanceList
    from intersight.model.tam_security_advisory_list import TamSecurityAdvisoryList
    from intersight.model.techsupportmanagement_collection_control_policy_list import TechsupportmanagementCollectionControlPolicyList
    from intersight.model.techsupportmanagement_download_list import TechsupportmanagementDownloadList
    from intersight.model.techsupportmanagement_tech_support_bundle_list import TechsupportmanagementTechSupportBundleList
    from intersight.model.techsupportmanagement_tech_support_status_list import TechsupportmanagementTechSupportStatusList
    from intersight.model.terminal_audit_log_list import TerminalAuditLogList
    from intersight.model.terraform_executor_list import TerraformExecutorList
    from intersight.model.thermal_policy_list import ThermalPolicyList
    from intersight.model.top_system_list import TopSystemList
    from intersight.model.ucsd_backup_info_list import UcsdBackupInfoList
    from intersight.model.uuidpool_block_list import UuidpoolBlockList
    from intersight.model.uuidpool_pool_list import UuidpoolPoolList
    from intersight.model.uuidpool_pool_member_list import UuidpoolPoolMemberList
    from intersight.model.uuidpool_universe_list import UuidpoolUniverseList
    from intersight.model.uuidpool_uuid_lease_list import UuidpoolUuidLeaseList
    from intersight.model.view_server_list import ViewServerList
    from intersight.model.virtualization_cisco_hypervisor_manager_list import VirtualizationCiscoHypervisorManagerList
    from intersight.model.virtualization_esxi_console_list import VirtualizationEsxiConsoleList
    from intersight.model.virtualization_host_list import VirtualizationHostList
    from intersight.model.virtualization_iwe_cluster_list import VirtualizationIweClusterList
    from intersight.model.virtualization_iwe_datacenter_list import VirtualizationIweDatacenterList
    from intersight.model.virtualization_iwe_dv_uplink_list import VirtualizationIweDvUplinkList
    from intersight.model.virtualization_iwe_dvswitch_list import VirtualizationIweDvswitchList
    from intersight.model.virtualization_iwe_host_interface_list import VirtualizationIweHostInterfaceList
    from intersight.model.virtualization_iwe_host_list import VirtualizationIweHostList
    from intersight.model.virtualization_iwe_host_vswitch_list import VirtualizationIweHostVswitchList
    from intersight.model.virtualization_iwe_network_list import VirtualizationIweNetworkList
    from intersight.model.virtualization_iwe_virtual_disk_list import VirtualizationIweVirtualDiskList
    from intersight.model.virtualization_iwe_virtual_machine_list import VirtualizationIweVirtualMachineList
    from intersight.model.virtualization_iwe_virtual_machine_network_interface_list import VirtualizationIweVirtualMachineNetworkInterfaceList
    from intersight.model.virtualization_virtual_disk_list import VirtualizationVirtualDiskList
    from intersight.model.virtualization_virtual_machine_list import VirtualizationVirtualMachineList
    from intersight.model.virtualization_virtual_network_list import VirtualizationVirtualNetworkList
    from intersight.model.virtualization_vmware_cluster_list import VirtualizationVmwareClusterList
    from intersight.model.virtualization_vmware_datacenter_list import VirtualizationVmwareDatacenterList
    from intersight.model.virtualization_vmware_datastore_cluster_list import VirtualizationVmwareDatastoreClusterList
    from intersight.model.virtualization_vmware_datastore_list import VirtualizationVmwareDatastoreList
    from intersight.model.virtualization_vmware_distributed_network_list import VirtualizationVmwareDistributedNetworkList
    from intersight.model.virtualization_vmware_distributed_switch_list import VirtualizationVmwareDistributedSwitchList
    from intersight.model.virtualization_vmware_folder_list import VirtualizationVmwareFolderList
    from intersight.model.virtualization_vmware_host_list import VirtualizationVmwareHostList
    from intersight.model.virtualization_vmware_kernel_network_list import VirtualizationVmwareKernelNetworkList
    from intersight.model.virtualization_vmware_network_list import VirtualizationVmwareNetworkList
    from intersight.model.virtualization_vmware_physical_network_interface_list import VirtualizationVmwarePhysicalNetworkInterfaceList
    from intersight.model.virtualization_vmware_uplink_port_list import VirtualizationVmwareUplinkPortList
    from intersight.model.virtualization_vmware_vcenter_list import VirtualizationVmwareVcenterList
    from intersight.model.virtualization_vmware_virtual_disk_list import VirtualizationVmwareVirtualDiskList
    from intersight.model.virtualization_vmware_virtual_machine_list import VirtualizationVmwareVirtualMachineList
    from intersight.model.virtualization_vmware_virtual_machine_snapshot_list import VirtualizationVmwareVirtualMachineSnapshotList
    from intersight.model.virtualization_vmware_virtual_network_interface_list import VirtualizationVmwareVirtualNetworkInterfaceList
    from intersight.model.virtualization_vmware_virtual_switch_list import VirtualizationVmwareVirtualSwitchList
    from intersight.model.vmedia_policy_list import VmediaPolicyList
    from intersight.model.vmrc_console_list import VmrcConsoleList
    from intersight.model.vnc_console_list import VncConsoleList
    from intersight.model.vnic_eth_adapter_policy_list import VnicEthAdapterPolicyList
    from intersight.model.vnic_eth_if_list import VnicEthIfList
    from intersight.model.vnic_eth_network_policy_list import VnicEthNetworkPolicyList
    from intersight.model.vnic_eth_qos_policy_list import VnicEthQosPolicyList
    from intersight.model.vnic_fc_adapter_policy_list import VnicFcAdapterPolicyList
    from intersight.model.vnic_fc_if_list import VnicFcIfList
    from intersight.model.vnic_fc_network_policy_list import VnicFcNetworkPolicyList
    from intersight.model.vnic_fc_qos_policy_list import VnicFcQosPolicyList
    from intersight.model.vnic_iscsi_adapter_policy_list import VnicIscsiAdapterPolicyList
    from intersight.model.vnic_iscsi_boot_policy_list import VnicIscsiBootPolicyList
    from intersight.model.vnic_iscsi_static_target_policy_list import VnicIscsiStaticTargetPolicyList
    from intersight.model.vnic_lan_connectivity_policy_list import VnicLanConnectivityPolicyList
    from intersight.model.vnic_lcp_status_list import VnicLcpStatusList
    from intersight.model.vnic_san_connectivity_policy_list import VnicSanConnectivityPolicyList
    from intersight.model.vnic_scp_status_list import VnicScpStatusList
    from intersight.model.vrf_vrf_list import VrfVrfList
    from intersight.model.workflow_ansible_batch_executor_list import WorkflowAnsibleBatchExecutorList
    from intersight.model.workflow_batch_api_executor_list import WorkflowBatchApiExecutorList
    from intersight.model.workflow_build_task_meta_list import WorkflowBuildTaskMetaList
    from intersight.model.workflow_build_task_meta_owner_list import WorkflowBuildTaskMetaOwnerList
    from intersight.model.workflow_catalog_list import WorkflowCatalogList
    from intersight.model.workflow_custom_data_type_definition_list import WorkflowCustomDataTypeDefinitionList
    from intersight.model.workflow_error_response_handler_list import WorkflowErrorResponseHandlerList
    from intersight.model.workflow_pending_dynamic_workflow_info_list import WorkflowPendingDynamicWorkflowInfoList
    from intersight.model.workflow_rollback_workflow_list import WorkflowRollbackWorkflowList
    from intersight.model.workflow_service_item_action_definition_list import WorkflowServiceItemActionDefinitionList
    from intersight.model.workflow_service_item_action_instance_list import WorkflowServiceItemActionInstanceList
    from intersight.model.workflow_service_item_definition_list import WorkflowServiceItemDefinitionList
    from intersight.model.workflow_service_item_instance_list import WorkflowServiceItemInstanceList
    from intersight.model.workflow_service_item_output_list import WorkflowServiceItemOutputList
    from intersight.model.workflow_solution_action_definition_list import WorkflowSolutionActionDefinitionList
    from intersight.model.workflow_solution_action_instance_list import WorkflowSolutionActionInstanceList
    from intersight.model.workflow_solution_definition_list import WorkflowSolutionDefinitionList
    from intersight.model.workflow_solution_instance_list import WorkflowSolutionInstanceList
    from intersight.model.workflow_solution_output_list import WorkflowSolutionOutputList
    from intersight.model.workflow_ssh_batch_executor_list import WorkflowSshBatchExecutorList
    from intersight.model.workflow_task_debug_log_list import WorkflowTaskDebugLogList
    from intersight.model.workflow_task_definition_list import WorkflowTaskDefinitionList
    from intersight.model.workflow_task_info_list import WorkflowTaskInfoList
    from intersight.model.workflow_task_metadata_list import WorkflowTaskMetadataList
    from intersight.model.workflow_template_function_meta_list import WorkflowTemplateFunctionMetaList
    from intersight.model.workflow_workflow_definition_list import WorkflowWorkflowDefinitionList
    from intersight.model.workflow_workflow_info_list import WorkflowWorkflowInfoList
    from intersight.model.workflow_workflow_meta_list import WorkflowWorkflowMetaList
    from intersight.model.workflow_workflow_metadata_list import WorkflowWorkflowMetadataList
    globals()['AaaAuditRecordList'] = AaaAuditRecordList
    globals()['AaaRetentionConfigList'] = AaaRetentionConfigList
    globals()['AaaRetentionPolicyList'] = AaaRetentionPolicyList
    globals()['AccessPolicyList'] = AccessPolicyList
    globals()['AdapterConfigPolicyList'] = AdapterConfigPolicyList
    globals()['AdapterExtEthInterfaceList'] = AdapterExtEthInterfaceList
    globals()['AdapterHostEthInterfaceList'] = AdapterHostEthInterfaceList
    globals()['AdapterHostFcInterfaceList'] = AdapterHostFcInterfaceList
    globals()['AdapterHostIscsiInterfaceList'] = AdapterHostIscsiInterfaceList
    globals()['AdapterUnitExpanderList'] = AdapterUnitExpanderList
    globals()['AdapterUnitList'] = AdapterUnitList
    globals()['ApplianceAppStatusList'] = ApplianceAppStatusList
    globals()['ApplianceAutoRmaPolicyList'] = ApplianceAutoRmaPolicyList
    globals()['ApplianceBackupList'] = ApplianceBackupList
    globals()['ApplianceBackupPolicyList'] = ApplianceBackupPolicyList
    globals()['ApplianceCertificateSettingList'] = ApplianceCertificateSettingList
    globals()['ApplianceDataExportPolicyList'] = ApplianceDataExportPolicyList
    globals()['ApplianceDeviceCertificateList'] = ApplianceDeviceCertificateList
    globals()['ApplianceDeviceClaimList'] = ApplianceDeviceClaimList
    globals()['ApplianceDeviceUpgradePolicyList'] = ApplianceDeviceUpgradePolicyList
    globals()['ApplianceDiagSettingList'] = ApplianceDiagSettingList
    globals()['ApplianceExternalSyslogSettingList'] = ApplianceExternalSyslogSettingList
    globals()['ApplianceFileGatewayList'] = ApplianceFileGatewayList
    globals()['ApplianceFileSystemStatusList'] = ApplianceFileSystemStatusList
    globals()['ApplianceGroupStatusList'] = ApplianceGroupStatusList
    globals()['ApplianceImageBundleList'] = ApplianceImageBundleList
    globals()['ApplianceNodeInfoList'] = ApplianceNodeInfoList
    globals()['ApplianceNodeStatusList'] = ApplianceNodeStatusList
    globals()['ApplianceReleaseNoteList'] = ApplianceReleaseNoteList
    globals()['ApplianceRemoteFileImportList'] = ApplianceRemoteFileImportList
    globals()['ApplianceRestoreList'] = ApplianceRestoreList
    globals()['ApplianceSetupInfoList'] = ApplianceSetupInfoList
    globals()['ApplianceSystemInfoList'] = ApplianceSystemInfoList
    globals()['ApplianceSystemStatusList'] = ApplianceSystemStatusList
    globals()['ApplianceUpgradeList'] = ApplianceUpgradeList
    globals()['ApplianceUpgradePolicyList'] = ApplianceUpgradePolicyList
    globals()['AssetClusterMemberList'] = AssetClusterMemberList
    globals()['AssetDeploymentDeviceList'] = AssetDeploymentDeviceList
    globals()['AssetDeploymentList'] = AssetDeploymentList
    globals()['AssetDeviceConfigurationList'] = AssetDeviceConfigurationList
    globals()['AssetDeviceConnectorManagerList'] = AssetDeviceConnectorManagerList
    globals()['AssetDeviceContractInformationList'] = AssetDeviceContractInformationList
    globals()['AssetDeviceRegistrationList'] = AssetDeviceRegistrationList
    globals()['AssetSubscriptionAccountList'] = AssetSubscriptionAccountList
    globals()['AssetSubscriptionDeviceContractInformationList'] = AssetSubscriptionDeviceContractInformationList
    globals()['AssetSubscriptionList'] = AssetSubscriptionList
    globals()['AssetTargetList'] = AssetTargetList
    globals()['BiosBootDeviceList'] = BiosBootDeviceList
    globals()['BiosBootModeList'] = BiosBootModeList
    globals()['BiosPolicyList'] = BiosPolicyList
    globals()['BiosSystemBootOrderList'] = BiosSystemBootOrderList
    globals()['BiosTokenSettingsList'] = BiosTokenSettingsList
    globals()['BiosUnitList'] = BiosUnitList
    globals()['BiosVfSelectMemoryRasConfigurationList'] = BiosVfSelectMemoryRasConfigurationList
    globals()['BootCddDeviceList'] = BootCddDeviceList
    globals()['BootDeviceBootModeList'] = BootDeviceBootModeList
    globals()['BootDeviceBootSecurityList'] = BootDeviceBootSecurityList
    globals()['BootHddDeviceList'] = BootHddDeviceList
    globals()['BootIscsiDeviceList'] = BootIscsiDeviceList
    globals()['BootNvmeDeviceList'] = BootNvmeDeviceList
    globals()['BootPchStorageDeviceList'] = BootPchStorageDeviceList
    globals()['BootPrecisionPolicyList'] = BootPrecisionPolicyList
    globals()['BootPxeDeviceList'] = BootPxeDeviceList
    globals()['BootSanDeviceList'] = BootSanDeviceList
    globals()['BootSdDeviceList'] = BootSdDeviceList
    globals()['BootUefiShellDeviceList'] = BootUefiShellDeviceList
    globals()['BootUsbDeviceList'] = BootUsbDeviceList
    globals()['BootVmediaDeviceList'] = BootVmediaDeviceList
    globals()['BulkExportList'] = BulkExportList
    globals()['BulkExportedItemList'] = BulkExportedItemList
    globals()['BulkRequestList'] = BulkRequestList
    globals()['BulkSubRequestObjList'] = BulkSubRequestObjList
    globals()['CapabilityAdapterUnitDescriptorList'] = CapabilityAdapterUnitDescriptorList
    globals()['CapabilityCatalogList'] = CapabilityCatalogList
    globals()['CapabilityChassisDescriptorList'] = CapabilityChassisDescriptorList
    globals()['CapabilityChassisManufacturingDefList'] = CapabilityChassisManufacturingDefList
    globals()['CapabilityCimcFirmwareDescriptorList'] = CapabilityCimcFirmwareDescriptorList
    globals()['CapabilityEquipmentPhysicalDefList'] = CapabilityEquipmentPhysicalDefList
    globals()['CapabilityEquipmentSlotArrayList'] = CapabilityEquipmentSlotArrayList
    globals()['CapabilityFanModuleDescriptorList'] = CapabilityFanModuleDescriptorList
    globals()['CapabilityFanModuleManufacturingDefList'] = CapabilityFanModuleManufacturingDefList
    globals()['CapabilityFexDescriptorList'] = CapabilityFexDescriptorList
    globals()['CapabilityFexManufacturingDefList'] = CapabilityFexManufacturingDefList
    globals()['CapabilityIoCardCapabilityDefList'] = CapabilityIoCardCapabilityDefList
    globals()['CapabilityIoCardDescriptorList'] = CapabilityIoCardDescriptorList
    globals()['CapabilityIoCardManufacturingDefList'] = CapabilityIoCardManufacturingDefList
    globals()['CapabilityPortGroupAggregationDefList'] = CapabilityPortGroupAggregationDefList
    globals()['CapabilityPsuDescriptorList'] = CapabilityPsuDescriptorList
    globals()['CapabilityPsuManufacturingDefList'] = CapabilityPsuManufacturingDefList
    globals()['CapabilityServerModelsCapabilityDefList'] = CapabilityServerModelsCapabilityDefList
    globals()['CapabilityServerSchemaDescriptorList'] = CapabilityServerSchemaDescriptorList
    globals()['CapabilitySiocModuleCapabilityDefList'] = CapabilitySiocModuleCapabilityDefList
    globals()['CapabilitySiocModuleDescriptorList'] = CapabilitySiocModuleDescriptorList
    globals()['CapabilitySiocModuleManufacturingDefList'] = CapabilitySiocModuleManufacturingDefList
    globals()['CapabilitySwitchCapabilityList'] = CapabilitySwitchCapabilityList
    globals()['CapabilitySwitchDescriptorList'] = CapabilitySwitchDescriptorList
    globals()['CapabilitySwitchManufacturingDefList'] = CapabilitySwitchManufacturingDefList
    globals()['CertificatemanagementPolicyList'] = CertificatemanagementPolicyList
    globals()['ChassisConfigChangeDetailList'] = ChassisConfigChangeDetailList
    globals()['ChassisConfigImportList'] = ChassisConfigImportList
    globals()['ChassisConfigResultEntryList'] = ChassisConfigResultEntryList
    globals()['ChassisConfigResultList'] = ChassisConfigResultList
    globals()['ChassisIomProfileList'] = ChassisIomProfileList
    globals()['ChassisProfileList'] = ChassisProfileList
    globals()['CloudAwsBillingUnitList'] = CloudAwsBillingUnitList
    globals()['CloudAwsKeyPairList'] = CloudAwsKeyPairList
    globals()['CloudAwsNetworkInterfaceList'] = CloudAwsNetworkInterfaceList
    globals()['CloudAwsOrganizationalUnitList'] = CloudAwsOrganizationalUnitList
    globals()['CloudAwsSecurityGroupList'] = CloudAwsSecurityGroupList
    globals()['CloudAwsSubnetList'] = CloudAwsSubnetList
    globals()['CloudAwsVirtualMachineList'] = CloudAwsVirtualMachineList
    globals()['CloudAwsVolumeList'] = CloudAwsVolumeList
    globals()['CloudAwsVpcList'] = CloudAwsVpcList
    globals()['CloudRegionsList'] = CloudRegionsList
    globals()['CloudSkuContainerTypeList'] = CloudSkuContainerTypeList
    globals()['CloudSkuDatabaseTypeList'] = CloudSkuDatabaseTypeList
    globals()['CloudSkuInstanceTypeList'] = CloudSkuInstanceTypeList
    globals()['CloudSkuNetworkTypeList'] = CloudSkuNetworkTypeList
    globals()['CloudSkuRegionRateCardsList'] = CloudSkuRegionRateCardsList
    globals()['CloudSkuVolumeTypeList'] = CloudSkuVolumeTypeList
    globals()['CloudTfcAgentpoolList'] = CloudTfcAgentpoolList
    globals()['CloudTfcOrganizationList'] = CloudTfcOrganizationList
    globals()['CloudTfcWorkspaceList'] = CloudTfcWorkspaceList
    globals()['CommHttpProxyPolicyList'] = CommHttpProxyPolicyList
    globals()['ComputeBladeIdentityList'] = ComputeBladeIdentityList
    globals()['ComputeBladeList'] = ComputeBladeList
    globals()['ComputeBoardList'] = ComputeBoardList
    globals()['ComputeMappingList'] = ComputeMappingList
    globals()['ComputePhysicalSummaryList'] = ComputePhysicalSummaryList
    globals()['ComputeRackUnitIdentityList'] = ComputeRackUnitIdentityList
    globals()['ComputeRackUnitList'] = ComputeRackUnitList
    globals()['ComputeServerPowerPolicyList'] = ComputeServerPowerPolicyList
    globals()['ComputeServerSettingList'] = ComputeServerSettingList
    globals()['ComputeVmediaList'] = ComputeVmediaList
    globals()['CondAlarmAggregationList'] = CondAlarmAggregationList
    globals()['CondAlarmList'] = CondAlarmList
    globals()['CondHclStatusDetailList'] = CondHclStatusDetailList
    globals()['CondHclStatusJobList'] = CondHclStatusJobList
    globals()['CondHclStatusList'] = CondHclStatusList
    globals()['ConnectorpackConnectorPackUpgradeList'] = ConnectorpackConnectorPackUpgradeList
    globals()['ConnectorpackUpgradeImpactList'] = ConnectorpackUpgradeImpactList
    globals()['ConsoleConsoleConfigList'] = ConsoleConsoleConfigList
    globals()['ConvergedinfraHealthCheckDefinitionList'] = ConvergedinfraHealthCheckDefinitionList
    globals()['ConvergedinfraHealthCheckExecutionList'] = ConvergedinfraHealthCheckExecutionList
    globals()['ConvergedinfraPodList'] = ConvergedinfraPodList
    globals()['CrdCustomResourceList'] = CrdCustomResourceList
    globals()['DeviceconnectorPolicyList'] = DeviceconnectorPolicyList
    globals()['EquipmentChassisIdentityList'] = EquipmentChassisIdentityList
    globals()['EquipmentChassisList'] = EquipmentChassisList
    globals()['EquipmentChassisOperationList'] = EquipmentChassisOperationList
    globals()['EquipmentDeviceSummaryList'] = EquipmentDeviceSummaryList
    globals()['EquipmentExpanderModuleList'] = EquipmentExpanderModuleList
    globals()['EquipmentFanControlList'] = EquipmentFanControlList
    globals()['EquipmentFanList'] = EquipmentFanList
    globals()['EquipmentFanModuleList'] = EquipmentFanModuleList
    globals()['EquipmentFexIdentityList'] = EquipmentFexIdentityList
    globals()['EquipmentFexList'] = EquipmentFexList
    globals()['EquipmentFexOperationList'] = EquipmentFexOperationList
    globals()['EquipmentFruList'] = EquipmentFruList
    globals()['EquipmentIdentitySummaryList'] = EquipmentIdentitySummaryList
    globals()['EquipmentIoCardList'] = EquipmentIoCardList
    globals()['EquipmentIoCardOperationList'] = EquipmentIoCardOperationList
    globals()['EquipmentIoExpanderList'] = EquipmentIoExpanderList
    globals()['EquipmentLocatorLedList'] = EquipmentLocatorLedList
    globals()['EquipmentPsuControlList'] = EquipmentPsuControlList
    globals()['EquipmentPsuList'] = EquipmentPsuList
    globals()['EquipmentRackEnclosureList'] = EquipmentRackEnclosureList
    globals()['EquipmentRackEnclosureSlotList'] = EquipmentRackEnclosureSlotList
    globals()['EquipmentSharedIoModuleList'] = EquipmentSharedIoModuleList
    globals()['EquipmentSwitchCardList'] = EquipmentSwitchCardList
    globals()['EquipmentSystemIoControllerList'] = EquipmentSystemIoControllerList
    globals()['EquipmentTpmList'] = EquipmentTpmList
    globals()['EquipmentTransceiverList'] = EquipmentTransceiverList
    globals()['EtherHostPortList'] = EtherHostPortList
    globals()['EtherNetworkPortList'] = EtherNetworkPortList
    globals()['EtherPhysicalPortList'] = EtherPhysicalPortList
    globals()['EtherPortChannelList'] = EtherPortChannelList
    globals()['ExternalsiteAuthorizationList'] = ExternalsiteAuthorizationList
    globals()['FabricAppliancePcRoleList'] = FabricAppliancePcRoleList
    globals()['FabricApplianceRoleList'] = FabricApplianceRoleList
    globals()['FabricConfigChangeDetailList'] = FabricConfigChangeDetailList
    globals()['FabricConfigResultEntryList'] = FabricConfigResultEntryList
    globals()['FabricConfigResultList'] = FabricConfigResultList
    globals()['FabricElementIdentityList'] = FabricElementIdentityList
    globals()['FabricEthNetworkControlPolicyList'] = FabricEthNetworkControlPolicyList
    globals()['FabricEthNetworkGroupPolicyList'] = FabricEthNetworkGroupPolicyList
    globals()['FabricEthNetworkPolicyList'] = FabricEthNetworkPolicyList
    globals()['FabricFcNetworkPolicyList'] = FabricFcNetworkPolicyList
    globals()['FabricFcStorageRoleList'] = FabricFcStorageRoleList
    globals()['FabricFcUplinkPcRoleList'] = FabricFcUplinkPcRoleList
    globals()['FabricFcUplinkRoleList'] = FabricFcUplinkRoleList
    globals()['FabricFcoeUplinkPcRoleList'] = FabricFcoeUplinkPcRoleList
    globals()['FabricFcoeUplinkRoleList'] = FabricFcoeUplinkRoleList
    globals()['FabricFlowControlPolicyList'] = FabricFlowControlPolicyList
    globals()['FabricLinkAggregationPolicyList'] = FabricLinkAggregationPolicyList
    globals()['FabricLinkControlPolicyList'] = FabricLinkControlPolicyList
    globals()['FabricMulticastPolicyList'] = FabricMulticastPolicyList
    globals()['FabricPcMemberList'] = FabricPcMemberList
    globals()['FabricPcOperationList'] = FabricPcOperationList
    globals()['FabricPortModeList'] = FabricPortModeList
    globals()['FabricPortOperationList'] = FabricPortOperationList
    globals()['FabricPortPolicyList'] = FabricPortPolicyList
    globals()['FabricServerRoleList'] = FabricServerRoleList
    globals()['FabricSwitchClusterProfileList'] = FabricSwitchClusterProfileList
    globals()['FabricSwitchControlPolicyList'] = FabricSwitchControlPolicyList
    globals()['FabricSwitchProfileList'] = FabricSwitchProfileList
    globals()['FabricSystemQosPolicyList'] = FabricSystemQosPolicyList
    globals()['FabricUplinkPcRoleList'] = FabricUplinkPcRoleList
    globals()['FabricUplinkRoleList'] = FabricUplinkRoleList
    globals()['FabricVlanList'] = FabricVlanList
    globals()['FabricVsanList'] = FabricVsanList
    globals()['FaultInstanceList'] = FaultInstanceList
    globals()['FcPhysicalPortList'] = FcPhysicalPortList
    globals()['FcPortChannelList'] = FcPortChannelList
    globals()['FcpoolFcBlockList'] = FcpoolFcBlockList
    globals()['FcpoolLeaseList'] = FcpoolLeaseList
    globals()['FcpoolPoolList'] = FcpoolPoolList
    globals()['FcpoolPoolMemberList'] = FcpoolPoolMemberList
    globals()['FcpoolUniverseList'] = FcpoolUniverseList
    globals()['FirmwareBiosDescriptorList'] = FirmwareBiosDescriptorList
    globals()['FirmwareBoardControllerDescriptorList'] = FirmwareBoardControllerDescriptorList
    globals()['FirmwareChassisUpgradeList'] = FirmwareChassisUpgradeList
    globals()['FirmwareCimcDescriptorList'] = FirmwareCimcDescriptorList
    globals()['FirmwareDimmDescriptorList'] = FirmwareDimmDescriptorList
    globals()['FirmwareDistributableList'] = FirmwareDistributableList
    globals()['FirmwareDistributableMetaList'] = FirmwareDistributableMetaList
    globals()['FirmwareDriveDescriptorList'] = FirmwareDriveDescriptorList
    globals()['FirmwareDriverDistributableList'] = FirmwareDriverDistributableList
    globals()['FirmwareEulaList'] = FirmwareEulaList
    globals()['FirmwareFirmwareSummaryList'] = FirmwareFirmwareSummaryList
    globals()['FirmwareGpuDescriptorList'] = FirmwareGpuDescriptorList
    globals()['FirmwareHbaDescriptorList'] = FirmwareHbaDescriptorList
    globals()['FirmwareIomDescriptorList'] = FirmwareIomDescriptorList
    globals()['FirmwareMswitchDescriptorList'] = FirmwareMswitchDescriptorList
    globals()['FirmwareNxosDescriptorList'] = FirmwareNxosDescriptorList
    globals()['FirmwarePcieDescriptorList'] = FirmwarePcieDescriptorList
    globals()['FirmwarePsuDescriptorList'] = FirmwarePsuDescriptorList
    globals()['FirmwareRunningFirmwareList'] = FirmwareRunningFirmwareList
    globals()['FirmwareSasExpanderDescriptorList'] = FirmwareSasExpanderDescriptorList
    globals()['FirmwareServerConfigurationUtilityDistributableList'] = FirmwareServerConfigurationUtilityDistributableList
    globals()['FirmwareStorageControllerDescriptorList'] = FirmwareStorageControllerDescriptorList
    globals()['FirmwareSwitchUpgradeList'] = FirmwareSwitchUpgradeList
    globals()['FirmwareUnsupportedVersionUpgradeList'] = FirmwareUnsupportedVersionUpgradeList
    globals()['FirmwareUpgradeImpactStatusList'] = FirmwareUpgradeImpactStatusList
    globals()['FirmwareUpgradeList'] = FirmwareUpgradeList
    globals()['FirmwareUpgradeStatusList'] = FirmwareUpgradeStatusList
    globals()['ForecastCatalogList'] = ForecastCatalogList
    globals()['ForecastDefinitionList'] = ForecastDefinitionList
    globals()['ForecastInstanceList'] = ForecastInstanceList
    globals()['GraphicsCardList'] = GraphicsCardList
    globals()['GraphicsControllerList'] = GraphicsControllerList
    globals()['HclDriverImageList'] = HclDriverImageList
    globals()['HclExemptedCatalogList'] = HclExemptedCatalogList
    globals()['HclHyperflexSoftwareCompatibilityInfoList'] = HclHyperflexSoftwareCompatibilityInfoList
    globals()['HclOperatingSystemList'] = HclOperatingSystemList
    globals()['HclOperatingSystemVendorList'] = HclOperatingSystemVendorList
    globals()['HyperflexAlarmList'] = HyperflexAlarmList
    globals()['HyperflexAppCatalogList'] = HyperflexAppCatalogList
    globals()['HyperflexAutoSupportPolicyList'] = HyperflexAutoSupportPolicyList
    globals()['HyperflexBackupClusterList'] = HyperflexBackupClusterList
    globals()['HyperflexCapabilityInfoList'] = HyperflexCapabilityInfoList
    globals()['HyperflexClusterBackupPolicyDeploymentList'] = HyperflexClusterBackupPolicyDeploymentList
    globals()['HyperflexClusterBackupPolicyInventoryList'] = HyperflexClusterBackupPolicyInventoryList
    globals()['HyperflexClusterBackupPolicyList'] = HyperflexClusterBackupPolicyList
    globals()['HyperflexClusterHealthCheckExecutionSnapshotList'] = HyperflexClusterHealthCheckExecutionSnapshotList
    globals()['HyperflexClusterList'] = HyperflexClusterList
    globals()['HyperflexClusterNetworkPolicyList'] = HyperflexClusterNetworkPolicyList
    globals()['HyperflexClusterProfileList'] = HyperflexClusterProfileList
    globals()['HyperflexClusterReplicationNetworkPolicyDeploymentList'] = HyperflexClusterReplicationNetworkPolicyDeploymentList
    globals()['HyperflexClusterReplicationNetworkPolicyList'] = HyperflexClusterReplicationNetworkPolicyList
    globals()['HyperflexClusterStoragePolicyList'] = HyperflexClusterStoragePolicyList
    globals()['HyperflexConfigResultEntryList'] = HyperflexConfigResultEntryList
    globals()['HyperflexConfigResultList'] = HyperflexConfigResultList
    globals()['HyperflexDataProtectionPeerList'] = HyperflexDataProtectionPeerList
    globals()['HyperflexDatastoreStatisticList'] = HyperflexDatastoreStatisticList
    globals()['HyperflexDevicePackageDownloadStateList'] = HyperflexDevicePackageDownloadStateList
    globals()['HyperflexDriveList'] = HyperflexDriveList
    globals()['HyperflexEncryptionList'] = HyperflexEncryptionList
    globals()['HyperflexExtFcStoragePolicyList'] = HyperflexExtFcStoragePolicyList
    globals()['HyperflexExtIscsiStoragePolicyList'] = HyperflexExtIscsiStoragePolicyList
    globals()['HyperflexFeatureLimitExternalList'] = HyperflexFeatureLimitExternalList
    globals()['HyperflexFeatureLimitInternalList'] = HyperflexFeatureLimitInternalList
    globals()['HyperflexHealthCheckDefinitionList'] = HyperflexHealthCheckDefinitionList
    globals()['HyperflexHealthCheckExecutionList'] = HyperflexHealthCheckExecutionList
    globals()['HyperflexHealthCheckExecutionSnapshotList'] = HyperflexHealthCheckExecutionSnapshotList
    globals()['HyperflexHealthCheckPackageChecksumList'] = HyperflexHealthCheckPackageChecksumList
    globals()['HyperflexHealthList'] = HyperflexHealthList
    globals()['HyperflexHxdpVersionList'] = HyperflexHxdpVersionList
    globals()['HyperflexHypervisorHostList'] = HyperflexHypervisorHostList
    globals()['HyperflexHypervisorVirtualMachineList'] = HyperflexHypervisorVirtualMachineList
    globals()['HyperflexKeyEncryptionKeyList'] = HyperflexKeyEncryptionKeyList
    globals()['HyperflexLicenseList'] = HyperflexLicenseList
    globals()['HyperflexLocalCredentialPolicyList'] = HyperflexLocalCredentialPolicyList
    globals()['HyperflexNodeConfigPolicyList'] = HyperflexNodeConfigPolicyList
    globals()['HyperflexNodeList'] = HyperflexNodeList
    globals()['HyperflexNodeProfileList'] = HyperflexNodeProfileList
    globals()['HyperflexProtectedClusterList'] = HyperflexProtectedClusterList
    globals()['HyperflexProxySettingPolicyList'] = HyperflexProxySettingPolicyList
    globals()['HyperflexServerFirmwareVersionEntryList'] = HyperflexServerFirmwareVersionEntryList
    globals()['HyperflexServerFirmwareVersionList'] = HyperflexServerFirmwareVersionList
    globals()['HyperflexServerModelList'] = HyperflexServerModelList
    globals()['HyperflexServiceAuthTokenList'] = HyperflexServiceAuthTokenList
    globals()['HyperflexSoftwareDistributionComponentList'] = HyperflexSoftwareDistributionComponentList
    globals()['HyperflexSoftwareDistributionEntryList'] = HyperflexSoftwareDistributionEntryList
    globals()['HyperflexSoftwareDistributionVersionList'] = HyperflexSoftwareDistributionVersionList
    globals()['HyperflexSoftwareVersionPolicyList'] = HyperflexSoftwareVersionPolicyList
    globals()['HyperflexStorageContainerList'] = HyperflexStorageContainerList
    globals()['HyperflexSysConfigPolicyList'] = HyperflexSysConfigPolicyList
    globals()['HyperflexUcsmConfigPolicyList'] = HyperflexUcsmConfigPolicyList
    globals()['HyperflexVcenterConfigPolicyList'] = HyperflexVcenterConfigPolicyList
    globals()['HyperflexVmBackupInfoList'] = HyperflexVmBackupInfoList
    globals()['HyperflexVmImportOperationList'] = HyperflexVmImportOperationList
    globals()['HyperflexVmRestoreOperationList'] = HyperflexVmRestoreOperationList
    globals()['HyperflexVmSnapshotInfoList'] = HyperflexVmSnapshotInfoList
    globals()['HyperflexVolumeList'] = HyperflexVolumeList
    globals()['HyperflexWitnessConfigurationList'] = HyperflexWitnessConfigurationList
    globals()['IaasConnectorPackList'] = IaasConnectorPackList
    globals()['IaasDeviceStatusList'] = IaasDeviceStatusList
    globals()['IaasDiagnosticMessagesList'] = IaasDiagnosticMessagesList
    globals()['IaasLicenseInfoList'] = IaasLicenseInfoList
    globals()['IaasMostRunTasksList'] = IaasMostRunTasksList
    globals()['IaasServiceRequestList'] = IaasServiceRequestList
    globals()['IaasUcsdInfoList'] = IaasUcsdInfoList
    globals()['IaasUcsdManagedInfraList'] = IaasUcsdManagedInfraList
    globals()['IaasUcsdMessagesList'] = IaasUcsdMessagesList
    globals()['IamAccountExperienceList'] = IamAccountExperienceList
    globals()['IamAccountList'] = IamAccountList
    globals()['IamApiKeyList'] = IamApiKeyList
    globals()['IamAppRegistrationList'] = IamAppRegistrationList
    globals()['IamBannerMessageList'] = IamBannerMessageList
    globals()['IamCertificateList'] = IamCertificateList
    globals()['IamCertificateRequestList'] = IamCertificateRequestList
    globals()['IamDomainGroupList'] = IamDomainGroupList
    globals()['IamEndPointPrivilegeList'] = IamEndPointPrivilegeList
    globals()['IamEndPointRoleList'] = IamEndPointRoleList
    globals()['IamEndPointUserList'] = IamEndPointUserList
    globals()['IamEndPointUserPolicyList'] = IamEndPointUserPolicyList
    globals()['IamEndPointUserRoleList'] = IamEndPointUserRoleList
    globals()['IamIdpList'] = IamIdpList
    globals()['IamIdpReferenceList'] = IamIdpReferenceList
    globals()['IamIpAccessManagementList'] = IamIpAccessManagementList
    globals()['IamIpAddressList'] = IamIpAddressList
    globals()['IamLdapGroupList'] = IamLdapGroupList
    globals()['IamLdapPolicyList'] = IamLdapPolicyList
    globals()['IamLdapProviderList'] = IamLdapProviderList
    globals()['IamLocalUserPasswordPolicyList'] = IamLocalUserPasswordPolicyList
    globals()['IamOAuthTokenList'] = IamOAuthTokenList
    globals()['IamPermissionList'] = IamPermissionList
    globals()['IamPrivateKeySpecList'] = IamPrivateKeySpecList
    globals()['IamPrivilegeList'] = IamPrivilegeList
    globals()['IamPrivilegeSetList'] = IamPrivilegeSetList
    globals()['IamQualifierList'] = IamQualifierList
    globals()['IamResourceLimitsList'] = IamResourceLimitsList
    globals()['IamResourcePermissionList'] = IamResourcePermissionList
    globals()['IamResourceRolesList'] = IamResourceRolesList
    globals()['IamRoleList'] = IamRoleList
    globals()['IamSecurityHolderList'] = IamSecurityHolderList
    globals()['IamServiceProviderList'] = IamServiceProviderList
    globals()['IamSessionLimitsList'] = IamSessionLimitsList
    globals()['IamSessionList'] = IamSessionList
    globals()['IamSystemList'] = IamSystemList
    globals()['IamTrustPointList'] = IamTrustPointList
    globals()['IamUserGroupList'] = IamUserGroupList
    globals()['IamUserList'] = IamUserList
    globals()['IamUserPreferenceList'] = IamUserPreferenceList
    globals()['InventoryDeviceInfoList'] = InventoryDeviceInfoList
    globals()['InventoryDnMoBindingList'] = InventoryDnMoBindingList
    globals()['InventoryGenericInventoryHolderList'] = InventoryGenericInventoryHolderList
    globals()['InventoryGenericInventoryList'] = InventoryGenericInventoryList
    globals()['IpmioverlanPolicyList'] = IpmioverlanPolicyList
    globals()['IppoolBlockLeaseList'] = IppoolBlockLeaseList
    globals()['IppoolIpLeaseList'] = IppoolIpLeaseList
    globals()['IppoolPoolList'] = IppoolPoolList
    globals()['IppoolPoolMemberList'] = IppoolPoolMemberList
    globals()['IppoolShadowBlockList'] = IppoolShadowBlockList
    globals()['IppoolShadowPoolList'] = IppoolShadowPoolList
    globals()['IppoolUniverseList'] = IppoolUniverseList
    globals()['IqnpoolBlockList'] = IqnpoolBlockList
    globals()['IqnpoolLeaseList'] = IqnpoolLeaseList
    globals()['IqnpoolPoolList'] = IqnpoolPoolList
    globals()['IqnpoolPoolMemberList'] = IqnpoolPoolMemberList
    globals()['IqnpoolUniverseList'] = IqnpoolUniverseList
    globals()['IwotenantTenantStatusList'] = IwotenantTenantStatusList
    globals()['KubernetesAciCniApicList'] = KubernetesAciCniApicList
    globals()['KubernetesAciCniProfileList'] = KubernetesAciCniProfileList
    globals()['KubernetesAciCniTenantClusterAllocationList'] = KubernetesAciCniTenantClusterAllocationList
    globals()['KubernetesAddonDefinitionList'] = KubernetesAddonDefinitionList
    globals()['KubernetesAddonPolicyList'] = KubernetesAddonPolicyList
    globals()['KubernetesAddonRepositoryList'] = KubernetesAddonRepositoryList
    globals()['KubernetesBaremetalNodeProfileList'] = KubernetesBaremetalNodeProfileList
    globals()['KubernetesCatalogList'] = KubernetesCatalogList
    globals()['KubernetesClusterAddonProfileList'] = KubernetesClusterAddonProfileList
    globals()['KubernetesClusterList'] = KubernetesClusterList
    globals()['KubernetesClusterProfileList'] = KubernetesClusterProfileList
    globals()['KubernetesConfigResultEntryList'] = KubernetesConfigResultEntryList
    globals()['KubernetesConfigResultList'] = KubernetesConfigResultList
    globals()['KubernetesContainerRuntimePolicyList'] = KubernetesContainerRuntimePolicyList
    globals()['KubernetesDaemonSetList'] = KubernetesDaemonSetList
    globals()['KubernetesDeploymentList'] = KubernetesDeploymentList
    globals()['KubernetesIngressList'] = KubernetesIngressList
    globals()['KubernetesNetworkPolicyList'] = KubernetesNetworkPolicyList
    globals()['KubernetesNodeGroupProfileList'] = KubernetesNodeGroupProfileList
    globals()['KubernetesNodeList'] = KubernetesNodeList
    globals()['KubernetesPodList'] = KubernetesPodList
    globals()['KubernetesServiceList'] = KubernetesServiceList
    globals()['KubernetesStatefulSetList'] = KubernetesStatefulSetList
    globals()['KubernetesSysConfigPolicyList'] = KubernetesSysConfigPolicyList
    globals()['KubernetesTrustedRegistriesPolicyList'] = KubernetesTrustedRegistriesPolicyList
    globals()['KubernetesVersionList'] = KubernetesVersionList
    globals()['KubernetesVersionPolicyList'] = KubernetesVersionPolicyList
    globals()['KubernetesVirtualMachineInfraConfigPolicyList'] = KubernetesVirtualMachineInfraConfigPolicyList
    globals()['KubernetesVirtualMachineInfrastructureProviderList'] = KubernetesVirtualMachineInfrastructureProviderList
    globals()['KubernetesVirtualMachineInstanceTypeList'] = KubernetesVirtualMachineInstanceTypeList
    globals()['KubernetesVirtualMachineNodeProfileList'] = KubernetesVirtualMachineNodeProfileList
    globals()['KvmPolicyList'] = KvmPolicyList
    globals()['KvmSessionList'] = KvmSessionList
    globals()['KvmTunnelList'] = KvmTunnelList
    globals()['KvmTunneledKvmPolicyList'] = KvmTunneledKvmPolicyList
    globals()['LicenseAccountLicenseDataList'] = LicenseAccountLicenseDataList
    globals()['LicenseCustomerOpList'] = LicenseCustomerOpList
    globals()['LicenseIksCustomerOpList'] = LicenseIksCustomerOpList
    globals()['LicenseIksLicenseCountList'] = LicenseIksLicenseCountList
    globals()['LicenseIwoCustomerOpList'] = LicenseIwoCustomerOpList
    globals()['LicenseIwoLicenseCountList'] = LicenseIwoLicenseCountList
    globals()['LicenseLicenseInfoList'] = LicenseLicenseInfoList
    globals()['LicenseLicenseReservationOpList'] = LicenseLicenseReservationOpList
    globals()['LicenseSmartlicenseTokenList'] = LicenseSmartlicenseTokenList
    globals()['LsServiceProfileList'] = LsServiceProfileList
    globals()['MacpoolIdBlockList'] = MacpoolIdBlockList
    globals()['MacpoolLeaseList'] = MacpoolLeaseList
    globals()['MacpoolPoolList'] = MacpoolPoolList
    globals()['MacpoolPoolMemberList'] = MacpoolPoolMemberList
    globals()['MacpoolUniverseList'] = MacpoolUniverseList
    globals()['ManagementControllerList'] = ManagementControllerList
    globals()['ManagementEntityList'] = ManagementEntityList
    globals()['ManagementInterfaceList'] = ManagementInterfaceList
    globals()['MemoryArrayList'] = MemoryArrayList
    globals()['MemoryPersistentMemoryConfigResultList'] = MemoryPersistentMemoryConfigResultList
    globals()['MemoryPersistentMemoryConfigurationList'] = MemoryPersistentMemoryConfigurationList
    globals()['MemoryPersistentMemoryNamespaceConfigResultList'] = MemoryPersistentMemoryNamespaceConfigResultList
    globals()['MemoryPersistentMemoryNamespaceList'] = MemoryPersistentMemoryNamespaceList
    globals()['MemoryPersistentMemoryPolicyList'] = MemoryPersistentMemoryPolicyList
    globals()['MemoryPersistentMemoryRegionList'] = MemoryPersistentMemoryRegionList
    globals()['MemoryPersistentMemoryUnitList'] = MemoryPersistentMemoryUnitList
    globals()['MemoryUnitList'] = MemoryUnitList
    globals()['MetaDefinitionList'] = MetaDefinitionList
    globals()['MoAggregateTransform'] = MoAggregateTransform
    globals()['MoDocumentCount'] = MoDocumentCount
    globals()['MoTagSummary'] = MoTagSummary
    globals()['NetworkElementList'] = NetworkElementList
    globals()['NetworkElementSummaryList'] = NetworkElementSummaryList
    globals()['NetworkFcZoneInfoList'] = NetworkFcZoneInfoList
    globals()['NetworkFeatureControlList'] = NetworkFeatureControlList
    globals()['NetworkInterfaceListList'] = NetworkInterfaceListList
    globals()['NetworkLicenseFileList'] = NetworkLicenseFileList
    globals()['NetworkSupervisorCardList'] = NetworkSupervisorCardList
    globals()['NetworkVlanPortInfoList'] = NetworkVlanPortInfoList
    globals()['NetworkVrfList'] = NetworkVrfList
    globals()['NetworkconfigPolicyList'] = NetworkconfigPolicyList
    globals()['NiaapiApicCcoPostList'] = NiaapiApicCcoPostList
    globals()['NiaapiApicFieldNoticeList'] = NiaapiApicFieldNoticeList
    globals()['NiaapiApicHweolList'] = NiaapiApicHweolList
    globals()['NiaapiApicLatestMaintainedReleaseList'] = NiaapiApicLatestMaintainedReleaseList
    globals()['NiaapiApicReleaseRecommendList'] = NiaapiApicReleaseRecommendList
    globals()['NiaapiApicSweolList'] = NiaapiApicSweolList
    globals()['NiaapiDcnmCcoPostList'] = NiaapiDcnmCcoPostList
    globals()['NiaapiDcnmFieldNoticeList'] = NiaapiDcnmFieldNoticeList
    globals()['NiaapiDcnmHweolList'] = NiaapiDcnmHweolList
    globals()['NiaapiDcnmLatestMaintainedReleaseList'] = NiaapiDcnmLatestMaintainedReleaseList
    globals()['NiaapiDcnmReleaseRecommendList'] = NiaapiDcnmReleaseRecommendList
    globals()['NiaapiDcnmSweolList'] = NiaapiDcnmSweolList
    globals()['NiaapiFileDownloaderList'] = NiaapiFileDownloaderList
    globals()['NiaapiNiaMetadataList'] = NiaapiNiaMetadataList
    globals()['NiaapiNibFileDownloaderList'] = NiaapiNibFileDownloaderList
    globals()['NiaapiNibMetadataList'] = NiaapiNibMetadataList
    globals()['NiaapiVersionRegexList'] = NiaapiVersionRegexList
    globals()['NiatelemetryAaaLdapProviderDetailsList'] = NiatelemetryAaaLdapProviderDetailsList
    globals()['NiatelemetryAaaRadiusProviderDetailsList'] = NiatelemetryAaaRadiusProviderDetailsList
    globals()['NiatelemetryAaaTacacsProviderDetailsList'] = NiatelemetryAaaTacacsProviderDetailsList
    globals()['NiatelemetryApicAppPluginDetailsList'] = NiatelemetryApicAppPluginDetailsList
    globals()['NiatelemetryApicCoreFileDetailsList'] = NiatelemetryApicCoreFileDetailsList
    globals()['NiatelemetryApicDbgexpRsExportDestList'] = NiatelemetryApicDbgexpRsExportDestList
    globals()['NiatelemetryApicDbgexpRsTsSchedulerList'] = NiatelemetryApicDbgexpRsTsSchedulerList
    globals()['NiatelemetryApicFanDetailsList'] = NiatelemetryApicFanDetailsList
    globals()['NiatelemetryApicFexDetailsList'] = NiatelemetryApicFexDetailsList
    globals()['NiatelemetryApicFlashDetailsList'] = NiatelemetryApicFlashDetailsList
    globals()['NiatelemetryApicNtpAuthList'] = NiatelemetryApicNtpAuthList
    globals()['NiatelemetryApicPsuDetailsList'] = NiatelemetryApicPsuDetailsList
    globals()['NiatelemetryApicRealmDetailsList'] = NiatelemetryApicRealmDetailsList
    globals()['NiatelemetryApicSnmpClientGrpDetailsList'] = NiatelemetryApicSnmpClientGrpDetailsList
    globals()['NiatelemetryApicSnmpCommunityAccessDetailsList'] = NiatelemetryApicSnmpCommunityAccessDetailsList
    globals()['NiatelemetryApicSnmpCommunityDetailsList'] = NiatelemetryApicSnmpCommunityDetailsList
    globals()['NiatelemetryApicSnmpTrapDetailsList'] = NiatelemetryApicSnmpTrapDetailsList
    globals()['NiatelemetryApicSnmpTrapFwdServerDetailsList'] = NiatelemetryApicSnmpTrapFwdServerDetailsList
    globals()['NiatelemetryApicSnmpVersionThreeDetailsList'] = NiatelemetryApicSnmpVersionThreeDetailsList
    globals()['NiatelemetryApicSysLogGrpList'] = NiatelemetryApicSysLogGrpList
    globals()['NiatelemetryApicSysLogSrcList'] = NiatelemetryApicSysLogSrcList
    globals()['NiatelemetryApicTransceiverDetailsList'] = NiatelemetryApicTransceiverDetailsList
    globals()['NiatelemetryApicUiPageCountsList'] = NiatelemetryApicUiPageCountsList
    globals()['NiatelemetryAppDetailsList'] = NiatelemetryAppDetailsList
    globals()['NiatelemetryCommonPoliciesList'] = NiatelemetryCommonPoliciesList
    globals()['NiatelemetryDcnmFanDetailsList'] = NiatelemetryDcnmFanDetailsList
    globals()['NiatelemetryDcnmFexDetailsList'] = NiatelemetryDcnmFexDetailsList
    globals()['NiatelemetryDcnmModuleDetailsList'] = NiatelemetryDcnmModuleDetailsList
    globals()['NiatelemetryDcnmPsuDetailsList'] = NiatelemetryDcnmPsuDetailsList
    globals()['NiatelemetryDcnmTransceiverDetailsList'] = NiatelemetryDcnmTransceiverDetailsList
    globals()['NiatelemetryEpgList'] = NiatelemetryEpgList
    globals()['NiatelemetryFabricModuleDetailsList'] = NiatelemetryFabricModuleDetailsList
    globals()['NiatelemetryFabricNodeControlDetailsList'] = NiatelemetryFabricNodeControlDetailsList
    globals()['NiatelemetryFabricPodProfileList'] = NiatelemetryFabricPodProfileList
    globals()['NiatelemetryFabricPodSsList'] = NiatelemetryFabricPodSsList
    globals()['NiatelemetryFaultList'] = NiatelemetryFaultList
    globals()['NiatelemetryHttpsAclContractDetailsList'] = NiatelemetryHttpsAclContractDetailsList
    globals()['NiatelemetryHttpsAclContractFilterMapList'] = NiatelemetryHttpsAclContractFilterMapList
    globals()['NiatelemetryHttpsAclEpgContractMapList'] = NiatelemetryHttpsAclEpgContractMapList
    globals()['NiatelemetryHttpsAclEpgDetailsList'] = NiatelemetryHttpsAclEpgDetailsList
    globals()['NiatelemetryHttpsAclFilterDetailsList'] = NiatelemetryHttpsAclFilterDetailsList
    globals()['NiatelemetryInsightGroupDetailsList'] = NiatelemetryInsightGroupDetailsList
    globals()['NiatelemetryLcList'] = NiatelemetryLcList
    globals()['NiatelemetryLeafPolGrpDetailsList'] = NiatelemetryLeafPolGrpDetailsList
    globals()['NiatelemetryMsoContractDetailsList'] = NiatelemetryMsoContractDetailsList
    globals()['NiatelemetryMsoEpgDetailsList'] = NiatelemetryMsoEpgDetailsList
    globals()['NiatelemetryMsoSchemaDetailsList'] = NiatelemetryMsoSchemaDetailsList
    globals()['NiatelemetryMsoSiteDetailsList'] = NiatelemetryMsoSiteDetailsList
    globals()['NiatelemetryMsoTenantDetailsList'] = NiatelemetryMsoTenantDetailsList
    globals()['NiatelemetryNexusDashboardControllerDetailsList'] = NiatelemetryNexusDashboardControllerDetailsList
    globals()['NiatelemetryNexusDashboardDetailsList'] = NiatelemetryNexusDashboardDetailsList
    globals()['NiatelemetryNexusDashboardMemoryDetailsList'] = NiatelemetryNexusDashboardMemoryDetailsList
    globals()['NiatelemetryNexusDashboardsList'] = NiatelemetryNexusDashboardsList
    globals()['NiatelemetryNiaFeatureUsageList'] = NiatelemetryNiaFeatureUsageList
    globals()['NiatelemetryNiaInventoryDcnmList'] = NiatelemetryNiaInventoryDcnmList
    globals()['NiatelemetryNiaInventoryFabricList'] = NiatelemetryNiaInventoryFabricList
    globals()['NiatelemetryNiaInventoryList'] = NiatelemetryNiaInventoryList
    globals()['NiatelemetryNiaLicenseStateList'] = NiatelemetryNiaLicenseStateList
    globals()['NiatelemetryPasswordStrengthCheckList'] = NiatelemetryPasswordStrengthCheckList
    globals()['NiatelemetryPodCommPoliciesList'] = NiatelemetryPodCommPoliciesList
    globals()['NiatelemetryPodSnmpPoliciesList'] = NiatelemetryPodSnmpPoliciesList
    globals()['NiatelemetryPodTimeServerPoliciesList'] = NiatelemetryPodTimeServerPoliciesList
    globals()['NiatelemetrySiteInventoryList'] = NiatelemetrySiteInventoryList
    globals()['NiatelemetrySnmpSrcList'] = NiatelemetrySnmpSrcList
    globals()['NiatelemetrySpinePolGrpDetailsList'] = NiatelemetrySpinePolGrpDetailsList
    globals()['NiatelemetrySshVersionTwoList'] = NiatelemetrySshVersionTwoList
    globals()['NiatelemetrySupervisorModuleDetailsList'] = NiatelemetrySupervisorModuleDetailsList
    globals()['NiatelemetrySyslogRemoteDestList'] = NiatelemetrySyslogRemoteDestList
    globals()['NiatelemetrySyslogSysMsgFacFilterList'] = NiatelemetrySyslogSysMsgFacFilterList
    globals()['NiatelemetrySyslogSysMsgList'] = NiatelemetrySyslogSysMsgList
    globals()['NiatelemetrySystemControllerDetailsList'] = NiatelemetrySystemControllerDetailsList
    globals()['NiatelemetryTenantList'] = NiatelemetryTenantList
    globals()['NotificationAccountSubscriptionList'] = NotificationAccountSubscriptionList
    globals()['NtpPolicyList'] = NtpPolicyList
    globals()['OauthAccessTokenList'] = OauthAccessTokenList
    globals()['OauthAuthorizationList'] = OauthAuthorizationList
    globals()['OprsDeploymentList'] = OprsDeploymentList
    globals()['OprsSyncTargetListMessageList'] = OprsSyncTargetListMessageList
    globals()['OrganizationOrganizationList'] = OrganizationOrganizationList
    globals()['OsBulkInstallInfoList'] = OsBulkInstallInfoList
    globals()['OsCatalogList'] = OsCatalogList
    globals()['OsConfigurationFileList'] = OsConfigurationFileList
    globals()['OsDistributionList'] = OsDistributionList
    globals()['OsInstallList'] = OsInstallList
    globals()['OsSupportedVersionList'] = OsSupportedVersionList
    globals()['PciCoprocessorCardList'] = PciCoprocessorCardList
    globals()['PciDeviceList'] = PciDeviceList
    globals()['PciLinkList'] = PciLinkList
    globals()['PciSwitchList'] = PciSwitchList
    globals()['PortGroupList'] = PortGroupList
    globals()['PortMacBindingList'] = PortMacBindingList
    globals()['PortSubGroupList'] = PortSubGroupList
    globals()['PowerControlStateList'] = PowerControlStateList
    globals()['PowerPolicyList'] = PowerPolicyList
    globals()['ProcessorUnitList'] = ProcessorUnitList
    globals()['RackUnitPersonalityList'] = RackUnitPersonalityList
    globals()['RecommendationCapacityRunwayList'] = RecommendationCapacityRunwayList
    globals()['RecommendationPhysicalItemList'] = RecommendationPhysicalItemList
    globals()['RecoveryBackupConfigPolicyList'] = RecoveryBackupConfigPolicyList
    globals()['RecoveryBackupProfileList'] = RecoveryBackupProfileList
    globals()['RecoveryConfigResultEntryList'] = RecoveryConfigResultEntryList
    globals()['RecoveryConfigResultList'] = RecoveryConfigResultList
    globals()['RecoveryOnDemandBackupList'] = RecoveryOnDemandBackupList
    globals()['RecoveryRestoreList'] = RecoveryRestoreList
    globals()['RecoveryScheduleConfigPolicyList'] = RecoveryScheduleConfigPolicyList
    globals()['ResourceGroupList'] = ResourceGroupList
    globals()['ResourceGroupMemberList'] = ResourceGroupMemberList
    globals()['ResourceLicenseResourceCountList'] = ResourceLicenseResourceCountList
    globals()['ResourceMembershipHolderList'] = ResourceMembershipHolderList
    globals()['ResourceMembershipList'] = ResourceMembershipList
    globals()['ResourceReservationList'] = ResourceReservationList
    globals()['ResourcepoolLeaseList'] = ResourcepoolLeaseList
    globals()['ResourcepoolLeaseResourceList'] = ResourcepoolLeaseResourceList
    globals()['ResourcepoolPoolList'] = ResourcepoolPoolList
    globals()['ResourcepoolPoolMemberList'] = ResourcepoolPoolMemberList
    globals()['ResourcepoolUniverseList'] = ResourcepoolUniverseList
    globals()['SdcardPolicyList'] = SdcardPolicyList
    globals()['SearchSearchItemList'] = SearchSearchItemList
    globals()['SearchSuggestItemList'] = SearchSuggestItemList
    globals()['SearchTagItemList'] = SearchTagItemList
    globals()['SecurityUnitList'] = SecurityUnitList
    globals()['ServerConfigChangeDetailList'] = ServerConfigChangeDetailList
    globals()['ServerConfigImportList'] = ServerConfigImportList
    globals()['ServerConfigResultEntryList'] = ServerConfigResultEntryList
    globals()['ServerConfigResultList'] = ServerConfigResultList
    globals()['ServerProfileList'] = ServerProfileList
    globals()['ServerProfileTemplateList'] = ServerProfileTemplateList
    globals()['SmtpPolicyList'] = SmtpPolicyList
    globals()['SnmpPolicyList'] = SnmpPolicyList
    globals()['SoftwareApplianceDistributableList'] = SoftwareApplianceDistributableList
    globals()['SoftwareDownloadHistoryList'] = SoftwareDownloadHistoryList
    globals()['SoftwareHclMetaList'] = SoftwareHclMetaList
    globals()['SoftwareHyperflexBundleDistributableList'] = SoftwareHyperflexBundleDistributableList
    globals()['SoftwareHyperflexDistributableList'] = SoftwareHyperflexDistributableList
    globals()['SoftwareReleaseMetaList'] = SoftwareReleaseMetaList
    globals()['SoftwareSolutionDistributableList'] = SoftwareSolutionDistributableList
    globals()['SoftwareUcsdBundleDistributableList'] = SoftwareUcsdBundleDistributableList
    globals()['SoftwareUcsdDistributableList'] = SoftwareUcsdDistributableList
    globals()['SoftwarerepositoryAuthorizationList'] = SoftwarerepositoryAuthorizationList
    globals()['SoftwarerepositoryCachedImageList'] = SoftwarerepositoryCachedImageList
    globals()['SoftwarerepositoryCatalogList'] = SoftwarerepositoryCatalogList
    globals()['SoftwarerepositoryCategoryMapperList'] = SoftwarerepositoryCategoryMapperList
    globals()['SoftwarerepositoryCategoryMapperModelList'] = SoftwarerepositoryCategoryMapperModelList
    globals()['SoftwarerepositoryCategorySupportConstraintList'] = SoftwarerepositoryCategorySupportConstraintList
    globals()['SoftwarerepositoryDownloadSpecList'] = SoftwarerepositoryDownloadSpecList
    globals()['SoftwarerepositoryOperatingSystemFileList'] = SoftwarerepositoryOperatingSystemFileList
    globals()['SoftwarerepositoryReleaseList'] = SoftwarerepositoryReleaseList
    globals()['SolPolicyList'] = SolPolicyList
    globals()['SshPolicyList'] = SshPolicyList
    globals()['StorageControllerList'] = StorageControllerList
    globals()['StorageDiskGroupList'] = StorageDiskGroupList
    globals()['StorageDiskSlotList'] = StorageDiskSlotList
    globals()['StorageDriveGroupList'] = StorageDriveGroupList
    globals()['StorageEnclosureDiskList'] = StorageEnclosureDiskList
    globals()['StorageEnclosureDiskSlotEpList'] = StorageEnclosureDiskSlotEpList
    globals()['StorageEnclosureList'] = StorageEnclosureList
    globals()['StorageFlexFlashControllerList'] = StorageFlexFlashControllerList
    globals()['StorageFlexFlashControllerPropsList'] = StorageFlexFlashControllerPropsList
    globals()['StorageFlexFlashPhysicalDriveList'] = StorageFlexFlashPhysicalDriveList
    globals()['StorageFlexFlashVirtualDriveList'] = StorageFlexFlashVirtualDriveList
    globals()['StorageFlexUtilControllerList'] = StorageFlexUtilControllerList
    globals()['StorageFlexUtilPhysicalDriveList'] = StorageFlexUtilPhysicalDriveList
    globals()['StorageFlexUtilVirtualDriveList'] = StorageFlexUtilVirtualDriveList
    globals()['StorageHitachiArrayList'] = StorageHitachiArrayList
    globals()['StorageHitachiControllerList'] = StorageHitachiControllerList
    globals()['StorageHitachiDiskList'] = StorageHitachiDiskList
    globals()['StorageHitachiHostList'] = StorageHitachiHostList
    globals()['StorageHitachiHostLunList'] = StorageHitachiHostLunList
    globals()['StorageHitachiParityGroupList'] = StorageHitachiParityGroupList
    globals()['StorageHitachiPoolList'] = StorageHitachiPoolList
    globals()['StorageHitachiPortList'] = StorageHitachiPortList
    globals()['StorageHitachiVolumeList'] = StorageHitachiVolumeList
    globals()['StorageHyperFlexStorageContainerList'] = StorageHyperFlexStorageContainerList
    globals()['StorageHyperFlexVolumeList'] = StorageHyperFlexVolumeList
    globals()['StorageItemList'] = StorageItemList
    globals()['StorageNetAppAggregateEventList'] = StorageNetAppAggregateEventList
    globals()['StorageNetAppAggregateList'] = StorageNetAppAggregateList
    globals()['StorageNetAppBaseDiskList'] = StorageNetAppBaseDiskList
    globals()['StorageNetAppClusterEventList'] = StorageNetAppClusterEventList
    globals()['StorageNetAppClusterList'] = StorageNetAppClusterList
    globals()['StorageNetAppDiskEventList'] = StorageNetAppDiskEventList
    globals()['StorageNetAppEthernetPortEventList'] = StorageNetAppEthernetPortEventList
    globals()['StorageNetAppEthernetPortList'] = StorageNetAppEthernetPortList
    globals()['StorageNetAppExportPolicyList'] = StorageNetAppExportPolicyList
    globals()['StorageNetAppFcInterfaceEventList'] = StorageNetAppFcInterfaceEventList
    globals()['StorageNetAppFcInterfaceList'] = StorageNetAppFcInterfaceList
    globals()['StorageNetAppFcPortEventList'] = StorageNetAppFcPortEventList
    globals()['StorageNetAppFcPortList'] = StorageNetAppFcPortList
    globals()['StorageNetAppInitiatorGroupList'] = StorageNetAppInitiatorGroupList
    globals()['StorageNetAppIpInterfaceEventList'] = StorageNetAppIpInterfaceEventList
    globals()['StorageNetAppIpInterfaceList'] = StorageNetAppIpInterfaceList
    globals()['StorageNetAppLicenseList'] = StorageNetAppLicenseList
    globals()['StorageNetAppLunEventList'] = StorageNetAppLunEventList
    globals()['StorageNetAppLunList'] = StorageNetAppLunList
    globals()['StorageNetAppLunMapList'] = StorageNetAppLunMapList
    globals()['StorageNetAppNodeEventList'] = StorageNetAppNodeEventList
    globals()['StorageNetAppNodeList'] = StorageNetAppNodeList
    globals()['StorageNetAppNtpServerList'] = StorageNetAppNtpServerList
    globals()['StorageNetAppSensorList'] = StorageNetAppSensorList
    globals()['StorageNetAppStorageVmList'] = StorageNetAppStorageVmList
    globals()['StorageNetAppSvmEventList'] = StorageNetAppSvmEventList
    globals()['StorageNetAppVolumeEventList'] = StorageNetAppVolumeEventList
    globals()['StorageNetAppVolumeList'] = StorageNetAppVolumeList
    globals()['StorageNetAppVolumeSnapshotList'] = StorageNetAppVolumeSnapshotList
    globals()['StoragePhysicalDiskExtensionList'] = StoragePhysicalDiskExtensionList
    globals()['StoragePhysicalDiskList'] = StoragePhysicalDiskList
    globals()['StoragePhysicalDiskUsageList'] = StoragePhysicalDiskUsageList
    globals()['StoragePureArrayList'] = StoragePureArrayList
    globals()['StoragePureControllerList'] = StoragePureControllerList
    globals()['StoragePureDiskList'] = StoragePureDiskList
    globals()['StoragePureHostGroupList'] = StoragePureHostGroupList
    globals()['StoragePureHostList'] = StoragePureHostList
    globals()['StoragePureHostLunList'] = StoragePureHostLunList
    globals()['StoragePurePortList'] = StoragePurePortList
    globals()['StoragePureProtectionGroupList'] = StoragePureProtectionGroupList
    globals()['StoragePureProtectionGroupSnapshotList'] = StoragePureProtectionGroupSnapshotList
    globals()['StoragePureReplicationScheduleList'] = StoragePureReplicationScheduleList
    globals()['StoragePureSnapshotScheduleList'] = StoragePureSnapshotScheduleList
    globals()['StoragePureVolumeList'] = StoragePureVolumeList
    globals()['StoragePureVolumeSnapshotList'] = StoragePureVolumeSnapshotList
    globals()['StorageSasExpanderList'] = StorageSasExpanderList
    globals()['StorageSasPortList'] = StorageSasPortList
    globals()['StorageSpanList'] = StorageSpanList
    globals()['StorageStoragePolicyList'] = StorageStoragePolicyList
    globals()['StorageVdMemberEpList'] = StorageVdMemberEpList
    globals()['StorageVirtualDriveContainerList'] = StorageVirtualDriveContainerList
    globals()['StorageVirtualDriveExtensionList'] = StorageVirtualDriveExtensionList
    globals()['StorageVirtualDriveIdentityList'] = StorageVirtualDriveIdentityList
    globals()['StorageVirtualDriveList'] = StorageVirtualDriveList
    globals()['SyslogPolicyList'] = SyslogPolicyList
    globals()['TamAdvisoryCountList'] = TamAdvisoryCountList
    globals()['TamAdvisoryDefinitionList'] = TamAdvisoryDefinitionList
    globals()['TamAdvisoryInfoList'] = TamAdvisoryInfoList
    globals()['TamAdvisoryInstanceList'] = TamAdvisoryInstanceList
    globals()['TamSecurityAdvisoryList'] = TamSecurityAdvisoryList
    globals()['TechsupportmanagementCollectionControlPolicyList'] = TechsupportmanagementCollectionControlPolicyList
    globals()['TechsupportmanagementDownloadList'] = TechsupportmanagementDownloadList
    globals()['TechsupportmanagementTechSupportBundleList'] = TechsupportmanagementTechSupportBundleList
    globals()['TechsupportmanagementTechSupportStatusList'] = TechsupportmanagementTechSupportStatusList
    globals()['TerminalAuditLogList'] = TerminalAuditLogList
    globals()['TerraformExecutorList'] = TerraformExecutorList
    globals()['ThermalPolicyList'] = ThermalPolicyList
    globals()['TopSystemList'] = TopSystemList
    globals()['UcsdBackupInfoList'] = UcsdBackupInfoList
    globals()['UuidpoolBlockList'] = UuidpoolBlockList
    globals()['UuidpoolPoolList'] = UuidpoolPoolList
    globals()['UuidpoolPoolMemberList'] = UuidpoolPoolMemberList
    globals()['UuidpoolUniverseList'] = UuidpoolUniverseList
    globals()['UuidpoolUuidLeaseList'] = UuidpoolUuidLeaseList
    globals()['ViewServerList'] = ViewServerList
    globals()['VirtualizationCiscoHypervisorManagerList'] = VirtualizationCiscoHypervisorManagerList
    globals()['VirtualizationEsxiConsoleList'] = VirtualizationEsxiConsoleList
    globals()['VirtualizationHostList'] = VirtualizationHostList
    globals()['VirtualizationIweClusterList'] = VirtualizationIweClusterList
    globals()['VirtualizationIweDatacenterList'] = VirtualizationIweDatacenterList
    globals()['VirtualizationIweDvUplinkList'] = VirtualizationIweDvUplinkList
    globals()['VirtualizationIweDvswitchList'] = VirtualizationIweDvswitchList
    globals()['VirtualizationIweHostInterfaceList'] = VirtualizationIweHostInterfaceList
    globals()['VirtualizationIweHostList'] = VirtualizationIweHostList
    globals()['VirtualizationIweHostVswitchList'] = VirtualizationIweHostVswitchList
    globals()['VirtualizationIweNetworkList'] = VirtualizationIweNetworkList
    globals()['VirtualizationIweVirtualDiskList'] = VirtualizationIweVirtualDiskList
    globals()['VirtualizationIweVirtualMachineList'] = VirtualizationIweVirtualMachineList
    globals()['VirtualizationIweVirtualMachineNetworkInterfaceList'] = VirtualizationIweVirtualMachineNetworkInterfaceList
    globals()['VirtualizationVirtualDiskList'] = VirtualizationVirtualDiskList
    globals()['VirtualizationVirtualMachineList'] = VirtualizationVirtualMachineList
    globals()['VirtualizationVirtualNetworkList'] = VirtualizationVirtualNetworkList
    globals()['VirtualizationVmwareClusterList'] = VirtualizationVmwareClusterList
    globals()['VirtualizationVmwareDatacenterList'] = VirtualizationVmwareDatacenterList
    globals()['VirtualizationVmwareDatastoreClusterList'] = VirtualizationVmwareDatastoreClusterList
    globals()['VirtualizationVmwareDatastoreList'] = VirtualizationVmwareDatastoreList
    globals()['VirtualizationVmwareDistributedNetworkList'] = VirtualizationVmwareDistributedNetworkList
    globals()['VirtualizationVmwareDistributedSwitchList'] = VirtualizationVmwareDistributedSwitchList
    globals()['VirtualizationVmwareFolderList'] = VirtualizationVmwareFolderList
    globals()['VirtualizationVmwareHostList'] = VirtualizationVmwareHostList
    globals()['VirtualizationVmwareKernelNetworkList'] = VirtualizationVmwareKernelNetworkList
    globals()['VirtualizationVmwareNetworkList'] = VirtualizationVmwareNetworkList
    globals()['VirtualizationVmwarePhysicalNetworkInterfaceList'] = VirtualizationVmwarePhysicalNetworkInterfaceList
    globals()['VirtualizationVmwareUplinkPortList'] = VirtualizationVmwareUplinkPortList
    globals()['VirtualizationVmwareVcenterList'] = VirtualizationVmwareVcenterList
    globals()['VirtualizationVmwareVirtualDiskList'] = VirtualizationVmwareVirtualDiskList
    globals()['VirtualizationVmwareVirtualMachineList'] = VirtualizationVmwareVirtualMachineList
    globals()['VirtualizationVmwareVirtualMachineSnapshotList'] = VirtualizationVmwareVirtualMachineSnapshotList
    globals()['VirtualizationVmwareVirtualNetworkInterfaceList'] = VirtualizationVmwareVirtualNetworkInterfaceList
    globals()['VirtualizationVmwareVirtualSwitchList'] = VirtualizationVmwareVirtualSwitchList
    globals()['VmediaPolicyList'] = VmediaPolicyList
    globals()['VmrcConsoleList'] = VmrcConsoleList
    globals()['VncConsoleList'] = VncConsoleList
    globals()['VnicEthAdapterPolicyList'] = VnicEthAdapterPolicyList
    globals()['VnicEthIfList'] = VnicEthIfList
    globals()['VnicEthNetworkPolicyList'] = VnicEthNetworkPolicyList
    globals()['VnicEthQosPolicyList'] = VnicEthQosPolicyList
    globals()['VnicFcAdapterPolicyList'] = VnicFcAdapterPolicyList
    globals()['VnicFcIfList'] = VnicFcIfList
    globals()['VnicFcNetworkPolicyList'] = VnicFcNetworkPolicyList
    globals()['VnicFcQosPolicyList'] = VnicFcQosPolicyList
    globals()['VnicIscsiAdapterPolicyList'] = VnicIscsiAdapterPolicyList
    globals()['VnicIscsiBootPolicyList'] = VnicIscsiBootPolicyList
    globals()['VnicIscsiStaticTargetPolicyList'] = VnicIscsiStaticTargetPolicyList
    globals()['VnicLanConnectivityPolicyList'] = VnicLanConnectivityPolicyList
    globals()['VnicLcpStatusList'] = VnicLcpStatusList
    globals()['VnicSanConnectivityPolicyList'] = VnicSanConnectivityPolicyList
    globals()['VnicScpStatusList'] = VnicScpStatusList
    globals()['VrfVrfList'] = VrfVrfList
    globals()['WorkflowAnsibleBatchExecutorList'] = WorkflowAnsibleBatchExecutorList
    globals()['WorkflowBatchApiExecutorList'] = WorkflowBatchApiExecutorList
    globals()['WorkflowBuildTaskMetaList'] = WorkflowBuildTaskMetaList
    globals()['WorkflowBuildTaskMetaOwnerList'] = WorkflowBuildTaskMetaOwnerList
    globals()['WorkflowCatalogList'] = WorkflowCatalogList
    globals()['WorkflowCustomDataTypeDefinitionList'] = WorkflowCustomDataTypeDefinitionList
    globals()['WorkflowErrorResponseHandlerList'] = WorkflowErrorResponseHandlerList
    globals()['WorkflowPendingDynamicWorkflowInfoList'] = WorkflowPendingDynamicWorkflowInfoList
    globals()['WorkflowRollbackWorkflowList'] = WorkflowRollbackWorkflowList
    globals()['WorkflowServiceItemActionDefinitionList'] = WorkflowServiceItemActionDefinitionList
    globals()['WorkflowServiceItemActionInstanceList'] = WorkflowServiceItemActionInstanceList
    globals()['WorkflowServiceItemDefinitionList'] = WorkflowServiceItemDefinitionList
    globals()['WorkflowServiceItemInstanceList'] = WorkflowServiceItemInstanceList
    globals()['WorkflowServiceItemOutputList'] = WorkflowServiceItemOutputList
    globals()['WorkflowSolutionActionDefinitionList'] = WorkflowSolutionActionDefinitionList
    globals()['WorkflowSolutionActionInstanceList'] = WorkflowSolutionActionInstanceList
    globals()['WorkflowSolutionDefinitionList'] = WorkflowSolutionDefinitionList
    globals()['WorkflowSolutionInstanceList'] = WorkflowSolutionInstanceList
    globals()['WorkflowSolutionOutputList'] = WorkflowSolutionOutputList
    globals()['WorkflowSshBatchExecutorList'] = WorkflowSshBatchExecutorList
    globals()['WorkflowTaskDebugLogList'] = WorkflowTaskDebugLogList
    globals()['WorkflowTaskDefinitionList'] = WorkflowTaskDefinitionList
    globals()['WorkflowTaskInfoList'] = WorkflowTaskInfoList
    globals()['WorkflowTaskMetadataList'] = WorkflowTaskMetadataList
    globals()['WorkflowTemplateFunctionMetaList'] = WorkflowTemplateFunctionMetaList
    globals()['WorkflowWorkflowDefinitionList'] = WorkflowWorkflowDefinitionList
    globals()['WorkflowWorkflowInfoList'] = WorkflowWorkflowInfoList
    globals()['WorkflowWorkflowMetaList'] = WorkflowWorkflowMetaList
    globals()['WorkflowWorkflowMetadataList'] = WorkflowWorkflowMetadataList


class MoBaseResponse(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'object_type': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        lazy_import()
        val = {
            'aaa.AuditRecord.List': AaaAuditRecordList,
            'aaa.RetentionConfig.List': AaaRetentionConfigList,
            'aaa.RetentionPolicy.List': AaaRetentionPolicyList,
            'access.Policy.List': AccessPolicyList,
            'adapter.ConfigPolicy.List': AdapterConfigPolicyList,
            'adapter.ExtEthInterface.List': AdapterExtEthInterfaceList,
            'adapter.HostEthInterface.List': AdapterHostEthInterfaceList,
            'adapter.HostFcInterface.List': AdapterHostFcInterfaceList,
            'adapter.HostIscsiInterface.List': AdapterHostIscsiInterfaceList,
            'adapter.Unit.List': AdapterUnitList,
            'adapter.UnitExpander.List': AdapterUnitExpanderList,
            'appliance.AppStatus.List': ApplianceAppStatusList,
            'appliance.AutoRmaPolicy.List': ApplianceAutoRmaPolicyList,
            'appliance.Backup.List': ApplianceBackupList,
            'appliance.BackupPolicy.List': ApplianceBackupPolicyList,
            'appliance.CertificateSetting.List': ApplianceCertificateSettingList,
            'appliance.DataExportPolicy.List': ApplianceDataExportPolicyList,
            'appliance.DeviceCertificate.List': ApplianceDeviceCertificateList,
            'appliance.DeviceClaim.List': ApplianceDeviceClaimList,
            'appliance.DeviceUpgradePolicy.List': ApplianceDeviceUpgradePolicyList,
            'appliance.DiagSetting.List': ApplianceDiagSettingList,
            'appliance.ExternalSyslogSetting.List': ApplianceExternalSyslogSettingList,
            'appliance.FileGateway.List': ApplianceFileGatewayList,
            'appliance.FileSystemStatus.List': ApplianceFileSystemStatusList,
            'appliance.GroupStatus.List': ApplianceGroupStatusList,
            'appliance.ImageBundle.List': ApplianceImageBundleList,
            'appliance.NodeInfo.List': ApplianceNodeInfoList,
            'appliance.NodeStatus.List': ApplianceNodeStatusList,
            'appliance.ReleaseNote.List': ApplianceReleaseNoteList,
            'appliance.RemoteFileImport.List': ApplianceRemoteFileImportList,
            'appliance.Restore.List': ApplianceRestoreList,
            'appliance.SetupInfo.List': ApplianceSetupInfoList,
            'appliance.SystemInfo.List': ApplianceSystemInfoList,
            'appliance.SystemStatus.List': ApplianceSystemStatusList,
            'appliance.Upgrade.List': ApplianceUpgradeList,
            'appliance.UpgradePolicy.List': ApplianceUpgradePolicyList,
            'asset.ClusterMember.List': AssetClusterMemberList,
            'asset.Deployment.List': AssetDeploymentList,
            'asset.DeploymentDevice.List': AssetDeploymentDeviceList,
            'asset.DeviceConfiguration.List': AssetDeviceConfigurationList,
            'asset.DeviceConnectorManager.List': AssetDeviceConnectorManagerList,
            'asset.DeviceContractInformation.List': AssetDeviceContractInformationList,
            'asset.DeviceRegistration.List': AssetDeviceRegistrationList,
            'asset.Subscription.List': AssetSubscriptionList,
            'asset.SubscriptionAccount.List': AssetSubscriptionAccountList,
            'asset.SubscriptionDeviceContractInformation.List': AssetSubscriptionDeviceContractInformationList,
            'asset.Target.List': AssetTargetList,
            'bios.BootDevice.List': BiosBootDeviceList,
            'bios.BootMode.List': BiosBootModeList,
            'bios.Policy.List': BiosPolicyList,
            'bios.SystemBootOrder.List': BiosSystemBootOrderList,
            'bios.TokenSettings.List': BiosTokenSettingsList,
            'bios.Unit.List': BiosUnitList,
            'bios.VfSelectMemoryRasConfiguration.List': BiosVfSelectMemoryRasConfigurationList,
            'boot.CddDevice.List': BootCddDeviceList,
            'boot.DeviceBootMode.List': BootDeviceBootModeList,
            'boot.DeviceBootSecurity.List': BootDeviceBootSecurityList,
            'boot.HddDevice.List': BootHddDeviceList,
            'boot.IscsiDevice.List': BootIscsiDeviceList,
            'boot.NvmeDevice.List': BootNvmeDeviceList,
            'boot.PchStorageDevice.List': BootPchStorageDeviceList,
            'boot.PrecisionPolicy.List': BootPrecisionPolicyList,
            'boot.PxeDevice.List': BootPxeDeviceList,
            'boot.SanDevice.List': BootSanDeviceList,
            'boot.SdDevice.List': BootSdDeviceList,
            'boot.UefiShellDevice.List': BootUefiShellDeviceList,
            'boot.UsbDevice.List': BootUsbDeviceList,
            'boot.VmediaDevice.List': BootVmediaDeviceList,
            'bulk.Export.List': BulkExportList,
            'bulk.ExportedItem.List': BulkExportedItemList,
            'bulk.Request.List': BulkRequestList,
            'bulk.SubRequestObj.List': BulkSubRequestObjList,
            'capability.AdapterUnitDescriptor.List': CapabilityAdapterUnitDescriptorList,
            'capability.Catalog.List': CapabilityCatalogList,
            'capability.ChassisDescriptor.List': CapabilityChassisDescriptorList,
            'capability.ChassisManufacturingDef.List': CapabilityChassisManufacturingDefList,
            'capability.CimcFirmwareDescriptor.List': CapabilityCimcFirmwareDescriptorList,
            'capability.EquipmentPhysicalDef.List': CapabilityEquipmentPhysicalDefList,
            'capability.EquipmentSlotArray.List': CapabilityEquipmentSlotArrayList,
            'capability.FanModuleDescriptor.List': CapabilityFanModuleDescriptorList,
            'capability.FanModuleManufacturingDef.List': CapabilityFanModuleManufacturingDefList,
            'capability.FexDescriptor.List': CapabilityFexDescriptorList,
            'capability.FexManufacturingDef.List': CapabilityFexManufacturingDefList,
            'capability.IoCardCapabilityDef.List': CapabilityIoCardCapabilityDefList,
            'capability.IoCardDescriptor.List': CapabilityIoCardDescriptorList,
            'capability.IoCardManufacturingDef.List': CapabilityIoCardManufacturingDefList,
            'capability.PortGroupAggregationDef.List': CapabilityPortGroupAggregationDefList,
            'capability.PsuDescriptor.List': CapabilityPsuDescriptorList,
            'capability.PsuManufacturingDef.List': CapabilityPsuManufacturingDefList,
            'capability.ServerModelsCapabilityDef.List': CapabilityServerModelsCapabilityDefList,
            'capability.ServerSchemaDescriptor.List': CapabilityServerSchemaDescriptorList,
            'capability.SiocModuleCapabilityDef.List': CapabilitySiocModuleCapabilityDefList,
            'capability.SiocModuleDescriptor.List': CapabilitySiocModuleDescriptorList,
            'capability.SiocModuleManufacturingDef.List': CapabilitySiocModuleManufacturingDefList,
            'capability.SwitchCapability.List': CapabilitySwitchCapabilityList,
            'capability.SwitchDescriptor.List': CapabilitySwitchDescriptorList,
            'capability.SwitchManufacturingDef.List': CapabilitySwitchManufacturingDefList,
            'certificatemanagement.Policy.List': CertificatemanagementPolicyList,
            'chassis.ConfigChangeDetail.List': ChassisConfigChangeDetailList,
            'chassis.ConfigImport.List': ChassisConfigImportList,
            'chassis.ConfigResult.List': ChassisConfigResultList,
            'chassis.ConfigResultEntry.List': ChassisConfigResultEntryList,
            'chassis.IomProfile.List': ChassisIomProfileList,
            'chassis.Profile.List': ChassisProfileList,
            'cloud.AwsBillingUnit.List': CloudAwsBillingUnitList,
            'cloud.AwsKeyPair.List': CloudAwsKeyPairList,
            'cloud.AwsNetworkInterface.List': CloudAwsNetworkInterfaceList,
            'cloud.AwsOrganizationalUnit.List': CloudAwsOrganizationalUnitList,
            'cloud.AwsSecurityGroup.List': CloudAwsSecurityGroupList,
            'cloud.AwsSubnet.List': CloudAwsSubnetList,
            'cloud.AwsVirtualMachine.List': CloudAwsVirtualMachineList,
            'cloud.AwsVolume.List': CloudAwsVolumeList,
            'cloud.AwsVpc.List': CloudAwsVpcList,
            'cloud.Regions.List': CloudRegionsList,
            'cloud.SkuContainerType.List': CloudSkuContainerTypeList,
            'cloud.SkuDatabaseType.List': CloudSkuDatabaseTypeList,
            'cloud.SkuInstanceType.List': CloudSkuInstanceTypeList,
            'cloud.SkuNetworkType.List': CloudSkuNetworkTypeList,
            'cloud.SkuRegionRateCards.List': CloudSkuRegionRateCardsList,
            'cloud.SkuVolumeType.List': CloudSkuVolumeTypeList,
            'cloud.TfcAgentpool.List': CloudTfcAgentpoolList,
            'cloud.TfcOrganization.List': CloudTfcOrganizationList,
            'cloud.TfcWorkspace.List': CloudTfcWorkspaceList,
            'comm.HttpProxyPolicy.List': CommHttpProxyPolicyList,
            'compute.Blade.List': ComputeBladeList,
            'compute.BladeIdentity.List': ComputeBladeIdentityList,
            'compute.Board.List': ComputeBoardList,
            'compute.Mapping.List': ComputeMappingList,
            'compute.PhysicalSummary.List': ComputePhysicalSummaryList,
            'compute.RackUnit.List': ComputeRackUnitList,
            'compute.RackUnitIdentity.List': ComputeRackUnitIdentityList,
            'compute.ServerPowerPolicy.List': ComputeServerPowerPolicyList,
            'compute.ServerSetting.List': ComputeServerSettingList,
            'compute.Vmedia.List': ComputeVmediaList,
            'cond.Alarm.List': CondAlarmList,
            'cond.AlarmAggregation.List': CondAlarmAggregationList,
            'cond.HclStatus.List': CondHclStatusList,
            'cond.HclStatusDetail.List': CondHclStatusDetailList,
            'cond.HclStatusJob.List': CondHclStatusJobList,
            'connectorpack.ConnectorPackUpgrade.List': ConnectorpackConnectorPackUpgradeList,
            'connectorpack.UpgradeImpact.List': ConnectorpackUpgradeImpactList,
            'console.ConsoleConfig.List': ConsoleConsoleConfigList,
            'convergedinfra.HealthCheckDefinition.List': ConvergedinfraHealthCheckDefinitionList,
            'convergedinfra.HealthCheckExecution.List': ConvergedinfraHealthCheckExecutionList,
            'convergedinfra.Pod.List': ConvergedinfraPodList,
            'crd.CustomResource.List': CrdCustomResourceList,
            'deviceconnector.Policy.List': DeviceconnectorPolicyList,
            'equipment.Chassis.List': EquipmentChassisList,
            'equipment.ChassisIdentity.List': EquipmentChassisIdentityList,
            'equipment.ChassisOperation.List': EquipmentChassisOperationList,
            'equipment.DeviceSummary.List': EquipmentDeviceSummaryList,
            'equipment.ExpanderModule.List': EquipmentExpanderModuleList,
            'equipment.Fan.List': EquipmentFanList,
            'equipment.FanControl.List': EquipmentFanControlList,
            'equipment.FanModule.List': EquipmentFanModuleList,
            'equipment.Fex.List': EquipmentFexList,
            'equipment.FexIdentity.List': EquipmentFexIdentityList,
            'equipment.FexOperation.List': EquipmentFexOperationList,
            'equipment.Fru.List': EquipmentFruList,
            'equipment.IdentitySummary.List': EquipmentIdentitySummaryList,
            'equipment.IoCard.List': EquipmentIoCardList,
            'equipment.IoCardOperation.List': EquipmentIoCardOperationList,
            'equipment.IoExpander.List': EquipmentIoExpanderList,
            'equipment.LocatorLed.List': EquipmentLocatorLedList,
            'equipment.Psu.List': EquipmentPsuList,
            'equipment.PsuControl.List': EquipmentPsuControlList,
            'equipment.RackEnclosure.List': EquipmentRackEnclosureList,
            'equipment.RackEnclosureSlot.List': EquipmentRackEnclosureSlotList,
            'equipment.SharedIoModule.List': EquipmentSharedIoModuleList,
            'equipment.SwitchCard.List': EquipmentSwitchCardList,
            'equipment.SystemIoController.List': EquipmentSystemIoControllerList,
            'equipment.Tpm.List': EquipmentTpmList,
            'equipment.Transceiver.List': EquipmentTransceiverList,
            'ether.HostPort.List': EtherHostPortList,
            'ether.NetworkPort.List': EtherNetworkPortList,
            'ether.PhysicalPort.List': EtherPhysicalPortList,
            'ether.PortChannel.List': EtherPortChannelList,
            'externalsite.Authorization.List': ExternalsiteAuthorizationList,
            'fabric.AppliancePcRole.List': FabricAppliancePcRoleList,
            'fabric.ApplianceRole.List': FabricApplianceRoleList,
            'fabric.ConfigChangeDetail.List': FabricConfigChangeDetailList,
            'fabric.ConfigResult.List': FabricConfigResultList,
            'fabric.ConfigResultEntry.List': FabricConfigResultEntryList,
            'fabric.ElementIdentity.List': FabricElementIdentityList,
            'fabric.EthNetworkControlPolicy.List': FabricEthNetworkControlPolicyList,
            'fabric.EthNetworkGroupPolicy.List': FabricEthNetworkGroupPolicyList,
            'fabric.EthNetworkPolicy.List': FabricEthNetworkPolicyList,
            'fabric.FcNetworkPolicy.List': FabricFcNetworkPolicyList,
            'fabric.FcStorageRole.List': FabricFcStorageRoleList,
            'fabric.FcUplinkPcRole.List': FabricFcUplinkPcRoleList,
            'fabric.FcUplinkRole.List': FabricFcUplinkRoleList,
            'fabric.FcoeUplinkPcRole.List': FabricFcoeUplinkPcRoleList,
            'fabric.FcoeUplinkRole.List': FabricFcoeUplinkRoleList,
            'fabric.FlowControlPolicy.List': FabricFlowControlPolicyList,
            'fabric.LinkAggregationPolicy.List': FabricLinkAggregationPolicyList,
            'fabric.LinkControlPolicy.List': FabricLinkControlPolicyList,
            'fabric.MulticastPolicy.List': FabricMulticastPolicyList,
            'fabric.PcMember.List': FabricPcMemberList,
            'fabric.PcOperation.List': FabricPcOperationList,
            'fabric.PortMode.List': FabricPortModeList,
            'fabric.PortOperation.List': FabricPortOperationList,
            'fabric.PortPolicy.List': FabricPortPolicyList,
            'fabric.ServerRole.List': FabricServerRoleList,
            'fabric.SwitchClusterProfile.List': FabricSwitchClusterProfileList,
            'fabric.SwitchControlPolicy.List': FabricSwitchControlPolicyList,
            'fabric.SwitchProfile.List': FabricSwitchProfileList,
            'fabric.SystemQosPolicy.List': FabricSystemQosPolicyList,
            'fabric.UplinkPcRole.List': FabricUplinkPcRoleList,
            'fabric.UplinkRole.List': FabricUplinkRoleList,
            'fabric.Vlan.List': FabricVlanList,
            'fabric.Vsan.List': FabricVsanList,
            'fault.Instance.List': FaultInstanceList,
            'fc.PhysicalPort.List': FcPhysicalPortList,
            'fc.PortChannel.List': FcPortChannelList,
            'fcpool.FcBlock.List': FcpoolFcBlockList,
            'fcpool.Lease.List': FcpoolLeaseList,
            'fcpool.Pool.List': FcpoolPoolList,
            'fcpool.PoolMember.List': FcpoolPoolMemberList,
            'fcpool.Universe.List': FcpoolUniverseList,
            'firmware.BiosDescriptor.List': FirmwareBiosDescriptorList,
            'firmware.BoardControllerDescriptor.List': FirmwareBoardControllerDescriptorList,
            'firmware.ChassisUpgrade.List': FirmwareChassisUpgradeList,
            'firmware.CimcDescriptor.List': FirmwareCimcDescriptorList,
            'firmware.DimmDescriptor.List': FirmwareDimmDescriptorList,
            'firmware.Distributable.List': FirmwareDistributableList,
            'firmware.DistributableMeta.List': FirmwareDistributableMetaList,
            'firmware.DriveDescriptor.List': FirmwareDriveDescriptorList,
            'firmware.DriverDistributable.List': FirmwareDriverDistributableList,
            'firmware.Eula.List': FirmwareEulaList,
            'firmware.FirmwareSummary.List': FirmwareFirmwareSummaryList,
            'firmware.GpuDescriptor.List': FirmwareGpuDescriptorList,
            'firmware.HbaDescriptor.List': FirmwareHbaDescriptorList,
            'firmware.IomDescriptor.List': FirmwareIomDescriptorList,
            'firmware.MswitchDescriptor.List': FirmwareMswitchDescriptorList,
            'firmware.NxosDescriptor.List': FirmwareNxosDescriptorList,
            'firmware.PcieDescriptor.List': FirmwarePcieDescriptorList,
            'firmware.PsuDescriptor.List': FirmwarePsuDescriptorList,
            'firmware.RunningFirmware.List': FirmwareRunningFirmwareList,
            'firmware.SasExpanderDescriptor.List': FirmwareSasExpanderDescriptorList,
            'firmware.ServerConfigurationUtilityDistributable.List': FirmwareServerConfigurationUtilityDistributableList,
            'firmware.StorageControllerDescriptor.List': FirmwareStorageControllerDescriptorList,
            'firmware.SwitchUpgrade.List': FirmwareSwitchUpgradeList,
            'firmware.UnsupportedVersionUpgrade.List': FirmwareUnsupportedVersionUpgradeList,
            'firmware.Upgrade.List': FirmwareUpgradeList,
            'firmware.UpgradeImpactStatus.List': FirmwareUpgradeImpactStatusList,
            'firmware.UpgradeStatus.List': FirmwareUpgradeStatusList,
            'forecast.Catalog.List': ForecastCatalogList,
            'forecast.Definition.List': ForecastDefinitionList,
            'forecast.Instance.List': ForecastInstanceList,
            'graphics.Card.List': GraphicsCardList,
            'graphics.Controller.List': GraphicsControllerList,
            'hcl.DriverImage.List': HclDriverImageList,
            'hcl.ExemptedCatalog.List': HclExemptedCatalogList,
            'hcl.HyperflexSoftwareCompatibilityInfo.List': HclHyperflexSoftwareCompatibilityInfoList,
            'hcl.OperatingSystem.List': HclOperatingSystemList,
            'hcl.OperatingSystemVendor.List': HclOperatingSystemVendorList,
            'hyperflex.Alarm.List': HyperflexAlarmList,
            'hyperflex.AppCatalog.List': HyperflexAppCatalogList,
            'hyperflex.AutoSupportPolicy.List': HyperflexAutoSupportPolicyList,
            'hyperflex.BackupCluster.List': HyperflexBackupClusterList,
            'hyperflex.CapabilityInfo.List': HyperflexCapabilityInfoList,
            'hyperflex.Cluster.List': HyperflexClusterList,
            'hyperflex.ClusterBackupPolicy.List': HyperflexClusterBackupPolicyList,
            'hyperflex.ClusterBackupPolicyDeployment.List': HyperflexClusterBackupPolicyDeploymentList,
            'hyperflex.ClusterBackupPolicyInventory.List': HyperflexClusterBackupPolicyInventoryList,
            'hyperflex.ClusterHealthCheckExecutionSnapshot.List': HyperflexClusterHealthCheckExecutionSnapshotList,
            'hyperflex.ClusterNetworkPolicy.List': HyperflexClusterNetworkPolicyList,
            'hyperflex.ClusterProfile.List': HyperflexClusterProfileList,
            'hyperflex.ClusterReplicationNetworkPolicy.List': HyperflexClusterReplicationNetworkPolicyList,
            'hyperflex.ClusterReplicationNetworkPolicyDeployment.List': HyperflexClusterReplicationNetworkPolicyDeploymentList,
            'hyperflex.ClusterStoragePolicy.List': HyperflexClusterStoragePolicyList,
            'hyperflex.ConfigResult.List': HyperflexConfigResultList,
            'hyperflex.ConfigResultEntry.List': HyperflexConfigResultEntryList,
            'hyperflex.DataProtectionPeer.List': HyperflexDataProtectionPeerList,
            'hyperflex.DatastoreStatistic.List': HyperflexDatastoreStatisticList,
            'hyperflex.DevicePackageDownloadState.List': HyperflexDevicePackageDownloadStateList,
            'hyperflex.Drive.List': HyperflexDriveList,
            'hyperflex.Encryption.List': HyperflexEncryptionList,
            'hyperflex.ExtFcStoragePolicy.List': HyperflexExtFcStoragePolicyList,
            'hyperflex.ExtIscsiStoragePolicy.List': HyperflexExtIscsiStoragePolicyList,
            'hyperflex.FeatureLimitExternal.List': HyperflexFeatureLimitExternalList,
            'hyperflex.FeatureLimitInternal.List': HyperflexFeatureLimitInternalList,
            'hyperflex.Health.List': HyperflexHealthList,
            'hyperflex.HealthCheckDefinition.List': HyperflexHealthCheckDefinitionList,
            'hyperflex.HealthCheckExecution.List': HyperflexHealthCheckExecutionList,
            'hyperflex.HealthCheckExecutionSnapshot.List': HyperflexHealthCheckExecutionSnapshotList,
            'hyperflex.HealthCheckPackageChecksum.List': HyperflexHealthCheckPackageChecksumList,
            'hyperflex.HxdpVersion.List': HyperflexHxdpVersionList,
            'hyperflex.HypervisorHost.List': HyperflexHypervisorHostList,
            'hyperflex.HypervisorVirtualMachine.List': HyperflexHypervisorVirtualMachineList,
            'hyperflex.KeyEncryptionKey.List': HyperflexKeyEncryptionKeyList,
            'hyperflex.License.List': HyperflexLicenseList,
            'hyperflex.LocalCredentialPolicy.List': HyperflexLocalCredentialPolicyList,
            'hyperflex.Node.List': HyperflexNodeList,
            'hyperflex.NodeConfigPolicy.List': HyperflexNodeConfigPolicyList,
            'hyperflex.NodeProfile.List': HyperflexNodeProfileList,
            'hyperflex.ProtectedCluster.List': HyperflexProtectedClusterList,
            'hyperflex.ProxySettingPolicy.List': HyperflexProxySettingPolicyList,
            'hyperflex.ServerFirmwareVersion.List': HyperflexServerFirmwareVersionList,
            'hyperflex.ServerFirmwareVersionEntry.List': HyperflexServerFirmwareVersionEntryList,
            'hyperflex.ServerModel.List': HyperflexServerModelList,
            'hyperflex.ServiceAuthToken.List': HyperflexServiceAuthTokenList,
            'hyperflex.SoftwareDistributionComponent.List': HyperflexSoftwareDistributionComponentList,
            'hyperflex.SoftwareDistributionEntry.List': HyperflexSoftwareDistributionEntryList,
            'hyperflex.SoftwareDistributionVersion.List': HyperflexSoftwareDistributionVersionList,
            'hyperflex.SoftwareVersionPolicy.List': HyperflexSoftwareVersionPolicyList,
            'hyperflex.StorageContainer.List': HyperflexStorageContainerList,
            'hyperflex.SysConfigPolicy.List': HyperflexSysConfigPolicyList,
            'hyperflex.UcsmConfigPolicy.List': HyperflexUcsmConfigPolicyList,
            'hyperflex.VcenterConfigPolicy.List': HyperflexVcenterConfigPolicyList,
            'hyperflex.VmBackupInfo.List': HyperflexVmBackupInfoList,
            'hyperflex.VmImportOperation.List': HyperflexVmImportOperationList,
            'hyperflex.VmRestoreOperation.List': HyperflexVmRestoreOperationList,
            'hyperflex.VmSnapshotInfo.List': HyperflexVmSnapshotInfoList,
            'hyperflex.Volume.List': HyperflexVolumeList,
            'hyperflex.WitnessConfiguration.List': HyperflexWitnessConfigurationList,
            'iaas.ConnectorPack.List': IaasConnectorPackList,
            'iaas.DeviceStatus.List': IaasDeviceStatusList,
            'iaas.DiagnosticMessages.List': IaasDiagnosticMessagesList,
            'iaas.LicenseInfo.List': IaasLicenseInfoList,
            'iaas.MostRunTasks.List': IaasMostRunTasksList,
            'iaas.ServiceRequest.List': IaasServiceRequestList,
            'iaas.UcsdInfo.List': IaasUcsdInfoList,
            'iaas.UcsdManagedInfra.List': IaasUcsdManagedInfraList,
            'iaas.UcsdMessages.List': IaasUcsdMessagesList,
            'iam.Account.List': IamAccountList,
            'iam.AccountExperience.List': IamAccountExperienceList,
            'iam.ApiKey.List': IamApiKeyList,
            'iam.AppRegistration.List': IamAppRegistrationList,
            'iam.BannerMessage.List': IamBannerMessageList,
            'iam.Certificate.List': IamCertificateList,
            'iam.CertificateRequest.List': IamCertificateRequestList,
            'iam.DomainGroup.List': IamDomainGroupList,
            'iam.EndPointPrivilege.List': IamEndPointPrivilegeList,
            'iam.EndPointRole.List': IamEndPointRoleList,
            'iam.EndPointUser.List': IamEndPointUserList,
            'iam.EndPointUserPolicy.List': IamEndPointUserPolicyList,
            'iam.EndPointUserRole.List': IamEndPointUserRoleList,
            'iam.Idp.List': IamIdpList,
            'iam.IdpReference.List': IamIdpReferenceList,
            'iam.IpAccessManagement.List': IamIpAccessManagementList,
            'iam.IpAddress.List': IamIpAddressList,
            'iam.LdapGroup.List': IamLdapGroupList,
            'iam.LdapPolicy.List': IamLdapPolicyList,
            'iam.LdapProvider.List': IamLdapProviderList,
            'iam.LocalUserPasswordPolicy.List': IamLocalUserPasswordPolicyList,
            'iam.OAuthToken.List': IamOAuthTokenList,
            'iam.Permission.List': IamPermissionList,
            'iam.PrivateKeySpec.List': IamPrivateKeySpecList,
            'iam.Privilege.List': IamPrivilegeList,
            'iam.PrivilegeSet.List': IamPrivilegeSetList,
            'iam.Qualifier.List': IamQualifierList,
            'iam.ResourceLimits.List': IamResourceLimitsList,
            'iam.ResourcePermission.List': IamResourcePermissionList,
            'iam.ResourceRoles.List': IamResourceRolesList,
            'iam.Role.List': IamRoleList,
            'iam.SecurityHolder.List': IamSecurityHolderList,
            'iam.ServiceProvider.List': IamServiceProviderList,
            'iam.Session.List': IamSessionList,
            'iam.SessionLimits.List': IamSessionLimitsList,
            'iam.System.List': IamSystemList,
            'iam.TrustPoint.List': IamTrustPointList,
            'iam.User.List': IamUserList,
            'iam.UserGroup.List': IamUserGroupList,
            'iam.UserPreference.List': IamUserPreferenceList,
            'inventory.DeviceInfo.List': InventoryDeviceInfoList,
            'inventory.DnMoBinding.List': InventoryDnMoBindingList,
            'inventory.GenericInventory.List': InventoryGenericInventoryList,
            'inventory.GenericInventoryHolder.List': InventoryGenericInventoryHolderList,
            'ipmioverlan.Policy.List': IpmioverlanPolicyList,
            'ippool.BlockLease.List': IppoolBlockLeaseList,
            'ippool.IpLease.List': IppoolIpLeaseList,
            'ippool.Pool.List': IppoolPoolList,
            'ippool.PoolMember.List': IppoolPoolMemberList,
            'ippool.ShadowBlock.List': IppoolShadowBlockList,
            'ippool.ShadowPool.List': IppoolShadowPoolList,
            'ippool.Universe.List': IppoolUniverseList,
            'iqnpool.Block.List': IqnpoolBlockList,
            'iqnpool.Lease.List': IqnpoolLeaseList,
            'iqnpool.Pool.List': IqnpoolPoolList,
            'iqnpool.PoolMember.List': IqnpoolPoolMemberList,
            'iqnpool.Universe.List': IqnpoolUniverseList,
            'iwotenant.TenantStatus.List': IwotenantTenantStatusList,
            'kubernetes.AciCniApic.List': KubernetesAciCniApicList,
            'kubernetes.AciCniProfile.List': KubernetesAciCniProfileList,
            'kubernetes.AciCniTenantClusterAllocation.List': KubernetesAciCniTenantClusterAllocationList,
            'kubernetes.AddonDefinition.List': KubernetesAddonDefinitionList,
            'kubernetes.AddonPolicy.List': KubernetesAddonPolicyList,
            'kubernetes.AddonRepository.List': KubernetesAddonRepositoryList,
            'kubernetes.BaremetalNodeProfile.List': KubernetesBaremetalNodeProfileList,
            'kubernetes.Catalog.List': KubernetesCatalogList,
            'kubernetes.Cluster.List': KubernetesClusterList,
            'kubernetes.ClusterAddonProfile.List': KubernetesClusterAddonProfileList,
            'kubernetes.ClusterProfile.List': KubernetesClusterProfileList,
            'kubernetes.ConfigResult.List': KubernetesConfigResultList,
            'kubernetes.ConfigResultEntry.List': KubernetesConfigResultEntryList,
            'kubernetes.ContainerRuntimePolicy.List': KubernetesContainerRuntimePolicyList,
            'kubernetes.DaemonSet.List': KubernetesDaemonSetList,
            'kubernetes.Deployment.List': KubernetesDeploymentList,
            'kubernetes.Ingress.List': KubernetesIngressList,
            'kubernetes.NetworkPolicy.List': KubernetesNetworkPolicyList,
            'kubernetes.Node.List': KubernetesNodeList,
            'kubernetes.NodeGroupProfile.List': KubernetesNodeGroupProfileList,
            'kubernetes.Pod.List': KubernetesPodList,
            'kubernetes.Service.List': KubernetesServiceList,
            'kubernetes.StatefulSet.List': KubernetesStatefulSetList,
            'kubernetes.SysConfigPolicy.List': KubernetesSysConfigPolicyList,
            'kubernetes.TrustedRegistriesPolicy.List': KubernetesTrustedRegistriesPolicyList,
            'kubernetes.Version.List': KubernetesVersionList,
            'kubernetes.VersionPolicy.List': KubernetesVersionPolicyList,
            'kubernetes.VirtualMachineInfraConfigPolicy.List': KubernetesVirtualMachineInfraConfigPolicyList,
            'kubernetes.VirtualMachineInfrastructureProvider.List': KubernetesVirtualMachineInfrastructureProviderList,
            'kubernetes.VirtualMachineInstanceType.List': KubernetesVirtualMachineInstanceTypeList,
            'kubernetes.VirtualMachineNodeProfile.List': KubernetesVirtualMachineNodeProfileList,
            'kvm.Policy.List': KvmPolicyList,
            'kvm.Session.List': KvmSessionList,
            'kvm.Tunnel.List': KvmTunnelList,
            'kvm.TunneledKvmPolicy.List': KvmTunneledKvmPolicyList,
            'license.AccountLicenseData.List': LicenseAccountLicenseDataList,
            'license.CustomerOp.List': LicenseCustomerOpList,
            'license.IksCustomerOp.List': LicenseIksCustomerOpList,
            'license.IksLicenseCount.List': LicenseIksLicenseCountList,
            'license.IwoCustomerOp.List': LicenseIwoCustomerOpList,
            'license.IwoLicenseCount.List': LicenseIwoLicenseCountList,
            'license.LicenseInfo.List': LicenseLicenseInfoList,
            'license.LicenseReservationOp.List': LicenseLicenseReservationOpList,
            'license.SmartlicenseToken.List': LicenseSmartlicenseTokenList,
            'ls.ServiceProfile.List': LsServiceProfileList,
            'macpool.IdBlock.List': MacpoolIdBlockList,
            'macpool.Lease.List': MacpoolLeaseList,
            'macpool.Pool.List': MacpoolPoolList,
            'macpool.PoolMember.List': MacpoolPoolMemberList,
            'macpool.Universe.List': MacpoolUniverseList,
            'management.Controller.List': ManagementControllerList,
            'management.Entity.List': ManagementEntityList,
            'management.Interface.List': ManagementInterfaceList,
            'memory.Array.List': MemoryArrayList,
            'memory.PersistentMemoryConfigResult.List': MemoryPersistentMemoryConfigResultList,
            'memory.PersistentMemoryConfiguration.List': MemoryPersistentMemoryConfigurationList,
            'memory.PersistentMemoryNamespace.List': MemoryPersistentMemoryNamespaceList,
            'memory.PersistentMemoryNamespaceConfigResult.List': MemoryPersistentMemoryNamespaceConfigResultList,
            'memory.PersistentMemoryPolicy.List': MemoryPersistentMemoryPolicyList,
            'memory.PersistentMemoryRegion.List': MemoryPersistentMemoryRegionList,
            'memory.PersistentMemoryUnit.List': MemoryPersistentMemoryUnitList,
            'memory.Unit.List': MemoryUnitList,
            'meta.Definition.List': MetaDefinitionList,
            'mo.AggregateTransform': MoAggregateTransform,
            'mo.DocumentCount': MoDocumentCount,
            'mo.TagSummary': MoTagSummary,
            'network.Element.List': NetworkElementList,
            'network.ElementSummary.List': NetworkElementSummaryList,
            'network.FcZoneInfo.List': NetworkFcZoneInfoList,
            'network.FeatureControl.List': NetworkFeatureControlList,
            'network.InterfaceList.List': NetworkInterfaceListList,
            'network.LicenseFile.List': NetworkLicenseFileList,
            'network.SupervisorCard.List': NetworkSupervisorCardList,
            'network.VlanPortInfo.List': NetworkVlanPortInfoList,
            'network.Vrf.List': NetworkVrfList,
            'networkconfig.Policy.List': NetworkconfigPolicyList,
            'niaapi.ApicCcoPost.List': NiaapiApicCcoPostList,
            'niaapi.ApicFieldNotice.List': NiaapiApicFieldNoticeList,
            'niaapi.ApicHweol.List': NiaapiApicHweolList,
            'niaapi.ApicLatestMaintainedRelease.List': NiaapiApicLatestMaintainedReleaseList,
            'niaapi.ApicReleaseRecommend.List': NiaapiApicReleaseRecommendList,
            'niaapi.ApicSweol.List': NiaapiApicSweolList,
            'niaapi.DcnmCcoPost.List': NiaapiDcnmCcoPostList,
            'niaapi.DcnmFieldNotice.List': NiaapiDcnmFieldNoticeList,
            'niaapi.DcnmHweol.List': NiaapiDcnmHweolList,
            'niaapi.DcnmLatestMaintainedRelease.List': NiaapiDcnmLatestMaintainedReleaseList,
            'niaapi.DcnmReleaseRecommend.List': NiaapiDcnmReleaseRecommendList,
            'niaapi.DcnmSweol.List': NiaapiDcnmSweolList,
            'niaapi.FileDownloader.List': NiaapiFileDownloaderList,
            'niaapi.NiaMetadata.List': NiaapiNiaMetadataList,
            'niaapi.NibFileDownloader.List': NiaapiNibFileDownloaderList,
            'niaapi.NibMetadata.List': NiaapiNibMetadataList,
            'niaapi.VersionRegex.List': NiaapiVersionRegexList,
            'niatelemetry.AaaLdapProviderDetails.List': NiatelemetryAaaLdapProviderDetailsList,
            'niatelemetry.AaaRadiusProviderDetails.List': NiatelemetryAaaRadiusProviderDetailsList,
            'niatelemetry.AaaTacacsProviderDetails.List': NiatelemetryAaaTacacsProviderDetailsList,
            'niatelemetry.ApicAppPluginDetails.List': NiatelemetryApicAppPluginDetailsList,
            'niatelemetry.ApicCoreFileDetails.List': NiatelemetryApicCoreFileDetailsList,
            'niatelemetry.ApicDbgexpRsExportDest.List': NiatelemetryApicDbgexpRsExportDestList,
            'niatelemetry.ApicDbgexpRsTsScheduler.List': NiatelemetryApicDbgexpRsTsSchedulerList,
            'niatelemetry.ApicFanDetails.List': NiatelemetryApicFanDetailsList,
            'niatelemetry.ApicFexDetails.List': NiatelemetryApicFexDetailsList,
            'niatelemetry.ApicFlashDetails.List': NiatelemetryApicFlashDetailsList,
            'niatelemetry.ApicNtpAuth.List': NiatelemetryApicNtpAuthList,
            'niatelemetry.ApicPsuDetails.List': NiatelemetryApicPsuDetailsList,
            'niatelemetry.ApicRealmDetails.List': NiatelemetryApicRealmDetailsList,
            'niatelemetry.ApicSnmpClientGrpDetails.List': NiatelemetryApicSnmpClientGrpDetailsList,
            'niatelemetry.ApicSnmpCommunityAccessDetails.List': NiatelemetryApicSnmpCommunityAccessDetailsList,
            'niatelemetry.ApicSnmpCommunityDetails.List': NiatelemetryApicSnmpCommunityDetailsList,
            'niatelemetry.ApicSnmpTrapDetails.List': NiatelemetryApicSnmpTrapDetailsList,
            'niatelemetry.ApicSnmpTrapFwdServerDetails.List': NiatelemetryApicSnmpTrapFwdServerDetailsList,
            'niatelemetry.ApicSnmpVersionThreeDetails.List': NiatelemetryApicSnmpVersionThreeDetailsList,
            'niatelemetry.ApicSysLogGrp.List': NiatelemetryApicSysLogGrpList,
            'niatelemetry.ApicSysLogSrc.List': NiatelemetryApicSysLogSrcList,
            'niatelemetry.ApicTransceiverDetails.List': NiatelemetryApicTransceiverDetailsList,
            'niatelemetry.ApicUiPageCounts.List': NiatelemetryApicUiPageCountsList,
            'niatelemetry.AppDetails.List': NiatelemetryAppDetailsList,
            'niatelemetry.CommonPolicies.List': NiatelemetryCommonPoliciesList,
            'niatelemetry.DcnmFanDetails.List': NiatelemetryDcnmFanDetailsList,
            'niatelemetry.DcnmFexDetails.List': NiatelemetryDcnmFexDetailsList,
            'niatelemetry.DcnmModuleDetails.List': NiatelemetryDcnmModuleDetailsList,
            'niatelemetry.DcnmPsuDetails.List': NiatelemetryDcnmPsuDetailsList,
            'niatelemetry.DcnmTransceiverDetails.List': NiatelemetryDcnmTransceiverDetailsList,
            'niatelemetry.Epg.List': NiatelemetryEpgList,
            'niatelemetry.FabricModuleDetails.List': NiatelemetryFabricModuleDetailsList,
            'niatelemetry.FabricNodeControlDetails.List': NiatelemetryFabricNodeControlDetailsList,
            'niatelemetry.FabricPodProfile.List': NiatelemetryFabricPodProfileList,
            'niatelemetry.FabricPodSs.List': NiatelemetryFabricPodSsList,
            'niatelemetry.Fault.List': NiatelemetryFaultList,
            'niatelemetry.HttpsAclContractDetails.List': NiatelemetryHttpsAclContractDetailsList,
            'niatelemetry.HttpsAclContractFilterMap.List': NiatelemetryHttpsAclContractFilterMapList,
            'niatelemetry.HttpsAclEpgContractMap.List': NiatelemetryHttpsAclEpgContractMapList,
            'niatelemetry.HttpsAclEpgDetails.List': NiatelemetryHttpsAclEpgDetailsList,
            'niatelemetry.HttpsAclFilterDetails.List': NiatelemetryHttpsAclFilterDetailsList,
            'niatelemetry.InsightGroupDetails.List': NiatelemetryInsightGroupDetailsList,
            'niatelemetry.Lc.List': NiatelemetryLcList,
            'niatelemetry.LeafPolGrpDetails.List': NiatelemetryLeafPolGrpDetailsList,
            'niatelemetry.MsoContractDetails.List': NiatelemetryMsoContractDetailsList,
            'niatelemetry.MsoEpgDetails.List': NiatelemetryMsoEpgDetailsList,
            'niatelemetry.MsoSchemaDetails.List': NiatelemetryMsoSchemaDetailsList,
            'niatelemetry.MsoSiteDetails.List': NiatelemetryMsoSiteDetailsList,
            'niatelemetry.MsoTenantDetails.List': NiatelemetryMsoTenantDetailsList,
            'niatelemetry.NexusDashboardControllerDetails.List': NiatelemetryNexusDashboardControllerDetailsList,
            'niatelemetry.NexusDashboardDetails.List': NiatelemetryNexusDashboardDetailsList,
            'niatelemetry.NexusDashboardMemoryDetails.List': NiatelemetryNexusDashboardMemoryDetailsList,
            'niatelemetry.NexusDashboards.List': NiatelemetryNexusDashboardsList,
            'niatelemetry.NiaFeatureUsage.List': NiatelemetryNiaFeatureUsageList,
            'niatelemetry.NiaInventory.List': NiatelemetryNiaInventoryList,
            'niatelemetry.NiaInventoryDcnm.List': NiatelemetryNiaInventoryDcnmList,
            'niatelemetry.NiaInventoryFabric.List': NiatelemetryNiaInventoryFabricList,
            'niatelemetry.NiaLicenseState.List': NiatelemetryNiaLicenseStateList,
            'niatelemetry.PasswordStrengthCheck.List': NiatelemetryPasswordStrengthCheckList,
            'niatelemetry.PodCommPolicies.List': NiatelemetryPodCommPoliciesList,
            'niatelemetry.PodSnmpPolicies.List': NiatelemetryPodSnmpPoliciesList,
            'niatelemetry.PodTimeServerPolicies.List': NiatelemetryPodTimeServerPoliciesList,
            'niatelemetry.SiteInventory.List': NiatelemetrySiteInventoryList,
            'niatelemetry.SnmpSrc.List': NiatelemetrySnmpSrcList,
            'niatelemetry.SpinePolGrpDetails.List': NiatelemetrySpinePolGrpDetailsList,
            'niatelemetry.SshVersionTwo.List': NiatelemetrySshVersionTwoList,
            'niatelemetry.SupervisorModuleDetails.List': NiatelemetrySupervisorModuleDetailsList,
            'niatelemetry.SyslogRemoteDest.List': NiatelemetrySyslogRemoteDestList,
            'niatelemetry.SyslogSysMsg.List': NiatelemetrySyslogSysMsgList,
            'niatelemetry.SyslogSysMsgFacFilter.List': NiatelemetrySyslogSysMsgFacFilterList,
            'niatelemetry.SystemControllerDetails.List': NiatelemetrySystemControllerDetailsList,
            'niatelemetry.Tenant.List': NiatelemetryTenantList,
            'notification.AccountSubscription.List': NotificationAccountSubscriptionList,
            'ntp.Policy.List': NtpPolicyList,
            'oauth.AccessToken.List': OauthAccessTokenList,
            'oauth.Authorization.List': OauthAuthorizationList,
            'oprs.Deployment.List': OprsDeploymentList,
            'oprs.SyncTargetListMessage.List': OprsSyncTargetListMessageList,
            'organization.Organization.List': OrganizationOrganizationList,
            'os.BulkInstallInfo.List': OsBulkInstallInfoList,
            'os.Catalog.List': OsCatalogList,
            'os.ConfigurationFile.List': OsConfigurationFileList,
            'os.Distribution.List': OsDistributionList,
            'os.Install.List': OsInstallList,
            'os.SupportedVersion.List': OsSupportedVersionList,
            'pci.CoprocessorCard.List': PciCoprocessorCardList,
            'pci.Device.List': PciDeviceList,
            'pci.Link.List': PciLinkList,
            'pci.Switch.List': PciSwitchList,
            'port.Group.List': PortGroupList,
            'port.MacBinding.List': PortMacBindingList,
            'port.SubGroup.List': PortSubGroupList,
            'power.ControlState.List': PowerControlStateList,
            'power.Policy.List': PowerPolicyList,
            'processor.Unit.List': ProcessorUnitList,
            'rack.UnitPersonality.List': RackUnitPersonalityList,
            'recommendation.CapacityRunway.List': RecommendationCapacityRunwayList,
            'recommendation.PhysicalItem.List': RecommendationPhysicalItemList,
            'recovery.BackupConfigPolicy.List': RecoveryBackupConfigPolicyList,
            'recovery.BackupProfile.List': RecoveryBackupProfileList,
            'recovery.ConfigResult.List': RecoveryConfigResultList,
            'recovery.ConfigResultEntry.List': RecoveryConfigResultEntryList,
            'recovery.OnDemandBackup.List': RecoveryOnDemandBackupList,
            'recovery.Restore.List': RecoveryRestoreList,
            'recovery.ScheduleConfigPolicy.List': RecoveryScheduleConfigPolicyList,
            'resource.Group.List': ResourceGroupList,
            'resource.GroupMember.List': ResourceGroupMemberList,
            'resource.LicenseResourceCount.List': ResourceLicenseResourceCountList,
            'resource.Membership.List': ResourceMembershipList,
            'resource.MembershipHolder.List': ResourceMembershipHolderList,
            'resource.Reservation.List': ResourceReservationList,
            'resourcepool.Lease.List': ResourcepoolLeaseList,
            'resourcepool.LeaseResource.List': ResourcepoolLeaseResourceList,
            'resourcepool.Pool.List': ResourcepoolPoolList,
            'resourcepool.PoolMember.List': ResourcepoolPoolMemberList,
            'resourcepool.Universe.List': ResourcepoolUniverseList,
            'sdcard.Policy.List': SdcardPolicyList,
            'search.SearchItem.List': SearchSearchItemList,
            'search.SuggestItem.List': SearchSuggestItemList,
            'search.TagItem.List': SearchTagItemList,
            'security.Unit.List': SecurityUnitList,
            'server.ConfigChangeDetail.List': ServerConfigChangeDetailList,
            'server.ConfigImport.List': ServerConfigImportList,
            'server.ConfigResult.List': ServerConfigResultList,
            'server.ConfigResultEntry.List': ServerConfigResultEntryList,
            'server.Profile.List': ServerProfileList,
            'server.ProfileTemplate.List': ServerProfileTemplateList,
            'smtp.Policy.List': SmtpPolicyList,
            'snmp.Policy.List': SnmpPolicyList,
            'software.ApplianceDistributable.List': SoftwareApplianceDistributableList,
            'software.DownloadHistory.List': SoftwareDownloadHistoryList,
            'software.HclMeta.List': SoftwareHclMetaList,
            'software.HyperflexBundleDistributable.List': SoftwareHyperflexBundleDistributableList,
            'software.HyperflexDistributable.List': SoftwareHyperflexDistributableList,
            'software.ReleaseMeta.List': SoftwareReleaseMetaList,
            'software.SolutionDistributable.List': SoftwareSolutionDistributableList,
            'software.UcsdBundleDistributable.List': SoftwareUcsdBundleDistributableList,
            'software.UcsdDistributable.List': SoftwareUcsdDistributableList,
            'softwarerepository.Authorization.List': SoftwarerepositoryAuthorizationList,
            'softwarerepository.CachedImage.List': SoftwarerepositoryCachedImageList,
            'softwarerepository.Catalog.List': SoftwarerepositoryCatalogList,
            'softwarerepository.CategoryMapper.List': SoftwarerepositoryCategoryMapperList,
            'softwarerepository.CategoryMapperModel.List': SoftwarerepositoryCategoryMapperModelList,
            'softwarerepository.CategorySupportConstraint.List': SoftwarerepositoryCategorySupportConstraintList,
            'softwarerepository.DownloadSpec.List': SoftwarerepositoryDownloadSpecList,
            'softwarerepository.OperatingSystemFile.List': SoftwarerepositoryOperatingSystemFileList,
            'softwarerepository.Release.List': SoftwarerepositoryReleaseList,
            'sol.Policy.List': SolPolicyList,
            'ssh.Policy.List': SshPolicyList,
            'storage.Controller.List': StorageControllerList,
            'storage.DiskGroup.List': StorageDiskGroupList,
            'storage.DiskSlot.List': StorageDiskSlotList,
            'storage.DriveGroup.List': StorageDriveGroupList,
            'storage.Enclosure.List': StorageEnclosureList,
            'storage.EnclosureDisk.List': StorageEnclosureDiskList,
            'storage.EnclosureDiskSlotEp.List': StorageEnclosureDiskSlotEpList,
            'storage.FlexFlashController.List': StorageFlexFlashControllerList,
            'storage.FlexFlashControllerProps.List': StorageFlexFlashControllerPropsList,
            'storage.FlexFlashPhysicalDrive.List': StorageFlexFlashPhysicalDriveList,
            'storage.FlexFlashVirtualDrive.List': StorageFlexFlashVirtualDriveList,
            'storage.FlexUtilController.List': StorageFlexUtilControllerList,
            'storage.FlexUtilPhysicalDrive.List': StorageFlexUtilPhysicalDriveList,
            'storage.FlexUtilVirtualDrive.List': StorageFlexUtilVirtualDriveList,
            'storage.HitachiArray.List': StorageHitachiArrayList,
            'storage.HitachiController.List': StorageHitachiControllerList,
            'storage.HitachiDisk.List': StorageHitachiDiskList,
            'storage.HitachiHost.List': StorageHitachiHostList,
            'storage.HitachiHostLun.List': StorageHitachiHostLunList,
            'storage.HitachiParityGroup.List': StorageHitachiParityGroupList,
            'storage.HitachiPool.List': StorageHitachiPoolList,
            'storage.HitachiPort.List': StorageHitachiPortList,
            'storage.HitachiVolume.List': StorageHitachiVolumeList,
            'storage.HyperFlexStorageContainer.List': StorageHyperFlexStorageContainerList,
            'storage.HyperFlexVolume.List': StorageHyperFlexVolumeList,
            'storage.Item.List': StorageItemList,
            'storage.NetAppAggregate.List': StorageNetAppAggregateList,
            'storage.NetAppAggregateEvent.List': StorageNetAppAggregateEventList,
            'storage.NetAppBaseDisk.List': StorageNetAppBaseDiskList,
            'storage.NetAppCluster.List': StorageNetAppClusterList,
            'storage.NetAppClusterEvent.List': StorageNetAppClusterEventList,
            'storage.NetAppDiskEvent.List': StorageNetAppDiskEventList,
            'storage.NetAppEthernetPort.List': StorageNetAppEthernetPortList,
            'storage.NetAppEthernetPortEvent.List': StorageNetAppEthernetPortEventList,
            'storage.NetAppExportPolicy.List': StorageNetAppExportPolicyList,
            'storage.NetAppFcInterface.List': StorageNetAppFcInterfaceList,
            'storage.NetAppFcInterfaceEvent.List': StorageNetAppFcInterfaceEventList,
            'storage.NetAppFcPort.List': StorageNetAppFcPortList,
            'storage.NetAppFcPortEvent.List': StorageNetAppFcPortEventList,
            'storage.NetAppInitiatorGroup.List': StorageNetAppInitiatorGroupList,
            'storage.NetAppIpInterface.List': StorageNetAppIpInterfaceList,
            'storage.NetAppIpInterfaceEvent.List': StorageNetAppIpInterfaceEventList,
            'storage.NetAppLicense.List': StorageNetAppLicenseList,
            'storage.NetAppLun.List': StorageNetAppLunList,
            'storage.NetAppLunEvent.List': StorageNetAppLunEventList,
            'storage.NetAppLunMap.List': StorageNetAppLunMapList,
            'storage.NetAppNode.List': StorageNetAppNodeList,
            'storage.NetAppNodeEvent.List': StorageNetAppNodeEventList,
            'storage.NetAppNtpServer.List': StorageNetAppNtpServerList,
            'storage.NetAppSensor.List': StorageNetAppSensorList,
            'storage.NetAppStorageVm.List': StorageNetAppStorageVmList,
            'storage.NetAppSvmEvent.List': StorageNetAppSvmEventList,
            'storage.NetAppVolume.List': StorageNetAppVolumeList,
            'storage.NetAppVolumeEvent.List': StorageNetAppVolumeEventList,
            'storage.NetAppVolumeSnapshot.List': StorageNetAppVolumeSnapshotList,
            'storage.PhysicalDisk.List': StoragePhysicalDiskList,
            'storage.PhysicalDiskExtension.List': StoragePhysicalDiskExtensionList,
            'storage.PhysicalDiskUsage.List': StoragePhysicalDiskUsageList,
            'storage.PureArray.List': StoragePureArrayList,
            'storage.PureController.List': StoragePureControllerList,
            'storage.PureDisk.List': StoragePureDiskList,
            'storage.PureHost.List': StoragePureHostList,
            'storage.PureHostGroup.List': StoragePureHostGroupList,
            'storage.PureHostLun.List': StoragePureHostLunList,
            'storage.PurePort.List': StoragePurePortList,
            'storage.PureProtectionGroup.List': StoragePureProtectionGroupList,
            'storage.PureProtectionGroupSnapshot.List': StoragePureProtectionGroupSnapshotList,
            'storage.PureReplicationSchedule.List': StoragePureReplicationScheduleList,
            'storage.PureSnapshotSchedule.List': StoragePureSnapshotScheduleList,
            'storage.PureVolume.List': StoragePureVolumeList,
            'storage.PureVolumeSnapshot.List': StoragePureVolumeSnapshotList,
            'storage.SasExpander.List': StorageSasExpanderList,
            'storage.SasPort.List': StorageSasPortList,
            'storage.Span.List': StorageSpanList,
            'storage.StoragePolicy.List': StorageStoragePolicyList,
            'storage.VdMemberEp.List': StorageVdMemberEpList,
            'storage.VirtualDrive.List': StorageVirtualDriveList,
            'storage.VirtualDriveContainer.List': StorageVirtualDriveContainerList,
            'storage.VirtualDriveExtension.List': StorageVirtualDriveExtensionList,
            'storage.VirtualDriveIdentity.List': StorageVirtualDriveIdentityList,
            'syslog.Policy.List': SyslogPolicyList,
            'tam.AdvisoryCount.List': TamAdvisoryCountList,
            'tam.AdvisoryDefinition.List': TamAdvisoryDefinitionList,
            'tam.AdvisoryInfo.List': TamAdvisoryInfoList,
            'tam.AdvisoryInstance.List': TamAdvisoryInstanceList,
            'tam.SecurityAdvisory.List': TamSecurityAdvisoryList,
            'techsupportmanagement.CollectionControlPolicy.List': TechsupportmanagementCollectionControlPolicyList,
            'techsupportmanagement.Download.List': TechsupportmanagementDownloadList,
            'techsupportmanagement.TechSupportBundle.List': TechsupportmanagementTechSupportBundleList,
            'techsupportmanagement.TechSupportStatus.List': TechsupportmanagementTechSupportStatusList,
            'terminal.AuditLog.List': TerminalAuditLogList,
            'terraform.Executor.List': TerraformExecutorList,
            'thermal.Policy.List': ThermalPolicyList,
            'top.System.List': TopSystemList,
            'ucsd.BackupInfo.List': UcsdBackupInfoList,
            'uuidpool.Block.List': UuidpoolBlockList,
            'uuidpool.Pool.List': UuidpoolPoolList,
            'uuidpool.PoolMember.List': UuidpoolPoolMemberList,
            'uuidpool.Universe.List': UuidpoolUniverseList,
            'uuidpool.UuidLease.List': UuidpoolUuidLeaseList,
            'view.Server.List': ViewServerList,
            'virtualization.CiscoHypervisorManager.List': VirtualizationCiscoHypervisorManagerList,
            'virtualization.EsxiConsole.List': VirtualizationEsxiConsoleList,
            'virtualization.Host.List': VirtualizationHostList,
            'virtualization.IweCluster.List': VirtualizationIweClusterList,
            'virtualization.IweDatacenter.List': VirtualizationIweDatacenterList,
            'virtualization.IweDvUplink.List': VirtualizationIweDvUplinkList,
            'virtualization.IweDvswitch.List': VirtualizationIweDvswitchList,
            'virtualization.IweHost.List': VirtualizationIweHostList,
            'virtualization.IweHostInterface.List': VirtualizationIweHostInterfaceList,
            'virtualization.IweHostVswitch.List': VirtualizationIweHostVswitchList,
            'virtualization.IweNetwork.List': VirtualizationIweNetworkList,
            'virtualization.IweVirtualDisk.List': VirtualizationIweVirtualDiskList,
            'virtualization.IweVirtualMachine.List': VirtualizationIweVirtualMachineList,
            'virtualization.IweVirtualMachineNetworkInterface.List': VirtualizationIweVirtualMachineNetworkInterfaceList,
            'virtualization.VirtualDisk.List': VirtualizationVirtualDiskList,
            'virtualization.VirtualMachine.List': VirtualizationVirtualMachineList,
            'virtualization.VirtualNetwork.List': VirtualizationVirtualNetworkList,
            'virtualization.VmwareCluster.List': VirtualizationVmwareClusterList,
            'virtualization.VmwareDatacenter.List': VirtualizationVmwareDatacenterList,
            'virtualization.VmwareDatastore.List': VirtualizationVmwareDatastoreList,
            'virtualization.VmwareDatastoreCluster.List': VirtualizationVmwareDatastoreClusterList,
            'virtualization.VmwareDistributedNetwork.List': VirtualizationVmwareDistributedNetworkList,
            'virtualization.VmwareDistributedSwitch.List': VirtualizationVmwareDistributedSwitchList,
            'virtualization.VmwareFolder.List': VirtualizationVmwareFolderList,
            'virtualization.VmwareHost.List': VirtualizationVmwareHostList,
            'virtualization.VmwareKernelNetwork.List': VirtualizationVmwareKernelNetworkList,
            'virtualization.VmwareNetwork.List': VirtualizationVmwareNetworkList,
            'virtualization.VmwarePhysicalNetworkInterface.List': VirtualizationVmwarePhysicalNetworkInterfaceList,
            'virtualization.VmwareUplinkPort.List': VirtualizationVmwareUplinkPortList,
            'virtualization.VmwareVcenter.List': VirtualizationVmwareVcenterList,
            'virtualization.VmwareVirtualDisk.List': VirtualizationVmwareVirtualDiskList,
            'virtualization.VmwareVirtualMachine.List': VirtualizationVmwareVirtualMachineList,
            'virtualization.VmwareVirtualMachineSnapshot.List': VirtualizationVmwareVirtualMachineSnapshotList,
            'virtualization.VmwareVirtualNetworkInterface.List': VirtualizationVmwareVirtualNetworkInterfaceList,
            'virtualization.VmwareVirtualSwitch.List': VirtualizationVmwareVirtualSwitchList,
            'vmedia.Policy.List': VmediaPolicyList,
            'vmrc.Console.List': VmrcConsoleList,
            'vnc.Console.List': VncConsoleList,
            'vnic.EthAdapterPolicy.List': VnicEthAdapterPolicyList,
            'vnic.EthIf.List': VnicEthIfList,
            'vnic.EthNetworkPolicy.List': VnicEthNetworkPolicyList,
            'vnic.EthQosPolicy.List': VnicEthQosPolicyList,
            'vnic.FcAdapterPolicy.List': VnicFcAdapterPolicyList,
            'vnic.FcIf.List': VnicFcIfList,
            'vnic.FcNetworkPolicy.List': VnicFcNetworkPolicyList,
            'vnic.FcQosPolicy.List': VnicFcQosPolicyList,
            'vnic.IscsiAdapterPolicy.List': VnicIscsiAdapterPolicyList,
            'vnic.IscsiBootPolicy.List': VnicIscsiBootPolicyList,
            'vnic.IscsiStaticTargetPolicy.List': VnicIscsiStaticTargetPolicyList,
            'vnic.LanConnectivityPolicy.List': VnicLanConnectivityPolicyList,
            'vnic.LcpStatus.List': VnicLcpStatusList,
            'vnic.SanConnectivityPolicy.List': VnicSanConnectivityPolicyList,
            'vnic.ScpStatus.List': VnicScpStatusList,
            'vrf.Vrf.List': VrfVrfList,
            'workflow.AnsibleBatchExecutor.List': WorkflowAnsibleBatchExecutorList,
            'workflow.BatchApiExecutor.List': WorkflowBatchApiExecutorList,
            'workflow.BuildTaskMeta.List': WorkflowBuildTaskMetaList,
            'workflow.BuildTaskMetaOwner.List': WorkflowBuildTaskMetaOwnerList,
            'workflow.Catalog.List': WorkflowCatalogList,
            'workflow.CustomDataTypeDefinition.List': WorkflowCustomDataTypeDefinitionList,
            'workflow.ErrorResponseHandler.List': WorkflowErrorResponseHandlerList,
            'workflow.PendingDynamicWorkflowInfo.List': WorkflowPendingDynamicWorkflowInfoList,
            'workflow.RollbackWorkflow.List': WorkflowRollbackWorkflowList,
            'workflow.ServiceItemActionDefinition.List': WorkflowServiceItemActionDefinitionList,
            'workflow.ServiceItemActionInstance.List': WorkflowServiceItemActionInstanceList,
            'workflow.ServiceItemDefinition.List': WorkflowServiceItemDefinitionList,
            'workflow.ServiceItemInstance.List': WorkflowServiceItemInstanceList,
            'workflow.ServiceItemOutput.List': WorkflowServiceItemOutputList,
            'workflow.SolutionActionDefinition.List': WorkflowSolutionActionDefinitionList,
            'workflow.SolutionActionInstance.List': WorkflowSolutionActionInstanceList,
            'workflow.SolutionDefinition.List': WorkflowSolutionDefinitionList,
            'workflow.SolutionInstance.List': WorkflowSolutionInstanceList,
            'workflow.SolutionOutput.List': WorkflowSolutionOutputList,
            'workflow.SshBatchExecutor.List': WorkflowSshBatchExecutorList,
            'workflow.TaskDebugLog.List': WorkflowTaskDebugLogList,
            'workflow.TaskDefinition.List': WorkflowTaskDefinitionList,
            'workflow.TaskInfo.List': WorkflowTaskInfoList,
            'workflow.TaskMetadata.List': WorkflowTaskMetadataList,
            'workflow.TemplateFunctionMeta.List': WorkflowTemplateFunctionMetaList,
            'workflow.WorkflowDefinition.List': WorkflowWorkflowDefinitionList,
            'workflow.WorkflowInfo.List': WorkflowWorkflowInfoList,
            'workflow.WorkflowMeta.List': WorkflowWorkflowMetaList,
            'workflow.WorkflowMetadata.List': WorkflowWorkflowMetadataList,
        }
        if not val:
            return None
        return {'object_type': val}

    attribute_map = {
        'object_type': 'ObjectType',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, object_type, *args, **kwargs):  # noqa: E501
        """MoBaseResponse - a model defined in OpenAPI

        Args:
            object_type (str): A discriminator value to disambiguate the schema of a HTTP GET response body.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
