"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-5808
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from intersight.model.adapter_unit_relationship import AdapterUnitRelationship
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.bios_boot_mode_relationship import BiosBootModeRelationship
    from intersight.model.bios_token_settings_relationship import BiosTokenSettingsRelationship
    from intersight.model.bios_unit_relationship import BiosUnitRelationship
    from intersight.model.bios_vf_select_memory_ras_configuration_relationship import BiosVfSelectMemoryRasConfigurationRelationship
    from intersight.model.boot_cdd_device_relationship import BootCddDeviceRelationship
    from intersight.model.boot_device_boot_mode_relationship import BootDeviceBootModeRelationship
    from intersight.model.boot_device_boot_security_relationship import BootDeviceBootSecurityRelationship
    from intersight.model.boot_hdd_device_relationship import BootHddDeviceRelationship
    from intersight.model.boot_iscsi_device_relationship import BootIscsiDeviceRelationship
    from intersight.model.boot_nvme_device_relationship import BootNvmeDeviceRelationship
    from intersight.model.boot_pch_storage_device_relationship import BootPchStorageDeviceRelationship
    from intersight.model.boot_pxe_device_relationship import BootPxeDeviceRelationship
    from intersight.model.boot_san_device_relationship import BootSanDeviceRelationship
    from intersight.model.boot_sd_device_relationship import BootSdDeviceRelationship
    from intersight.model.boot_uefi_shell_device_relationship import BootUefiShellDeviceRelationship
    from intersight.model.boot_usb_device_relationship import BootUsbDeviceRelationship
    from intersight.model.boot_vmedia_device_relationship import BootVmediaDeviceRelationship
    from intersight.model.compute_alarm_summary import ComputeAlarmSummary
    from intersight.model.compute_blade_all_of import ComputeBladeAllOf
    from intersight.model.compute_board_relationship import ComputeBoardRelationship
    from intersight.model.compute_ip_address import ComputeIpAddress
    from intersight.model.compute_physical import ComputePhysical
    from intersight.model.compute_vmedia_relationship import ComputeVmediaRelationship
    from intersight.model.display_names import DisplayNames
    from intersight.model.equipment_chassis_relationship import EquipmentChassisRelationship
    from intersight.model.equipment_fru_relationship import EquipmentFruRelationship
    from intersight.model.equipment_io_expander_relationship import EquipmentIoExpanderRelationship
    from intersight.model.equipment_locator_led_relationship import EquipmentLocatorLedRelationship
    from intersight.model.equipment_physical_identity_relationship import EquipmentPhysicalIdentityRelationship
    from intersight.model.graphics_card_relationship import GraphicsCardRelationship
    from intersight.model.inventory_device_info_relationship import InventoryDeviceInfoRelationship
    from intersight.model.inventory_generic_inventory_holder_relationship import InventoryGenericInventoryHolderRelationship
    from intersight.model.management_controller_relationship import ManagementControllerRelationship
    from intersight.model.memory_array_relationship import MemoryArrayRelationship
    from intersight.model.mo_base_mo_relationship import MoBaseMoRelationship
    from intersight.model.mo_tag import MoTag
    from intersight.model.mo_version_context import MoVersionContext
    from intersight.model.pci_device_relationship import PciDeviceRelationship
    from intersight.model.processor_unit_relationship import ProcessorUnitRelationship
    from intersight.model.storage_controller_relationship import StorageControllerRelationship
    from intersight.model.storage_enclosure_relationship import StorageEnclosureRelationship
    from intersight.model.top_system_relationship import TopSystemRelationship
    globals()['AdapterUnitRelationship'] = AdapterUnitRelationship
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['BiosBootModeRelationship'] = BiosBootModeRelationship
    globals()['BiosTokenSettingsRelationship'] = BiosTokenSettingsRelationship
    globals()['BiosUnitRelationship'] = BiosUnitRelationship
    globals()['BiosVfSelectMemoryRasConfigurationRelationship'] = BiosVfSelectMemoryRasConfigurationRelationship
    globals()['BootCddDeviceRelationship'] = BootCddDeviceRelationship
    globals()['BootDeviceBootModeRelationship'] = BootDeviceBootModeRelationship
    globals()['BootDeviceBootSecurityRelationship'] = BootDeviceBootSecurityRelationship
    globals()['BootHddDeviceRelationship'] = BootHddDeviceRelationship
    globals()['BootIscsiDeviceRelationship'] = BootIscsiDeviceRelationship
    globals()['BootNvmeDeviceRelationship'] = BootNvmeDeviceRelationship
    globals()['BootPchStorageDeviceRelationship'] = BootPchStorageDeviceRelationship
    globals()['BootPxeDeviceRelationship'] = BootPxeDeviceRelationship
    globals()['BootSanDeviceRelationship'] = BootSanDeviceRelationship
    globals()['BootSdDeviceRelationship'] = BootSdDeviceRelationship
    globals()['BootUefiShellDeviceRelationship'] = BootUefiShellDeviceRelationship
    globals()['BootUsbDeviceRelationship'] = BootUsbDeviceRelationship
    globals()['BootVmediaDeviceRelationship'] = BootVmediaDeviceRelationship
    globals()['ComputeAlarmSummary'] = ComputeAlarmSummary
    globals()['ComputeBladeAllOf'] = ComputeBladeAllOf
    globals()['ComputeBoardRelationship'] = ComputeBoardRelationship
    globals()['ComputeIpAddress'] = ComputeIpAddress
    globals()['ComputePhysical'] = ComputePhysical
    globals()['ComputeVmediaRelationship'] = ComputeVmediaRelationship
    globals()['DisplayNames'] = DisplayNames
    globals()['EquipmentChassisRelationship'] = EquipmentChassisRelationship
    globals()['EquipmentFruRelationship'] = EquipmentFruRelationship
    globals()['EquipmentIoExpanderRelationship'] = EquipmentIoExpanderRelationship
    globals()['EquipmentLocatorLedRelationship'] = EquipmentLocatorLedRelationship
    globals()['EquipmentPhysicalIdentityRelationship'] = EquipmentPhysicalIdentityRelationship
    globals()['GraphicsCardRelationship'] = GraphicsCardRelationship
    globals()['InventoryDeviceInfoRelationship'] = InventoryDeviceInfoRelationship
    globals()['InventoryGenericInventoryHolderRelationship'] = InventoryGenericInventoryHolderRelationship
    globals()['ManagementControllerRelationship'] = ManagementControllerRelationship
    globals()['MemoryArrayRelationship'] = MemoryArrayRelationship
    globals()['MoBaseMoRelationship'] = MoBaseMoRelationship
    globals()['MoTag'] = MoTag
    globals()['MoVersionContext'] = MoVersionContext
    globals()['PciDeviceRelationship'] = PciDeviceRelationship
    globals()['ProcessorUnitRelationship'] = ProcessorUnitRelationship
    globals()['StorageControllerRelationship'] = StorageControllerRelationship
    globals()['StorageEnclosureRelationship'] = StorageEnclosureRelationship
    globals()['TopSystemRelationship'] = TopSystemRelationship


class ComputeBlade(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'COMPUTE.BLADE': "compute.Blade",
        },
        ('object_type',): {
            'COMPUTE.BLADE': "compute.Blade",
        },
        ('management_mode',): {
            'INTERSIGHTSTANDALONE': "IntersightStandalone",
            'UCSM': "UCSM",
            'INTERSIGHT': "Intersight",
        },
        ('oper_reason',): {
            'None': None,
            'UNKNOWN': "Unknown",
            'WILLBOOTERROR': "WillBootError",
            'MEMORYINOPERABLE': "MemoryInoperable",
            'PROCESSORINOPERABLE': "ProcessorInoperable",
            'DEPRECATEDADAPTER': "DeprecatedAdapter",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'chassis_id': (str,),  # noqa: E501
            'scaled_mode': (str,),  # noqa: E501
            'slot_id': (int,),  # noqa: E501
            'adapters': ([AdapterUnitRelationship], none_type,),  # noqa: E501
            'bios_bootmode': (BiosBootModeRelationship,),  # noqa: E501
            'bios_token_settings': (BiosTokenSettingsRelationship,),  # noqa: E501
            'bios_units': ([BiosUnitRelationship], none_type,),  # noqa: E501
            'bios_vf_select_memory_ras_configuration': (BiosVfSelectMemoryRasConfigurationRelationship,),  # noqa: E501
            'bmc': (ManagementControllerRelationship,),  # noqa: E501
            'board': (ComputeBoardRelationship,),  # noqa: E501
            'boot_device_bootmode': (BootDeviceBootModeRelationship,),  # noqa: E501
            'equipment_chassis': (EquipmentChassisRelationship,),  # noqa: E501
            'equipment_io_expanders': ([EquipmentIoExpanderRelationship], none_type,),  # noqa: E501
            'generic_inventory_holders': ([InventoryGenericInventoryHolderRelationship], none_type,),  # noqa: E501
            'graphics_cards': ([GraphicsCardRelationship], none_type,),  # noqa: E501
            'inventory_device_info': (InventoryDeviceInfoRelationship,),  # noqa: E501
            'locator_led': (EquipmentLocatorLedRelationship,),  # noqa: E501
            'memory_arrays': ([MemoryArrayRelationship], none_type,),  # noqa: E501
            'pci_devices': ([PciDeviceRelationship], none_type,),  # noqa: E501
            'processors': ([ProcessorUnitRelationship], none_type,),  # noqa: E501
            'registered_device': (AssetDeviceRegistrationRelationship,),  # noqa: E501
            'storage_controllers': ([StorageControllerRelationship], none_type,),  # noqa: E501
            'storage_enclosures': ([StorageEnclosureRelationship], none_type,),  # noqa: E501
            'top_system': (TopSystemRelationship,),  # noqa: E501
            'account_moid': (str,),  # noqa: E501
            'create_time': (datetime,),  # noqa: E501
            'domain_group_moid': (str,),  # noqa: E501
            'mod_time': (datetime,),  # noqa: E501
            'moid': (str,),  # noqa: E501
            'owners': ([str], none_type,),  # noqa: E501
            'shared_scope': (str,),  # noqa: E501
            'tags': ([MoTag], none_type,),  # noqa: E501
            'version_context': (MoVersionContext,),  # noqa: E501
            'ancestors': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'parent': (MoBaseMoRelationship,),  # noqa: E501
            'permission_resources': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'display_names': (DisplayNames,),  # noqa: E501
            'device_mo_id': (str,),  # noqa: E501
            'dn': (str,),  # noqa: E501
            'rn': (str,),  # noqa: E501
            'model': (str,),  # noqa: E501
            'presence': (str,),  # noqa: E501
            'revision': (str,),  # noqa: E501
            'serial': (str,),  # noqa: E501
            'vendor': (str,),  # noqa: E501
            'previous_fru': (EquipmentFruRelationship,),  # noqa: E501
            'admin_power_state': (str,),  # noqa: E501
            'alarm_summary': (ComputeAlarmSummary,),  # noqa: E501
            'asset_tag': (str,),  # noqa: E501
            'available_memory': (int,),  # noqa: E501
            'bios_post_complete': (bool,),  # noqa: E501
            'fault_summary': (int,),  # noqa: E501
            'hardware_uuid': (str,),  # noqa: E501
            'kvm_ip_addresses': ([ComputeIpAddress], none_type,),  # noqa: E501
            'management_mode': (str,),  # noqa: E501
            'memory_speed': (str,),  # noqa: E501
            'mgmt_ip_address': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'num_adaptors': (int,),  # noqa: E501
            'num_cpu_cores': (int,),  # noqa: E501
            'num_cpu_cores_enabled': (int,),  # noqa: E501
            'num_cpus': (int,),  # noqa: E501
            'num_eth_host_interfaces': (int,),  # noqa: E501
            'num_fc_host_interfaces': (int,),  # noqa: E501
            'num_threads': (int,),  # noqa: E501
            'oper_power_state': (str,),  # noqa: E501
            'oper_reason': ([str], none_type,),  # noqa: E501
            'oper_state': (str,),  # noqa: E501
            'operability': (str,),  # noqa: E501
            'platform_type': (str,),  # noqa: E501
            'service_profile': (str,),  # noqa: E501
            'total_memory': (int,),  # noqa: E501
            'tunneled_kvm': (bool,),  # noqa: E501
            'user_label': (str,),  # noqa: E501
            'uuid': (str,),  # noqa: E501
            'boot_cdd_devices': ([BootCddDeviceRelationship], none_type,),  # noqa: E501
            'boot_device_boot_security': (BootDeviceBootSecurityRelationship,),  # noqa: E501
            'boot_hdd_devices': ([BootHddDeviceRelationship], none_type,),  # noqa: E501
            'boot_iscsi_devices': ([BootIscsiDeviceRelationship], none_type,),  # noqa: E501
            'boot_nvme_devices': ([BootNvmeDeviceRelationship], none_type,),  # noqa: E501
            'boot_pch_storage_devices': ([BootPchStorageDeviceRelationship], none_type,),  # noqa: E501
            'boot_pxe_devices': ([BootPxeDeviceRelationship], none_type,),  # noqa: E501
            'boot_san_devices': ([BootSanDeviceRelationship], none_type,),  # noqa: E501
            'boot_sd_devices': ([BootSdDeviceRelationship], none_type,),  # noqa: E501
            'boot_uefi_shell_devices': ([BootUefiShellDeviceRelationship], none_type,),  # noqa: E501
            'boot_usb_devices': ([BootUsbDeviceRelationship], none_type,),  # noqa: E501
            'boot_vmedia_devices': ([BootVmediaDeviceRelationship], none_type,),  # noqa: E501
            'mgmt_identity': (EquipmentPhysicalIdentityRelationship,),  # noqa: E501
            'vmedia': (ComputeVmediaRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        val = {
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'chassis_id': 'ChassisId',  # noqa: E501
        'scaled_mode': 'ScaledMode',  # noqa: E501
        'slot_id': 'SlotId',  # noqa: E501
        'adapters': 'Adapters',  # noqa: E501
        'bios_bootmode': 'BiosBootmode',  # noqa: E501
        'bios_token_settings': 'BiosTokenSettings',  # noqa: E501
        'bios_units': 'BiosUnits',  # noqa: E501
        'bios_vf_select_memory_ras_configuration': 'BiosVfSelectMemoryRasConfiguration',  # noqa: E501
        'bmc': 'Bmc',  # noqa: E501
        'board': 'Board',  # noqa: E501
        'boot_device_bootmode': 'BootDeviceBootmode',  # noqa: E501
        'equipment_chassis': 'EquipmentChassis',  # noqa: E501
        'equipment_io_expanders': 'EquipmentIoExpanders',  # noqa: E501
        'generic_inventory_holders': 'GenericInventoryHolders',  # noqa: E501
        'graphics_cards': 'GraphicsCards',  # noqa: E501
        'inventory_device_info': 'InventoryDeviceInfo',  # noqa: E501
        'locator_led': 'LocatorLed',  # noqa: E501
        'memory_arrays': 'MemoryArrays',  # noqa: E501
        'pci_devices': 'PciDevices',  # noqa: E501
        'processors': 'Processors',  # noqa: E501
        'registered_device': 'RegisteredDevice',  # noqa: E501
        'storage_controllers': 'StorageControllers',  # noqa: E501
        'storage_enclosures': 'StorageEnclosures',  # noqa: E501
        'top_system': 'TopSystem',  # noqa: E501
        'account_moid': 'AccountMoid',  # noqa: E501
        'create_time': 'CreateTime',  # noqa: E501
        'domain_group_moid': 'DomainGroupMoid',  # noqa: E501
        'mod_time': 'ModTime',  # noqa: E501
        'moid': 'Moid',  # noqa: E501
        'owners': 'Owners',  # noqa: E501
        'shared_scope': 'SharedScope',  # noqa: E501
        'tags': 'Tags',  # noqa: E501
        'version_context': 'VersionContext',  # noqa: E501
        'ancestors': 'Ancestors',  # noqa: E501
        'parent': 'Parent',  # noqa: E501
        'permission_resources': 'PermissionResources',  # noqa: E501
        'display_names': 'DisplayNames',  # noqa: E501
        'device_mo_id': 'DeviceMoId',  # noqa: E501
        'dn': 'Dn',  # noqa: E501
        'rn': 'Rn',  # noqa: E501
        'model': 'Model',  # noqa: E501
        'presence': 'Presence',  # noqa: E501
        'revision': 'Revision',  # noqa: E501
        'serial': 'Serial',  # noqa: E501
        'vendor': 'Vendor',  # noqa: E501
        'previous_fru': 'PreviousFru',  # noqa: E501
        'admin_power_state': 'AdminPowerState',  # noqa: E501
        'alarm_summary': 'AlarmSummary',  # noqa: E501
        'asset_tag': 'AssetTag',  # noqa: E501
        'available_memory': 'AvailableMemory',  # noqa: E501
        'bios_post_complete': 'BiosPostComplete',  # noqa: E501
        'fault_summary': 'FaultSummary',  # noqa: E501
        'hardware_uuid': 'HardwareUuid',  # noqa: E501
        'kvm_ip_addresses': 'KvmIpAddresses',  # noqa: E501
        'management_mode': 'ManagementMode',  # noqa: E501
        'memory_speed': 'MemorySpeed',  # noqa: E501
        'mgmt_ip_address': 'MgmtIpAddress',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'num_adaptors': 'NumAdaptors',  # noqa: E501
        'num_cpu_cores': 'NumCpuCores',  # noqa: E501
        'num_cpu_cores_enabled': 'NumCpuCoresEnabled',  # noqa: E501
        'num_cpus': 'NumCpus',  # noqa: E501
        'num_eth_host_interfaces': 'NumEthHostInterfaces',  # noqa: E501
        'num_fc_host_interfaces': 'NumFcHostInterfaces',  # noqa: E501
        'num_threads': 'NumThreads',  # noqa: E501
        'oper_power_state': 'OperPowerState',  # noqa: E501
        'oper_reason': 'OperReason',  # noqa: E501
        'oper_state': 'OperState',  # noqa: E501
        'operability': 'Operability',  # noqa: E501
        'platform_type': 'PlatformType',  # noqa: E501
        'service_profile': 'ServiceProfile',  # noqa: E501
        'total_memory': 'TotalMemory',  # noqa: E501
        'tunneled_kvm': 'TunneledKvm',  # noqa: E501
        'user_label': 'UserLabel',  # noqa: E501
        'uuid': 'Uuid',  # noqa: E501
        'boot_cdd_devices': 'BootCddDevices',  # noqa: E501
        'boot_device_boot_security': 'BootDeviceBootSecurity',  # noqa: E501
        'boot_hdd_devices': 'BootHddDevices',  # noqa: E501
        'boot_iscsi_devices': 'BootIscsiDevices',  # noqa: E501
        'boot_nvme_devices': 'BootNvmeDevices',  # noqa: E501
        'boot_pch_storage_devices': 'BootPchStorageDevices',  # noqa: E501
        'boot_pxe_devices': 'BootPxeDevices',  # noqa: E501
        'boot_san_devices': 'BootSanDevices',  # noqa: E501
        'boot_sd_devices': 'BootSdDevices',  # noqa: E501
        'boot_uefi_shell_devices': 'BootUefiShellDevices',  # noqa: E501
        'boot_usb_devices': 'BootUsbDevices',  # noqa: E501
        'boot_vmedia_devices': 'BootVmediaDevices',  # noqa: E501
        'mgmt_identity': 'MgmtIdentity',  # noqa: E501
        'vmedia': 'Vmedia',  # noqa: E501
    }

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """ComputeBlade - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "compute.Blade", must be one of ["compute.Blade", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "compute.Blade", must be one of ["compute.Blade", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            chassis_id (str): The id of the chassis that the blade is discovered in.. [optional]  # noqa: E501
            scaled_mode (str): The mode of the server that determines it is scaled.. [optional]  # noqa: E501
            slot_id (int): The slot number in the chassis that the blade is discovered in.. [optional]  # noqa: E501
            adapters ([AdapterUnitRelationship], none_type): An array of relationships to adapterUnit resources.. [optional]  # noqa: E501
            bios_bootmode (BiosBootModeRelationship): [optional]  # noqa: E501
            bios_token_settings (BiosTokenSettingsRelationship): [optional]  # noqa: E501
            bios_units ([BiosUnitRelationship], none_type): An array of relationships to biosUnit resources.. [optional]  # noqa: E501
            bios_vf_select_memory_ras_configuration (BiosVfSelectMemoryRasConfigurationRelationship): [optional]  # noqa: E501
            bmc (ManagementControllerRelationship): [optional]  # noqa: E501
            board (ComputeBoardRelationship): [optional]  # noqa: E501
            boot_device_bootmode (BootDeviceBootModeRelationship): [optional]  # noqa: E501
            equipment_chassis (EquipmentChassisRelationship): [optional]  # noqa: E501
            equipment_io_expanders ([EquipmentIoExpanderRelationship], none_type): An array of relationships to equipmentIoExpander resources.. [optional]  # noqa: E501
            generic_inventory_holders ([InventoryGenericInventoryHolderRelationship], none_type): An array of relationships to inventoryGenericInventoryHolder resources.. [optional]  # noqa: E501
            graphics_cards ([GraphicsCardRelationship], none_type): An array of relationships to graphicsCard resources.. [optional]  # noqa: E501
            inventory_device_info (InventoryDeviceInfoRelationship): [optional]  # noqa: E501
            locator_led (EquipmentLocatorLedRelationship): [optional]  # noqa: E501
            memory_arrays ([MemoryArrayRelationship], none_type): An array of relationships to memoryArray resources.. [optional]  # noqa: E501
            pci_devices ([PciDeviceRelationship], none_type): An array of relationships to pciDevice resources.. [optional]  # noqa: E501
            processors ([ProcessorUnitRelationship], none_type): An array of relationships to processorUnit resources.. [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            storage_controllers ([StorageControllerRelationship], none_type): An array of relationships to storageController resources.. [optional]  # noqa: E501
            storage_enclosures ([StorageEnclosureRelationship], none_type): An array of relationships to storageEnclosure resources.. [optional]  # noqa: E501
            top_system (TopSystemRelationship): [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
            device_mo_id (str): The database identifier of the registered device of an object.. [optional]  # noqa: E501
            dn (str): The Distinguished Name unambiguously identifies an object in the system.. [optional]  # noqa: E501
            rn (str): The Relative Name uniquely identifies an object within a given context.. [optional]  # noqa: E501
            model (str): This field identifies the model of the given component.. [optional]  # noqa: E501
            presence (str): This field identifies the presence (equipped) or absence of the given component.. [optional]  # noqa: E501
            revision (str): This field identifies the revision of the given component.. [optional]  # noqa: E501
            serial (str): This field identifies the serial of the given component.. [optional]  # noqa: E501
            vendor (str): This field identifies the vendor of the given component.. [optional]  # noqa: E501
            previous_fru (EquipmentFruRelationship): [optional]  # noqa: E501
            admin_power_state (str): The desired power state of the server.. [optional]  # noqa: E501
            alarm_summary (ComputeAlarmSummary): [optional]  # noqa: E501
            asset_tag (str): The user defined asset tag assigned to the server.. [optional]  # noqa: E501
            available_memory (int): The amount of memory available on the server.. [optional]  # noqa: E501
            bios_post_complete (bool): The BIOS POST completion status of the server.. [optional]  # noqa: E501
            fault_summary (int): The fault summary for the server.. [optional]  # noqa: E501
            hardware_uuid (str): The universally unique hardware identity of the server provided by the manufacturer.. [optional]  # noqa: E501
            kvm_ip_addresses ([ComputeIpAddress], none_type): [optional]  # noqa: E501
            management_mode (str): The management mode of the server. * `IntersightStandalone` - Intersight Standalone mode of operation. * `UCSM` - Unified Computing System Manager mode of operation. * `Intersight` - Intersight managed mode of operation.. [optional] if omitted the server will use the default value of "IntersightStandalone"  # noqa: E501
            memory_speed (str): The maximum memory speed in MHz available on the server.. [optional]  # noqa: E501
            mgmt_ip_address (str): Management address of the server.. [optional]  # noqa: E501
            name (str): The name of the UCS Fabric Interconnect cluster or Cisco Integrated Management Controller (CIMC). When this server is attached to a UCS Fabric Interconnect, the value of this property is the name of the UCS Fabric Interconnect along with chassis/server Id. When this server configured in standalone mode, the value of this property is the name of the Cisco Integrated Management Controller. when this server is configired in IMM mode, the value of this property contains model and chassis/server Id.. [optional]  # noqa: E501
            num_adaptors (int): The total number of network adapters present on the server.. [optional]  # noqa: E501
            num_cpu_cores (int): The total number of CPU cores present on the server.. [optional]  # noqa: E501
            num_cpu_cores_enabled (int): The total number of CPU cores enabled on the server.. [optional]  # noqa: E501
            num_cpus (int): The total number of CPUs present on the server.. [optional]  # noqa: E501
            num_eth_host_interfaces (int): The total number of vNICs which are visible to a host on the server.. [optional]  # noqa: E501
            num_fc_host_interfaces (int): The total number of vHBAs which are visible to a host on the server.. [optional]  # noqa: E501
            num_threads (int): The total number of threads the server is capable of handling.. [optional]  # noqa: E501
            oper_power_state (str): The actual power state of the server.. [optional]  # noqa: E501
            oper_reason ([str], none_type): [optional]  # noqa: E501
            oper_state (str): The operational state of the server.. [optional]  # noqa: E501
            operability (str): The operability of the server.. [optional]  # noqa: E501
            platform_type (str): The platform type of the registered device - whether managed by UCSM or operating in standalone mode.. [optional]  # noqa: E501
            service_profile (str): The distinguished name of the service profile to which the server is associated to. It is applicable only for servers which are managed via UCSM.. [optional]  # noqa: E501
            total_memory (int): The total memory available on the server.. [optional]  # noqa: E501
            tunneled_kvm (bool): The Tunneled vKVM status of the server.. [optional]  # noqa: E501
            user_label (str): The user defined label assigned to the server.. [optional]  # noqa: E501
            uuid (str): The universally unique identity of the server.. [optional]  # noqa: E501
            boot_cdd_devices ([BootCddDeviceRelationship], none_type): An array of relationships to bootCddDevice resources.. [optional]  # noqa: E501
            boot_device_boot_security (BootDeviceBootSecurityRelationship): [optional]  # noqa: E501
            boot_hdd_devices ([BootHddDeviceRelationship], none_type): An array of relationships to bootHddDevice resources.. [optional]  # noqa: E501
            boot_iscsi_devices ([BootIscsiDeviceRelationship], none_type): An array of relationships to bootIscsiDevice resources.. [optional]  # noqa: E501
            boot_nvme_devices ([BootNvmeDeviceRelationship], none_type): An array of relationships to bootNvmeDevice resources.. [optional]  # noqa: E501
            boot_pch_storage_devices ([BootPchStorageDeviceRelationship], none_type): An array of relationships to bootPchStorageDevice resources.. [optional]  # noqa: E501
            boot_pxe_devices ([BootPxeDeviceRelationship], none_type): An array of relationships to bootPxeDevice resources.. [optional]  # noqa: E501
            boot_san_devices ([BootSanDeviceRelationship], none_type): An array of relationships to bootSanDevice resources.. [optional]  # noqa: E501
            boot_sd_devices ([BootSdDeviceRelationship], none_type): An array of relationships to bootSdDevice resources.. [optional]  # noqa: E501
            boot_uefi_shell_devices ([BootUefiShellDeviceRelationship], none_type): An array of relationships to bootUefiShellDevice resources.. [optional]  # noqa: E501
            boot_usb_devices ([BootUsbDeviceRelationship], none_type): An array of relationships to bootUsbDevice resources.. [optional]  # noqa: E501
            boot_vmedia_devices ([BootVmediaDeviceRelationship], none_type): An array of relationships to bootVmediaDevice resources.. [optional]  # noqa: E501
            mgmt_identity (EquipmentPhysicalIdentityRelationship): [optional]  # noqa: E501
            vmedia (ComputeVmediaRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "compute.Blade")
        object_type = kwargs.get('object_type', "compute.Blade")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        model_args = {}
        model_args.update(required_args)
        model_args.update(kwargs)
        composed_info = validate_get_composed_info(
            constant_args, model_args, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        unused_args = composed_info[3]

        for var_name, var_value in required_args.items():
            setattr(self, var_name, var_value)
        for var_name, var_value in kwargs.items():
            if var_name in unused_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        not self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error beause the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              ComputeBladeAllOf,
              ComputePhysical,
          ],
          'oneOf': [
          ],
        }
