import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabProjectMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
    * The full path of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_membership#full_path DataGitlabProjectMembership#full_path}
    */
    readonly fullPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_membership#id DataGitlabProjectMembership#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Return all project members including members through ancestor groups
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_membership#inherited DataGitlabProjectMembership#inherited}
    */
    readonly inherited?: boolean | cdktf.IResolvable;
    /**
    * The ID of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_membership#project_id DataGitlabProjectMembership#project_id}
    */
    readonly projectId?: number;
    /**
    * A query string to search for members
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_membership#query DataGitlabProjectMembership#query}
    */
    readonly query?: string;
}
export interface DataGitlabProjectMembershipMembers {
}
export declare function dataGitlabProjectMembershipMembersToTerraform(struct?: DataGitlabProjectMembershipMembers): any;
export declare class DataGitlabProjectMembershipMembersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectMembershipMembers | undefined;
    set internalValue(value: DataGitlabProjectMembershipMembers | undefined);
    get accessLevel(): string;
    get avatarUrl(): string;
    get expiresAt(): string;
    get id(): number;
    get name(): string;
    get state(): string;
    get username(): string;
    get webUrl(): string;
}
export declare class DataGitlabProjectMembershipMembersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectMembershipMembersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_membership gitlab_project_membership}
*/
export declare class DataGitlabProjectMembership extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_project_membership";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/project_membership gitlab_project_membership} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabProjectMembershipConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGitlabProjectMembershipConfig);
    private _fullPath?;
    get fullPath(): string;
    set fullPath(value: string);
    resetFullPath(): void;
    get fullPathInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inherited?;
    get inherited(): boolean | cdktf.IResolvable;
    set inherited(value: boolean | cdktf.IResolvable);
    resetInherited(): void;
    get inheritedInput(): boolean | cdktf.IResolvable | undefined;
    private _members;
    get members(): DataGitlabProjectMembershipMembersList;
    private _projectId?;
    get projectId(): number;
    set projectId(value: number);
    resetProjectId(): void;
    get projectIdInput(): number | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    resetQuery(): void;
    get queryInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
