from setuptools import setup, find_packages

VERSION=0.7113

DESCRIPTION="A package for pre-trained image classification and context-decider for question-answering chatbots."
LONG_DESCRIPTION="Your one-stop destination to utilize image-classification models with just one line of code. A library meant to simplify your life by providing you with pre-trained models like ResNet50, EfficientNetVB6, VGG19, etc. You can simply opt for training your own models from scratch by just tweaking a few values. If you want to try popular active-learning sampling methods on image classification, no need to worry! This library has got you covered. Along with that for simple-bridging and basic into NLP, we have context-deciders, HTML parsers and simple chatbot object classes, to create an interface similar to Google Lens. You input an image or item that you are curious about and you can ask one-on-one questions from the chatbot. This is made possible by using the tiny imagenet dataset. This library is being actively updated and new features are being added frequently. New datasets and pre-trained models will be updated soon. Feel free to share your feedback! I would really appreciate it!"
CLASSIFIERS=[
    'Development Status :: 5 - Production/Stable',
    'Intended Audience :: Education',
    'License :: OSI Approved :: MIT License',
    'Programming Language :: Python :: 3'
]
setup(name="OneOnOne",version=VERSION,description=DESCRIPTION, long_description=LONG_DESCRIPTION,author="Sohini Bhattacharya",author_email="mail.sohinibhattacharya@gmail.com",License="MIT",packages=find_packages(),keywords=["python","image-classification","active-learning-sampling","question-answering","pre-trained models","tiny-image-net","speech-recognition","cifar10"],classifiers=CLASSIFIERS,install_requires=["wget","pytesseract","bayesian-optimization","PyPDF2","googletrans==3.1.0a0","speechrecognition","pyttsx3","pydub","torch","transformers","gdown","numpy","pandas","tensorflow==2.14","datetime","keras==2.14","tensorflow_datasets==4.9.2","scipy==1.10.1","tqdm==4.65.0"])