import unittest
from pyvalidator import *

class TestIsLatLong(unittest.TestCase):

    def test_valid_lat_long(self):
        self.assertTrue(is_lat_long('(-17.738223, 85.605469)'))
        self.assertTrue(is_lat_long('(-12.3456789, +12.3456789)'))
        self.assertTrue(is_lat_long('(-60.978437, -0.175781)'))
        self.assertTrue(is_lat_long('(77.719772, -37.529297)'))
        self.assertTrue(is_lat_long('(7.264394, 165.058594)'))
        self.assertTrue(is_lat_long('0.955766, -19.863281'))
        self.assertTrue(is_lat_long('(31.269161,164.355469)'))
        self.assertTrue(is_lat_long('+12.3456789, -12.3456789'))
        self.assertTrue(is_lat_long('-15.379543, -137.285156'))
        self.assertTrue(is_lat_long('(11.770570, -162.949219)'))
        self.assertTrue(is_lat_long('-55.034319, 113.027344'))
        self.assertTrue(is_lat_long('58.025555, 36.738281'))
        self.assertTrue(is_lat_long('55.720923,-28.652344'))
        self.assertTrue(is_lat_long('-90.00000,-180.00000'))
        self.assertTrue(is_lat_long('(-71, -146)'))
        self.assertTrue(is_lat_long('(-71.616864, -146.616864)'))
        self.assertTrue(is_lat_long('-0.55, +0.22'))
        self.assertTrue(is_lat_long('90, 180'))
        self.assertTrue(is_lat_long('+90, -180'))
        self.assertTrue(is_lat_long('-90,+180'))
        self.assertTrue(is_lat_long('90,180'))
        self.assertTrue(is_lat_long('0, 0'))
        print('OK - test_valid_lat_long')

    def test_invalid_lat_long(self):
        self.assertFalse(is_lat_long('(020.000000, 010.000000000)'))
        self.assertFalse(is_lat_long('89.9999999989, 360.0000000'))
        self.assertFalse(is_lat_long('90.1000000, 180.000000'))
        self.assertFalse(is_lat_long('+90.000000, -180.00001'))
        self.assertFalse(is_lat_long('090.0000, 0180.0000'))
        self.assertFalse(is_lat_long('126, -158'))
        self.assertFalse(is_lat_long('(-126.400010, -158.400010)'))
        self.assertFalse(is_lat_long('-95, -96'))
        self.assertFalse(is_lat_long('-95.738043, -96.738043'))
        self.assertFalse(is_lat_long('137, -148'))
        self.assertFalse(is_lat_long('(-137.5942, -148.5942)'))
        self.assertFalse(is_lat_long('(-120, -203)'))
        self.assertFalse(is_lat_long('(-119, -196)'))
        self.assertFalse(is_lat_long('+119.821728, -196.821728'))
        self.assertFalse(is_lat_long('(-110, -223)'))
        self.assertFalse(is_lat_long('-110.369532, 223.369532'))
        self.assertFalse(is_lat_long('(-120.969949, +203.969949)'))
        self.assertFalse(is_lat_long('-116, -126'))
        self.assertFalse(is_lat_long('-116.894222, -126.894222'))
        self.assertFalse(is_lat_long('-112, -160'))
        self.assertFalse(is_lat_long('-112.96381, -160.96381'))
        self.assertFalse(is_lat_long('-90., -180.'))
        self.assertFalse(is_lat_long('+90.1, -180.1'))
        self.assertFalse(is_lat_long('(-17.738223, 85.605469'))
        self.assertFalse(is_lat_long('0.955766, -19.863281)'))
        self.assertFalse(is_lat_long('+,-'))
        self.assertFalse(is_lat_long('(,)'))
        self.assertFalse(is_lat_long(','))
        self.assertFalse(is_lat_long(' '))
        print('OK - test_invalid_lat_long')

    def test_valid_lat_long_dms(self):
        self.assertTrue(is_lat_long('40° 26′ 46″ N, 79° 58′ 56″ W', { "check_dms": True }))
        self.assertTrue(is_lat_long('40° 26′ 46″ S, 79° 58′ 56″ E', { "check_dms": True }))
        self.assertTrue(is_lat_long('90° 0′ 0″ S, 180° 0′ 0″ E', { "check_dms": True }))
        self.assertTrue(is_lat_long('40° 26′ 45.9996″ N, 79° 58′ 55.2″ E', { "check_dms": True }))
        self.assertTrue(is_lat_long('40° 26′ 46″ n, 79° 58′ 56″ w', { "check_dms": True }))
        self.assertTrue(is_lat_long('40°26′46″s, 79°58′56″e', { "check_dms": True }))
        self.assertTrue(is_lat_long('11° 0′ 0.005″ S, 180° 0′ 0″ E', { "check_dms": True }))
        self.assertTrue(is_lat_long('40°26′45.9996″N, 79°58′55.2″E', { "check_dms": True }))
        print('OK - test_valid_lat_long_dms')

    def test_invalid_lat_long_dms(self):
        self.assertFalse(is_lat_long('100° 26′ 46″ N, 79° 70′ 56″ W', { "check_dms": True }))
        self.assertFalse(is_lat_long('40° 89′ 46″ S, 79° 58′ 100″ E', { "check_dms": True }))
        self.assertFalse(is_lat_long('40° 26.445′ 45″ N, 79° 58′ 55.2″ E', { "check_dms": True }))
        self.assertFalse(is_lat_long('40° 46″ N, 79° 58′ 56″ W', { "check_dms": True }))
        print('OK - test_invalid_lat_long_dms')
