# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'AlertaDengue'}

packages = \
['ad_main']

package_data = \
{'': ['*']}

install_requires = \
['Django>=3.1.8,<4',
 'Fiona>=1.8.21,<2.0.0',
 'SQLAlchemy>=1.4.41,<2.0.0',
 'celery>=5.2.6,<6.0.0',
 'certifi>=2022.12.7,<2023.0.0',
 'click<8.1.5',
 'dbfread>=2.0.7,<3.0.0',
 'dj-database-url>=0.5.0,<0.6.0',
 'dj-static>=0.0.6,<0.0.7',
 'django-bootstrap4>=22.1,<23.0',
 'django-celery-results>=2.3.1,<3.0.0',
 'django-chunked-upload<2.0.0',
 'django-cprofile-middleware>=1.0.5,<2.0.0',
 'django-leaflet>=0.28.2,<0.29.0',
 'django-maintenance-mode>=0.16.3,<0.17.0',
 'django-pymemcache>=1.0.0,<2.0.0',
 'docker-compose>=1.29.2,<2.0.0',
 'fastparquet>=0.8.1,<0.9.0',
 'geojson>=2.5.0,<3.0.0',
 'geopandas>=0.10.2,<0.11.0',
 'geopy>=2.2.0,<3.0.0',
 'gunicorn>=20.1.0,<21.0.0',
 'ibis-framework[postgres]>=3.2.0,<4.0.0',
 'pandas==1.4.0',
 'plotly>=5.11.0,<6.0.0',
 'pyproj>=3.3.0,<4.0.0',
 'python-dotenv>=0.20.0,<0.21.0',
 'python-memcached>=1.59,<2.0',
 'rasterio>=1.2.10,<2.0.0',
 'sh>=1.14.2,<2.0.0',
 'simpledbf>=0.2.6,<0.3.0',
 'tables>=3.7.0,<4.0.0']

setup_kwargs = {
    'name': 'alertadengue',
    'version': '3.2.0',
    'description': 'AlertaDengue package',
    'long_description': '## AlertaDengue\n\n### This repository contains the main applications and services for the InfoDengue web portal.\n\n### InfoDengue is an early-warning system to all states of Brazil, the system is based on the continuous analysis of hybrid data generated through the research of climate and epidemiological data and social scraping.\n\n\nFor more information, please visit our website [info.dengue.mat.br](https://info.dengue.mat.br) to visualize the current epidemiological situation in each state.\n\n---\n\n### Sponsors\n\n<div style="width: 100%; text-align: left; position: relative;">\n    <a href="https://portal.fiocruz.br/"> <img width="250" alt="Fiocruz" src="https://institutolula.org/uploads/6862.png" />\n    <a href="https://emap.fgv.br/"> <img width="350" src="https://i.imgur.com/bdfNqNv.png" alt="FGV EMAp" align=right />\n</div>\n\n---\n\n## How to contribute with InfoDengue\n\nYou can find more information about [Contributing](https://github.com/AlertaDengue/AlertaDengue/blob/main/CONTRIBUTING.md) on GitHub. Also check our [Team](https://info.dengue.mat.br/equipe/) page to see if there is a work oportunity in the project.\n\n---\n## How data can be visualized\n\nThe Infodengue website is accessed by many people and it is common for us to receive news that this information is used in the definition of travel and other activities. All data is compiled, analyzed and generated in a national level with the support of the Brazilian Health Ministry, the weekly reports can be found in our website through graphics or downloaded in JSON and CSV files via [API](https://info.dengue.mat.br/services/api).\n\n\n### API\n\nThe InfoDengue API will provide the data contained in the reports compiled in JSON or CSV files, it also provides a custom range of time. _If you don\'t know Python or R, please check the tutorials [here](https://info.dengue.mat.br/services/tutorial)._\n\n### Reports\n\nIf you are a member of a Municipal Health Department, or a citizen, and you have interest in detailed information on the transmission alerts of your municipality, just type the name of the city or state [here](https://info.dengue.mat.br/report/).\n\n---\n\n## Where the data comes from\n- Dengue, Chikungunya and Zika data are provided by [SINAN](http://portalsinan.saude.gov.br/) as a notification form that feeds a municipal database, which is then consolidated at the state level and finally, federally by the Ministry of Health. Only a fraction of these cases are laboratory confirmed, most receive final classification based on clinical and epidemiological criteria. From the notified cases, the incidence indicators that feed the InfoDengue are calculated.\n- InfoDengue has partnered with the [Dengue Observatory](https://www.observatorio.inweb.org.br/), that captures and analyzes tweets from geolocalized people for the mention of dengue symptoms on social media.\n- Weather and climate data are obtained from [REDEMET](https://www.redemet.aer.mil.br/) in the airports all over Brazil.\n- Epidemiological indicators require population size. Demographic data of Brazilian cities are updated each year in Infodengue using estimates [IBGE](https://www.ibge.gov.br/pt/inicio.html).\n\n---\n\n### Check out below the softwares we use in the project:\n\n| <a href=https://www.djangoproject.com/><img width="298" height="100%" alt="Django" src="https://i.imgur.com/Z9wo3bS.png"></a> | <a href=https://postgis.net/documentation/><img width="298" height="100%" alt="postgis" src="https://i.imgur.com/pVEX2Gl.png">|<a href=https://docs.docker.com/get-started/><img width="298" height="100%" alt="docker" src="https://i.ibb.co/Yp8B38R/docker.png"> |\n|:-------------------------:|:-------------------------:|:-------------------------:|\n|<a href=https://docs.celeryq.dev/en/stable/><img width="298" height="100%" alt="celery" src="https://i.ibb.co/L81p2zD/celery.png"> | <a href=https://docs.nginx.com/><img width="298" height="100%" alt="nginx" src="https://i.ibb.co/2n5HZBg/nginx.png">|<a href=https://plotly.com/><img width="298" height="100%" alt="plotly" src="https://i.ibb.co/r0HYsYH/plotly.png">|\n\n---\n',
    'author': 'Flavio Codeco Coelho',
    'author_email': 'fccoelho@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/AlertaDengue/AlertaDengue',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<3.11',
}


setup(**setup_kwargs)
