# AUTOGENERATED! DO NOT EDIT! File to edit: ../notebooks/pyramide_ages.ipynb.

# %% auto 0
__all__ = ["config", "df", "df_all", "ref", "perimeter", "data", "pyramide", "path"]

# %% ../notebooks/pyramide_ages.ipynb 3
# import time

import pandas as pd
from leximpact_socio_fisca_simu_etat.config import Configuration

from leximpact_aggregates.aggregate import (
    Aggregate,
    AggregateManager,
    Data,
    DataStructure,
    FileFormat,
    Perimeter,
    Reference,
)

# from ruamel.yaml import YAML


config = Configuration(project_folder="leximpact-aggregates")

# %% ../notebooks/pyramide_ages.ipynb 4
df = pd.read_excel(
    "https://www.insee.fr/fr/statistiques/fichier/2381472/demo-pop-pyram.xlsx",
    skiprows=2,
    nrows=101,
)
df.columns
df.columns = ["an_naissance", "age", "nb_femmes", "nb_hommes", "all"]
df_all = df[["age", "nb_femmes", "nb_hommes", "all"]]

# %% ../notebooks/pyramide_ages.ipynb 7
ref = Reference(
    title="Estimations de population (INSEE)",
    href="https://www.insee.fr/fr/metadonnees/source/serie/s1169",
)
perimeter = Perimeter(entity="person", period="year", geographic="France entière")
data = Data(reference=[ref], date="2022", values=df_all.to_dict(orient="records"))
pyramide = Aggregate(
    description="Pyramide des âges",
    short_name="Pyramide des âges",
    openfisca_variable="age",
    source_variable="Ensemble",
    unit="person",
    perimeter=perimeter,
    data=[data],
)

# %% ../notebooks/pyramide_ages.ipynb 9
path = AggregateManager().get_path(
    AggregateManager().aggregates_path,
    "INSEE",
    "age",
    FileFormat.YAML,
    "2022",
    DataStructure.LIST,
)
AggregateManager().save_agg_to_yaml_and_json(
    path, pyramide, AggregateManager().aggregates_path
)
