# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['bento2seldon']

package_data = \
{'': ['*']}

install_requires = \
['BentoML>=0.12,<0.13', 'decorator>=5.0,<6.0', 'pydantic>=1.8,<2.0']

extras_require = \
{':python_version < "3.8"': ['importlib_metadata>=1.6.0,<2.0.0']}

setup_kwargs = {
    'name': 'bento2seldon',
    'version': '0.3.1',
    'description': 'This project aims to combine the awesome capabilities of BentoML in packaging models with the powerful Seldon Core engine to deploy such models. It also features an optional cache using Redis that can also be used to make the feedback loop easier by using the request ID to get back the original request and response. For now, it was created for internal use and is in alpha state. But it will soon be prepared to be used by everyone.',
    'long_description': '# bento2seldon\n\n<div align="center">\n\n[![Build status](https://github.com/fernandocamargoai/bento2seldon/workflows/build/badge.svg?branch=master&event=push)](https://github.com/fernandocamargoai/bento2seldon/actions?query=workflow%3Abuild)\n[![Python Version](https://img.shields.io/pypi/pyversions/bento2seldon.svg)](https://pypi.org/project/bento2seldon/)\n[![Dependencies Status](https://img.shields.io/badge/dependencies-up%20to%20date-brightgreen.svg)](https://github.com/fernandocamargoai/bento2seldon/pulls?utf8=%E2%9C%93&q=is%3Apr%20author%3Aapp%2Fdependabot)\n\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![Security: bandit](https://img.shields.io/badge/security-bandit-green.svg)](https://github.com/PyCQA/bandit)\n[![Pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/fernandocamargoai/bento2seldon/blob/master/.pre-commit-config.yaml)\n[![Semantic Versions](https://img.shields.io/badge/%F0%9F%9A%80-semantic%20versions-informational.svg)](https://github.com/fernandocamargoai/bento2seldon/releases)\n[![License](https://img.shields.io/github/license/fernandocamargoai/bento2seldon)](https://github.com/fernandocamargoai/bento2seldon/blob/master/LICENSE)\n\nThis project aims to combine the awesome capabilities of BentoML in packaging models with the powerful Seldon Core engine to deploy such models. It also features an optional cache using Redis that can also be used to make the feedback loop easier by using the request ID to get back the original request and response. For now, it was created for internal use and is in alpha state. But it will soon be prepared to be used by everyone.\n\n</div>\n\n## Installation\n\n```bash\npip install -U bento2seldon\n```\n\nor install with `Poetry`\n\n```bash\npoetry add bento2seldon\n```\n\n### Makefile usage\n\n[`Makefile`](https://github.com/fernandocamargoai/bento2seldon/blob/master/Makefile) contains many functions for fast assembling and convenient work.\n\n<details>\n<summary>1. Download Poetry</summary>\n<p>\n\n```bash\nmake download-poetry\n```\n\n</p>\n</details>\n\n<details>\n<summary>2. Install all dependencies and pre-commit hooks</summary>\n<p>\n\n```bash\nmake install\n```\n\nIf you do not want to install pre-commit hooks, run the command with the NO_PRE_COMMIT flag:\n\n```bash\nmake install NO_PRE_COMMIT=1\n```\n\n</p>\n</details>\n\n<details>\n<summary>3. Check the security of your code</summary>\n<p>\n\n```bash\nmake check-safety\n```\n\nThis command launches a `Poetry` and `Pip` integrity check as well as identifies security issues with `Safety` and `Bandit`. By default, the build will not crash if any of the items fail. But you can set `STRICT=1` for the entire build, or you can configure strictness for each item separately.\n\n```bash\nmake check-safety STRICT=1\n```\n\nor only for `safety`:\n\n```bash\nmake check-safety SAFETY_STRICT=1\n```\n\nmultiple\n\n```bash\nmake check-safety PIP_STRICT=1 SAFETY_STRICT=1\n```\n\n> List of flags for `check-safety` (can be set to `1` or `0`): `STRICT`, `POETRY_STRICT`, `PIP_STRICT`, `SAFETY_STRICT`, `BANDIT_STRICT`.\n\n</p>\n</details>\n\n<details>\n<summary>4. Check the codestyle</summary>\n<p>\n\nThe command is similar to `check-safety` but to check the code style, obviously. It uses `Black`, `Darglint`, `Isort`, and `Mypy` inside.\n\n```bash\nmake check-style\n```\n\nIt may also contain the `STRICT` flag.\n\n```bash\nmake check-style STRICT=1\n```\n\n> List of flags for `check-style` (can be set to `1` or `0`): `STRICT`, `BLACK_STRICT`, `DARGLINT_STRICT`, `ISORT_STRICT`, `MYPY_STRICT`.\n\n</p>\n</details>\n\n<details>\n<summary>5. Run all the codestyle formaters</summary>\n<p>\n\nCodestyle uses `pre-commit` hooks, so ensure you\'ve run `make install` before.\n\n```bash\nmake codestyle\n```\n\n</p>\n</details>\n\n<details>\n<summary>6. Run tests</summary>\n<p>\n\n```bash\nmake test\n```\n\n</p>\n</details>\n\n<details>\n<summary>7. Run all the linters</summary>\n<p>\n\n```bash\nmake lint\n```\n\nthe same as:\n\n```bash\nmake test && make check-safety && make check-style\n```\n\n> List of flags for `lint` (can be set to `1` or `0`): `STRICT`, `POETRY_STRICT`, `PIP_STRICT`, `SAFETY_STRICT`, `BANDIT_STRICT`, `BLACK_STRICT`, `DARGLINT_STRICT`, `ISORT_STRICT`, `MYPY_STRICT`.\n\n</p>\n</details>\n\n## 📈 Releases\n\nYou can see the list of available releases on the [GitHub Releases](https://github.com/fernandocamargoai/bento2seldon/releases) page.\n\nWe follow [Semantic Versions](https://semver.org/) specification.\n\nWe use [`Release Drafter`](https://github.com/marketplace/actions/release-drafter). As pull requests are merged, a draft release is kept up-to-date listing the changes, ready to publish when you’re ready. With the categories option, you can categorize pull requests in release notes using labels.\n\nFor Pull Request this labels are configured, by default:\n\n|               **Label**               |  **Title in Releases**  |\n| :-----------------------------------: | :---------------------: |\n|       `enhancement`, `feature`        |       🚀 Features       |\n| `bug`, `refactoring`, `bugfix`, `fix` | 🔧 Fixes & Refactoring  |\n|       `build`, `ci`, `testing`        | 📦 Build System & CI/CD |\n|              `breaking`               |   💥 Breaking Changes   |\n|            `documentation`            |    📝 Documentation     |\n|            `dependencies`             | ⬆️ Dependencies updates |\n\nYou can update it in [`release-drafter.yml`](https://github.com/fernandocamargoai/bento2seldon/blob/master/.github/release-drafter.yml).\n\nGitHub creates the `bug`, `enhancement`, and `documentation` labels for you. Dependabot creates the `dependencies` label. Create the remaining labels on the Issues tab of your GitHub repository, when you need them.\n\n## 🛡 License\n\n[![License](https://img.shields.io/github/license/fernandocamargoai/bento2seldon)](https://github.com/fernandocamargoai/bento2seldon/blob/master/LICENSE)\n\nThis project is licensed under the terms of the `Apache Software License 2.0` license. See [LICENSE](https://github.com/fernandocamargoai/bento2seldon/blob/master/LICENSE) for more details.\n\n## 📃 Citation\n\n```\n@misc{bento2seldon,\n  author = {fernandocamargoai},\n  title = {Bento2Seldon: A package to run BentoML models in a Kubernetes cluster with Seldon},\n  year = {2021},\n  publisher = {GitHub},\n  journal = {GitHub repository},\n  howpublished = {\\url{https://github.com/fernandocamargoai/bento2seldon}}\n}\n```\n\n## Credits\n\nThis project was generated with [`python-package-template`](https://github.com/TezRomacH/python-package-template).\n',
    'author': 'fernandocamargoai',
    'author_email': 'fernando.camargo.ai@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/fernandocamargoai/bento2seldon',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
