import * as appscaling from '@aws-cdk/aws-applicationautoscaling';
import { IConstruct } from '@aws-cdk/core';
/**
 * Interface for scalable attributes.
 *
 * @stability stable
 */
export interface IScalableFunctionAttribute extends IConstruct {
    /**
     * Scale out or in to keep utilization at a given level.
     *
     * The utilization is tracked by the
     * LambdaProvisionedConcurrencyUtilization metric, emitted by lambda. See:
     * https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics.html#monitoring-metrics-concurrency
     *
     * @stability stable
     */
    scaleOnUtilization(options: UtilizationScalingOptions): void;
    /**
     * Scale out or in based on schedule.
     *
     * @stability stable
     */
    scaleOnSchedule(id: string, actions: appscaling.ScalingSchedule): void;
}
/**
 * Options for enabling Lambda utilization tracking.
 *
 * @stability stable
 */
export interface UtilizationScalingOptions extends appscaling.BaseTargetTrackingProps {
    /**
     * Utilization target for the attribute.
     *
     * For example, .5 indicates that 50 percent of allocated provisioned concurrency is in use.
     *
     * @stability stable
     */
    readonly utilizationTarget: number;
}
/**
 * Properties for enabling Lambda autoscaling.
 *
 * @stability stable
 */
export interface AutoScalingOptions {
    /**
     * Minimum capacity to scale to.
     *
     * @default 1
     * @stability stable
     */
    readonly minCapacity?: number;
    /**
     * Maximum capacity to scale to.
     *
     * @stability stable
     */
    readonly maxCapacity: number;
}
