/*
 * Decompiled with CFR 0.152.
 */
package bsearch.space;

import bsearch.space.ParameterSpec;
import org.nlogo.api.MersenneTwisterFast;

public strictfp class DoubleContinuousSpec
extends ParameterSpec {
    private double dMin;
    private double dMax;

    public DoubleContinuousSpec(String string, double d, double d2) {
        super(string);
        this.dMin = d;
        this.dMax = d2;
    }

    public double getMin() {
        return this.dMin;
    }

    public double getMax() {
        return this.dMax;
    }

    public double enforceValidRange(double d) {
        if (d < this.dMin) {
            return this.dMin;
        }
        if (d > this.dMax) {
            return this.dMax;
        }
        return d;
    }

    @Override
    public Double generateRandomValue(MersenneTwisterFast mersenneTwisterFast) {
        return mersenneTwisterFast.nextDouble() * (this.dMax - this.dMin) + this.dMin;
    }

    @Override
    public Double mutate(Object object, double d, MersenneTwisterFast mersenneTwisterFast) {
        double d2 = (this.dMax - this.dMin) * d;
        return this.enforceValidRange((Double)object + d2 * mersenneTwisterFast.nextGaussian());
    }

    @Override
    public int choiceCount() {
        return -1;
    }

    public String toString() {
        return "[ \"" + this.name + "\" [ " + this.dMin + " \"C\" " + this.dMax + " ]]";
    }

    @Override
    public Object getValueFromChoice(long l, long l2) {
        return this.dMin + (this.dMax - this.dMin) * (double)l / (double)(l2 - 1L);
    }

    @Override
    public long getChoiceIndexFromValue(Object object, long l) {
        if (!(object instanceof Number)) {
            throw new IllegalStateException("Type mismatch: can't represent a non-number using this double-valued parameter specification.");
        }
        double d = ((Number)object).doubleValue();
        return StrictMath.round((d - this.dMin) * (double)(l - 1L) / (this.dMax - this.dMin));
    }
}

