/*
 * Decompiled with CFR 0.152.
 */
package nl4py.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Phaser;
import nl4py.server.HeadlessWorkspaceController;
import py4j.GatewayServer;

public class HeadlessWorkspaceControllerPool {
    private HashSet<HeadlessWorkspaceController> allWorkers;
    private ConcurrentHashMap<String, byte[][][]> resultsMap;
    private Phaser notifier;
    private Integer countProcessors;
    private String modelName;
    private ArrayList<ArrayList<ArrayList<String>>> runNameInitStringPairs;
    private ArrayList<String> reporters;
    private Integer startTick;
    private Integer tickInterval;
    private Integer stopTick;
    private String goCommand;

    public HeadlessWorkspaceControllerPool(String string, Integer n, ArrayList<ArrayList<ArrayList<String>>> arrayList, ArrayList<String> arrayList2, int n2, int n3, int n4, String string2) {
        this.modelName = string;
        this.allWorkers = new HashSet();
        this.resultsMap = new ConcurrentHashMap();
        this.notifier = new Phaser(1);
        this.runNameInitStringPairs = new ArrayList<ArrayList<ArrayList<String>>>(arrayList);
        this.reporters = arrayList2;
        this.startTick = n2;
        this.tickInterval = n3;
        this.stopTick = n4;
        this.goCommand = string2;
        this.countProcessors = n;
        if (this.countProcessors == -1) {
            this.countProcessors = Runtime.getRuntime().availableProcessors();
        }
        if (arrayList.size() < this.countProcessors) {
            this.countProcessors = arrayList.size();
        }
    }

    public HashMap<String, byte[][][]> run() {
        Object object;
        GatewayServer gatewayServer = new GatewayServer(this);
        for (int i = 0; i != this.countProcessors; ++i) {
            object = new HeadlessWorkspaceController(this.notifier, gatewayServer);
            ((HeadlessWorkspaceController)object).openModel(this.modelName);
            this.allWorkers.add((HeadlessWorkspaceController)object);
        }
        object = this.allWorkers.iterator();
        int n = 0;
        while (object.hasNext()) {
            HeadlessWorkspaceController headlessWorkspaceController = (HeadlessWorkspaceController)object.next();
            ArrayList arrayList = new ArrayList(this.runNameInitStringPairs.get(n));
            headlessWorkspaceController.attachPoolTasks(arrayList, this.reporters, this.startTick, this.tickInterval, this.stopTick, this.goCommand, this.resultsMap);
            ++n;
        }
        this.notifier.arriveAndAwaitAdvance();
        this.allWorkers.clear();
        return new HashMap<String, byte[][][]>(this.resultsMap);
    }
}

