/*
 * Decompiled with CFR 0.152.
 */
package nl4py.server;

import bsearch.nlogolink.NetLogoLinkException;
import bsearch.nlogolink.Utils;
import bsearch.space.ParameterSpec;
import bsearch.space.SearchSpace;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.ImageIO;
import nl4py.server.NetLogoController;
import nl4py.server.NetLogoVersionCompatibilityResolver;
import org.nlogo.core.LogoList;
import org.nlogo.headless.HeadlessWorkspace;
import py4j.GatewayServer;
import scala.collection.Iterator;

public class HeadlessWorkspaceController
extends NetLogoController {
    GatewayServer gs;
    HeadlessWorkspace ws;

    public HeadlessWorkspaceController(GatewayServer gatewayServer) {
        this.gs = gatewayServer;
        this.ws = HeadlessWorkspace.newInstance();
    }

    @Override
    public void openModel(String string) {
        try {
            NetLogoVersionCompatibilityResolver.open(this.ws, string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void closeModel() {
        try {
            this.ws.halt();
            this.ws.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            this.ws.dispose();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.ws = HeadlessWorkspace.newInstance();
    }

    @Override
    public void exportView(String string) {
        try {
            BufferedImage bufferedImage = this.ws.exportView();
            File file = new File(string);
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void command(String string) {
        try {
            this.ws.command(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public byte[] report(byte[] byArray) {
        Object object = null;
        try {
            object = this.ws.report(new String(byArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object = exception.getMessage();
        }
        return object.toString().getBytes();
    }

    @Override
    public ArrayList<ArrayList<String>> scheduleReportersAndRun(ArrayList<byte[]> arrayList, int n, int n2, int n3, String string) {
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        int n4 = ((Double)this.ws.report("ticks")).intValue();
        if (n4 < n) {
            this.ws.command("repeat " + Double.toString(n - n4) + " [" + string + "]");
        }
        String string2 = "let nl4pyData (list) repeat " + Integer.toString(n3 - n4) + " [ " + string + " let resultsThisTick (list ";
        for (byte[] byArray : arrayList) {
            string2 = string2 + "( " + new String(byArray) + " ) ";
        }
        string2 = string2 + ") set nl4pyData lput resultsThisTick nl4pyData ] ask patch 0 0 [set plabel nl4pyData]";
        this.ws.command(string2);
        Iterator iterator = ((LogoList)this.ws.report("[plabel] of patch 0 0")).toIterator();
        for (int i = 0; i < (n3 - n4) / n2; ++i) {
            LogoList logoList = (LogoList)iterator.next();
            Iterator iterator2 = logoList.toIterator();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (int j = 0; j < arrayList.size(); ++j) {
                arrayList3.add(iterator2.next().toString());
            }
            arrayList2.add(i, arrayList3);
        }
        return arrayList2;
    }

    @Override
    public SearchSpace getParamList(String string) {
        String string2 = "";
        SearchSpace searchSpace = null;
        try {
            string2 = Utils.getDefaultConstraintsText(string);
            searchSpace = new SearchSpace(Arrays.asList(string2.split("\n")));
            for (ParameterSpec parameterSpec : searchSpace.getParamSpecs()) {
            }
        }
        catch (NetLogoLinkException netLogoLinkException) {
            netLogoLinkException.printStackTrace();
        }
        return searchSpace;
    }

    @Override
    protected void disposeWorkspace() {
        this.closeModel();
        try {
            this.ws.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.ws = null;
        this.gs.shutdown();
        System.gc();
    }
}

