import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectIssueConfig extends cdktf.TerraformMetaArguments {
    /**
    * The IDs of the users to assign the issue to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#assignee_ids ProjectIssue#assignee_ids}
    */
    readonly assigneeIds?: number[];
    /**
    * When the issue was closed. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#closed_at ProjectIssue#closed_at}
    */
    readonly closedAt?: string;
    /**
    * The ID of the user that closed the issue. Use `gitlab_user` data source to get more information about the user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#closed_by_user_id ProjectIssue#closed_by_user_id}
    */
    readonly closedByUserId?: number;
    /**
    * Set an issue to be confidential.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#confidential ProjectIssue#confidential}
    */
    readonly confidential?: boolean | cdktf.IResolvable;
    /**
    * When the issue was created. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z. Requires administrator or project/group owner rights.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#created_at ProjectIssue#created_at}
    */
    readonly createdAt?: string;
    /**
    * Whether the issue is deleted instead of closed during destroy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#delete_on_destroy ProjectIssue#delete_on_destroy}
    */
    readonly deleteOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * The description of an issue. Limited to 1,048,576 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#description ProjectIssue#description}
    */
    readonly description?: string;
    /**
    * Whether the issue is locked for discussions or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#discussion_locked ProjectIssue#discussion_locked}
    */
    readonly discussionLocked?: boolean | cdktf.IResolvable;
    /**
    * The ID of a discussion to resolve. This fills out the issue with a default description and mark the discussion as resolved. Use in combination with merge_request_to_resolve_discussions_of.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#discussion_to_resolve ProjectIssue#discussion_to_resolve}
    */
    readonly discussionToResolve?: string;
    /**
    * The due date. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
  **Note:** removing a due date is currently not supported, see https://github.com/xanzy/go-gitlab/issues/1384 for details.
                  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#due_date ProjectIssue#due_date}
    */
    readonly dueDate?: string;
    /**
    * The ID of the epic issue.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#epic_issue_id ProjectIssue#epic_issue_id}
    */
    readonly epicIssueId?: number;
    /**
    * The human-readable time estimate of the issue.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#human_time_estimate ProjectIssue#human_time_estimate}
    */
    readonly humanTimeEstimate?: string;
    /**
    * The human-readable total time spent of the issue.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#human_total_time_spent ProjectIssue#human_total_time_spent}
    */
    readonly humanTotalTimeSpent?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#id ProjectIssue#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The internal ID of the project's issue.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#iid ProjectIssue#iid}
    */
    readonly iid?: number;
    /**
    * The type of issue. Valid values are: `issue`, `incident`, `test_case`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#issue_type ProjectIssue#issue_type}
    */
    readonly issueType?: string;
    /**
    * The labels of an issue.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#labels ProjectIssue#labels}
    */
    readonly labels?: string[];
    /**
    * The links of the issue.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#links ProjectIssue#links}
    */
    readonly links?: {
        [key: string]: string;
    };
    /**
    * The IID of a merge request in which to resolve all issues. This fills out the issue with a default description and mark all discussions as resolved. When passing a description or title, these values take precedence over the default values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#merge_request_to_resolve_discussions_of ProjectIssue#merge_request_to_resolve_discussions_of}
    */
    readonly mergeRequestToResolveDiscussionsOf?: number;
    /**
    * The global ID of a milestone to assign issue. To find the milestone_id associated with a milestone, view an issue with the milestone assigned and use the API to retrieve the issue's details.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#milestone_id ProjectIssue#milestone_id}
    */
    readonly milestoneId?: number;
    /**
    * The name or ID of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#project ProjectIssue#project}
    */
    readonly project: string;
    /**
    * The references of the issue.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#references ProjectIssue#references}
    */
    readonly references?: {
        [key: string]: string;
    };
    /**
    * The state of the issue. Valid values are: `opened`, `closed`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#state ProjectIssue#state}
    */
    readonly state?: string;
    /**
    * The time estimate of the issue.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#time_estimate ProjectIssue#time_estimate}
    */
    readonly timeEstimate?: number;
    /**
    * The title of the issue.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#title ProjectIssue#title}
    */
    readonly title: string;
    /**
    * The total time spent of the issue.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#total_time_spent ProjectIssue#total_time_spent}
    */
    readonly totalTimeSpent?: number;
    /**
    * When the issue was updated. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#updated_at ProjectIssue#updated_at}
    */
    readonly updatedAt?: string;
    /**
    * The weight of the issue. Valid values are greater than or equal to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#weight ProjectIssue#weight}
    */
    readonly weight?: number;
    /**
    * task_completion_status block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#task_completion_status ProjectIssue#task_completion_status}
    */
    readonly taskCompletionStatus?: ProjectIssueTaskCompletionStatus;
}
export interface ProjectIssueTaskCompletionStatus {
    /**
    * The number of tasks that are completed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#completed_count ProjectIssue#completed_count}
    */
    readonly completedCount?: number;
    /**
    * The number of tasks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue#count ProjectIssue#count}
    */
    readonly count?: number;
}
export declare function projectIssueTaskCompletionStatusToTerraform(struct?: ProjectIssueTaskCompletionStatusOutputReference | ProjectIssueTaskCompletionStatus): any;
export declare class ProjectIssueTaskCompletionStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ProjectIssueTaskCompletionStatus | undefined;
    set internalValue(value: ProjectIssueTaskCompletionStatus | undefined);
    private _completedCount?;
    get completedCount(): number;
    set completedCount(value: number);
    resetCompletedCount(): void;
    get completedCountInput(): number | undefined;
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue gitlab_project_issue}
*/
export declare class ProjectIssue extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_project_issue";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue gitlab_project_issue} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectIssueConfig
    */
    constructor(scope: Construct, id: string, config: ProjectIssueConfig);
    private _assigneeIds?;
    get assigneeIds(): number[];
    set assigneeIds(value: number[]);
    resetAssigneeIds(): void;
    get assigneeIdsInput(): number[] | undefined;
    get authorId(): number;
    private _closedAt?;
    get closedAt(): string;
    set closedAt(value: string);
    resetClosedAt(): void;
    get closedAtInput(): string | undefined;
    private _closedByUserId?;
    get closedByUserId(): number;
    set closedByUserId(value: number);
    resetClosedByUserId(): void;
    get closedByUserIdInput(): number | undefined;
    private _confidential?;
    get confidential(): boolean | cdktf.IResolvable;
    set confidential(value: boolean | cdktf.IResolvable);
    resetConfidential(): void;
    get confidentialInput(): boolean | cdktf.IResolvable | undefined;
    private _createdAt?;
    get createdAt(): string;
    set createdAt(value: string);
    resetCreatedAt(): void;
    get createdAtInput(): string | undefined;
    private _deleteOnDestroy?;
    get deleteOnDestroy(): boolean | cdktf.IResolvable;
    set deleteOnDestroy(value: boolean | cdktf.IResolvable);
    resetDeleteOnDestroy(): void;
    get deleteOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _discussionLocked?;
    get discussionLocked(): boolean | cdktf.IResolvable;
    set discussionLocked(value: boolean | cdktf.IResolvable);
    resetDiscussionLocked(): void;
    get discussionLockedInput(): boolean | cdktf.IResolvable | undefined;
    private _discussionToResolve?;
    get discussionToResolve(): string;
    set discussionToResolve(value: string);
    resetDiscussionToResolve(): void;
    get discussionToResolveInput(): string | undefined;
    get downvotes(): number;
    private _dueDate?;
    get dueDate(): string;
    set dueDate(value: string);
    resetDueDate(): void;
    get dueDateInput(): string | undefined;
    get epicId(): number;
    private _epicIssueId?;
    get epicIssueId(): number;
    set epicIssueId(value: number);
    resetEpicIssueId(): void;
    get epicIssueIdInput(): number | undefined;
    get externalId(): string;
    private _humanTimeEstimate?;
    get humanTimeEstimate(): string;
    set humanTimeEstimate(value: string);
    resetHumanTimeEstimate(): void;
    get humanTimeEstimateInput(): string | undefined;
    private _humanTotalTimeSpent?;
    get humanTotalTimeSpent(): string;
    set humanTotalTimeSpent(value: string);
    resetHumanTotalTimeSpent(): void;
    get humanTotalTimeSpentInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _iid?;
    get iid(): number;
    set iid(value: number);
    resetIid(): void;
    get iidInput(): number | undefined;
    get issueId(): number;
    get issueLinkId(): number;
    private _issueType?;
    get issueType(): string;
    set issueType(value: string);
    resetIssueType(): void;
    get issueTypeInput(): string | undefined;
    private _labels?;
    get labels(): string[];
    set labels(value: string[]);
    resetLabels(): void;
    get labelsInput(): string[] | undefined;
    private _links?;
    get links(): {
        [key: string]: string;
    };
    set links(value: {
        [key: string]: string;
    });
    resetLinks(): void;
    get linksInput(): {
        [key: string]: string;
    } | undefined;
    private _mergeRequestToResolveDiscussionsOf?;
    get mergeRequestToResolveDiscussionsOf(): number;
    set mergeRequestToResolveDiscussionsOf(value: number);
    resetMergeRequestToResolveDiscussionsOf(): void;
    get mergeRequestToResolveDiscussionsOfInput(): number | undefined;
    get mergeRequestsCount(): number;
    private _milestoneId?;
    get milestoneId(): number;
    set milestoneId(value: number);
    resetMilestoneId(): void;
    get milestoneIdInput(): number | undefined;
    get movedToId(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _references?;
    get references(): {
        [key: string]: string;
    };
    set references(value: {
        [key: string]: string;
    });
    resetReferences(): void;
    get referencesInput(): {
        [key: string]: string;
    } | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    get subscribed(): cdktf.IResolvable;
    private _timeEstimate?;
    get timeEstimate(): number;
    set timeEstimate(value: number);
    resetTimeEstimate(): void;
    get timeEstimateInput(): number | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _totalTimeSpent?;
    get totalTimeSpent(): number;
    set totalTimeSpent(value: number);
    resetTotalTimeSpent(): void;
    get totalTimeSpentInput(): number | undefined;
    private _updatedAt?;
    get updatedAt(): string;
    set updatedAt(value: string);
    resetUpdatedAt(): void;
    get updatedAtInput(): string | undefined;
    get upvotes(): number;
    get userNotesCount(): number;
    get webUrl(): string;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
    private _taskCompletionStatus;
    get taskCompletionStatus(): ProjectIssueTaskCompletionStatusOutputReference;
    putTaskCompletionStatus(value: ProjectIssueTaskCompletionStatus): void;
    resetTaskCompletionStatus(): void;
    get taskCompletionStatusInput(): ProjectIssueTaskCompletionStatus | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=project-issue.d.ts.map