"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConcreteWidget = exports.GRID_WIDTH = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The width of the grid we're filling
 */
exports.GRID_WIDTH = 24;
/**
 * A real CloudWatch widget that has its own fixed size and remembers its position.
 *
 * This is in contrast to other widgets which exist for layout purposes.
 *
 * @stability stable
 */
class ConcreteWidget {
    /**
     * @stability stable
     */
    constructor(width, height) {
        this.width = width;
        this.height = height;
        if (this.width > exports.GRID_WIDTH) {
            throw new Error(`Widget is too wide, max ${exports.GRID_WIDTH} units allowed`);
        }
    }
    /**
     * Place the widget at a given position.
     *
     * @stability stable
     */
    position(x, y) {
        this.x = x;
        this.y = y;
    }
}
exports.ConcreteWidget = ConcreteWidget;
_a = JSII_RTTI_SYMBOL_1;
ConcreteWidget[_a] = { fqn: "@aws-cdk/aws-cloudwatch.ConcreteWidget", version: "1.101.0" };
//# sourceMappingURL=data:application/json;base64,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