import { ConcreteWidget } from './widget';
/**
 * Types of view.
 *
 * @stability stable
 */
export declare enum LogQueryVisualizationType {
    /**
     * Table view.
     *
     * @stability stable
     */
    TABLE = "table",
    /**
     * Line view.
     *
     * @stability stable
     */
    LINE = "line",
    /**
     * Stacked area view.
     *
     * @stability stable
     */
    STACKEDAREA = "stackedarea",
    /**
     * Bar view.
     *
     * @stability stable
     */
    BAR = "bar",
    /**
     * Pie view.
     *
     * @stability stable
     */
    PIE = "pie"
}
/**
 * Properties for a Query widget.
 *
 * @stability stable
 */
export interface LogQueryWidgetProps {
    /**
     * Title for the widget.
     *
     * @default No title
     * @stability stable
     */
    readonly title?: string;
    /**
     * Names of log groups to query.
     *
     * @stability stable
     */
    readonly logGroupNames: string[];
    /**
     * Full query string for log insights.
     *
     * Be sure to prepend every new line with a newline and pipe character
     * (`\n|`).
     *
     * @default - Exactly one of `queryString`, `queryLines` is required.
     * @stability stable
     */
    readonly queryString?: string;
    /**
     * A sequence of lines to use to build the query.
     *
     * The query will be built by joining the lines together using `\n|`.
     *
     * @default - Exactly one of `queryString`, `queryLines` is required.
     * @stability stable
     */
    readonly queryLines?: string[];
    /**
     * The region the metrics of this widget should be taken from.
     *
     * @default Current region
     * @stability stable
     */
    readonly region?: string;
    /**
     * The type of view to use.
     *
     * @default LogQueryVisualizationType.TABLE
     * @stability stable
     */
    readonly view?: LogQueryVisualizationType;
    /**
     * Width of the widget, in a grid of 24 units wide.
     *
     * @default 6
     * @stability stable
     */
    readonly width?: number;
    /**
     * Height of the widget.
     *
     * @default 6
     * @stability stable
     */
    readonly height?: number;
}
/**
 * Display query results from Logs Insights.
 *
 * @stability stable
 */
export declare class LogQueryWidget extends ConcreteWidget {
    private readonly props;
    /**
     * @stability stable
     */
    constructor(props: LogQueryWidgetProps);
    /**
     * Return the widget JSON for use in the dashboard.
     *
     * @stability stable
     */
    toJson(): any[];
}
