import { Construct } from 'constructs';
import { AlarmBase, IAlarm, IAlarmRule } from './alarm-base';
/**
 * Properties for creating a Composite Alarm.
 *
 * @stability stable
 */
export interface CompositeAlarmProps {
    /**
     * Whether the actions for this alarm are enabled.
     *
     * @default true
     * @stability stable
     */
    readonly actionsEnabled?: boolean;
    /**
     * Description for the alarm.
     *
     * @default No description
     * @stability stable
     */
    readonly alarmDescription?: string;
    /**
     * Name of the alarm.
     *
     * @default Automatically generated name
     * @stability stable
     */
    readonly compositeAlarmName?: string;
    /**
     * Expression that specifies which other alarms are to be evaluated to determine this composite alarm's state.
     *
     * @stability stable
     */
    readonly alarmRule: IAlarmRule;
}
/**
 * A Composite Alarm based on Alarm Rule.
 *
 * @stability stable
 */
export declare class CompositeAlarm extends AlarmBase {
    /**
     * Import an existing CloudWatch composite alarm provided an Name.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param compositeAlarmName Composite Alarm Name.
     * @stability stable
     */
    static fromCompositeAlarmName(scope: Construct, id: string, compositeAlarmName: string): IAlarm;
    /**
     * Import an existing CloudWatch composite alarm provided an ARN.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param compositeAlarmArn Composite Alarm ARN (i.e. arn:aws:cloudwatch:<region>:<account-id>:alarm/CompositeAlarmName).
     * @stability stable
     */
    static fromCompositeAlarmArn(scope: Construct, id: string, compositeAlarmArn: string): IAlarm;
    /**
     * ARN of this alarm.
     *
     * @stability stable
     * @attribute true
     */
    readonly alarmArn: string;
    /**
     * Name of this alarm.
     *
     * @stability stable
     * @attribute true
     */
    readonly alarmName: string;
    private readonly alarmRule;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: CompositeAlarmProps);
    private generateUniqueId;
}
