# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ruia_peewee_async']

package_data = \
{'': ['*']}

install_requires = \
['peewee-async>=0.8.0,<0.9.0', 'ruia>=0.8.4,<0.9.0', 'schema>=0.7.5,<0.8.0']

extras_require = \
{'aiomysql': ['aiomysql>=0.1.1,<0.2.0'],
 'aiopg': ['aiopg>=1.3.4,<2.0.0'],
 'all': ['aiomysql>=0.1.1,<0.2.0', 'aiopg>=1.3.4,<2.0.0']}

setup_kwargs = {
    'name': 'ruia-peewee-async',
    'version': '1.2.1',
    'description': 'A Ruia plugin that uses the peewee-async to store data to MySQL',
    'long_description': '# ruia-peewee-async\n[![996.icu](https://img.shields.io/badge/link-996.icu-red.svg)](https://996.icu)\n[![LICENSE](https://img.shields.io/badge/license-Anti%20996-blue.svg)](https://github.com/996icu/996.ICU/blob/master/LICENSE)\n\nA [Ruia](https://github.com/howie6879/ruia) plugin that uses [peewee-async](https://github.com/05bit/peewee-async) to store data to MySQL or PostgreSQL or both of them.\n\n\n## Installation\n\nUsing [pip](https://pip.pypa.io/en/stable/) or [ pipenv ](https://pipenv.pypa.io/en/latest/) or [ poetry ](https://python-poetry.org/) to install.\n\n```shell\npip install ruia-peewee-async[aiomysql]\npipenv install ruia-peewee-async[aiomysql]\npoetry add ruia-peewee-async[aiomysql]\n\nor\n\npip install ruia-peewee-async[aiopg]\npipenv install ruia-peewee-async[aiopg]\npoetry add ruia-peewee-async[aiopg]\n\nor\n\npip install ruia-peewee-async[all]\npipenv install ruia-peewee-async[all]\npoetry install ruia-peewee-async[all]\n```\n`ruia-peewee-async[all]` means to install both aiomysql and aiopg.\n\n## Usage\n\nA complete example is like below.\n```python\n# -*- coding: utf-8 -*-\nfrom peewee import CharField\nfrom ruia import AttrField, Item, Response, TextField\n\nfrom ruia_peewee_async import (\n    RuiaPeeweeInsert,\n    RuiaPeeweeUpdate,\n    Spider,\n    TargetDB,\n    after_start,\n)\n\n\nclass DoubanItem(Item):\n    target_item = TextField(css_select="tr.item")\n    title = AttrField(css_select="a.nbg", attr="title")\n    url = AttrField(css_select="a.nbg", attr="href")\n\n    async def clean_title(self, value):\n        return value.strip()\n\n\nclass DoubanSpider(Spider):\n    start_urls = ["https://movie.douban.com/chart"]\n    # aiohttp_kwargs = {"proxy": "http://127.0.0.1:7890"}\n\n    async def parse(self, response: Response):\n        async for item in DoubanItem.get_items(html=await response.text()):\n            yield RuiaPeeweeInsert(item.results)  # default is MySQL\n            # yield RuiaPeeweeInsert(item.results, database=TargetDB.POSTGRES) # save to Postgresql\n            # yield RuiaPeeweeInsert(item.results, database=TargetDB.BOTH) # save to both MySQL and Postgresql\n\n\nclass DoubanUpdateSpider(Spider):\n    start_urls = ["https://movie.douban.com/chart"]\n\n    async def parse(self, response: Response):\n        async for item in DoubanItem.get_items(html=await response.text()):\n            res = {}\n            res["title"] = item.results["title"]\n            res["url"] = "http://whatever.youwanttoupdate.com"\n            yield RuiaPeeweeUpdate(\n                res,\n                {"title": res["title"]},\n                database=TargetDB.POSTGRES,  # default is MySQL\n            )\n\n            # Args for RuiaPeeweeUpdate\n            # data: A dict that\'s going to be updated in the database.\n            # query: A peewee\'s query or a dict to search for the target data in database.\n            # database: The target database type.\n            # create_when_not_exists: Default is True. If True, will create a record when query can\'t get the record.\n            # not_update_when_exists: Default is True. If True and record exists, won\'t update data to the records.\n            # only: A list or tuple of fields that should be updated only.\n\n\nmysql = {\n    "host": "127.0.0.1",\n    "port": 3306,\n    "user": "ruiamysql",\n    "password": "abc123",\n    "database": "ruiamysql",\n    "model": {\n        "table_name": "ruia_mysql",\n        "title": CharField(),\n        "url": CharField(),\n    },\n}\npostgres = {\n    "host": "127.0.0.1",\n    "port": 5432,\n    "user": "ruiapostgres",\n    "password": "abc123",\n    "database": "ruiapostgres",\n    "model": {\n        "table_name": "ruia_postgres",\n        "title": CharField(),\n        "url": CharField(),\n    },\n}\n\nif __name__ == "__main__":\n    DoubanSpider.start(after_start=after_start(mysql=mysql))\n    # DoubanSpider.start(after_start=after_start(postgres=postgres))\n    # DoubanSpider.start(after_start=after_start(mysql=mysql, postgres=postgres))\n    # DoubanUpdateSpider.start(after_start=after_start(mysql=mysql))\n```\n\nThere\'s a `create_model` method to create the Peewee model based on database configuration.\n```python\nfrom ruia_peewee_async import create_model\n\nmodel = create_model(mysql=mysql) # or postgres=postgres or both\n# create the table at the same time\nmodel = create_mode(postgres=postgres, create_table=True)\nrows = model.select().count()\nprint(rows)\n```\n\nAnd class `Spider` from `ruia_peewee_async` has attributes below related to database you can use.\n```python\nfrom peewee import Model\nfrom typing import Dict\nfrom peewee_async import Manager, MySQLDatabase, PostgresqlDatabase\nfrom ruia import Spider as RuiaSpider\n\nclass Spider(RuiaSpider):\n    mysql_model: Union[Model, Dict] # It will be a Model instance after spider started.\n    mysql_manager: Manager\n    postgres_model: Union[Model, Dict] # same above\n    postgres_manager: Manager\n    mysql_db: MySQLDatabase\n    postgres_db: PostgresqlDatabase\n```\nFor more information, check out [peewee\'s documentation](http://docs.peewee-orm.com/en/latest/) and [peewee-async\'s documentation](https://peewee-async.readthedocs.io/en/latest/).\n\n## Development\nUsing `pyenv` to install the version of python that you need.\nFor example\n```shell\npyenv install 3.7.9\n```\nThen go to the root of the project and run:\n```shell\npoetry install && poetry install -E aiomysql -E aiopg\n```\nto install all dependencies.\n\n- Using `poetry shell` to enter the virtual environment.\n  Or open your favorite editor and select the virtual environment to start coding.\n- Using `pytest` to run unit tests under `tests` folder.\n- Using `pytest --cov .` to run all tests and generate coverage report in terminal.\n\n## Thanks\n- [ruia](https://github.com/howie6879/ruia)\n- [peewew](https://github.com/coleifer/peewee)\n- [peewee-async](https://github.com/05bit/peewee-async)\n- [aiomysql](https://github.com/aio-libs/aiomysql)\n- [aiopg](https://github.com/aio-libs/aiopg)\n- [schema](https://github.com/keleshev/schema)\n- [pytest and its awesome plugins](https://github.com/pytest-dev/pytest)\n',
    'author': 'Jack Deng',
    'author_email': 'dlwxxxdlw@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/JackTheMico/ruia-peewee-async',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7.2,<4.0.0',
}


setup(**setup_kwargs)
