# Bayesian inference and forecast of COVID-19, code repository

[![Documentation Status](https://readthedocs.org/projects/covid19-inference/badge/?version=latest)](https://covid19-inference.readthedocs.io/en/latest/doc/gettingstarted.html)
[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

This is a Bayesian python toolbox for inference and forecast of the spread of the Coronavirus. We also provide a variety of data download utilities which allow quick and easy data exploration of Coronavirus related datasets.

- [**Documentation**](https://covid19-inference.readthedocs.io/en/latest/index.html)
- [**Getting started**](https://covid19-inference.readthedocs.io/en/latest/doc/gettingstarted.html)
- [**Examples**](https://covid19-inference.readthedocs.io/en/latest/doc/examples.html)
- [**Contributing**](https://covid19-inference.readthedocs.io/en/latest/doc/contributing.html)
- [**Source code**](https://github.com/Priesemann-Group/covid19_inference)


The latest stable version is [v0.4.0](https://github.com/Priesemann-Group/covid19_inference/tree/v0.4.0)!


## Please take notice of our [disclaimer](DISCLAIMER.md).


## Installation:

Can be installed from pypi with
```
pip install covid19_inference
```

## Related Publications
These research articles use this package:
- *Inferring change points in the spread of COVID-19 reveals the effectiveness of interventions*
    - This research article [is available on arXiv](https://arxiv.org/abs/2004.01105) (**updated on April 13 2020**) and was published [in Science](https://www.science.org/doi/10.1126/science.abb9789).
    - The code used to produce the figures is available in the other repository [here](https://github.com/Priesemann-Group/covid19_inference_forecast).
- *Mutational signatures and transmissibility of SARS-CoV-2 Gamma and Lambda variants*
    - This research article [is available on arXiv](https://arxiv.org/abs/2108.10018) (**updated on August 21 2021**).

If you are interested in our efforts and like to help us feel free to contact us. **We are looking for support**