"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SpaDistribution = exports.StaticSiteDistribution = exports.BaseDistribution = void 0;
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_cloudfront_origins_1 = require("@aws-cdk/aws-cloudfront-origins");
const core_1 = require("@aws-cdk/core");
const cdk_deletable_bucket_1 = require("@cloudcomponents/cdk-deletable-bucket");
class BaseDistribution extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b, _c;
        super(scope, id);
        const removalPolicy = (_a = props.removalPolicy) !== null && _a !== void 0 ? _a : core_1.RemovalPolicy.DESTROY;
        const origin = (_b = props.origin) !== null && _b !== void 0 ? _b : this.defaultOrigin(removalPolicy === core_1.RemovalPolicy.DESTROY);
        const distribution = new aws_cloudfront_1.Distribution(this, 'Distribution', {
            priceClass: (_c = props.priceClass) !== null && _c !== void 0 ? _c : aws_cloudfront_1.PriceClass.PRICE_CLASS_100,
            errorResponses: props.errorResponses,
            certificate: props.certificate,
            defaultBehavior: props.authorization.createDefaultBehavior(origin),
            additionalBehaviors: props.authorization.createAdditionalBehaviors(origin),
        });
        //TODO
        distribution.node.findChild('CFDistribution').addOverride('Properties.DistributionConfig.DefaultRootObject', 'index.html');
        props.authorization.updateUserPoolClientCallbacks({
            callbackUrls: [`https://${distribution.distributionDomainName}${props.authorization.redirectPaths.signIn}`],
            logoutUrls: [`https://${distribution.distributionDomainName}${props.authorization.redirectPaths.signOut}`],
        });
    }
    defaultOrigin(forceDelete) {
        const bucket = new cdk_deletable_bucket_1.DeletableBucket(this, 'DeletableBucket', {
            forceDelete,
        });
        return new aws_cloudfront_origins_1.S3Origin(bucket);
    }
}
exports.BaseDistribution = BaseDistribution;
class StaticSiteDistribution extends BaseDistribution {
    constructor(scope, id, props) {
        super(scope, id, props);
    }
}
exports.StaticSiteDistribution = StaticSiteDistribution;
class SpaDistribution extends BaseDistribution {
    constructor(scope, id, props) {
        var _a;
        super(scope, id, {
            ...props,
            errorResponses: [
                {
                    httpStatus: 404,
                    responseHttpStatus: 200,
                    ttl: (_a = props.ttl) !== null && _a !== void 0 ? _a : core_1.Duration.seconds(300),
                    responsePagePath: '/index.html',
                },
            ],
        });
    }
}
exports.SpaDistribution = SpaDistribution;
//# sourceMappingURL=data:application/json;base64,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