"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthFlow = void 0;
const path = require("path");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const cdk_lambda_at_edge_pattern_1 = require("@cloudcomponents/cdk-lambda-at-edge-pattern");
class AuthFlow extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const edgeRole = new cdk_lambda_at_edge_pattern_1.EdgeRole(this, 'EdgeRole');
        const configuration = {
            logLevel: props.logLevel,
            httpHeaders: props.httpHeaders,
            redirectPathSignIn: props.redirectPaths.signIn,
            redirectPathAuthRefresh: props.redirectPaths.authRefresh,
            redirectPathSignOut: props.redirectPaths.signOut,
            userPoolId: props.userPool.userPoolId,
            clientId: props.userPoolClient.userPoolClientId,
            oauthScopes: props.oauthScopes.map((scope) => scope.scopeName),
            cognitoAuthDomain: props.cognitoAuthDomain,
            cookieSettings: props.cookieSettings,
            nonceSigningSecret: props.nonceSigningSecret,
            clientSecret: props.clientSecret,
        };
        this.checkAuth = new cdk_lambda_at_edge_pattern_1.EdgeFunction(this, 'CheckAuth', {
            name: 'check-auth',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'check-auth')),
            edgeRole,
            configuration,
            eventType: aws_cloudfront_1.LambdaEdgeEventType.VIEWER_REQUEST,
        });
        this.parseAuth = new cdk_lambda_at_edge_pattern_1.EdgeFunction(this, 'ParseAuth', {
            name: 'parse-auth',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'parse-auth')),
            edgeRole,
            configuration,
            eventType: aws_cloudfront_1.LambdaEdgeEventType.VIEWER_REQUEST,
        });
        this.refreshAuth = new cdk_lambda_at_edge_pattern_1.EdgeFunction(this, 'RefreshAuth', {
            name: 'refresh-auth',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'refresh-auth')),
            edgeRole,
            configuration,
            eventType: aws_cloudfront_1.LambdaEdgeEventType.VIEWER_REQUEST,
        });
        this.signOut = new cdk_lambda_at_edge_pattern_1.EdgeFunction(this, 'SignOut', {
            name: 'sign-out',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'sign-out')),
            edgeRole,
            configuration,
            eventType: aws_cloudfront_1.LambdaEdgeEventType.VIEWER_REQUEST,
        });
        this.httpHeaders = new cdk_lambda_at_edge_pattern_1.HttpHeaders(this, 'HttpHeaders', {
            httpHeaders: props.httpHeaders,
            edgeRole,
        });
    }
}
exports.AuthFlow = AuthFlow;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXV0aC1mbG93LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2F1dGgtZmxvdy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw2QkFBNkI7QUFDN0IsNERBQThEO0FBRTlELG9EQUEyQztBQUMzQyx3Q0FBMEM7QUFDMUMsNEZBQTRHO0FBcUI1RyxNQUFhLFFBQVMsU0FBUSxnQkFBUztJQU9yQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQW9CO1FBQzVELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxRQUFRLEdBQUcsSUFBSSxxQ0FBUSxDQUFDLElBQUksRUFBRSxVQUFVLENBQUMsQ0FBQztRQUVoRCxNQUFNLGFBQWEsR0FBRztZQUNwQixRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7WUFDeEIsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxhQUFhLENBQUMsTUFBTTtZQUM5Qyx1QkFBdUIsRUFBRSxLQUFLLENBQUMsYUFBYSxDQUFDLFdBQVc7WUFDeEQsbUJBQW1CLEVBQUUsS0FBSyxDQUFDLGFBQWEsQ0FBQyxPQUFPO1lBQ2hELFVBQVUsRUFBRSxLQUFLLENBQUMsUUFBUSxDQUFDLFVBQVU7WUFDckMsUUFBUSxFQUFFLEtBQUssQ0FBQyxjQUFjLENBQUMsZ0JBQWdCO1lBQy9DLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQztZQUM5RCxpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCO1lBQzFDLGNBQWMsRUFBRSxLQUFLLENBQUMsY0FBYztZQUNwQyxrQkFBa0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCO1lBQzVDLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtTQUNqQyxDQUFDO1FBRUYsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLHlDQUFZLENBQUMsSUFBSSxFQUFFLFdBQVcsRUFBRTtZQUNuRCxJQUFJLEVBQUUsWUFBWTtZQUNsQixJQUFJLEVBQUUsaUJBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLFlBQVksQ0FBQyxDQUFDO1lBQ25FLFFBQVE7WUFDUixhQUFhO1lBQ2IsU0FBUyxFQUFFLG9DQUFtQixDQUFDLGNBQWM7U0FDOUMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLHlDQUFZLENBQUMsSUFBSSxFQUFFLFdBQVcsRUFBRTtZQUNuRCxJQUFJLEVBQUUsWUFBWTtZQUNsQixJQUFJLEVBQUUsaUJBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLFlBQVksQ0FBQyxDQUFDO1lBQ25FLFFBQVE7WUFDUixhQUFhO1lBQ2IsU0FBUyxFQUFFLG9DQUFtQixDQUFDLGNBQWM7U0FDOUMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLHlDQUFZLENBQUMsSUFBSSxFQUFFLGFBQWEsRUFBRTtZQUN2RCxJQUFJLEVBQUUsY0FBYztZQUNwQixJQUFJLEVBQUUsaUJBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLGNBQWMsQ0FBQyxDQUFDO1lBQ3JFLFFBQVE7WUFDUixhQUFhO1lBQ2IsU0FBUyxFQUFFLG9DQUFtQixDQUFDLGNBQWM7U0FDOUMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLHlDQUFZLENBQUMsSUFBSSxFQUFFLFNBQVMsRUFBRTtZQUMvQyxJQUFJLEVBQUUsVUFBVTtZQUNoQixJQUFJLEVBQUUsaUJBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLFVBQVUsQ0FBQyxDQUFDO1lBQ2pFLFFBQVE7WUFDUixhQUFhO1lBQ2IsU0FBUyxFQUFFLG9DQUFtQixDQUFDLGNBQWM7U0FDOUMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLHdDQUFXLENBQUMsSUFBSSxFQUFFLGFBQWEsRUFBRTtZQUN0RCxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsUUFBUTtTQUNULENBQUMsQ0FBQztJQUNMLENBQUM7Q0FDRjtBQWhFRCw0QkFnRUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0IHsgTGFtYmRhRWRnZUV2ZW50VHlwZSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1jbG91ZGZyb250JztcbmltcG9ydCB7IElVc2VyUG9vbCwgSVVzZXJQb29sQ2xpZW50LCBPQXV0aFNjb3BlIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWNvZ25pdG8nO1xuaW1wb3J0IHsgQ29kZSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBFZGdlRnVuY3Rpb24sIEh0dHBIZWFkZXJzLCBMb2dMZXZlbCwgRWRnZVJvbGUgfSBmcm9tICdAY2xvdWRjb21wb25lbnRzL2Nkay1sYW1iZGEtYXQtZWRnZS1wYXR0ZXJuJztcblxuZXhwb3J0IGludGVyZmFjZSBSZWRpcmVjdFBhdGhzIHtcbiAgcmVhZG9ubHkgc2lnbkluOiBzdHJpbmc7XG4gIHJlYWRvbmx5IGF1dGhSZWZyZXNoOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHNpZ25PdXQ6IHN0cmluZztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBBdXRoRmxvd1Byb3BzIHtcbiAgcmVhZG9ubHkgbG9nTGV2ZWw6IExvZ0xldmVsO1xuICByZWFkb25seSBodHRwSGVhZGVyczogUmVjb3JkPHN0cmluZywgc3RyaW5nPjtcbiAgcmVhZG9ubHkgdXNlclBvb2w6IElVc2VyUG9vbDtcbiAgcmVhZG9ubHkgdXNlclBvb2xDbGllbnQ6IElVc2VyUG9vbENsaWVudDtcbiAgcmVhZG9ubHkgY29nbml0b0F1dGhEb21haW46IHN0cmluZztcbiAgcmVhZG9ubHkgcmVkaXJlY3RQYXRoczogUmVkaXJlY3RQYXRocztcbiAgcmVhZG9ubHkgb2F1dGhTY29wZXM6IE9BdXRoU2NvcGVbXTtcbiAgcmVhZG9ubHkgY29va2llU2V0dGluZ3M6IFJlY29yZDxzdHJpbmcsIHN0cmluZz47XG4gIHJlYWRvbmx5IG5vbmNlU2lnbmluZ1NlY3JldDogc3RyaW5nO1xuICByZWFkb25seSBjbGllbnRTZWNyZXQ/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBjbGFzcyBBdXRoRmxvdyBleHRlbmRzIENvbnN0cnVjdCB7XG4gIHB1YmxpYyByZWFkb25seSBjaGVja0F1dGg6IEVkZ2VGdW5jdGlvbjtcbiAgcHVibGljIHJlYWRvbmx5IHBhcnNlQXV0aDogRWRnZUZ1bmN0aW9uO1xuICBwdWJsaWMgcmVhZG9ubHkgcmVmcmVzaEF1dGg6IEVkZ2VGdW5jdGlvbjtcbiAgcHVibGljIHJlYWRvbmx5IHNpZ25PdXQ6IEVkZ2VGdW5jdGlvbjtcbiAgcHVibGljIHJlYWRvbmx5IGh0dHBIZWFkZXJzOiBFZGdlRnVuY3Rpb247XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEF1dGhGbG93UHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgZWRnZVJvbGUgPSBuZXcgRWRnZVJvbGUodGhpcywgJ0VkZ2VSb2xlJyk7XG5cbiAgICBjb25zdCBjb25maWd1cmF0aW9uID0ge1xuICAgICAgbG9nTGV2ZWw6IHByb3BzLmxvZ0xldmVsLFxuICAgICAgaHR0cEhlYWRlcnM6IHByb3BzLmh0dHBIZWFkZXJzLFxuICAgICAgcmVkaXJlY3RQYXRoU2lnbkluOiBwcm9wcy5yZWRpcmVjdFBhdGhzLnNpZ25JbixcbiAgICAgIHJlZGlyZWN0UGF0aEF1dGhSZWZyZXNoOiBwcm9wcy5yZWRpcmVjdFBhdGhzLmF1dGhSZWZyZXNoLFxuICAgICAgcmVkaXJlY3RQYXRoU2lnbk91dDogcHJvcHMucmVkaXJlY3RQYXRocy5zaWduT3V0LFxuICAgICAgdXNlclBvb2xJZDogcHJvcHMudXNlclBvb2wudXNlclBvb2xJZCxcbiAgICAgIGNsaWVudElkOiBwcm9wcy51c2VyUG9vbENsaWVudC51c2VyUG9vbENsaWVudElkLFxuICAgICAgb2F1dGhTY29wZXM6IHByb3BzLm9hdXRoU2NvcGVzLm1hcCgoc2NvcGUpID0+IHNjb3BlLnNjb3BlTmFtZSksXG4gICAgICBjb2duaXRvQXV0aERvbWFpbjogcHJvcHMuY29nbml0b0F1dGhEb21haW4sXG4gICAgICBjb29raWVTZXR0aW5nczogcHJvcHMuY29va2llU2V0dGluZ3MsXG4gICAgICBub25jZVNpZ25pbmdTZWNyZXQ6IHByb3BzLm5vbmNlU2lnbmluZ1NlY3JldCxcbiAgICAgIGNsaWVudFNlY3JldDogcHJvcHMuY2xpZW50U2VjcmV0LFxuICAgIH07XG5cbiAgICB0aGlzLmNoZWNrQXV0aCA9IG5ldyBFZGdlRnVuY3Rpb24odGhpcywgJ0NoZWNrQXV0aCcsIHtcbiAgICAgIG5hbWU6ICdjaGVjay1hdXRoJyxcbiAgICAgIGNvZGU6IENvZGUuZnJvbUFzc2V0KHBhdGguam9pbihfX2Rpcm5hbWUsICdsYW1iZGFzJywgJ2NoZWNrLWF1dGgnKSksXG4gICAgICBlZGdlUm9sZSxcbiAgICAgIGNvbmZpZ3VyYXRpb24sXG4gICAgICBldmVudFR5cGU6IExhbWJkYUVkZ2VFdmVudFR5cGUuVklFV0VSX1JFUVVFU1QsXG4gICAgfSk7XG5cbiAgICB0aGlzLnBhcnNlQXV0aCA9IG5ldyBFZGdlRnVuY3Rpb24odGhpcywgJ1BhcnNlQXV0aCcsIHtcbiAgICAgIG5hbWU6ICdwYXJzZS1hdXRoJyxcbiAgICAgIGNvZGU6IENvZGUuZnJvbUFzc2V0KHBhdGguam9pbihfX2Rpcm5hbWUsICdsYW1iZGFzJywgJ3BhcnNlLWF1dGgnKSksXG4gICAgICBlZGdlUm9sZSxcbiAgICAgIGNvbmZpZ3VyYXRpb24sXG4gICAgICBldmVudFR5cGU6IExhbWJkYUVkZ2VFdmVudFR5cGUuVklFV0VSX1JFUVVFU1QsXG4gICAgfSk7XG5cbiAgICB0aGlzLnJlZnJlc2hBdXRoID0gbmV3IEVkZ2VGdW5jdGlvbih0aGlzLCAnUmVmcmVzaEF1dGgnLCB7XG4gICAgICBuYW1lOiAncmVmcmVzaC1hdXRoJyxcbiAgICAgIGNvZGU6IENvZGUuZnJvbUFzc2V0KHBhdGguam9pbihfX2Rpcm5hbWUsICdsYW1iZGFzJywgJ3JlZnJlc2gtYXV0aCcpKSxcbiAgICAgIGVkZ2VSb2xlLFxuICAgICAgY29uZmlndXJhdGlvbixcbiAgICAgIGV2ZW50VHlwZTogTGFtYmRhRWRnZUV2ZW50VHlwZS5WSUVXRVJfUkVRVUVTVCxcbiAgICB9KTtcblxuICAgIHRoaXMuc2lnbk91dCA9IG5ldyBFZGdlRnVuY3Rpb24odGhpcywgJ1NpZ25PdXQnLCB7XG4gICAgICBuYW1lOiAnc2lnbi1vdXQnLFxuICAgICAgY29kZTogQ29kZS5mcm9tQXNzZXQocGF0aC5qb2luKF9fZGlybmFtZSwgJ2xhbWJkYXMnLCAnc2lnbi1vdXQnKSksXG4gICAgICBlZGdlUm9sZSxcbiAgICAgIGNvbmZpZ3VyYXRpb24sXG4gICAgICBldmVudFR5cGU6IExhbWJkYUVkZ2VFdmVudFR5cGUuVklFV0VSX1JFUVVFU1QsXG4gICAgfSk7XG5cbiAgICB0aGlzLmh0dHBIZWFkZXJzID0gbmV3IEh0dHBIZWFkZXJzKHRoaXMsICdIdHRwSGVhZGVycycsIHtcbiAgICAgIGh0dHBIZWFkZXJzOiBwcm9wcy5odHRwSGVhZGVycyxcbiAgICAgIGVkZ2VSb2xlLFxuICAgIH0pO1xuICB9XG59XG4iXX0=