# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['openbb_terminal',
 'openbb_terminal.alternative',
 'openbb_terminal.alternative.covid',
 'openbb_terminal.alternative.oss',
 'openbb_terminal.common',
 'openbb_terminal.common.behavioural_analysis',
 'openbb_terminal.common.quantitative_analysis',
 'openbb_terminal.common.technical_analysis',
 'openbb_terminal.core',
 'openbb_terminal.core.completer',
 'openbb_terminal.core.config',
 'openbb_terminal.core.integration_tests',
 'openbb_terminal.core.library',
 'openbb_terminal.core.log',
 'openbb_terminal.core.log.collection',
 'openbb_terminal.core.log.generation',
 'openbb_terminal.core.scripts',
 'openbb_terminal.cryptocurrency',
 'openbb_terminal.cryptocurrency.defi',
 'openbb_terminal.cryptocurrency.discovery',
 'openbb_terminal.cryptocurrency.due_diligence',
 'openbb_terminal.cryptocurrency.nft',
 'openbb_terminal.cryptocurrency.onchain',
 'openbb_terminal.cryptocurrency.overview',
 'openbb_terminal.cryptocurrency.quantitative_analysis',
 'openbb_terminal.cryptocurrency.technical_analysis',
 'openbb_terminal.cryptocurrency.tools',
 'openbb_terminal.dashboards',
 'openbb_terminal.dashboards.stream',
 'openbb_terminal.econometrics',
 'openbb_terminal.economy',
 'openbb_terminal.economy.quantitative_analysis',
 'openbb_terminal.etf',
 'openbb_terminal.etf.discovery',
 'openbb_terminal.etf.screener',
 'openbb_terminal.etf.technical_analysis',
 'openbb_terminal.forecast',
 'openbb_terminal.forex',
 'openbb_terminal.forex.oanda',
 'openbb_terminal.forex.quantitative_analysis',
 'openbb_terminal.forex.technical_analysis',
 'openbb_terminal.futures',
 'openbb_terminal.mutual_funds',
 'openbb_terminal.portfolio',
 'openbb_terminal.portfolio.brokers',
 'openbb_terminal.portfolio.brokers.ally',
 'openbb_terminal.portfolio.brokers.coinbase',
 'openbb_terminal.portfolio.brokers.degiro',
 'openbb_terminal.portfolio.brokers.robinhood',
 'openbb_terminal.portfolio.portfolio_analysis',
 'openbb_terminal.portfolio.portfolio_optimization',
 'openbb_terminal.portfolio.portfolio_optimization.parameters',
 'openbb_terminal.reports',
 'openbb_terminal.stocks',
 'openbb_terminal.stocks.backtesting',
 'openbb_terminal.stocks.behavioural_analysis',
 'openbb_terminal.stocks.comparison_analysis',
 'openbb_terminal.stocks.dark_pool_shorts',
 'openbb_terminal.stocks.discovery',
 'openbb_terminal.stocks.due_diligence',
 'openbb_terminal.stocks.fundamental_analysis',
 'openbb_terminal.stocks.government',
 'openbb_terminal.stocks.insider',
 'openbb_terminal.stocks.options',
 'openbb_terminal.stocks.options.hedge',
 'openbb_terminal.stocks.options.pricing',
 'openbb_terminal.stocks.options.screen',
 'openbb_terminal.stocks.quantitative_analysis',
 'openbb_terminal.stocks.research',
 'openbb_terminal.stocks.screener',
 'openbb_terminal.stocks.sector_industry_analysis',
 'openbb_terminal.stocks.technical_analysis',
 'openbb_terminal.stocks.tradinghours',
 'openbb_terminal.stocks.tradinghours.data']

package_data = \
{'': ['*'],
 'openbb_terminal': ['custom_reports/lunar_crash/*',
                     'miscellaneous/*',
                     'miscellaneous/exports/alternative/covid/*',
                     'miscellaneous/exports/common/behavioural_analysis/*',
                     'miscellaneous/exports/common/prediction_techniques/*',
                     'miscellaneous/exports/common/quantitative_analysis/*',
                     'miscellaneous/exports/common/technical_analysis/*',
                     'miscellaneous/exports/custom/*',
                     'miscellaneous/exports/econometrics/*',
                     'miscellaneous/exports/economy/*',
                     'miscellaneous/exports/etf/movers/*',
                     'miscellaneous/exports/etf/screeners/*',
                     'miscellaneous/exports/mutual_funds/*',
                     'miscellaneous/exports/portfolio/*',
                     'miscellaneous/exports/portfolio/views/*',
                     'miscellaneous/exports/stocks/backtesting/*',
                     'miscellaneous/exports/stocks/behavioural_analysis/*',
                     'miscellaneous/exports/stocks/comparison_analysis/*',
                     'miscellaneous/exports/stocks/dark_pool_shorts/*',
                     'miscellaneous/exports/stocks/discovery/*',
                     'miscellaneous/exports/stocks/due_diligence/*',
                     'miscellaneous/exports/stocks/fundamental_analysis/*',
                     'miscellaneous/exports/stocks/government/*',
                     'miscellaneous/exports/stocks/insider/*',
                     'miscellaneous/exports/stocks/options/*',
                     'miscellaneous/exports/stocks/prediction_techniques/*',
                     'miscellaneous/exports/stocks/quantitative_analysis/*',
                     'miscellaneous/exports/stocks/raw_data/*',
                     'miscellaneous/exports/stocks/sector_industry_analysis/*',
                     'miscellaneous/exports/stocks/technical_analysis/*',
                     'miscellaneous/futures/*',
                     'miscellaneous/i18n/*',
                     'miscellaneous/integration_tests_scripts/*',
                     'miscellaneous/integration_tests_scripts/alternative/*',
                     'miscellaneous/integration_tests_scripts/cryptocurrency/*',
                     'miscellaneous/integration_tests_scripts/dashboards/*',
                     'miscellaneous/integration_tests_scripts/econometrics/*',
                     'miscellaneous/integration_tests_scripts/economy/*',
                     'miscellaneous/integration_tests_scripts/etf/*',
                     'miscellaneous/integration_tests_scripts/forecast/*',
                     'miscellaneous/integration_tests_scripts/forex/*',
                     'miscellaneous/integration_tests_scripts/futures/*',
                     'miscellaneous/integration_tests_scripts/portfolio/*',
                     'miscellaneous/integration_tests_scripts/reports/*',
                     'miscellaneous/integration_tests_scripts/stocks/*',
                     'miscellaneous/library/*',
                     'miscellaneous/portfolio/*',
                     'miscellaneous/routines/*',
                     'miscellaneous/stocks/insider/*',
                     'miscellaneous/stocks/screener/*',
                     'miscellaneous/styles/default/*'],
 'openbb_terminal.cryptocurrency': ['data/*'],
 'openbb_terminal.dashboards': ['voila/*', 'widgets/*'],
 'openbb_terminal.etf.screener': ['presets/*'],
 'openbb_terminal.forex': ['data/*'],
 'openbb_terminal.portfolio.portfolio_analysis': ['portfolios/*'],
 'openbb_terminal.reports': ['.ipynb_checkpoints/*',
                             'data/*',
                             'stored/*',
                             'templates/*',
                             'widgets/*'],
 'openbb_terminal.stocks': ['mappings/*'],
 'openbb_terminal.stocks.options': ['presets/*']}

install_requires = \
['FundamentalAnalysis>=0.2.6,<0.3.0',
 'GitPython>=3.1.17,<4.0.0',
 'Jinja2>=3.0.3,<4.0.0',
 'Pygments>=2.11.2,<3.0.0',
 'Quandl>=3.6.0,<4.0.0',
 'alpha-vantage>=2.3.1,<3.0.0',
 'ascii-magic>=1.6,<2.0',
 'bs4>=0.0.1,<0.0.2',
 'bt>=0.2.9,<0.3.0',
 'ccxt>=2.5.67,<3.0.0',
 'charset-normalizer==2.1.1',
 'degiro-connector>=2.0.3,<3.0.0',
 'detecta>=0.0.5,<0.0.6',
 'dnspython>=2.1.0,<3.0.0',
 'feedparser>=6.0.10,<7.0.0',
 'financedatabase==1.0.2',
 'finnhub-python>=2.4.10,<3.0.0',
 'finviz>=1.3.4,<2.0.0',
 'finvizfinance>=0.14.0,<0.15.0',
 'fred>=3.1,<4.0',
 'fredapi>=0.4.3,<0.5.0',
 'grpcio>=1.51.1,<2.0.0',
 'holidays>=0.14.2,<0.15.0',
 'html5lib>=1.1,<2.0',
 'investiny>=0.5.0,<0.6.0',
 'investpy>=1.0.7,<2.0.0',
 'ipyflex>=0.2.4,<0.3.0',
 'ipympl>=0.8.2,<0.9.0',
 'ipython==8.5.0',
 'ipywidgets>=8.0.2,<9.0.0',
 'iso8601>=0.1.14,<0.2.0',
 'jsonschema>=3.2.0,<4.0.0',
 'jupyterlab-widgets>=3.0.3,<4.0.0',
 'jupyterlab>=3.2.4,<4.0.0',
 'linearmodels>=4.25,<5.0',
 'matplotlib>=3.3.3,<4.0.0',
 'mplfinance>=0.12.7-alpha.7,<0.13.0',
 'numpy==1.23.4',
 'oandapyV20>=0.6.3,<0.7.0',
 'openpyxl>=3.0.9,<4.0.0',
 'packaging>=22.0',
 'pandas-market-calendars>=3.2,<3.3',
 'pandas-ta>=0.3.14-beta.0,<0.4.0',
 'pandas>=1.5.0,<2.0.0',
 'papermill>=2.4.0,<3.0.0',
 'plotly>=5.0.0,<6.0.0',
 'praw>=7.1.4,<8.0.0',
 'prompt-toolkit>=3.0.16,<4.0.0',
 'protobuf==3.20.1',
 'psaw>=0.0.12,<0.0.13',
 'pyEX>=0.5.0,<0.6.0',
 'pyally>=1.1.2,<2.0.0',
 'pycoingecko>=2.2.0,<3.0.0',
 'pyrsistent>=0.18.0,<0.19.0',
 'pythclient>=0.1.2,<0.2.0',
 'python-binance>=1.0.15,<2.0.0',
 'python-coinmarketcap>=0.2,<0.3',
 'python-dotenv>=0.19.2,<0.20.0',
 'python-i18n>=0.3.9,<0.4.0',
 'pytrends>=4.7.3,<5.0.0',
 'rapidfuzz>=1.1.1,<2.0.0',
 'requests>=2.25.1,<3.0.0',
 'rich>=12.6.0,<13.0.0',
 'robin-stocks>=2.0.3,<3.0.0',
 'ruamel.yaml>=0.17.21,<0.18.0',
 'scipy>=1.9.3,<2.0.0',
 'screeninfo>=0.6.7,<0.7.0',
 'seaborn>=0.11.0,<0.12.0',
 'sentiment-investor>=2.0.0,<3.0.0',
 'setuptools<65.5.0',
 'squarify>=0.4.3,<0.5.0',
 'statsmodels>=0.13,<0.14',
 'stocksera>=0.1.21,<0.2.0',
 'streamlit>=1.12.2,<2.0.0',
 'thepassiveinvestor>=1.1.2,<2.0.0',
 'tokenterminal>=1.0.1,<2.0.0',
 'tradingview-ta>=3.2.3,<4.0.0',
 'vaderSentiment==3.3.2',
 'valinvest>=0.0.2,<0.0.3',
 'voila>=0.3.0',
 'watchdog>=2.1.9,<3.0.0',
 'yfinance>=0.2.9,<0.3.0']

extras_require = \
{'all': ['Riskfolio-Lib>=3.1.1,<4.0.0',
         'torch==1.11.0',
         'pytorch-lightning==1.6.5',
         'u8darts[torch]==0.23.0'],
 'doc': ['docstring-parser>=0.15,<0.16'],
 'installer': ['pyinstaller>=4.10,<5.0'],
 'jupyterlab': ['jupyterlab-code-formatter>=1.4.10,<2.0.0',
                'jupyterlab-lsp>=3.10.1,<4.0.0',
                'jedi-language-server>=0.40.0,<0.41.0'],
 'optimization': ['Riskfolio-Lib>=3.1.1,<4.0.0'],
 'prediction': ['torch==1.11.0',
                'pytorch-lightning==1.6.5',
                'u8darts[torch]==0.23.0']}

entry_points = \
{'console_scripts': ['openbb = '
                     'openbb_terminal.terminal_controller:parse_args_and_run']}

setup_kwargs = {
    'name': 'openbb',
    'version': '2.3.1',
    'description': 'Investment Research for Everyone, Anywhere.',
    'long_description': '---\ntitle: Installation\nsidebar_position: 2\ndescription: The OpenBB SDK can be directly installed on your computer via our installation instructions. Within this section, you are guided through the installation process and how to launch the program. If you struggle with the installation process, please don’t hesitate to reach us on Discord or visit our contact page.\nkeywords: [installation, installer, install, guide, mac, windows, linux, python, github, macos, how to, explanation, openbb sdk]\n---\n\n# Installation\n\nWe provide a simple installation method in order to utilize the OpenBB SDK. You must first create an environment, which allows you to isolate the SDK from the rest of your system. It is our recommendation that you utilize a `conda` environment because there are optional features, such as `forecast`, that utilize libraries that are specifically sourced from `conda-forge`. Due to this, if you do not use a conda environment, you will not be able to use some of these features. As such, the installation steps will be written under the assumption that you are using conda.\n\n## Steps\n\n:::note NOTE\nMake sure you meet all [requirements](requirements.md) before proceeding.\n:::\n\n<p>Follow along with the instructions of the video or use the steps below to use the OpenBB SDK:</p>\n\n<iframe width="100%" height="450" src="https://www.youtube.com/embed/gQu6Paz5xN4" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>\n\n### 1. **Install [Miniconda](https://docs.conda.io/en/latest/miniconda.html)**\n\n   Download the `x86_64` Miniconda for your respective system and follow along\n   with it\'s installation instructions. The Miniconda architecture MUST be\n   `x86_64` in order to use certain features.\n\n### 2. **Create the virtual environment**\n\n```bash\nconda create -n obb python=3.9.6 -y\n```\n\n### 3. **Activate the virtual environment**\n\n```bash\nconda activate obb\n```\n\n### 4. **Install OpenBB SDK Core package**\n\n```bash\npip install openbb\n```\n\n### 5. **(Optional) Install the Toolkits**\n\n#### 5.1 **If you would like to use the Portfolio Optimization features**\n\n:::note NOTE\nIf on Apple Silicon Macs (M1/M2) you will need to install dependency from conda-forge first\n```bash\nconda install -c conda-forge cvxpy=1.2.2 -y\n```\n:::\n\n\nInstall the Portfolio Optimization Toolkit\n\n```bash\npip install "openbb[optimization]"\n```\n\n#### 5.2 **If you would like ML Forecasting features**\n\n:::note NOTE\nIf on Apple Silicon Macs (M1/M2) you will need to install the dependency from conda-forge first\n```bash\nconda install -c conda-forge lightgbm=3.3.3 -y\n```\n:::\n\nInstall the Forecasting Toolkit\n\n```bash\npip install "openbb[prediction]"\n```\n\n#### 5.3 **If you would like to use both Portfolio Optimization and ML forecast features**\n\n:::note NOTE\nIf on Apple Silicon Macs (M1/M2) you will need to install the dependencies from conda-forge first\n```bash\nconda install -c conda-forge lightgbm=3.3.3 cvxpy=1.2.2 -y\n```\n:::\n\nInstall all Toolkits\n\n```bash\npip install "openbb[all]"\n```\n\nCongratulations! You have successfully installed `openbb` on an environment and are now able to begin using it. However, it is important to note that if you close out of your CLI you must re-activate your environment in order begin using it again. This can be done with the following:\n\n```bash\nconda activate obb\n```\n\nThe OpenBB SDK can be imported to a Jupyter Notebook or any code editor with, `from openbb_terminal.sdk import openbb` as explained in the [How to use the SDK](https://docs.openbb.co/sdk/guides/basics) guides. By following the above process, the [OpenBB Terminal](https://docs.openbb.co/terminal) is automatically included as well which can be ran by typing `openbb`.\n\n',
    'author': 'Didier Rodrigues Lopes',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://openbb.co',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8, !=2.7.*, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*, !=3.4.*, !=3.5.*, !=3.6.*, !=3.7.*',
}


setup(**setup_kwargs)
