#!/usr/bin/env python
#  Copyright (c) 2019 JD Williams
#
#  This file is part of Firefly, a Python SOA framework built by JD Williams. Firefly is free software; you can
#  redistribute it and/or modify it under the terms of the GNU General Public License as published by the
#  Free Software Foundation; either version 3 of the License, or (at your option) any later version.
#
#  Firefly is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
#  Public License for more details. You should have received a copy of the GNU Lesser General Public
#  License along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#  You should have received a copy of the GNU General Public License along with Firefly. If not, see
#  <http://www.gnu.org/licenses/>.

""" Unit tests for the msvs.py file. """

import gyp.generator.msvs as msvs
import unittest
import StringIO


class TestSequenceFunctions(unittest.TestCase):

  def setUp(self):
    self.stderr = StringIO.StringIO()

  def test_GetLibraries(self):
    self.assertEqual(
      msvs._GetLibraries({}),
      [])
    self.assertEqual(
      msvs._GetLibraries({'libraries': []}),
      [])
    self.assertEqual(
      msvs._GetLibraries({'other':'foo', 'libraries': ['a.lib']}),
      ['a.lib'])
    self.assertEqual(
      msvs._GetLibraries({'libraries': ['-la']}),
      ['a.lib'])
    self.assertEqual(
      msvs._GetLibraries({'libraries': ['a.lib', 'b.lib', 'c.lib', '-lb.lib',
                                   '-lb.lib', 'd.lib', 'a.lib']}),
      ['c.lib', 'b.lib', 'd.lib', 'a.lib'])

if __name__ == '__main__':
  unittest.main()
