# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/03a_utils.colormap.ipynb.

# %% auto 0
__all__ = ['TorchCmap']

# %% ../../nbs/03a_utils.colormap.ipynb 4
from typing import Optional
from matplotlib import colormaps
from matplotlib.colors import to_rgba, ListedColormap
import torch
from torch.nn.functional import embedding

from ..repr_rgb import RGBProxy

# %% ../../nbs/03a_utils.colormap.ipynb 16
class TorchCmap():
    """
    Fast lut-based color mapping that is compatible with matplotlib colormaps

    Parameters extept `cmap` are matplotlib color strings.
    """
    def __init__(self,
                 cmap: ListedColormap, # Base matplotlib colormap
                 below: Optional[str] =None, # Values below 0
                 above: Optional[str] =None, # Values above 1
                 nan:   Optional[str] =None, # NaNs
                 ninf:  Optional[str] =None, # -inf
                 pinf:  Optional[str] =None, # +inf
                ):
        _ = cmap(0) # one call to make sure the cmap is initialized
        assert len(cmap._lut) == 259, "The colormap LUT should have 259 inputs"
        lut = torch.from_numpy(cmap._lut).float()
        
        if below: lut[256] = torch.tensor(to_rgba(below))
        if above: lut[257] = torch.tensor(to_rgba(above))
        if nan: lut[258] = torch.tensor(to_rgba(nan))

        # For +/- inf, use above/below as defaults.
        tensor_cmap_ninf = torch.tensor(to_rgba(ninf)) if ninf else lut[256]
        tensor_cmap_pinf = torch.tensor(to_rgba(pinf)) if pinf else lut[257]

        # Remove the alpha channel, it causes probems in pad_frame_gutters().
        self.lut = torch.cat([ lut, tensor_cmap_ninf[None], tensor_cmap_pinf[None] ])[:,:3]

    def __call__(self, t: torch.Tensor):
        lut_idxs = t.mul(255).byte().long()
        
        lut_idxs[ t < 0. ] = 256
        lut_idxs[ t > 1. ] = 257
        lut_idxs[ t.isnan()] = 258

        lut_idxs[ t.isneginf() ] = 259
        lut_idxs[ t.isposinf() ] = 260
        
        return embedding(lut_idxs, self.lut.to(t.device)) # RGB added as color-last.
