# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_repr_rgb.ipynb.

# %% auto 0
__all__ = ['rgb']

# %% ../nbs/01_repr_rgb.ipynb 3
from PIL import Image
import torch

# %% ../nbs/01_repr_rgb.ipynb 4
# This is here for the monkey-patched tensor use case.

# I want to be able to call both `tensor.rgb` and `tensor.rgb(stats)`. For the
# first case, the class defines `_repr_png_` to send the image to Jupyter. For
# the later case, it defines __call__, which accps the argument.

class RGBProxy():
    """Flexible `PIL.Image.Image` wrapper"""
    @torch.no_grad()
    def __init__(self, t:torch.Tensor):
        super().__init__()
        assert t.dim() == 3, f"Expecting a 3-dim tensor, got {t.shape}={t.dim()}"
        self.t = t.detach().cpu()

    @torch.no_grad()
    def __call__(self, denorm=None, cl=False):
        t = self.t.permute(1, 2, 0) if not cl else self.t
        n_ch = t.shape[-1]
        assert n_ch in (3, 4), f"Expecting 3 (RGB) or 4 (RGBA) channels, got {n_ch}" 
        if denorm:
            means = torch.tensor(denorm[0])
            stds = torch.tensor(denorm[1])
            t = t.mul(stds).add(means)
        return Image.fromarray(t.mul(255).byte().numpy())
    
    @torch.no_grad()
    def _repr_png_(self):
        return self.__call__()._repr_png_()


# %% ../nbs/01_repr_rgb.ipynb 5
def rgb(t: torch.Tensor, # Tensor to display. [C,H,W] or [H,W,C]
            denorm=None, # Reverse per-channel normalizatoin
            cl=False):   # Channel-last
    return RGBProxy(t)(denorm, cl=cl) 
