# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/05_repr_chans.ipynb.

# %% auto 0
__all__ = ['chans']

# %% ../nbs/05_repr_chans.ipynb 4
from matplotlib import colormaps
import torch

# %% ../nbs/05_repr_chans.ipynb 5
from .repr_rgb import RGBProxy
from .utils.colormap import TorchCmap
from .utils.pad import pad_frame_gutters
from .utils.tile2d import tile_images

# %% ../nbs/05_repr_chans.ipynb 6
def _chans(t: torch.Tensor, # 2 or 3-dim tensor to view. Channel-first if 3d.
                 cmap = "coolwarm", # Use matplotlib colormap by this name
                 cm_below="blue", cm_above="red",
                 cm_ninf="cyan", cm_pinf="fuchsia",
                 cm_nan="yellow",
                 view_width=966,
                 pad_frac=0.05,   # Draw write gutters when tiling the images
                 frame_px=1):     # Draw black frame around each image
    
    """
    Process individual channels of a tensor that can be interpreted as as image
    `x` and `y` specify which dimensions should be used as spatial ones.
    """
    
    assert t.dim() in (2, 3), f"Expected a 2 or 3-dim input, got {t.shape}={t.dim()}"
    if t.dim() == 2: t = t.expand(0)
    
    ### XXX Do we want a way to pass a custom cmap instead of mpl one?
    tcmap = TorchCmap(cmap=colormaps[cmap],
                  below=cm_below, above=cm_above,
                  nan=cm_nan, ninf=cm_ninf, pinf=cm_pinf)

    padded = pad_frame_gutters(tcmap(t), gutter_frac=pad_frac, frame_px=frame_px)
    tiled = tile_images(padded, view_width=view_width)  
    
#     return tiled
    return RGBProxy(tiled)(cl=True)

# %% ../nbs/05_repr_chans.ipynb 7
class ChanProxy():
    def __init__(self, t: torch.Tensor):
        self.t = t
    
    def __call__(self,
                 cmap = "coolwarm", # Use matplotlib colormap by this name
                 cm_below="blue",   # Override color for values velow 0
                 cm_above="red",    # Override color for values above 1
                 cm_ninf="cyan",    # Override color for -inf values
                 cm_pinf="fuchsia", # Override color for +inf values
                 cm_nan="yellow",   # Override color for NaN values
                 view_width=966,    # Try to produce an image at most this wide
                 pad_frac=0.05,     # Draw write gutters when tiling the images, %of the image.
                 frame_px=1 ):      # Drawa black frame around images.
        
        return _chans(self.t,
                     cmap=cmap,
                     cm_below=cm_below,
                     cm_above=cm_above,
                     cm_ninf=cm_ninf,
                     cm_pinf=cm_pinf,
                     cm_nan=cm_nan,
                     view_width=view_width,
                     pad_frac=pad_frac,
                     frame_px=frame_px)
    
    def _repr_png_(self):
        return self.__call__()._repr_png_()

# %% ../nbs/05_repr_chans.ipynb 8
def chans(t: torch.Tensor, # 2 or 3-dim tensor to view. Channel-first if 3d.
             cmap = "coolwarm", # Use matplotlib colormap by this name
             cm_below="blue",   # Color for values below 0
             cm_above="red",    # Color for values above 1
             cm_ninf="cyan",    # Color for -inf values
             cm_pinf="fuchsia", # Color for +inf values
             cm_nan="yellow",   # Color for NaN values
             view_width=966,    # Try to produce an image at most this wide
             pad_frac=0.05,   # Draw write gutters when tiling the images
             frame_px=1):     # Draw black frame around each image
    
    return ChanProxy(t)(cmap=cmap,
                         cm_below=cm_below,
                         cm_above=cm_above,
                         cm_ninf=cm_ninf,
                         cm_pinf=cm_pinf,
                         cm_nan=cm_nan,
                         view_width=view_width,
                         pad_frac=pad_frac,
                         frame_px=frame_px)
