from setuptools import setup

name = "types-polib"
description = "Typing stubs for polib"
long_description = '''
## Typing stubs for polib

This is a PEP 561 type stub package for the `polib` package.
It can be used by type-checking tools like mypy, PyCharm, pytype etc. to check code
that uses `polib`. The source for this package can be found at
https://github.com/python/typeshed/tree/master/stubs/polib. All fixes for
types and metadata should be contributed there.

See https://github.com/python/typeshed/blob/master/README.md for more details.
This package was generated from typeshed commit `45a2dad83cc372cd066a91fc04ab44297b714e69`.
'''.lstrip()

setup(name=name,
      version="1.1.10",
      description=description,
      long_description=long_description,
      long_description_content_type="text/markdown",
      url="https://github.com/python/typeshed",
      project_urls={
          "GitHub": "https://github.com/python/typeshed",
          "Changes": "https://github.com/typeshed-internal/stub_uploader/blob/main/data/changelogs/polib.md",
          "Issue tracker": "https://github.com/python/typeshed/issues",
          "Chat": "https://gitter.im/python/typing",
      },
      install_requires=[],
      packages=['polib-stubs'],
      package_data={'polib-stubs': ['__init__.pyi', 'METADATA.toml']},
      license="Apache-2.0 license",
      classifiers=[
          "License :: OSI Approved :: Apache Software License",
          "Typing :: Stubs Only",
      ]
)
