"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RotationSchedule = void 0;
const core_1 = require("@aws-cdk/core");
const secretsmanager_generated_1 = require("./secretsmanager.generated");
/**
 * A rotation schedule.
 */
class RotationSchedule extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        new secretsmanager_generated_1.CfnRotationSchedule(this, 'Resource', {
            secretId: props.secret.secretArn,
            rotationLambdaArn: props.rotationLambda.functionArn,
            rotationRules: {
                automaticallyAfterDays: props.automaticallyAfter && props.automaticallyAfter.toDays() || 30,
            },
        });
    }
}
exports.RotationSchedule = RotationSchedule;
//# sourceMappingURL=data:application/json;base64,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