# Generated by Django 2.2.7 on 2020-07-07 13:53

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='MLModel',
            fields=[
                ('model_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=50)),
                ('started_at', models.DateTimeField()),
                ('finished_at', models.DateTimeField()),
                ('optimized', models.BooleanField()),
                ('hyperparameters', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='Table',
            fields=[
                ('name', models.CharField(editable=False, max_length=50, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField()),
                ('last_update_at', models.DateTimeField()),
                ('n_rows', models.BigIntegerField()),
                ('n_cols', models.BigIntegerField()),
                ('active', models.BooleanField(default=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ModelContingencyTable',
            fields=[
                ('model', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='app.MLModel')),
                ('true_positive', models.BigIntegerField(blank=True, null=True)),
                ('true_negative', models.BigIntegerField(blank=True, null=True)),
                ('false_positive', models.BigIntegerField(blank=True, null=True)),
                ('false_negative', models.BigIntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='ModelMetrics',
            fields=[
                ('model', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='app.MLModel')),
                ('roc_auc', models.FloatField(blank=True, null=True)),
                ('accuracy', models.FloatField(blank=True, null=True)),
                ('balanced_accuracy', models.FloatField(blank=True, null=True)),
                ('recall', models.FloatField(blank=True, null=True)),
                ('precision', models.FloatField(blank=True, null=True)),
                ('f1_score', models.FloatField(blank=True, null=True)),
                ('gini', models.FloatField(blank=True, null=True)),
                ('log_loss', models.FloatField(blank=True, null=True)),
                ('mean_squared_error', models.FloatField(blank=True, null=True)),
                ('mean_absolute_error', models.FloatField(blank=True, null=True)),
                ('r_squared', models.FloatField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Sustainability',
            fields=[
                ('model', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='app.MLModel')),
                ('carbon_footprint', models.DecimalField(decimal_places=3, max_digits=5)),
            ],
        ),
        migrations.CreateModel(
            name='TableColumnsSpec',
            fields=[
                ('feature_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('column_name', models.CharField(max_length=50)),
                ('label', models.BooleanField()),
                ('problem_type', models.CharField(choices=[('classification', 'classification'), ('regression', 'regression')], max_length=30)),
                ('feature', models.BooleanField()),
                ('categorical', models.BooleanField()),
                ('num_categories', models.IntegerField(blank=True, null=True)),
                ('numerical', models.BooleanField()),
                ('cluster', models.CharField(blank=True, max_length=15, null=True)),
                ('prop_null', models.FloatField()),
                ('table', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='app.Table')),
            ],
        ),
        migrations.CreateModel(
            name='Run',
            fields=[
                ('run_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('started_at', models.DateTimeField()),
                ('last_update_at', models.DateTimeField()),
                ('label', models.CharField(max_length=50)),
                ('problem_type', models.CharField(max_length=30)),
                ('filter', models.CharField(max_length=100)),
                ('metric', models.CharField(max_length=30)),
                ('selection_method', models.CharField(blank=True, max_length=20, null=True)),
                ('features', models.TextField()),
                ('selected_features', models.TextField()),
                ('oversampling', models.BooleanField()),
                ('n_test', models.IntegerField()),
                ('n_train', models.IntegerField()),
                ('table', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='app.Table')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ModelFeatureImportance',
            fields=[
                ('feature_importance_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('feature', models.CharField(max_length=50)),
                ('importance', models.FloatField()),
                ('model', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='app.MLModel')),
            ],
        ),
        migrations.AddField(
            model_name='mlmodel',
            name='run',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='app.Run'),
        ),
    ]
