# Contributing
When contributing to this repository, please first discuss the change you wish to make via issue,
email, or any other method with the owners of this repository before. 

## Issues
You can freely open any new issue related to bugs you found, enhancements you wish or doubts you have
about anything related to the project's code and its usage.

### Bug reporting
* Specify a clear title which summarizes the bug
* Add a code snippet which reproduces the error.
* Add the version of SHERLOCK you are running
* Add the OS in which you're running SHERLOCK.
* If the bug is related to a SHERLOCK dependency, please provide the dependency's version.

## Pull Request Process
1. Ensure any install or build dependencies are removed before the end of the layer when doing a 
   build.
2. Update the README.md with details of changes to the interface.
3. Increase the version numbers in any examples files and the README.md to the new version that this
   Pull Request would represent. The versioning scheme we use is [SemVer](http://semver.org/).
4. You may merge the Pull Request in once you have the sign-off of two other developers, or if you 
   do not have permission to do that, you may request the second reviewer to merge it for you.

## Code of conduct
Project maintainers are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, issues, and other contributions
that are not aligned to a polite code of conduct, or to ban temporarily or
permanently any contributor for other behaviors that they deem inappropriate,
threatening, offensive, or harmful.
