<!-- markdownlint-disable MD033 -->
# python-wechaty

![Python Wechaty](./docs/img/getting-started/python-wechaty.png)

[![PyPI Version](https://img.shields.io/pypi/v/wechaty?color=blue)](https://pypi.org/project/wechaty/)
[![Python Wechaty Getting Started](https://img.shields.io/badge/Python%20Wechaty-Getting%20Started-blue)](https://github.com/wechaty/python-wechaty-getting-started)
[![Python 3.7](https://img.shields.io/badge/python-3.7+-blue.svg)](https://www.python.org/downloads/release/python-370/)
[![Downloads](https://pepy.tech/badge/wechaty)](https://pepy.tech/project/wechaty)
[![Wechaty in Python](https://img.shields.io/badge/Wechaty-Python-blue)](https://github.com/wechaty/python-wechaty)
[![codecov](https://codecov.io/gh/wechaty/python-wechaty/branch/master/graph/badge.svg)](https://codecov.io/gh/wechaty/python-wechaty)
[![PyPI](https://github.com/wechaty/python-wechaty/actions/workflows/pypi.yml/badge.svg)](https://github.com/wechaty/python-wechaty/actions/workflows/pypi.yml)
![PyPI - Downloads](https://img.shields.io/pypi/dm/wechaty?color=blue)

[📄 Chinese Document](https://wechaty.readthedocs.io/zh_CN/latest/)  [python-wechaty-template](https://github.com/wechaty/python-wechaty-template)

## What's Python Wechaty

Python Wechaty is an Open Source software application for building chatbots. It is a modern Conversational RPA SDK which Chatbot makers can use to create a bot in a few lines of code.

You can use Wechaty to build a chatbot which automates conversations and interact with people through instant messaging platforms such as WhatsApp, WeChat, WeCom, Gitter and Lark among others.

## Features

* **Message Processing**: You can use the simple code, similar to natural language, to process the message receving & sending.
* **Plugin System**: You can use the community-contributed plugins to handle your scenario.
* **Write onece, run multi IM platform**: python wechaty support many IM platforms with one code, all of you need to do is switch the token token type.
* **Wechaty UI**: you can use the powerful wechaty-ui to create interactive chatbot
* ...


## Getting Started

There are few steps to start your bot, and we give a [bot-template](https://github.com/wechaty/python-wechaty-template) for you to getting started quickly. 


## Join Us

Wechaty is used in many ChatBot projects by thousands of developers. If you want to talk with other developers, just scan the following QR Code in WeChat with secret code _python wechaty_, join our **Wechaty Python Developers' Home**.

![Wechaty Friday.BOT QR Code](https://wechaty.js.org/img/friday-qrcode.svg)

Scan now, because other Wechaty Python developers want to talk with you too! (secret code: _python wechaty_)


## Requirements

1. Python 3.7+

## Install

```shell
pip3 install wechaty
```

## See Also

- [Packaging Python Projects](https://packaging.python.org/tutorials/packaging-projects/)

### Static & Instance of Class

- [Static variables and methods in Python](https://radek.io/2011/07/21/static-variables-and-methods-in-python/)

### Typings

- [PEP 526 -- Syntax for Variable Annotations - Class and instance variable annotations](https://www.python.org/dev/peps/pep-0526/#class-and-instance-variable-annotations)
  - [Python Type Checking (Guide)](https://realpython.com/python-type-checking/) by [Geir Arne Hjelle](https://realpython.com/team/gahjelle/)

## History

### v0.6 (Jun 19, 2020)

Python Wechaty Scala Wechaty **BETA** Released!

Read more from our Multi-language Wechaty Beta Release event from our blog:

- [Multi Language Wechaty Beta Release Announcement!](https://wechaty.js.org/2020/06/19/multi-language-wechaty-beta-release/)

### v0.4 (Mar 15, 2020) master

Welcome [@huangaszaq](https://github.com/huangaszaq) for joining the project! [#42](https://github.com/wechaty/python-wechaty/pull/42)

1. Add a friendly exception message for PyPI users. [#24](https://github.com/wechaty/python-wechaty/issues/24)

### v0.1 (Mar 8, 2020)

Welcome [@wj-Mcat](https://github.com/wj-Mcat) for joining the project! [#4](https://github.com/wechaty/python-wechaty/pull/4)

1. Starting translate TypeScript of Wechaty to Python
1. DevOps Setup
    1. Type Checking: mypy & pytype
    1. Unit Testing: pytest
    1. Linting: pylint, pycodestyle, and flake8
    1. CI/CD: GitHub Actions
1. Publish to PyPI automatically after the tests passed.

### v0.0.1 (Aug 25, 2018)

Project created, publish a empty module `wechaty` on PyPI.

## Related Projects

- [Wechaty](https://github.com/wechaty/wechaty) - Conversatioanl AI Chatot SDK for Wechaty Individual Accounts (TypeScript)
- [Python Wechaty](https://github.com/wechaty/python-wechaty) - Python WeChaty Conversational AI Chatbot SDK for Wechat Individual Accounts (Python)
- [Go Wechaty](https://github.com/wechaty/go-wechaty) - Go WeChaty Conversational AI Chatbot SDK for Wechat Individual Accounts (Go)
- [Java Wechaty](https://github.com/wechaty/java-wechaty) - Java WeChaty Conversational AI Chatbot SDK for Wechat Individual Accounts (Java)
- [Scala Wechaty](https://github.com/wechaty/scala-wechaty) - Scala WeChaty Conversational AI Chatbot SDK for WechatyIndividual Accounts (Scala)

## Badge

[![Wechaty in Python](https://img.shields.io/badge/Wechaty-Python-blue)](https://github.com/wechaty/python-wechaty)

```md
[![Wechaty in Python](https://img.shields.io/badge/Wechaty-Python-blue)](https://github.com/wechaty/python-wechaty)
```

## Stargazers over time

[![Stargazers over time](https://starchart.cc/wechaty/python-wechaty.svg)](https://starchart.cc/wechaty/python-wechaty)

## Contributors

<a href="https://github.com/wechaty/python-wechaty/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=wechaty/python-wechaty" />
</a>

Made with [contrib.rocks](https://contrib.rocks).

## Support

Thanks the following supported Software. 

[![test image size](https://resources.jetbrains.com/storage/products/company/brand/logos/jb_beam.svg?_gl=1*1lb7oaa*_ga*MjE5ODE2MzAwLjE2MzYxODMyNTE.*_ga_V0XZL7QHEB*MTY0MTI2NzU5OS41LjEuMTY0MTI2NzY3OC4w&_ga=2.157122558.411488113.1641267600-219816300.1636183251)](https://jb.gg/OpenSourceSupport)

## Committers

1. [@huangaszaq](https://github.com/huangaszaq) -  Chunhong HUANG (黄纯洪)

## Creators

- [@wj-Mcat](https://github.com/wj-Mcat) - Jingjing WU (吴京京)
- [@huan](https://github.com/huan) - ([李卓桓](http://linkedin.com/in/zixia)) zixia@zixia.net

## Copyright & License

- Code & Docs © 2018 Wechaty Contributors <https://github.com/wechaty>
- Code released under the Apache-2.0 License
- Docs released under Creative Commons
