# Creat CVS/SVN related targets
#
#
FIND_PROGRAM(CVSCOMMAND cvs )
SET(CVS_UPDATE_OPTIONS "-d -A -P" CACHE STRING "Options passed to the cvs update command.")
FIND_PROGRAM(SVNCOMMAND svn)
#SET(SVN_UPDATE_OPTIONS "-d -A -P" CACHE STRING "Options passed to the svn update command.")

IF(NOT UPDATE_TYPE)
  IF(EXISTS "${CMAKE_CURRENT_SOURCE_DIR}/CVS")
    SET(UPDATE_TYPE cvs)
  ELSE(EXISTS "${CMAKE_CURRENT_SOURCE_DIR}/CVS")
    IF(EXISTS "${CMAKE_CURRENT_SOURCE_DIR}/.svn")
      SET(UPDATE_TYPE svn)
    ENDIF(EXISTS "${CMAKE_CURRENT_SOURCE_DIR}/.svn")
  ENDIF(EXISTS "${CMAKE_CURRENT_SOURCE_DIR}/CVS")
ENDIF(NOT UPDATE_TYPE)

#IF(NOT UPDATE_TYPE)
#  MESSAGE(STATUS "Cannot determine repository type. Please set UPDATE_TYPE to 'cvs' or 'svn'. CTest update will not work.")
#ENDIF(NOT UPDATE_TYPE)

IF(UPDATE_TYPE MATCHES "[Cc][Vv][Ss]")
  MESSAGE(STATUS "This is a CVS repository")
  SET(UPDATE_COMMAND "${CVSCOMMAND}")
  SET(UPDATE_OPTIONS "${CVS_UPDATE_OPTIONS}")
ELSE(UPDATE_TYPE MATCHES "[Cc][Vv][Ss]")
  IF(UPDATE_TYPE MATCHES "[Ss][Vv][Nn]")
    MESSAGE(STATUS "This is a SVN repository")
    SET(UPDATE_COMMAND "${SVNCOMMAND}")
    SET(UPDATE_OPTIONS "${SVN_UPDATE_OPTIONS}")
  ENDIF(UPDATE_TYPE MATCHES "[Ss][Vv][Nn]")
ENDIF(UPDATE_TYPE MATCHES "[Cc][Vv][Ss]")


MARK_AS_ADVANCED(
  CVSCOMMAND
  SVNCOMMAND
  CVS_UPDATE_OPTIONS
  SVN_UPDATE_OPTIONS
  )

IF(NOT CVSUPDATE_INIT)
  ADD_CUSTOM_TARGET(cvsupdate  cd ${CMAKE_CURRENT_SOURCE_DIR} \; ${UPDATE_COMMAND} up -P )
  SET(CVSUPDATE_INIT 1)
ENDIF(NOT CVSUPDATE_INIT)

IF(UPDATE_TYPE MATCHES "[Cc][Vv][Ss]")
IF(NOT CVSNEW_INIT)
  ADD_CUSTOM_TARGET(cvsnew ${CMAKE_CURRENT_SOURCE_DIR}/SDIF/cmModules/cvsnew.sh ${CMAKE_CURRENT_SOURCE_DIR} ${UPDATE_COMMAND} )
  SET(CVSNEW_INIT 1)
ENDIF(NOT CVSNEW_INIT)
ENDIF(UPDATE_TYPE MATCHES "[Cc][Vv][Ss]")


