import random
from typing import List, Tuple, Union

from pydantic import dataclasses

WeightedOption = Tuple[str, int, list, list, list]
WeightedSimpleOption = List[int]
WeightedOptions = List[WeightedOption]
WeightedSimpleOptions = List[WeightedSimpleOption]

cameraAnglesL = [
    ["dutch angle", 12, [], [], []],
    ["from above", 12, ["above"], [], []],
    ["from behind", 12, ["behind"], [], []],
    ["from below", 12, ["below"], [], []],
    ["from side", 12, [], [], []],
    ["three quarter view", 12, [], [], []],
    ["straight-on", 12, ["front"], [], []],
]
framingTypesL = [
    ["portrait", 8, [], [], []],
    ["upper body", 12, ["body"], [], []],
    ["cowboy shot", 12, ["legs", "body"], [], []],
    ["full body", 12, ["feet", "legs", "body"], [], []],
]
subjectFocusL = [
    ["solo focus", 12, [], [], []],
    ["ass focus", 12, [], [], ["front"]],
    ["foot focus", 12, [], ["feet"], []],
    ["hip focus", 12, [], [], []],
    ["back focus", 12, [], [], ["front"]],
    ["breast focus", 4, [], ["female"], []],
    ["armpit focus", 4, [], [], []],
    ["eye focus", 12, [], [], []],
]
sceneTypesL = [
    ["landscape", 12, [], [], []],
    ["nature", 12, [], [], []],
    ["scenery", 12, [], [], []],
    ["still life", 12, [], [], []],
    ["cityscape", 12, [], [], []],
]
backgroundTypesL = [
    ["white background", 12, [], [], []],
    ["grey background", 12, [], [], []],
    ["gradient background", 16, [], [], []],
    ["blurry background", 12, [], [], []],
    ["blue background", 12, [], [], []],
    ["pink background", 12, [], [], []],
    ["black background", 12, [], [], []],
    ["yellow background", 12, [], [], []],
    ["red background", 12, [], [], []],
    ["two-tone background", 16, [], [], []],
    ["brown background", 12, [], [], []],
    ["green background", 12, [], [], []],
    ["purple background", 12, [], [], []],
    ["orange background", 12, [], [], []],
    ["floral background", 12, [], [], []],
    ["polka dot background", 12, [], [], []],
    ["striped background", 12, [], [], []],
    ["multicolored background", 16, [], [], []],
    ["starry background", 12, [], [], []],
    ["simple background, starry background", 12, [], [], []],
    ["dark background", 12, [], [], []],
    ["simple background, checkered background", 12, [], [], []],
    ["aqua background", 12, [], [], []],
    ["beige background", 12, [], [], []],
    ["heart background", 12, [], [], []],
    ["argyle background", 8, [], [], []],
    ["halftone background", 8, [], [], []],
    ["simple background, sparkle background", 12, [], [], []],
    ["simple background, abstract background", 12, [], [], []],
    ["abstract background", 12, [], [], []],
    ["patterned background", 12, [], [], []],
    ["plaid background", 10, [], [], []],
    ["simple background, sunburst background", 10, [], [], []],
    ["tan background", 12, [], [], []],
    ["light blue background", 12, [], [], []],
    ["snowflake background", 8, [], [], []],
    ["grid background", 12, [], [], []],
    ["leaf background", 12, [], [], []],
    ["simple background, rainbow background", 12, [], [], []],
    ["rainbow background", 12, [], [], []],
    ["lavender background", 12, [], [], []],
    ["light brown background", 12, [], [], []],
    ["bubble background", 12, [], [], []],
    ["sepia background", 12, [], [], []],
    ["fiery background", 12, [], [], []],
    ["silver background", 12, [], [], []],
    ["splatter background", 12, [], [], []],
    ["sketch background, scenery", 12, [], [], []],
    ["scenery", 220, [], [], []],
]
artStylesL = [
    ["ligne claire", 12, [], [], []],
    ["realistic", 12, [], [], []],
    ["photorealistic", 12, [], [], []],
    ["cel shading", 12, [], [], []],
    ["sketch", 12, [], [], []],
    ["jaggy lines", 12, [], [], []],
    ["retro artstyle", 12, [], [], []],
    ["toon (style)", 12, [], [], []],
    ["surreal", 12, [], [], []],
    ["abstract", 12, [], [], []],
    ["spot color", 12, [], [], []],
    ["graphite (medium)", 12, [], [], []],
    ["watercolor (medium)", 12, [], [], []],
    ["concept art", 12, [], [], []],
    ["flat color", 12, [], [], []],
    ["ai-generated", 12, [], [], []],
    ["faux traditional media", 12, [], [], []],
    ["oekaki", 12, [], [], []],
    ["minimalism", 12, [], [], []],
    ["impressionism", 12, [], [], []],
    ["1970s (style)", 12, [], [], []],
    ["1980s (style)", 12, [], [], []],
    ["1990s (style)", 12, [], [], []],
    ["chibi, chibi only", 12, [], [], []],
    ["pc-98 (style)", 12, [], [], []],
    ["shikishi", 1, [], [], []],
    ["colored pencil (medium)", 12, [], [], []],
    ["painterly", 12, [], [], []],
    ["millipen (medium)", 12, [], [], []],
    ["pen (medium)", 12, [], [], []],
    ["tegaki", 12, [], [], []],
    ["vector trace", 12, [], [], []],
    ["production art", 12, [], [], []],
    ["figure, photo (medium)", 12, [], [], []],
    ["pixelated", 12, [], [], []],
    ["color trace", 12, [], [], []],
    ["pastel (medium)", 12, [], [], []],
]
animalCharacteristicsL = [
    ["bat ears, bat wings", 12, [], [], []],
    ["bear ears", 12, [], [], []],
    ["rabbit girl, rabbit ears", 12, [], ["female"], []],
    ["rabbit girl, rabbit ears, floppy ears", 12, [], ["female"], []],
    ["cat ears, cat tail", 12, [], [], []],
    ["leopard ears, leopard tail", 12, [], [], []],
    ["snow leopard ears, snow leopard tail", 12, [], [], []],
    ["panther ears, panther tail", 12, [], [], []],
    ["jaguar ears, jaguar tail", 12, [], [], []],
    ["cow ears, cow horns, cow tail", 12, [], [], []],
    ["deer ears, deer antlers", 12, [], [], []],
    ["dog ears, dog tail", 12, [], [], []],
    ["fox ears, fox tail", 12, [], [], []],
    ["horse ears, horse tail", 12, [], [], []],
    ["monkey ears, monkey tail", 12, [], [], []],
    ["mouse ears, mouse tail", 12, [], [], []],
    ["sheep ears, sheep horns", 12, [], [], []],
    ["goat ears, goat horns", 12, [], [], []],
    ["lion ears, lion tail", 12, [], [], []],
    ["squirrel ears, squirrel tail", 12, [], [], []],
    ["tiger ears, tiger tail", 12, [], [], []],
    ["wolf ears, wolf tail", 12, [], [], []],
    ["oni, oni horns", 12, [], [], []],
    ["elf, pointy ears", 12, [], [], []],
    ["elf, long pointy ears", 12, [], [], []],
    ["dark elf, pointy ears", 12, [], [], []],
    ["dark elf, long pointy ears", 12, [], [], []],
    ["fairy, fairy wings", 12, [], [], []],
    ["dragon horns, dragon tail", 12, [], [], []],
    ["demon horns, demon tail", 12, [], [], []],
    ["cow ears, cow horns", 12, [], [], []],
    ["angel", 12, [], [], []],
    ["android, robot joints", 12, [], [], []],
    ["robot girl, clothed robot", 12, [], ["female"], []],
    ["monster girl, mermaid, scales", 12, ["nolegs"], ["female"], []],
    ["monster girl, head fins, fish tail", 12, [], ["female"], []],
    ["raccoon ears, raccoon tail", 12, [], [], []],
    ["monster girl, slime girl", 12, [], ["female"], []],
    ["monster girl, lamia", 12, ["nolegs"], ["female"], []],
    ["monster girl, harpy, winged arms", 12, ["noarms", "female"], [], []],
    ["orc, colored skin", 12, [], [], []],
    ["cyclops, one-eyed", 12, [], [], []],
    ["centaur", 12, ["nolegs"], [], []],
    ["monster", 12, [], [], []],
    ["monster girl, plant girl, alraune", 12, [], ["female"], []],
    ["minigirl", 12, [], ["female"], []],
    ["miniboy", 12, [], ["male"], []],
    ["ghost, ghost tail", 12, [], [], []],
    ["centauroid", 12, [], [], []],
    ["monster girl, scylla, tentacles", 12, ["nolegs"], ["female"], []],
    ["weasel tail, weasel ears", 12, [], [], []],
    ["otter ears, otter tail", 12, [], [], []],
    ["halfling", 12, [], [], []],
    ["goblin", 12, [], [], []],
    ["chipmunk ears, chipmunk tail", 12, [], [], []],
]
skinTypesL = [
    ["dark skin", 200, [], [], []],
    ["very dark skin", 200, [], [], []],
    ["pale skin", 200, [], [], []],
    ["tan", 200, [], [], []],
    ["gradient skin", 12, [], [], []],
    ["black skin", 12, [], [], []],
    ["blue skin", 12, [], [], []],
    ["green skin", 12, [], [], []],
    ["grey skin", 12, [], [], []],
    ["orange skin", 12, [], [], []],
    ["pink skin", 12, [], [], []],
    ["purple skin", 12, [], [], []],
    ["red skin", 12, [], [], []],
    ["white skin", 12, [], [], []],
    ["yellow skin", 12, [], [], []],
]
eyeCharacteristicsL = [
    ["heterochromia", 12, [], [], []],
    ["multicolored eyes", 12, [], [], []],
    ["no eyes", 12, ["noeyes"], [], []],
    ["ringed eyes", 12, [], [], []],
    ["heart-shaped pupils", 12, [], [], []],
    ["star-shaped pupils", 12, [], [], []],
    ["diamond-shaped pupils", 12, [], [], []],
    ["cross-shaped pupils", 12, [], [], []],
    ["x-shaped pupils", 12, [], [], []],
    ["horizontal pupils", 12, [], [], []],
    ["bags under eyes", 12, [], [], []],
    ["glowing eyes", 2, [], [], []],
    ["glowing eye", 2, [], [], []],
    ["flaming eye", 2, [], [], []],
    ["bright pupils", 12, [], [], []],
    ["sparkling eyes", 12, [], [], []],
    ["star in eye", 12, [], [], []],
    ["slit pupils", 12, [], [], []],
    ["constricted pupils", 12, [], [], []],
]
eyeExpressionsL = [
    ["crazy eyes", 4, [], [], []],
    ["empty eyes", 12, [], [], []],
    ["solid circle eyes", 4, ["nocoloreyes"], [], []],
    ["solid oval eyes", 4, ["nocoloreyes"], [], []],
    ["jitome", 12, [], [], []],
    ["tareme", 12, [], [], []],
    ["tsurime", 12, [], [], []],
    ["sanpaku", 12, [], [], []],
    ["long eyelashes", 12, [], [], []],
]
hairLengthsL = [
    ["very short hair", 12, [], [], []],
    ["short hair", 12, [], [], []],
    ["short hair with long locks", 2, [], [], []],
    ["medium hair", 12, [], [], []],
    ["long hair", 12, ["longhair"], [], []],
    ["very long hair", 4, ["longhair"], ["female"], []],
    ["absurdly long hair", 4, ["longhair"], ["female"], []],
    ["big hair", 8, ["longhair"], ["female"], []],
]
braidedHairstylesL = [
    ["braid", 12, [], [], []],
    ["braided bangs", 12, [], ["female"], []],
    ["front braid", 12, [], ["female"], []],
    ["side braid", 12, [], ["female"], []],
    ["french braid", 12, [], ["female"], []],
    ["crown braid", 12, [], ["female"], []],
    ["single braid", 12, [], [], []],
    ["multiple braids", 12, [], ["female"], []],
    ["braided ponytail", 12, [], [], []],
    ["hair bun", 12, [], ["female"], []],
    ["braided bun", 12, [], [], []],
    ["single hair bun", 12, [], [], []],
    ["double bun", 12, [], ["female"], []],
    ["hair rings", 12, [], ["female"], []],
    ["half updo, short ponytai", 12, [], [], []],
    ["half updo, hair bun", 12, [], [], []],
    ["half updo, bow", 12, [], [], []],
    ["one side up", 12, [], ["female"], []],
    ["two side up", 12, [], ["female"], []],
    ["cone hair bun", 12, [], ["female"], []],
    ["low-braided long hair", 12, [], ["longhair"], []],
    ["low-tied long hair", 12, [], ["longhair"], []],
    ["ponytail", 12, [], [], []],
    ["folded ponytail", 12, [], [], []],
    ["high ponytail", 12, [], [], []],
    ["short ponytail", 12, [], [], []],
    ["side ponytail", 12, [], ["female"], []],
    ["wide ponytail", 12, [], [], []],
    ["twintails", 12, [], ["female"], []],
    ["low twintails", 12, [], ["female"], []],
    ["short twintails", 12, [], ["female"], []],
    ["uneven twintails", 12, [], ["female"], []],
    ["drill hair, twin drills", 12, [], ["female"], []],
    ["sidecut", 12, [], [], []],
    ["asymmetrical hair", 12, [], [], []],
    ["hime cut", 12, [], ["female", "longhair"], []],
    ["single side bun", 12, [], ["female"], []],
    ["afro", 12, [], [], []],
    ["beehive hairdo", 12, [], ["female"], []],
    ["pompadour", 12, [], [], []],
    ["bow-shaped hair", 12, [], ["female"], []],
    ["dreadlocks", 12, [], [], []],
    ["doughnut hair bun", 12, [], ["female"], []],
    ["wolf cut", 12, [], [], []],
    ["undercut", 12, [], [], ["longhair"]],
    ["pixie cut", 12, [], [], ["longhair"]],
    ["bob cut", 12, [], [], ["longhair"]],
    ["inverted bob", 12, [], [], ["longhair"]],
    ["bowl cut", 12, [], [], ["longhair"]],
    ["topknot", 12, [], [], []],
    ["single hair ring", 12, [], ["female"], []],
    ["mohawk", 12, [], [], []],
    ["low twin braids", 12, [], ["female"], []],
    ["hair horns", 12, [], [], []],
    ["center-flap bangs", 12, [], [], []],
    ["buzz cut", 12, [], [], []],
]
uniqueHairstylesL = [
    ["drill hair", 12, [], ["female", "longhair"], []],
    ["hair flaps", 12, [], [], []],
    ["messy hair", 12, [], [], []],
    ["ringlets", 12, [], ["female"], []],
    ["spiked hair", 12, [], [], []],
    ["straight hair", 12, [], [], []],
    ["wavy hair", 12, [], [], []],
    ["blunt ends", 12, [], [], []],
    ["flipped hair", 12, [], [], []],
    ["lone nape hair", 12, [], [], []],
    ["parted hair", 12, [], [], []],
    ["fluffy hair", 12, [], [], []],
    ["curly hair", 12, [], [], []],
]
bangsStylesL = [
    ["arched bangs", 12, [], [], []],
    ["asymmetrical bangs", 12, [], [], []],
    ["bangs pinned back", 12, [], [], []],
    ["blunt bangs", 12, [], [], []],
    ["crossed bangs", 12, [], [], []],
    ["hair over eyes", 12, [], [], []],
    ["hair over one eye", 12, [], [], []],
    ["long bangs", 12, [], [], []],
    ["parted bangs", 12, [], [], []],
    ["short bangs", 12, [], [], []],
    ["swept bangs", 12, [], [], []],
    ["hair between eyes", 12, [], [], []],
    ["hair intakes", 12, [], ["female"], []],
    ["single hair intake", 12, [], ["female"], []],
    ["sidelocks", 12, [], [], []],
    ["asymmetrical sidelocks", 12, [], [], []],
    ["drill sidelocks", 12, [], ["female"], []],
    ["single sidelock", 12, [], [], []],
    ["hair pulled back", 12, [], [], []],
    ["hair slicked back", 12, [], [], []],
    ["ahoge", 8, [], [], []],
    ["ahoge, huge ahoge", 4, [], [], []],
    ["ahoge, heart ahoge", 4, [], [], []],
    ["antenna hair", 12, [], [], []],
    ["cowlick", 12, [], [], []],
    ["diagonal bangs", 12, [], [], []],
    ["curtained hair", 12, [], [], []],
    ["long hair between eyes", 12, [], [], []],
    ["hair behind ear", 12, [], ["female"], []],
    ["double-parted bangs", 12, [], [], []],
    ["low-tied sidelocks", 12, [], [], []],
    ["side part", 12, [], [], []],
]
breastSizesL = [
    ["flat chest", 6, [], [], []],
    ["small breasts", 14, ["breasts"], [], []],
    ["medium breasts", 14, ["breasts"], [], []],
    ["large breasts", 4, ["breasts"], [], []],
    ["huge breasts", 2, ["breasts"], [], []],
    ["gigantic breasts", 1, ["breasts"], [], []],
    ["sagging breasts", 1, ["breasts"], [], []],
]
bodyFeaturesL = [
    ["forehead", 12, [], [], []],
    ["collarbone", 12, [], [], []],
    ["neck", 12, [], [], []],
    ["narrow waist", 12, [], [], []],
    ["wide hips", 12, [], ["female"], []],
    ["shiny skin", 12, [], [], []],
    ["thighs", 12, [], [], []],
    ["thick thighs", 12, [], ["female"], []],
    ["thigh gap", 12, [], ["female"], []],
    ["third eye", 1, [], [], []],
    ["thick eyebrows", 12, [], [], []],
    ["teeth", 12, [], [], []],
    ["stomach", 12, [], [], []],
    ["plump", 12, [], [], []],
    ["scar", 4, [], [], []],
    ["petite", 12, [], [], []],
    ["muscular", 12, [], [], []],
    ["mature female", 12, [], ["female"], []],
    ["mature male", 12, [], ["male"], []],
    ["huge ass", 2, [], [], ["front"]],
    ["flat ass", 2, [], [], ["front"]],
    ["mole under eye", 4, [], [], []],
    ["mole under mouth", 4, [], [], []],
    ["mole on thigh", 4, [], ["legs"], []],
    ["freckles", 12, [], [], []],
    ["curvy", 12, [], ["female"], []],
    ["androgynous", 12, [], [], []],
    ["abs", 12, [], [], []],
    ["old woman", 12, [], ["female"], []],
    ["old man", 12, [], ["male"], []],
    ["toned", 12, [], [], []],
    ["fat", 2, [], [], []],
    ["biceps", 12, [], [], []],
    ["knees", 12, [], [], []],
    ["skinny", 12, [], [], []],
    ["hip bones", 12, [], [], []],
    ["thick arms", 12, [], [], []],
    ["tall", 12, [], [], []],
    ["short", 12, [], [], []],
    ["tomboy", 12, [], ["female"], []],
    ["otoko no ko", 12, [], ["male"], []],
    ["sideburns", 12, [], ["male"], []],
    ["long sideburns", 12, [], ["male"], []],
    ["handsome lady", 12, [], ["female"], []],
    ["hairy", 12, [], ["male"], []],
    ["bishounen", 12, [], ["male"], []],
    ["big belly", 1, [], [], []],
    ["bara", 12, [], ["male"], []],
    ["sideburns stubble", 12, [], ["male"], []],
    ["veiny arms", 12, [], [], []],
    ["shortstack", 12, [], ["female"], []],
    ["thick lips", 12, [], [], []],
    ["stoic beauty", 12, [], ["female"], []],
    ["ugly man", 12, [], ["male"], []],
    ["ugly woman", 12, [], ["female"], []],
]
hatsAndHeadwearL = [
    ["hat, baseball cap", 12, ["headcovering"], [], []],
    ["hat, cabbie hat", 12, ["headcovering"], [], []],
    ["hat, deerstalker", 12, ["headcovering"], [], []],
    ["hat, peaked cap", 12, ["headcovering"], [], []],
    ["hat, shako cap", 12, ["headcovering"], [], []],
    ["hat, bicorne", 12, ["headcovering"], [], []],
    ["hat, bowler hat", 12, ["headcovering"], [], []],
    ["hat, cowboy hat", 12, ["headcovering"], [], []],
    ["hat, straw hat", 12, ["headcovering"], [], []],
    ["hat, fedora", 12, ["headcovering"], [], []],
    ["hat, flat cap", 12, ["headcovering"], [], []],
    ["hat, pirate hat", 12, ["headcovering"], [], []],
    ["hat, sun hat", 12, ["headcovering"], [], []],
    ["hat, top hat", 12, ["headcovering"], [], []],
    ["hat, tricorne", 12, ["headcovering"], [], []],
    ["hat, witch hat", 12, ["headcovering"], [], []],
    ["hat, wizard hat, conical hat", 12, ["headcovering"], [], []],
    ["hat, military hat, dixie cup hat", 12, ["headcovering"], [], []],
    ["hat, chef hat", 12, ["headcovering"], [], []],
    ["hat, beret", 12, ["headcovering"], [], []],
    ["hat, beanie", 12, ["headcovering"], [], []],
    ["coif", 12, ["headcovering"], [], []],
    ["hat, fur hat", 12, ["headcovering"], [], []],
    ["hat, nightcap", 12, ["headcovering"], [], []],
    ["hat, nurse cap", 12, ["headcovering"], [], []],
    ["hat, party hat", 12, ["headcovering"], [], []],
    ["hat, sailor hat", 12, ["headcovering"], [], []],
    ["hat, santa hat", 12, ["headcovering"], [], []],
    ["hat, animal hat", 12, ["headcovering"], [], []],
    ["crown", 12, ["headcovering"], [], []],
    ["tiara", 12, ["headcovering"], ["female"], []],
    ["aviator cap, goggles", 12, ["headcovering"], [], []],
    ["bandana", 12, ["headcovering"], [], []],
    ["bonnet", 12, ["headcovering"], ["female"], []],
    ["headscarf", 12, ["headcovering"], [], []],
    ["hat, jester cap", 12, ["headcovering"], [], []],
    ["hat, frilled hat", 12, ["headcovering"], [], []],
    ["hat, military hat", 12, ["headcovering"], [], []],
    ["hat, police hat", 12, ["headcovering"], [], []],
    ["visor cap", 12, ["headcovering"], [], []],
    ["hat, garrison cap", 12, ["headcovering"], [], []],
    ["head wreath", 12, ["headcovering"], [], []],
    ["flower wreath", 12, ["headcovering"], [], []],
    ["on head, animal on head, bird on head", 3, ["headcovering"], [], []],
    ["on head, animal on head, cat on head", 3, ["headcovering"], [], []],
    ["on head, animal on head, dog on head", 3, ["headcovering"], [], []],
    ["on head, animal on head, panda on head", 3, ["headcovering"], [], []],
    ["on head, animal on head, rabbit on head", 3, ["headcovering"], [], []],
    ["on head, animal on head, capybara on head", 1, ["headcovering"], [], []],
    ["hat, tokin hat", 12, ["headcovering"], [], []],
    ["super crown", 1, ["headcovering"], [], []],
    ["rabbit hood", 12, ["headcovering"], [], []],
    ["qingdai guanmao", 12, ["headcovering"], [], []],
    ["horned helmet", 12, ["headcovering"], [], []],
    ["turban", 12, ["headcovering"], [], []],
    ["space helmet", 4, [], [], []],
    ["tenugui", 12, ["headcovering"], [], []],
    ["pom pom beanie", 12, ["headcovering"], [], []],
]
hairAccessoriesL = [
    ["hair ribbon", 12, [], ["female"], []],
    ["hair bow", 12, [], ["female"], []],
    ["hairband", 12, [], [], []],
    ["headband", 12, [], [], []],
    ["headdress", 12, [], ["female"], []],
    ["veil", 12, [], ["female"], []],
    ["hooded cloak", 12, [], [], []],
    ["triangular headpiece", 12, [], [], []],
    ["towel on head", 12, [], [], []],
    ["lolita hairband", 12, [], ["female"], []],
    ["horned headwear", 12, [], [], []],
    ["bun cover", 12, [], ["female"], []],
    ["hairpods", 12, [], [], []],
    ["hachimaki", 12, [], [], []],
    ["rabbit ear hairband", 4, [], ["female"], []],
    ["cat ear hairband", 12, [], [], []],
]
hatDecorationsL = [
    ["hat bow", 12, [], [], []],
    ["hat flower", 12, [], [], []],
    ["hat ornament", 12, [], [], []],
    ["hat ribbon", 12, [], [], []],
    ["hat with ears", 12, [], [], []],
    ["winged hat", 8, [], [], []],
    ["ears through headwear", 1, [], [], []],
]
dressesAndAttireL = [
    ["dress, cocktail dress", 12, [], ["female"], []],
    ["german clothes, dirndl", 5, [], ["female"], []],
    ["dress, evening gown", 5, [], ["female"], []],
    ["funeral dress", 5, [], ["female"], []],
    ["gown", 5, ["strapped"], ["female"], []],
    ["nightgown", 5, ["strapped"], ["female"], []],
    ["pencil dress", 5, ["strapped"], ["female"], []],
    ["sailor dress", 5, [], ["female"], []],
    ["santa dress", 5, [], ["female"], []],
    ["sundress", 5, [], ["female"], []],
    ["sweater dress", 5, [], ["female"], []],
    ["tube dress", 5, [], ["female"], []],
    ["wedding dress", 5, [], ["female"], []],
    ["fur-trimmed dress", 5, [], ["female"], []],
    ["armored dress", 5, [], ["female"], []],
    ["backless dress", 5, [], ["female"], []],
    ["collared dress", 5, [], ["female"], []],
    ["frilled dress", 5, ["buttons"], ["female"], []],
    ["halter dress", 5, [], ["female"], []],
    ["latex dress", 5, [], ["female"], []],
    ["layered dress", 5, [], ["female"], []],
    ["long dress", 5, [], ["female"], []],
    ["off-shoulder dress", 5, [], ["female"], []],
    ["pleated dress", 5, [], ["female"], []],
    ["ribbed dress", 5, [], ["female"], []],
    ["ribbon-trimmed dress", 5, [], ["female"], []],
    ["short dress", 5, ["strapped"], ["female"], []],
    ["see-through dress", 5, [], ["female"], []],
    ["sleeveless dress", 5, [], ["female"], []],
    ["strapless dress", 5, [], ["female"], []],
    ["china dress", 5, [], ["female"], []],
    ["camisole", 12, ["strapped"], ["female"], []],
    ["babydoll", 12, ["strapped"], ["female"], []],
    ["chemise", 12, ["strapped"], ["female"], []],
    ["nightgown", 12, ["strapped"], ["female"], []],
    ["pinafore dress", 12, [], ["female"], []],
    ["see-through dress", 12, [], ["female"], []],
    ["glitter dress", 12, ["strapped"], ["female"], []],
    ["crinoline", 12, [], ["female"], []],
    ["microdress", 12, [], ["female"], []],
    ["highleg dress", 12, [], ["female"], []],
    ["hobble dress", 12, [], ["female"], []],
]
socksAndStockingsL = [
    ["socks", 12, [], ["feel"], []],
    ["kneehighs", 12, [], ["female", "feet"], []],
    ["over-kneehighs", 12, ["legwear"], ["female", "legs"], []],
    ["thighhighs", 16, ["legwear"], ["female", "legs"], []],
    ["pantyhose", 8, [], ["female", "legs"], []],
    ["thighband pantyhose", 8, [], ["female", "legs"], []],
    ["leggings", 24, ["legwear"], ["female", "legs"], []],
    ["leg warmers", 12, [], ["legs"], []],
    ["loose socks", 12, [], ["feet"], []],
    ["bobby socks", 12, [], ["feet", "female"], []],
    ["frilled socks", 12, [], ["feet", "female"], []],
]
legwearStylesL = [
    ["fishnet legwear", 12, [], ["legwear"], []],
    ["bow legwear", 12, [], ["legwear"], []],
    ["ribbed legwear", 12, [], ["legwear"], []],
    ["seamed legwear", 12, [], ["legwear"], []],
    ["see-through legwear", 12, [], ["legwear"], []],
    ["shiny legwear", 12, [], ["legwear"], []],
    ["fur-trimmed legwear", 12, [], ["legwear"], []],
    ["lace-trimmed legwear", 12, [], ["legwear"], []],
    ["uneven legwear", 12, [], ["legwear"], []],
    ["mismatched legwear", 12, [], ["legwear"], []],
]
topsAndShirtsL = [
    ["blouse", 12, ["buttons"], [], []],
    ["frilled shirt", 12, ["shirt"], [], []],
    ["sleeveless shirt", 12, ["shirt"], [], []],
    ["bustier", 12, [], ["breasts"], []],
    ["crop top", 12, ["strapped"], [], []],
    ["cardigan", 12, [], [], []],
    ["cardigan vest", 12, [], [], []],
    ["coat", 12, [], [], []],
    ["duffel coat", 12, [], [], []],
    ["fur coat", 12, [], [], []],
    ["fur-trimmed coat", 12, [], [], []],
    ["long coat", 12, [], [], []],
    ["overcoat", 12, [], [], []],
    ["raincoat", 12, [], [], []],
    ["trench coat", 12, [], [], []],
    ["winter coat", 12, [], [], []],
    ["compression shirt", 12, ["shirt"], [], []],
    ["halterneck", 12, [], ["female"], []],
    ["criss-cross halter", 12, [], ["female"], []],
    ["hoodie", 12, [], [], []],
    ["jacket", 12, ["zipper"], [], []],
    ["blazer", 12, [], [], []],
    ["cropped jacket", 12, [], [], []],
    ["letterman jacket", 12, [], [], []],
    ["safari jacket", 12, [], [], []],
    ["suit jacket", 12, [], [], []],
    ["leather jacket", 12, [], [], []],
    ["poncho", 12, [], [], []],
    ["raglan sleeves", 12, [], [], []],
    ["shirt", 12, ["shirt"], [], []],
    ["collared shirt", 12, ["buttons", "shirt"], [], []],
    ["dress shirt", 12, ["shirt"], [], []],
    ["off-shoulder shirt", 12, ["shirt"], [], []],
    ["sleeveless shirt", 12, ["shirt"], [], []],
    ["striped shirt", 12, ["shirt"], [], []],
    ["t-shirt", 12, ["shirt"], [], []],
    ["shrug (clothing)", 12, [], ["female"], []],
    ["surcoat", 12, [], [], []],
    ["sweater", 12, [], [], []],
    ["turtleneck", 12, [], [], []],
    ["sleeveless turtleneck", 12, [], [], []],
    ["ribbed sweater", 12, [], [], []],
    ["aran sweater", 12, [], [], []],
    ["argyle sweater", 12, [], [], []],
    ["virgin killer sweater", 12, [], ["female"], []],
    ["open-chest sweater", 12, [], ["female"], []],
    ["tabard", 12, [], [], []],
    ["tailcoat", 12, [], [], []],
    ["tank top", 12, [], [], []],
    ["tube top", 12, [], ["female"], []],
    ["bandeau", 12, [], ["female", "breasts"], []],
    ["underbust", 12, [], ["female", "breasts"], []],
    ["vest", 12, [], [], []],
    ["sweater vest", 12, [], [], []],
    ["waistcoat", 12, [], [], []],
    ["chest sarashi", 12, [], [], []],
    ["budget sarashi", 12, [], ["female", "breasts"], []],
    ["tunic", 12, ["buttons"], [], []],
    ["front-tie top", 12, [], ["female"], []],
    ["breast curtains", 12, [], ["female", "breasts"], []],
    ["pasties", 1, [], ["female"], []],
    ["heart pasties", 1, [], ["female"], []],
    ["cross pasties", 1, [], ["female"], []],
    ["star pasties", 1, [], ["female"], []],
    ["track jacket", 12, [], [], []],
    ["strapless shirt", 12, [], ["female"], []],
    ["bomber jacket", 12, [], [], []],
    ["hawaiian shirt", 12, [], [], []],
    ["tangzhuang", 12, [], [], []],
    ["sleeveless hoodie", 12, [], [], []],
    ["camouflage jacket", 12, [], [], []],
    ["denim jacket", 12, [], [], []],
    ["see-through jacket", 12, [], [], []],
    ["duster coat", 12, [], [], []],
]
pantsAndBottomsL = [
    ["bloomers", 12, [], ["female"], []],
    ["buruma", 12, [], ["female"], []],
    ["chaps", 12, [], [], []],
    ["pants", 12, [], [], []],
    ["tight pants", 12, [], [], []],
    ["baggy pants", 12, [], [], []],
    ["bell-bottoms", 12, [], [], []],
    ["capri pants", 12, [], [], []],
    ["detached pants", 12, [], [], []],
    ["jeans", 12, [], [], []],
    ["lowleg pants", 12, [], [], []],
    ["pants rolled up", 12, [], [], []],
    ["yoga pants", 12, [], [], []],
    ["pelvic curtain", 12, [], [], []],
    ["petticoat", 12, [], ["female"], []],
    ["shorts", 12, [], [], []],
    ["bike shorts", 12, [], [], []],
    ["denim shorts", 12, [], [], []],
    ["dolphin shorts", 12, [], ["female"], []],
    ["gym shorts", 12, [], [], []],
    ["lowleg shorts", 12, [], [], []],
    ["micro shorts", 12, [], ["female"], []],
    ["short shorts", 12, [], [], []],
    ["suspender shorts", 12, [], [], []],
    ["shorts under skirt", 12, ["skirt"], ["female"], []],
    ["skirt", 12, ["skirt"], ["female"], []],
    ["bubble skirt", 12, ["skirt"], ["female"], []],
    ["high-waist skirt", 12, ["skirt"], ["female"], []],
    ["long skirt", 12, ["skirt"], ["female"], []],
    ["lowleg skirt", 12, ["skirt"], ["female"], []],
    ["microskirt", 12, ["skirt"], ["female"], []],
    ["miniskirt", 12, ["skirt"], ["female"], []],
    ["overall skirt", 12, ["skirt"], ["female"], []],
    ["plaid skirt", 12, ["skirt"], ["female"], []],
    ["pleated skirt", 12, ["skirt"], ["female"], []],
    ["suspender skirt", 12, ["skirt"], ["female"], []],
    ["showgirl skirt", 12, ["skirt"], ["female"], []],
    ["sweatpants", 12, [], [], []],
    ["track pants", 12, [], [], []],
    ["loincloth", 12, [], [], []],
    ["high-waist shorts", 12, [], [], []],
    ["high-waist pants", 12, [], [], []],
    ["camouflage pants", 12, [], [], []],
    ["boxer briefs", 12, [], [], []],
    ["dress pants", 12, [], [], []],
]
bootsAndFootwearL = [
    ["boots", 12, [], ["feet"], []],
    ["ankle boots", 12, [], ["feet"], []],
    ["armored boots", 12, [], ["feet"], []],
    ["cowboy boots", 12, [], ["feet"], []],
    ["knee boots", 12, [], ["feet"], []],
    ["high heel boots", 12, [], ["feet", "female"], []],
    ["lace-up boots", 12, [], ["feet"], []],
    ["rubber boots", 12, [], ["feet"], []],
    ["thigh boots", 12, [], ["feet"], []],
    ["cross-laced footwear", 12, [], ["feet"], []],
    ["dress shoes", 12, [], ["feet"], []],
    ["flats", 12, [], ["feet"], []],
    ["high heels", 12, [], ["feet", "female"], []],
    ["stiletto heels", 12, [], ["feet", "female"], []],
    ["loafers", 12, [], ["feet"], []],
    ["mary janes", 12, [], ["feet"], []],
    ["platform footwear", 12, [], ["feet"], []],
    ["pointy footwear", 4, [], ["feet"], []],
    ["pumps", 12, [], ["feet", "female"], []],
    ["sandals", 12, [], ["feet"], []],
    ["flip-flops", 12, [], ["feet"], []],
    ["geta", 12, [], ["feet"], []],
    ["gladiator sandals", 12, [], ["feet"], []],
    ["okobo", 12, [], ["feet"], []],
    ["zouri", 12, [], ["feet"], []],
    ["slippers", 12, [], ["feet"], []],
    ["animal slippers", 12, [], ["feet"], []],
    ["ballet slippers", 12, [], ["feet", "female"], []],
    ["crocs", 12, [], ["feet"], []],
    ["uwabaki", 12, [], ["feet"], []],
    ["sneakers", 12, [], ["feet"], []],
    ["high tops", 12, [], ["feet"], []],
    ["converse", 12, [], ["feet"], []],
    ["toeless footwear", 12, [], ["feet"], []],
    ["wedge heels", 12, [], ["feet", "female"], []],
    ["tabi", 12, [], ["feet"], []],
]
armorsAndUniformsL = [
    ["armor", 12, [], [], []],
    ["full armor", 12, [], [], []],
    ["power armor", 12, [], [], []],
    ["armored dress", 12, [], ["female"], []],
    ["bikini armor", 12, [], ["female"], []],
    ["band uniform", 12, [], [], []],
    ["cassock", 12, [], [], []],
    ["cheerleader", 12, [], ["female"], []],
    ["ghost costume", 12, [], [], []],
    ["business suit", 12, [], [], []],
    ["pant suit", 12, ["shirt"], [], []],
    ["skirt suit", 12, ["shirt", "skirt"], [], []],
    ["tuxedo", 12, [], [], []],
    ["gym uniform", 12, [], [], []],
    ["habit", 12, [], ["female"], []],
    ["harem outfit", 12, [], [], []],
    ["hazmat suit", 12, [], [], []],
    ["animal costume", 12, [], [], []],
    ["maid", 8, ["skirt"], ["female"], []],
    ["maid, victorian maid", 8, [], ["female"], []],
    ["maid, wa maid", 8, [], ["female"], []],
    ["unconventional maid, maid leotard", 4, [], ["female"], []],
    ["unconventional maid, maid one-piece swimsuit", 4, [], ["female"], []],
    ["miko", 12, [], ["female"], []],
    ["military uniform", 12, [], [], []],
    ["overalls", 12, [], [], []],
    ["pajamas", 12, [], [], []],
    ["pilot suit", 12, [], [], []],
    ["sailor", 12, [], [], []],
    ["santa costume", 12, [], [], []],
    ["school uniform", 12, ["shirt"], [], []],
    ["serafuku", 12, ["shirt"], ["female"], []],
    ["track suit", 12, [], [], []],
    ["tutu", 12, [], ["female"], []],
    ["waitress", 12, [], ["female"], []],
    ["cowboy western", 12, ["shirt"], [], []],
    ["magical girl", 12, [], ["female"], []],
    ["lab coat", 12, [], [], []],
    ["idol, idol clothes", 12, [], [], []],
    ["police", 12, [], [], []],
    ["race queen", 12, [], ["female"], []],
    ["bride", 12, [], ["female"], []],
    ["knight", 12, [], [], []],
    ["soccer uniform", 12, ["shirt"], [], []],
    ["employee uniform", 12, ["shirt"], [], []],
    ["dancer", 12, [], [], []],
    ["spacesuit", 12, [], [], []],
    ["gyaru", 12, [], ["female"], []],
    ["kogal", 12, [], ["female"], []],
    ["soldier", 12, [], [], []],
    ["pirate costume", 12, [], [], []],
    ["princess", 12, [], ["female"], []],
    ["prince", 12, [], ["male"], []],
    ["japanese clothes, samurai", 12, [], [], []],
    ["priest", 12, [], ["male"], []],
    ["priestess", 12, [], ["female"], []],
    ["nun, traditional nun", 12, [], ["female"], []],
    ["fundoshi", 12, [], ["male"], []],
    ["fundoshi, shirt, front-tie top, ", 12, [], ["female"], []],
    ["hakama", 12, [], [], []],
    ["hakama short skirt", 12, [], [], []],
    ["hakama pants", 12, [], [], []],
    ["japanese clothes, kimono", 12, [], [], []],
    ["japanese clothes, kimono, haori", 12, [], [], []],
    ["japanese clothes, short kimono", 12, [], [], []],
    ["japanese clothes, kimono, yukata", 12, [], [], []],
    ["japanese clothes, kimono, furisode", 12, [], [], []],
    ["japanese clothes, kimono, tasuki", 12, [], [], []],
    ["playboy bunny", 12, [], ["female"], []],
    ["reverse bunnysuit", 4, [], ["female"], []],
    ["translucent bunnysuit", 12, [], ["female"], []],
    ["cat lingerie", 6, [], ["female"], []],
    ["dongtan dress", 12, [], ["female"], []],
    ["heattech leotard", 12, [], ["female"], []],
    ["hot limit", 12, [], [], []],
    ["modakawa dress", 12, [], ["female"], []],
    ["virgin destroyer sweater", 12, [], ["female"], []],
    ["virgin killer outfit", 12, [], ["female"], []],
    ["anna miller", 12, [], ["female"], []],
    ["gakuran", 12, [], [], []],
    ["kindergarten uniform", 12, [], [], []],
    ["baseball uniform", 12, ["shirt"], [], []],
    ["basketball uniform", 12, ["shirt"], [], []],
    ["american football uniform", 12, ["shirt"], [], []],
    ["tennis uniform", 12, ["shirt"], [], []],
    ["track uniform", 12, ["shirt"], [], []],
    ["scout uniform", 12, ["shirt"], [], []],
    ["kigurumi", 12, [], [], []],
    ["jersey maid", 12, [], ["female"], []],
    ["tennis dress", 12, [], ["female"], []],
    ["winter clothes", 12, [], [], []],
    ["winter uniform", 12, [], [], []],
    ["superhero costume", 12, [], [], []],
    ["sportswear", 12, [], [], []],
    ["sleepwear", 12, [], [], []],
    ["office lady", 12, [], ["female"], []],
    ["kariginu", 12, [], [], []],
    ["jirai kei", 12, [], [], []],
    ["jiangshi", 12, [], [], []],
    ["ancient egyptian clothes", 12, [], [], []],
    ["dougi", 12, [], [], []],
    ["arabian clothes", 12, [], [], []],
    ["greco-roman clothes", 12, [], [], []],
    ["ainu clothes", 12, [], [], []],
    ["spandex", 12, [], [], []],
    ["wrestling outfit", 12, [], [], []],
    ["ancient greek clothes", 12, [], [], []],
    ["biker clothes", 12, [], [], []],
    ["mummy costume", 12, [], [], []],
    ["kappougi", 12, [], [], []],
    ["japanese clothes, happi", 12, [], [], []],
    ["tribal", 12, [], [], []],
    ["loungewear", 12, [], [], []],
    ["korean clothes, hanbok", 12, [], [], []],
    ["onesie", 12, [], [], []],
    ["native american", 12, [], [], []],
    ["body armor", 12, [], [], []],
    ["wa lolita, yukata, frills", 12, [], ["female"], []],
    ["mizu happi", 12, [], [], []],
    ["scale armor", 12, [], [], []],
    ["amesuku gyaru", 12, [], ["female"], []],
    ["butler", 12, [], ["male"], []],
    ["female butler", 12, [], ["female"], []],
    ["wolf costume", 12, [], [], []],
    ["aristocratic clothes", 12, [], [], []],
    ["housewife", 12, [], ["female"], []],
    ["sukeban, delinquent, sarashi, long skirt", 12, [], ["female"], []],
    ["dinosaur costume", 12, [], [], []],
]
zipperedOutfitsL = [
    ["bikesuit", 12, ["zipper"], [], []],
    ["racing suit", 12, ["zipper"], [], []],
    ["bodysuit", 12, ["zipper"], [], []],
    ["jumpsuit", 12, ["zipper"], [], []],
    ["short jumpsuit", 12, ["zipper"], [], []],
    ["leotard", 12, [], ["female"], []],
    ["strapless leotard", 12, ["female"], [], []],
    ["thong leotard", 12, [], ["female"], []],
    ["robe", 12, [], [], []],
    ["unitard", 12, [], [], []],
    ["sleeveless turtleneck leotard", 12, [], ["female"], []],
    ["turtleneck leotard", 12, [], ["female"], []],
    ["frilled leotard", 12, [], ["female"], []],
    ["ribbed bodysuit", 12, [], [], []],
    ["ribbed leotard", 12, [], ["female"], []],
]
swimwearL = [
    ["swimsuit", 12, [], [], []],
    ["one-piece swimsuit", 12, [], ["female"], []],
    ["casual one-piece swimsuit", 12, [], ["female"], []],
    ["competition swimsuit", 12, [], ["female"], []],
    ["slingshot swimsuit", 12, [], ["female"], []],
    ["square bikini", 12, ["strapped"], ["female"], []],
    ["school swimsuit", 12, [], ["female"], []],
    ["bikini", 12, [], ["female"], []],
    ["string bikini", 12, ["strapped"], ["female"], []],
    ["micro bikini", 12, ["strapped"], ["female"], []],
    ["lowleg bikini", 12, ["strapped"], ["female"], []],
    ["thong bikini", 12, ["strapped"], ["female"], []],
    ["sports bikini", 12, ["strapped"], ["female"], []],
    ["swim briefs", 12, [], ["male"], []],
    ["rash guard", 12, [], [], []],
    ["wetsuit", 12, [], [], []],
    ["front-tie bikini top", 12, ["strapped"], ["female"], []],
    ["o-ring bikini", 12, ["strapped"], ["female"], []],
    ["strapless bikini", 12, [], ["female"], []],
    ["maid bikini", 12, ["strapped"], ["female"], []],
    ["swim trunks", 12, [], ["male"], []],
    ["swim trunks, bikini top only", 12, ["strapped"], ["female"], []],
    ["gris swimsuit", 12, [], ["female"], []],
    ["front zipper swimsuit", 12, ["zipper"], ["female"], []],
    ["dress swimsuit", 12, [], ["female"], []],
]
accessoriesAndOuterwearL = [
    ["apron", 12, [], [], []],
    ["cape", 12, [], [], []],
    ["hooded cape", 12, [], [], []],
    ["capelet", 12, [], [], []],
    ["hooded capelet", 12, [], [], []],
    ["hood", 12, [], [], []],
    ["bodystocking", 12, [], ["female"], []],
    ["ascot", 12, [], [], []],
    ["bowtie", 12, [], [], []],
    ["choker", 12, [], [], []],
    ["collar", 12, [], [], []],
    ["epaulettes", 12, [], [], []],
    ["lapels", 12, [], [], []],
    ["neck ruff", 12, [], [], []],
    ["neckerchief", 12, [], [], []],
    ["necklace", 12, [], [], []],
    ["necktie", 12, [], [], []],
    ["neck ribbon", 12, [], [], []],
    ["scarf", 12, [], [], []],
    ["shawl", 12, [], [], []],
    ["anklet", 12, [], [], []],
    ["arm belt", 12, [], [], []],
    ["armband", 12, [], [], []],
    ["armlet", 12, [], [], []],
    ["bracelet", 12, [], [], []],
    ["bangle", 12, [], [], []],
    ["spiked bracelet", 12, [], [], []],
    ["bridal gauntlets", 12, [], ["female"], []],
    ["detached sleeves", 12, [], [], []],
    ["arm warmers", 12, [], [], []],
    ["gloves", 12, [], [], []],
    ["fingerless gloves", 12, [], [], []],
    ["elbow gloves", 12, [], [], []],
    ["half gloves", 12, [], [], []],
    ["single glove", 12, [], [], []],
    ["single elbow glove", 12, [], [], []],
    ["mittens", 12, [], [], []],
    ["leg belt", 12, [], [], []],
    ["ring", 12, [], [], []],
    ["thighlet", 12, [], [], ["nolegs"]],
    ["wide sleeves", 12, [], [], []],
    ["wristband", 12, [], [], []],
    ["wrist cuffs", 12, [], [], []],
    ["wrist scrunchie", 12, [], [], []],
    ["badge", 12, [], [], []],
    ["belt", 12, [], [], []],
    ["brooch", 12, [], [], []],
    ["buttons", 12, [], [], []],
    ["collar chain", 12, [], [], []],
    ["corsage", 12, [], [], []],
    ["cuff links", 12, [], [], []],
    ["pentacle", 12, [], [], []],
    ["sarong", 12, [], ["female"], []],
    ["sash", 12, [], [], []],
    ["suspenders", 12, [], [], []],
    ["tassel", 12, [], [], []],
    ["clothing cutout", 12, [], [], []],
    ["flower trim", 12, [], [], []],
    ["frills", 12, [], [], []],
    ["gold trim", 12, [], [], []],
    ["lace trim", 12, [], [], []],
    ["ribbon trim", 12, [], [], []],
    ["see-through", 12, [], [], []],
    ["silver trim", 12, [], [], []],
    ["torn clothes", 12, [], [], []],
    ["earrings", 12, [], [], []],
    ["hoop earrings", 12, [], [], []],
    ["stud earrings", 12, [], [], []],
    ["sphere earrings", 12, [], [], []],
    ["single earring", 12, [], [], []],
    ["earclip", 12, [], [], []],
    ["glasses", 12, [], [], []],
    ["monocle", 12, [], [], []],
    ["hair ornament", 12, [], ["female"], []],
    ["hair beads", 12, [], ["female"], []],
    ["hair bobbles", 12, [], ["female"], []],
    ["hairclip", 12, [], ["female"], []],
    ["hairpin", 12, [], ["female"], []],
    ["hair scrunchie", 12, [], ["female"], []],
    ["hair stick", 12, [], ["female"], []],
    ["hair flower", 12, [], ["female"], []],
    ["hair bell", 12, [], ["female"], []],
    ["mask", 12, [], [], []],
    ["surgical mask", 12, [], [], []],
    ["sleeves pushed up", 12, [], [], []],
    ["sleeves rolled up", 12, [], [], []],
    ["short sleeves", 12, [], [], []],
    ["long sleeves", 12, [], [], []],
    ["very long sleeves", 12, [], [], []],
    ["short over long sleeves", 12, [], [], []],
    ["sleeves past wrists", 12, [], ["body"], []],
    ["sleeves past fingers", 12, [], ["body"], []],
    ["sleeves past elbows", 12, [], ["body"], []],
    ["puffy sleeves", 12, [], [], []],
    ["sleeveless", 12, [], [], []],
    ["goggles", 12, [], [], []],
    ["sunglasses", 12, [], [], []],
    ["coke-bottle glasses", 12, [], [], ["eyes"]],
    ["opaque glasses", 12, 12, [], [], ["eyes"]],
    ["safety glasses", 12, [], [], []],
    ["ski goggles", 12, [], [], []],
    ["bespectacled", 12, [], [], []],
    ["ear piercing", 12, [], [], []],
    ["eyebrow piercing", 12, [], [], []],
    ["lip piercing", 12, [], [], []],
    ["nose piercing", 12, [], [], []],
    ["tongue piercing", 12, [], [], []],
    ["navel piercing", 12, [], [], []],
    ["zipper", 12, [], [], []],
    ["zettai ryouiki", 12, [], ["body"], []],
    ["wristwatch", 12, [], [], []],
    ["x hair ornament", 12, [], ["female"], []],
    ["wing collar", 12, [], [], []],
    ["whisker markings", 12, [], [], []],
    ["wet", 12, [], [], []],
    ["wand", 12, [], [], []],
    ["waist apron", 12, [], [], []],
    ["veins", 12, [], [], []],
    ["vambraces", 12, [], [], []],
    ["valentine", 12, [], [], []],
    ["underboob", 12, [], ["breasts"], []],
    ["umbrella", 12, [], [], []],
    ["parasol", 12, [], [], []],
    ["under-rim eyewear", 12, [], [], []],
    ["unbuttoned", 12, [], ["buttons"], []],
    ["tray", 12, [], [], []],
    ["toenail polish", 12, [], ["female", "feet", "barefoot"], []],
    ["tentacles", 12, [], [], []],
    ["tattoo", 12, [], [], []],
    ["tanlines", 12, [], [], []],
    ["swimsuit under clothes", 12, [], ["female"], []],
    ["sweat", 12, [], [], []],
    ["striped", 12, [], [], []],
    ["strap slip", 12, [], ["strapped"], []],
    ["strap gap", 12, [], ["strapped", "breasts"], []],
    ["star print", 12, [], [], []],
    ["spikes", 12, [], [], []],
    ["sideboob", 12, [], ["breasts"], []],
    ["side slit", 12, [], [], []],
    ["shoulder armor", 12, [], [], []],
    ["shoulder bag", 12, [], [], []],
    ["shoulder cutout", 12, [], [], []],
    ["shoulder tattoo", 12, [], [], []],
    ["shirt tucked in", 12, [], ["shirt"], []],
    ["shiny clothes", 12, [], [], []],
    ["sharp teeth", 12, [], [], []],
    ["sharp fingernails", 12, [], [], []],
    ["saliva", 12, [], [], []],
    ["pouch", 12, [], [], []],
    ["polka dot", 12, [], [], []],
    ["pom pom (clothes)", 12, [], [], []],
    ["pocket", 12, [], [], []],
    ["revealing clothes", 12, [], [], []],
    ["ribbon", 12, [], [], []],
    ["ribbon choker", 12, [], [], []],
    ["randoseru", 12, [], [], []],
    ["semi-rimless eyewear", 12, [], [], []],
    ["scrunchie", 12, [], [], []],
    ["school bag", 12, [], [], []],
    ["plaid", 12, [], [], []],
    ["pendant", 12, [], [], []],
    ["pauldrons", 12, [], [], []],
    ["partially unbuttoned", 12, [], ["buttons"], []],
    ["paw gloves", 12, [], [], []],
    ["open clothes", 12, [], [], []],
    ["off shoulder", 12, [], [], []],
    ["o-ring top", 12, [], [], []],
    ["neck bell", 12, [], [], []],
    ["navel cutout", 12, [], [], []],
    ["mustache", 12, [], ["male"], []],
    ["wings", 12, [], [], []],
    ["low wings", 12, [], [], []],
    ["lipstick", 21, [], [], []],
    ["leg ribbon", 12, [], ["legs"], []],
    ["leash", 12, [], [], []],
    ["lace", 12, [], [], []],
    ["knee pads", 12, [], ["legs"], []],
    ["kemonomimi mode", 12, [], [], []],
    ["juliet sleeves", 12, [], [], []],
    ["joints", 12, [], [], []],
    ["jewelry", 12, [], [], []],
    ["jacket on shoulders", 12, [], [], []],
    ["impossible clothes", 12, [], [], []],
    ["ice wings", 12, [], [], []],
    ["horns", 12, [], [], []],
    ["curled horns", 12, [], [], []],
    ["small horns", 12, [], [], []],
    ["cone horns", 12, [], [], []],
    ["uneven horns", 12, [], [], []],
    ["highleg", 12, [], [], []],
    ["high collar", 12, [], [], []],
    ["helmet", 12, ["headcovering"], [], ["headcovering"]],
    ["mouth mask", 12, [], [], []],
    ["midriff peek", 12, [], [], []],
    ["midriff", 12, [], [], []],
    ["mechanical arms", 12, [], [], []],
    ["mask on head", 12, ["headcovering"], [], ["headcovering"]],
    ["makeup", 12, [], ["female"], []],
    ["long fingernails", 12, [], [], []],
    ["halo", 12, [], [], []],
    ["hair tubes", 12, [], ["female"], []],
    ["gauntlets", 12, [], [], []],
    ["garter straps", 12, [], ["legs"], []],
    ["fur trim", 12, [], [], []],
    ["floating hair", 12, [], [], []],
    ["fangs", 12, [], [], []],
    ["fang out", 12, [], [], []],
    ["facial mark", 12, [], [], []],
    ["facial hair", 12, [], ["male"], []],
    ["eyeshadow", 12, [], [], []],
    ["eyes visible through hair", 12, [], [], []],
    ["eyepatch", 12, [], [], []],
    ["eyeliner", 12, [], [], []],
    ["eyelashes", 12, [], [], []],
    ["eyebrows", 12, [], [], []],
    ["eyewear on head", 12, [], [], []],
    ["earmuffs", 12, [], [], []],
    ["covered navel", 12, [], [], []],
    ["corset", 12, [], ["female", "breasts"], []],
    ["contemporary", 12, [], [], []],
    ["colored eyelashes", 12, [], [], []],
    ["cleavage cutout", 12, [], ["breasts"], []],
    ["cleavage", 12, [], ["breasts"], []],
    ["claws", 12, [], [], []],
    ["center opening", 12, [], [], []],
    ["center frills", 12, [], [], []],
    ["breasts apart", 12, [], ["breasts"], []],
    ["breastplate", 12, [], [], []],
    ["breast pocket", 12, [], [], []],
    ["bracer", 12, [], [], []],
    ["blood on clothes", 6, [], [], []],
    ["blood on face", 6, [], [], []],
    ["blindfold", 12, [], [], []],
    ["bare shoulders", 12, [], [], []],
    ["bare arms", 12, [], [], []],
    ["bare legs", 12, [], ["legs"], []],
    ["bandaid on face", 12, [], [], []],
    ["bandaid", 12, [], [], []],
    ["bandages", 12, [], [], []],
    ["bandaged leg", 12, [], ["legs"], []],
    ["bandaged arm", 12, [], [], []],
    ["backpack", 12, [], [], []],
    ["backless outfit", 12, [], [], []],
    ["back bow", 12, [], [], []],
    ["ass visible through thighs", 12, [], ["legs"], []],
    ["armpits", 12, [], [], []],
    ["armpit crease", 12, [], [], []],
    ["armpit peed", 12, [], [], []],
    ["arm tattoo", 12, [], [], []],
    ["animal print", 12, [], [], []],
    ["clothes around waist", 12, [], [], []],
    ["headphones around neck", 12, [], [], []],
    ["oversized clothes", 12, [], [], []],
    ["manly", 12, [], [], []],
    ["greaves", 12, [], [], []],
    ["one-eyed", 12, [], [], []],
    ["fur-trimmed sleeves", 12, [], [], []],
    ["polka dot bow", 12, [], [], []],
    ["harness", 3, [], [], []],
    ["forehead jewel", 12, [], [], []],
    ["forehead mark", 12, [], [], []],
    ["single bare shoulder", 12, [], [], []],
    ["spiked collar", 12, [], [], []],
    ["striped necktie", 12, [], [], []],
    ["arm guards", 12, [], [], []],
    ["undershirt", 12, [], [], []],
    ["latex", 12, [], [], []],
    ["bandaid on leg", 12, [], [], []],
    ["bead necklace", 12, [], [], []],
    ["dirty", 12, [], [], []],
    ["giantess", 12, [], ["female"], []],
    ["cyborg", 12, [], [], []],
    ["bruise", 12, [], [], []],
    ["extra arms", 12, [], [], []],
    ["taut shirt", 12, [], [], []],
    ["chest jewel", 12, [], [], []],
    ["v-neck", 12, [], [], []],
    ["plaid scarf", 12, [], [], []],
    ["prosthesis", 12, [], [], []],
    ["single mechanical arm", 12, [], [], []],
    ["blood on hands", 12, [], [], []],
    ["bandaid on nose", 12, [], [], []],
    ["robot joints", 12, [], [], []],
    ["zombie", 12, [], [], []],
    ["tail ribbon", 12, [], [], []],
    ["tomboy", 12, [], ["female"], []],
    ["panty peek", 12, [], [], []],
    ["leg tattoo", 12, [], [], []],
    ["lanyard", 12, [], [], []],
    ["bra visible through clothes", 12, [], [], []],
    ["amputee", 12, [], [], []],
    ["bra strap", 12, ["shirt"], ["female", "breasts"], []],
    ["money", 12, [], [], []],
    ["revolver", 12, [], [], []],
    ["pearl necklace", 12, [], [], []],
    ["coat on shoulders", 12, [], [], []],
    ["chest harness", 4, [], [], []],
    ["slime (substance)", 12, [], [], []],
    ["partially unzipped", 12, [], ["zipper"], []],
    ["bodypaint", 12, [], [], []],
    ["metal collar", 12, [], [], []],
    ["loose necktie", 12, [], [], []],
    ["clover", 12, [], [], []],
    ["body markings", 12, [], [], []],
    ["mechanical wings", 12, [], [], []],
    ["leaf print", 12, [], [], []],
    ["pentagram", 12, [], [], []],
    ["neon trim", 12, [], [], []],
    ["prosthetic arm", 12, [], [], []],
    ["bandage over one eye", 12, [], [], []],
    ["mascara", 12, [], [], []],
    ["cat ear headphones", 12, [], [], []],
    ["cuts", 12, [], [], []],
    ["jacket around waist", 12, [], ["legs"], []],
    ["bleeding", 12, [], [], []],
    ["rectangular eyewear", 12, [], [], []],
    ["chain necklace", 12, [], [], []],
    ["paw shoes", 12, [], [], []],
    ["feather trim", 12, [], [], []],
    ["gold chain", 12, [], [], []],
    ["mechanical parts", 12, [], [], []],
    ["mechanical legs", 12, [], [], ["nolegs"]],
    ["eye mask", 12, [], [], []],
    ["scratches", 12, [], [], []],
    ["cross scar", 12, [], [], []],
    ["tusks", 12, [], [], []],
    ["dragon print", 12, [], [], []],
    ["sun symbol", 12, [], [], []],
    ["uneven sleeves", 12, [], [], []],
    ["energy wings", 12, [], [], []],
    ["cat print", 12, [], [], []],
    ["sweatband", 12, [], [], []],
    ["sweater around waist", 12, [], ["legs"], []],
    ["glowing sword", 12, [], [], []],
    ["fanny pack", 12, [], ["legs"], []],
    ["blood stain", 12, [], [], []],
    ["single pauldron", 12, [], [], []],
    ["energy ball", 12, [], [], []],
    ["scepter", 12, [], [], []],
    ["cherry blossom print", 12, [], [], []],
    ["insect wings", 12, [], [], []],
    ["constellation print", 12, [], [], []],
    ["utility belt", 12, [], [], []],
    ["prosthetic leg", 12, [], [], ["nolegs"]],
    ["very sweaty", 12, [], [], []],
    ["scales", 12, [], [], []],
    ["fake animal ears", 12, [], [], []],
    ["elbow pads", 12, [], [], []],
    ["plunging neckline", 12, [], [], []],
    ["waist cape", 12, [], [], []],
    ["waist bow", 12, [], ["female"], []],
    ["vertical stripes", 12, [], [], []],
    ["v-neck", 12, [], [], []],
    ["undersized clothes", 12, [], [], []],
    ["towel around neck", 12, [], [], []],
    ["taut clothes", 12, [], [], []],
    ["tassel hair ornament", 12, [], ["female"], []],
    ["talisman", 12, [], [], []],
    ["tail, tail wagging", 12, [], [], []],
    ["tail, tail raised", 12, [], [], []],
    ["tail, tail bow", 12, [], [], []],
    ["striped clothes", 12, [], [], []],
    ["stitches", 12, [], [], []],
    ["steaming body", 12, [], [], []],
    ["skin fang", 12, [], [], []],
    ["skin fangs", 12, [], [], []],
    ["skin tight", 12, [], [], []],
    ["skin-covered horns", 12, [], [], []],
    ["skindentation", 12, [], ["female"], []],
    ["single sleeve", 12, [], [], []],
    ["single horn", 12, [], [], []],
    ["sideless outfit", 12, [], ["female"], []],
    ["side cutout", 12, [], [], []],
    ["short necktie", 12, [], [], []],
    ["short eyebrows", 12, [], [], []],
    ["round teeth", 12, [], [], []],
    ["reindeer antlers", 12, [], [], []],
    ["rabbit hair ornament", 12, [], [], []],
    ["popped collar", 12, [], [], []],
    ["pinstripe pattern", 12, [], [], []],
    ["pince-nez", 12, [], [], []],
    ["pendant choker", 12, [], [], []],
    ["neck ring", 12, [], [], []],
    ["multiple wings", 12, [], [], []],
    ["multiple horns", 12, [], [], []],
    ["mind control", 12, [], [], []],
    ["shoulder spikes", 12, [], [], []],
    ["shoulder pads", 12, [], [], []],
    ["shoulder blades", 12, [], [], ["front"]],
    ["median furrow", 12, [], [], ["front"]],
    ["medical eyepatch", 12, [], [], []],
    ["mechabare", 12, [], [], []],
    ["material growth", 12, [], [], []],
    ["mandarin collar", 12, [], [], []],
    ["magatama", 12, [], [], []],
    ["layered clothes", 12, [], [], []],
    ["layered sleeves", 12, [], [], []],
    ["large tail", 12, [], [], []],
    ["notched ear", 12, [], [], []],
    ["notched lapels", 12, [], [], []],
    ["jingle bell", 12, [], [], []],
    ["injury", 12, [], [], []],
    ["high collar", 12, [], [], []],
    ["hagoromo", 12, [], [], []],
    ["gothic lolita", 12, [], ["female"], []],
    ["gas mask", 12, [], [], []],
    ["framed breasts", 12, [], ["breasts"], []],
    ["flame-tipped tail", 12, [], [], []],
    ["fake horns", 12, [], [], []],
    ["fake animal ears", 12, [], [], []],
    ["dot nose", 12, [], [], []],
    ["detached wings", 12, [], [], []],
    ["cowbell", 12, [], [], []],
    ["colored extremities", 12, [], [], []],
    ["colored eyelashes", 12, [], [], []],
    ["bursting breasts", 12, [], ["breasts"], []],
    ["buckle", 12, [], [], []],
    ["body fur", 12, [], [], []],
    ["body blush", 12, [], [], []],
    ["beard stubble", 12, [], ["male"], []],
    ["beard", 12, [], ["male"], []],
    ["thick beard", 12, [], ["male"], []],
    ["very long beard", 12, [], ["male"], []],
    ["goatee stubble", 12, [], ["male"], []],
    ["bare hips", 12, [], [], []],
    ["star choker", 12, [], [], []],
    ["nape", 12, [], [], []],
    ["teardrop facial mark", 12, [], [], []],
    ["mechanical tail", 12, [], [], []],
    ["single off shoulder", 12, [], [], []],
    ["hands in opposite sleeves", 12, [], [], []],
    ["gorget", 12, [], [], []],
    ["hikimayu", 12, [], [], []],
    ["pearl (gemstone)", 12, [], [], []],
    ["collared cape", 12, [], [], []],
    ["fiery hair", 12, [], [], []],
    ["stitched face", 12, [], [], []],
    ["burning", 12, [], [], []],
    ["star necklace", 12, [], [], []],
    ["patchwork skin", 12, [], [], []],
    ["mouth veil", 12, [], [], []],
    ["stole", 12, [], [], []],
    ["star facial mark", 12, [], [], []],
    ["bow choker", 12, [], ["female"], []],
    ["buck teeth", 12, [], [], []],
    ["prehensile hair", 12, [], [], []],
    ["diving mask", 12, [], [], []],
    ["loose hair strand", 12, [], [], []],
    ["neck fur", 12, [], [], []],
    ["fake antlers", 12, [], [], []],
    ["loose bowtie", 12, [], [], []],
    ["broken halo", 12, [], [], []],
    ["very long fingernails", 12, [], [], []],
    ["forked tongue", 12, [], [], []],
    ["digitigrade", 12, [], [], []],
    ["spiked tail", 12, [], [], []],
    ["large wings", 12, [], [], []],
    ["dark halo", 12, [], [], []],
    ["mechanical ears", 12, [], [], []],
    ["bruise on face", 12, [], [], []],
    ["white halo", 12, [], [], []],
    ["sweaty clothes", 12, [], [], []],
    ["transparent wings", 12, [], [], []],
    ["magatama earrings", 12, [], [], []],
    ["spiked halo", 12, [], [], []],
    ["crystal hair", 12, [], [], []],
    ["artificial eye", 12, [], [], []],
    ["fake mustache", 12, [], [], []],
    ["pointy nose", 12, [], [], []],
    ["button eyes", 12, ["eyes"], [], ["eyes", "noeyes"]],
    ["bolo tie", 12, [], [], []],
    ["fiery horns", 12, [], [], []],
    ["sparkle print", 12, [], [], []],
    ["liquid hair", 12, [], [], []],
    ["frilled ascot", 12, [], [], []],
    ["baggy clothes", 12, [], [], []],
    ["aegyo sal", 12, [], ["female"], []],
    ["glowing wings", 12, [], [], []],
    ["glowing horns", 12, [], [], []],
    ["diamond (gemstone)", 12, [], [], []],
    ["paint splatter on face", 12, [], [], []],
    ["long nose", 12, [], [], []],
    ["studded choker", 12, [], [], []],
    ["webbed hands", 12, [], [], []],
    ["shiny hair", 12, [], [], []],
    ["glitter", 12, [], [], []],
    ["warrior", 12, [], [], []],
    ["sparkling aura", 12, [], [], []],
    ["fiery tail", 12, [], [], []],
    ["gingham", 12, [], [], []],
    ["lazy eye", 12, [], [], []],
    ["scorpion tail", 12, [], [], []],
    ["dinosaur tail", 12, [], [], []],
    ["lei, flower necklace", 12, [], [], []],
    ["loving aura", 12, [], [], []],
    ["skeletal hand", 6, [], [], []],
]
facialExpressionsL = [
    ["wince", 12, [], [], []],
    ["wide-eyed", 12, [], [], []],
    ["tears", 12, [], [], []],
    ["triangle mouth", 12, [], [], []],
    ["trembling", 12, [], [], []],
    ["tongue out", 12, [], [], []],
    ["tearing up", 12, [], [], []],
    ["sweatdrop", 12, [], [], []],
    ["surprised", 12, [], [], []],
    ["spoken heart", 12, [], [], []],
    ["spoken question mark", 12, [], [], []],
    ["spoken ellipsis", 12, [], [], []],
    ["smug", 12, [], [], []],
    ["smirk", 12, [], [], []],
    ["smile", 12, [], [], []],
    ["serious", 12, [], [], []],
    ["shaded face", 12, [], [], []],
    ["pout", 12, [], [], []],
    ["parted lips", 12, [], [], []],
    ["o_o", 12, [], [], []],
    ["notice lines", 12, [], [], []],
    ["nose blush", 12, [], [], []],
    ["naughty face", 12, [], [], []],
    ["light smile", 12, [], [], []],
    ["light blush", 12, [], [], []],
    ["licking lips", 12, [], [], []],
    ["laughing", 12, [], [], []],
    ["heavy breathing", 12, [], [], []],
    ["happy", 12, [], [], []],
    ["half-closed eyes", 12, [], [], []],
    ["grin", 12, [], [], []],
    ["frown", 12, [], [], []],
    ["flying sweatdrops", 12, [], [], []],
    ["expressionless", 12, [], [], []],
    ["evil smile", 12, [], [], []],
    ["embarrassed", 12, [], [], []],
    ["drunk", 12, [], [], []],
    ["crying with eyes open", 12, [], [], []],
    ["crying", 12, [], [], []],
    ["closed eyes", 12, ["eyes"], [], ["eyes", "noeyes"]],
    ["clenched teeth", 12, [], [], []],
    ["chestnut mouth", 12, [], [], []],
    ["blush stickers", 12, [], [], []],
    ["blush", 12, [], [], []],
    ["angry", 12, [], [], []],
    ["anger vein", 12, [], [], []],
    ["ahegao", 1, [], [], []],
    ["^_^", 12, [], [], []],
    ["@_@", 12, [], [], []],
    ["?", 12, [], [], []],
    [">:)", 12, [], [], []],
    ["=_=", 12, ["eyes"], [], ["eyes", "noeyes"]],
    [";d", 12, [], [], []],
    [";)", 12, [], [], []],
    [":t", 12, [], [], []],
    [":q", 12, [], [], []],
    [":p", 12, [], [], []],
    [":o", 12, [], [], []],
    [":d", 12, [], [], []],
    [":>", 12, [], [], []],
    [":<", 12, [], [], []],
    [":3", 12, [], [], []],
    ["...", 12, [], [], []],
    ["+_+", 12, [], [], []],
    ["+++", 12, [], [], []],
    ["!?", 12, [], [], []],
    ["!", 12, [], [], []],
    ["annoyed", 12, [], [], []],
    ["spoken exclamation mark", 12, [], [], []],
    ["sad", 12, [], [], []],
    [":/", 12, [], [], []],
    ["!!", 12, [], [], []],
    ["nervous", 12, [], [], []],
    ["0_0", 12, ["eyes"], [], ["eyes", "noeyes"]],
    [";o", 12, [], [], []],
    ["seductive smile", 12, [], [], []],
    ["torogao", 1, [], [], []],
    ["d:", 12, [], [], []],
    ["sleepy", 12, [], [], []],
    ["ear blush", 12, [], [], []],
    ["nervous sweating", 12, [], [], []],
    ["puff of air", 12, [], [], []],
    ["spoken musical note", 12, [], [], []],
    ["glaring", 12, [], [], []],
    [";p", 12, [], [], []],
    ["shy", 12, [], [], []],
    ["streaming tears", 12, [], [], []],
    ["spoken blush", 12, [], [], []],
    [">:(", 12, [], [], []],
    ["evil grin", 12, [], [], []],
    ["nervous smile", 12, [], [], []],
    [";q", 12, [], [], []],
    ["spoken squiggle", 12, [], [], []],
    ["spoken interrobang", 12, [], [], []],
    ["thinking", 12, [], [], []],
    ["puckered lips", 12, [], [], []],
    ["screaming", 12, [], [], []],
    ["spoken anger vein", 12, [], [], []],
    ["dot mouth", 12, [], [], []],
    ["grimace", 12, [], [], []],
    [";3", 12, [], [], []],
    ["confused", 12, [], [], []],
    ["worried", 12, [], [], []],
    ["u_u", 12, ["eyes"], [], ["eyes", "noeyes"]],
    ["raised eyebrows", 12, [], [], []],
    ["uneven eyes", 12, [], [], []],
    ["turn pale", 12, [], [], []],
    ["squeans", 12, [], [], []],
    ["split mouth", 12, [], [], []],
    ["sideways glance", 12, [], [], []],
    ["scowl", 12, [], [], []],
    ["head tilt", 12, [], [], []],
    ["furrowed brow", 12, [], [], []],
    ["drooling", 12, [], [], []],
    ["averting eyes", 12, [], [], []],
    ["^_^", 12, ["eyes"], [], ["eyes", "noeyes"]],
    [">_<", 12, ["eyes"], [], ["eyes", "noeyes"]],
    ["x_x", 12, ["eyes"], [], ["eyes", "noeyes"]],
    [">:)", 12, [], [], []],
    [">:(", 12, [], [], []],
    [";q", 12, [], [], []],
    [";d", 12, [], [], []],
    [";)", 12, [], [], []],
    ["> o", 12, [], [], []],
    ["snot", 4, [], [], []],
    ["upturned eyes", 12, [], [], []],
    ["unusually open eyes", 12, [], [], []],
    ["crazy smile", 12, [], [], []],
    ["happy tears", 12, [], [], []],
    ["o3o", 12, [], [], []],
    ["flustered", 12, [], [], []],
    ["nose bubble", 12, [], [], []],
    ["false smile", 12, [], [], []],
    ["disgust", 12, [], [], []],
    ["excited", 12, [], [], []],
    ["._.", 12, ["eyes"], [], ["eyes", "noeyes"]],
    ["puffy cheeks", 12, [], [], []],
    ["blank stare", 12, [], [], []],
    ["determined", 12, [], [], []],
    ["pouty lips", 12, [], [], []],
    ["gesugao", 12, [], [], []],
    ["panicking", 12, [], [], []],
    ["forced smile", 12, [], [], []],
    [";(", 12, [], [], []],
    [":c", 12, [], [], []],
    ["sad smile", 12, [], [], []],
    ["happy aura", 12, [], [], []],
]
yearlyThemesL = [
    ["year 2005", 12, [], [], []],
    ["year 2006", 12, [], [], []],
    ["year 2007", 12, [], [], []],
    ["year 2008", 12, [], [], []],
    ["year 2009", 12, [], [], []],
    ["year 2010", 12, [], [], []],
    ["year 2011", 12, [], [], []],
    ["year 2012", 12, [], [], []],
    ["year 2013", 12, [], [], []],
    ["year 2014", 12, [], [], []],
    ["year 2015", 12, [], [], []],
    ["year 2016", 12, [], [], []],
    ["year 2017", 12, [], [], []],
    ["year 2018", 12, [], [], []],
    ["year 2019", 12, [], [], []],
    ["year 2020", 12, [], [], []],
    ["year 2021", 12, [], [], []],
    ["year 2022", 12, [], [], []],
    ["year 2023", 12, [], [], []],
    ["year 2024", 12, [], [], []],
]
sceneElementsL = [
    ["wooden floor", 12, ["floor"], [], ["below"]],
    ["window", 12, [], [], []],
    ["water drop", 12, [], [], []],
    ["water", 12, [], [], []],
    ["wall", 12, [], [], []],
    ["underwater", 12, [], [], []],
    ["torii", 12, ["location"], [], ["location"]],
    ["tatami", 12, ["floor"], [], ["below"]],
    ["steam", 12, [], [], []],
    ["starry sky", 12, [], [], ["above"]],
    ["stairs", 12, [], [], []],
    ["space", 12, ["location"], [], ["location"]],
    ["snow", 12, [], [], []],
    ["snowing", 12, [], [], []],
    ["smoke", 12, [], [], []],
    ["sky", 12, [], [], ["above"]],
    ["shadow", 12, [], [], []],
    ["shade", 12, [], [], []],
    ["sand", 12, [], [], []],
    ["road", 12, ["location"], [], ["location"]],
    ["reflection", 12, [], [], []],
    ["rain", 12, [], [], []],
    ["railing", 12, [], [], []],
    ["pool", 12, [], [], []],
    ["palm tree", 12, [], [], []],
    ["outdoors", 12, ["location"], [], ["location"]],
    ["onsen", 12, ["location"], [], ["location"]],
    ["ocean", 12, "location", [], ["location"]],
    ["night sky", 12, [], [], ["above"]],
    ["night", 12, [], [], []],
    ["nature", 12, [], [], []],
    ["moon", 12, [], [], []],
    ["mountain", 12, [], [], []],
    ["indoors", 12, ["location"], [], ["location"]],
    ["horizon", 12, [], [], []],
    ["grass", 12, [], [], []],
    ["full moon", 12, [], [], []],
    ["frog", 12, [], [], []],
    ["forest", 12, ["location"], [], ["location"]],
    ["field", 12, ["location"], [], ["location"]],
    ["fence", 12, [], [], []],
    ["desk", 12, [], [], []],
    ["day", 12, [], [], []],
    ["curtains", 12, [], [], []],
    ["couch", 12, ["location"], [], ["location"]],
    ["cloudy sky", 12, [], [], ["above"]],
    ["cloud", 12, [], [], []],
    ["classroom", 12, ["location"], [], ["location"]],
    ["cityscape", 12, ["location"], [], ["location"]],
    ["city", 12, ["location"], [], ["location"]],
    ["bush", 12, [], [], []],
    ["building", 12, ["location"], [], ["location"]],
    ["bookshelf", 12, [], [], []],
    ["bedroom", 12, ["location"], [], ["location"]],
    ["bed", 12, [], [], []],
    ["beach", 12, ["location"], [], ["location"]],
    ["bath", 12, ["location"], [], ["location"]],
    ["vines", 12, [], [], []],
    ["bamboo", 12, [], [], []],
    ["house", 12, ["location"], [], ["location"]],
    ["ruins", 12, ["location"], [], ["location"]],
    ["crescent moon", 12, [], [], []],
    ["sliding doors", 12, [], [], []],
    ["brick wall", 12, [], [], []],
    ["east asian architecture", 12, [], [], []],
    ["futon", 12, [], [], []],
    ["bridge", 12, [], [], []],
    ["planet", 12, [], [], []],
    ["shelf", 12, [], [], []],
    ["bare tree", 12, [], [], []],
    ["street", 12, ["location"], [], ["location"]],
    ["river", 12, ["location"], [], ["location"]],
    ["castle", 12, ["location"], [], ["location"]],
    ["flower field", 12, ["location"], [], ["location"]],
    ["skyscraper", 12, ["location"], [], ["location"]],
    ["utility pole", 12, [], [], []],
    ["train interior", 12, ["location"], [], ["location"]],
    ["evening", 12, [], [], []],
    ["mountainous horizon", 12, [], [], []],
    ["waves", 12, [], [], []],
    ["crowd", 12, [], [], []],
    ["kitchen", 12, ["location"], [], ["location"]],
    ["tower", 12, ["location"], [], ["location"]],
    ["waterfall", 12, ["location"], [], ["location"]],
    ["library", 12, ["location"], [], ["location"]],
    ["puddle", 12, [], [], []],
    ["shop", 12, ["location"], [], ["location"]],
    ["lake", 12, ["location"], [], ["location"]],
    ["fog", 12, [], [], []],
    ["shrine", 12, ["location"], [], ["location"]],
    ["red moon", 12, [], [], []],
    ["rooftop", 12, ["location"], [], ["location"]],
    ["shore", 12, ["location"], [], ["location"]],
    ["floor", 12, [], [], ["below"]],
    ["contrail", 12, [], [], []],
    ["shooting star", 12, [], [], []],
    ["ceiling", 12, [], [], ["above"]],
    ["city lights", 12, [], [], []],
    ["bamboo forest", 12, ["location"], [], ["location"]],
    ["hallway", 12, ["location"], [], ["location"]],
    ["moonlight", 12, [], [], []],
    ["locker room", 12, ["location"], [], ["location"]],
    ["dusk", 12, [], [], []],
    ["tombstone", 12, [], [], []],
    ["hill", 12, [], [], []],
    ["sunrise", 12, [], [], []],
    ["restaurant", 12, ["location"], [], ["location"]],
    ["moss", 12, [], [], []],
    ["church", 12, ["location"], [], ["location"]],
    ["town", 12, ["location"], [], ["location"]],
    ["cave", 12, ["location"], [], ["location"]],
    ["festival", 12, ["location"], [], ["location"]],
    ["veranda", 12, ["location"], [], ["location"]],
    ["reflective floor", 12, [], [], ["below"]],
    ["alley", 12, ["location"], [], ["location"]],
    ["pond", 12, ["location"], [], ["location"]],
    ["tree", 12, [], [], []],
    ["overgrown", 12, [], [], []],
    ["industrial pipe", 12, [], [], []],
    ["shallow water", 12, [], [], []],
    ["column", 12, [], [], []],
    ["tree stump", 12, [], [], []],
    ["sunflower field", 12, ["location"], [], ["location"]],
    ["wading pool", 12, [], [], []],
    ["jungle", 12, ["location"], [], ["location"]],
    ["meadow", 12, ["location"], [], ["location"]],
    ["wheat field", 12, ["location"], [], ["location"]],
    ["dungeon", 12, ["location"], [], ["location"]],
]
objectsAndStuffedAnimalsL = [
    ["fruit, food, strawberry", 12, [], [], []],
    ["stuffed animal, teddy bear", 12, [], [], []],
    ["stuffed animal, stuffed rabbit", 4, [], [], []],
    ["stuffed animal, stuffed shark", 4, [], [], []],
    ["stuffed animal, stuffed fish", 4, [], [], []],
    ["stuffed animal, stuffed frog", 4, [], [], []],
    ["stuffed animal, stuffed panda", 4, [], [], []],
    ["stuffed animal, stuffed octopus", 4, [], [], []],
    ["stuffed animal, stuffed lion", 4, [], [], []],
    ["stuffed animal, stuffed sheep", 4, [], [], []],
    ["teacup", 12, [], [], []],
    ["teapot", 12, [], [], []],
    ["spoon", 12, [], [], []],
    ["smartphone", 12, [], [], []],
    ["skull", 12, [], [], []],
    ["shield", 12, [], [], []],
    ["sheath", 12, [], [], []],
    ["school desk", 12, [], [], []],
    ["weapon, scythe, holding scythe", 12, [], [], []],
    ["sack, holding sack", 12, [], [], []],
    ["flower, rose", 12, [], [], []],
    ["rope", 12, [], [], []],
    ["rock", 12, [], [], []],
    ["rifle", 12, [], [], []],
    ["pumpkin", 12, [], [], []],
    ["potted plant", 12, [], [], []],
    ["food, popsicle, popsicle in mouth", 6, [], [], []],
    ["food, popsicle, holding popsicle", 6, [], [], []],
    ["food, popsicle, popsicle in mouth, watermelon bar", 6, [], [], []],
    ["food, popsicle, holding popsicle, watermelon bar", 6, [], [], []],
    ["weapon, polearm, holding weapon", 12, [], [], []],
    ["pocky", 12, [], [], []],
    ["plate", 12, [], [], []],
    ["plant", 12, [], [], []],
    ["pen, holding pen", 12, [], [], []],
    ["phone, smartphone, holding phone", 12, [], [], []],
    ["fruit, peach", 12, [], [], []],
    ["open book", 12, [], [], []],
    ["ofuda", 12, [], [], []],
    ["cup, mug, beer mug", 12, [], [], []],
    ["cup, mug, coffee mug", 12, [], [], []],
    ["mecha", 12, [], [], []],
    ["machinery", 12, [], [], []],
    ["candy, lollipop", 12, [], [], []],
    ["leaf", 12, [], [], []],
    ["lantern", 4, [], [], []],
    ["lantern, wooden lantern", 4, [], [], []],
    ["lantern, paper lantern", 4, [], [], []],
    ["lamp", 12, [], [], []],
    ["knife, kitchen knife", 12, [], [], []],
    ["weapon, katana", 12, [], [], []],
    ["weapon, spear", 12, [], [], []],
    ["jack-o'-lantern", 12, [], [], []],
    ["innertube", 12, [], [], []],
    ["innertube, doughnut innertube", 12, [], [], []],
    ["id card, lanyard", 12, [], [], []],
    ["ice cream, soft serve", 12, [], [], []],
    ["flower, hibiscus", 12, [], [], []],
    ["flower, daisy", 12, [], [], []],
    ["flower, iris (flower)", 12, [], [], []],
    ["flower, lilac", 12, [], [], []],
    ["flower, chrysanthemum", 12, [], [], []],
    ["flower, carnation", 12, [], [], []],
    ["flower, camellia", 12, [], [], []],
    ["flower, crocus (flower)", 12, [], [], []],
    ["flower, lily of the valley", 12, [], [], []],
    ["flower, poppy (flower)", 12, [], [], []],
    ["flower, nemophila (flower)", 12, [], [], []],
    ["flower, snowbell (flower)", 12, [], [], []],
    ["flower, orchid", 12, [], [], []],
    ["flower, spider lily", 12, [], [], []],
    ["flower, strawberry blossoms", 12, [], [], []],
    ["flower, sunflower", 12, [], [], []],
    ["flower, violet (flower)", 12, [], [], []],
    ["flower, lily (flower)", 12, [], [], []],
    ["flower, lotus", 12, [], [], []],
    ["flower, plum blossoms", 12, [], [], []],
    ["flower, black rose", 12, [], [], []],
    ["flower, tulip", 12, [], [], []],
    ["flower, water lily flower", 12, [], [], []],
    ["flower, wisteria", 12, [], [], []],
    ["flower, cosmos (flower)", 12, [], [], []],
    ["flower, nemophila (flower)", 12, [], [], []],
    ["headset", 12, [], [], []],
    ["headphones", 12, [], [], []],
    ["weapon, gun, handgun", 12, [], [], []],
    ["bag, handbag", 12, [], [], []],
    ["bag, shoulder bag", 12, [], [], []],
    ["hand fan, folding fan", 12, [], [], []],
    ["instrument, guitar", 12, [], [], []],
    ["gift, gift bag", 12, [], [], []],
    ["gift, gift box", 12, [], [], []],
    ["ghost", 12, [], [], []],
    ["gem", 12, [], [], []],
    ["fruit", 12, [], [], []],
    ["fork, holding fork", 12, [], [], []],
    ["food", 12, [], [], []],
    ["animal, fish", 12, [], [], []],
    ["doll, holding doll", 12, [], [], []],
    ["cup, disposable cup", 12, [], [], []],
    ["weapon, dagger", 12, [], [], []],
    ["cup", 12, [], [], []],
    ["cross", 12, [], [], []],
    ["controller", 12, [], [], []],
    ["computer, monitor, keyboard (computer)", 12, [], [], []],
    ["cigarette", 12, [], [], []],
    ["chopsticks", 12, [], [], []],
    ["chocolate", 12, [], [], []],
    ["chair", 12, [], [], []],
    ["chain", 12, [], [], []],
    ["carrot", 12, [], [], []],
    ["cannon", 12, [], [], []],
    ["candy", 12, [], [], []],
    ["candle", 12, [], [], []],
    ["can", 12, [], [], []],
    ["camera", 12, [], [], []],
    ["food, cake", 12, [], [], []],
    ["bug, butterfly", 12, [], [], []],
    ["bucket", 12, [], [], []],
    ["broom", 12, [], [], []],
    ["branch", 12, [], [], []],
    ["box", 12, [], [], []],
    ["bowl", 12, [], [], []],
    ["bouquet", 12, [], [], []],
    ["bottle", 12, [], [], []],
    ["book", 12, [], [], []],
    ["blanket", 12, [], [], []],
    ["bird", 12, [], [], []],
    ["bench", 12, [], [], []],
    ["bell", 12, [], [], []],
    ["bed sheet", 12, [], [], []],
    ["beads", 12, [], [], []],
    ["beachball", 12, [], [], []],
    ["basket", 12, [], [], []],
    ["balloon", 12, [], [], []],
    ["ball", 12, [], [], []],
    ["weapon, axe", 12, [], [], []],
    ["weapon, gun, assault rifle", 12, [], [], []],
    ["fruit, apple", 12, [], [], []],
    ["sake, sake bottle", 12, [], [], []],
    ["paintbrush", 12, [], [], []],
    ["tea", 12, [], [], []],
    ["black cat", 12, [], [], []],
    ["maple leaf", 12, [], [], []],
    ["mushroom", 12, [], [], []],
    ["television", 12, [], [], []],
    ["handcuffs", 12, [], [], []],
    ["food, doughnut", 12, [], [], []],
    ["water bottle", 12, [], [], []],
    ["food, bread, bagel", 12, [], [], []],
    ["food, bread, baguette", 12, [], [], []],
    ["flower, pink rose", 12, [], [], []],
    ["handheld game console", 12, [], [], []],
    ["weapon, huge weapon", 12, [], [], []],
    ["stool", 12, [], [], []],
    ["smoking pipe", 12, [], [], []],
    ["food, cookie", 12, [], [], []],
    ["chalkboard", 12, [], [], []],
    ["coin", 12, [], [], []],
    ["syringe", 12, [], [], []],
    ["christmas tree", 12, [], [], []],
    ["rice", 12, [], [], []],
    ["bathtub", 12, [], [], []],
    ["beer, beer bottle", 12, [], [], []],
    ["lamppost", 12, [], [], []],
    ["egg", 12, [], [], []],
    ["fruit, cherry", 12, [], [], []],
    ["cushion", 12, [], [], []],
    ["shell", 12, [], [], []],
    ["sake, sakazuki", 12, [], [], []],
    ["food, burger", 12, [], [], []],
    ["clipboard", 12, [], [], []],
    ["skeleton", 12, [], [], []],
    ["instrument, electric guitar", 12, [], [], []],
    ["box, cardboard box", 12, [], [], []],
    ["pillar", 12, [], [], []],
    ["book stack", 12, [], [], []],
    ["wine", 12, [], [], []],
    ["mouse (animal)", 12, [], [], []],
    ["computer, laptop", 12, [], [], []],
    ["table, kotatsu", 12, [], [], []],
    ["bag, shopping bag", 12, [], [], []],
    ["whip", 12, [], [], []],
    ["riding crop", 12, [], [], []],
    ["dango", 12, [], [], []],
    ["fruit, grapes", 12, [], [], []],
    ["water gun", 12, [], [], []],
    ["vase", 12, [], [], []],
    ["whistle", 12, [], [], []],
    ["microphone stand, microphone", 12, [], [], []],
    ["notebook", 12, [], [], []],
    ["flower, hydrangea", 12, [], [], []],
    ["suitcase", 12, [], [], []],
    ["bone", 12, [], [], []],
    ["ice cream, ice cream cone", 12, [], [], []],
    ["heart-shaped chocolate", 12, [], [], []],
    ["weapon, lance", 12, [], [], []],
    ["cane", 12, [], [], []],
    ["ladle", 12, [], [], []],
    ["orange (fruit)", 12, [], [], []],
    ["spring onion", 12, [], [], []],
    ["statue", 12, [], [], []],
    ["locker", 12, [], [], []],
    ["gears", 12, [], [], []],
    ["crab", 12, [], [], []],
    ["wine bottle", 12, [], [], []],
    ["gourd", 12, [], [], []],
    ["starfish", 12, [], [], []],
    ["gun, weapon, machine gun", 12, [], [], []],
    ["weapon, trident", 12, [], [], []],
    ["lock", 12, [], [], []],
    ["crow", 12, [], [], []],
    ["boat", 12, [], [], []],
    ["road sign", 12, [], [], []],
    ["stick", 12, [], [], []],
    ["armchair", 12, [], [], []],
    ["frilled pillow", 12, [], [], []],
    ["tissue box", 12, [], [], []],
    ["jar", 12, [], [], []],
    ["mandarin orange", 12, [], [], []],
    ["office chair", 12, [], [], []],
    ["pot", 12, [], [], []],
    ["pole", 12, [], [], []],
    ["food print", 12, [], [], []],
    ["test tube", 12, [], [], []],
    ["spider web", 12, [], [], []],
    ["weapon, rapier", 12, [], [], []],
    ["envelope", 12, [], [], []],
    ["fruit, banana", 12, [], [], []],
    ["fruit, lemon", 12, [], [], []],
    ["weapon, gun, shotgun", 12, [], [], []],
    ["weapon, energy sword", 12, [], [], []],
    ["staff, holding staff", 12, [], [], []],
    ["mage staff", 12, [], [], []],
    ["food, pizza", 12, [], [], []],
    ["digital media player, earphones", 12, [], [], []],
    ["fruit, tomato", 12, [], [], []],
    ["rubber duck", 12, [], [], []],
    ["food, candy apple", 12, [], [], []],
    ["food, baozi", 12, [], [], []],
    ["lily pad", 12, [], [], []],
    ["pancake", 12, [], [], []],
    ["soda can", 12, [], [], []],
    ["vegetable", 12, [], [], []],
    ["trash can", 12, [], [], []],
    ["frying pan", 12, [], [], []],
    ["clover, four-leaf clover", 12, [], [], []],
    ["electric fan", 12, [], [], []],
    ["puppet", 12, [], [], []],
    ["food, noodles, ramen", 12, [], [], []],
    ["food, bento", 12, [], [], []],
    ["food, candy, candy cane", 12, [], [], []],
    ["shell, seashell", 12, [], [], []],
    ["plastic bag", 12, [], [], []],
    ["instrument, bass guitar", 12, [], [], []],
    ["flower pot", 12, [], [], []],
    ["food, pudding", 12, [], [], []],
    ["flask, erlenmeyer flask", 12, [], [], []],
    ["flask, round-bottom flask", 12, [], [], []],
    ["ball, soccer ball", 12, [], [], []],
    ["bag, duffel bag", 12, [], [], []],
    ["cigar", 12, [], [], []],
    ["towel, beach towel", 12, [], [], []],
    ["food, shaved ice", 12, [], [], []],
    ["mallet, holding mallet", 12, [], [], []],
    ["glowstick", 12, [], [], []],
    ["disposable cup, disposable coffee cup", 12, [], [], []],
    ["drumsticks", 12, [], [], []],
    ["jellyfish", 12, [], [], []],
    ["ball, volleyball", 12, [], [], []],
    ["food, sweets", 12, [], [], []],
    ["candy, lollipop, swirl lollipop", 12, [], [], []],
    ["food, pastry", 12, [], [], []],
    ["food, omelet", 12, [], [], []],
    ["food, curry", 12, [], [], []],
    ["bottle, milk bottle", 12, [], [], []],
    ["food, dessert", 12, [], [], []],
    ["bag, satchel", 12, [], [], []],
    ["holding torch, torch", 12, [], [], []],
    ["umbrella, transparent umbrella", 12, [], [], []],
    ["holding surfboard, surfboard", 12, [], [], []],
    ["beads, prayer beads", 12, [], [], []],
    ["food, potato chips", 12, [], [], []],
    ["racket, tennis racket, holding racket", 12, [], [], []],
    ["turtle", 12, [], [], []],
    ["briefcase", 12, [], [], []],
    ["ball, baseball (object)", 12, [], [], []],
    ["bucket, wooden bucket", 12, [], [], []],
    ["food, crepe", 12, [], [], []],
    ["barrel", 12, [], [], []],
    ["ramune", 12, [], [], []],
    ["cat teaser", 12, [], [], []],
    ["baseball mitt", 12, [], [], []],
    ["lamp, desk lamp", 12, [], [], []],
    ["parfait", 12, [], [], []],
    ["food, macaron", 12, [], [], []],
    ["calligraphy brush", 12, [], [], []],
    ["paddle", 12, [], [], []],
    ["drink can", 12, [], [], []],
    ["shower head", 12, [], [], []],
    ["tokkuri", 12, [], [], []],
    ["yunomi", 12, [], [], []],
    ["light bulb", 12, [], [], []],
    ["omurice", 12, [], [], []],
    ["mimikaki", 12, [], [], []],
    ["used tissue", 12, [], [], []],
    ["ginkgo leaf", 12, [], [], []],
    ["love letter", 12, [], [], []],
    ["tanabata", 12, [], [], []],
    ["weapon, halberd", 12, [], [], []],
    ["weapon, naginata", 12, [], [], []],
    ["cucumber", 12, [], [], []],
    ["button eyes", 12, [], [], []],
    ["club (weapon), kanabou", 12, [], [], []],
    ["makizushi, sushi, food", 12, [], [], []],
    ["teruterubouzu", 12, [], [], []],
    ["radish", 12, [], [], []],
    ["roasted sweet potato", 12, [], [], []],
    ["ikayaki", 12, [], [], []],
]
bodyPosesAndActionsL = [
    ["waving", 12, [], [], []],
    ["sitting, wariza", 12, [], ["body"], []],
    ["walking", 12, [], ["body"], []],
    ["wading", 12, [], ["body"], []],
    ["w", 12, [], [], []],
    ["top-down bottom-up", 12, [], ["body"], []],
    ["thought bubble", 12, [], [], []],
    ["talking", 12, [], [], []],
    ["stretching", 12, [], [], []],
    ["straddling", 12, [], ["body"], []],
    ["standing, standing on one leg", 12, [], ["body"], []],
    ["standing", 12, [], ["body"], []],
    ["spread legs", 12, [], ["body"], []],
    ["outstretched arms, spread arms", 12, [], [], []],
    ["skirt hold", 12, [], [], []],
    ["sitting", 12, [], ["body"], []],
    ["sitting, crossed legs", 12, [], ["body"], []],
    ["sitting, seiza", 12, [], ["body"], []],
    ["sitting, yokozuwari", 12, [], ["body"], []],
    ["clothes lift, shirt lift", 12, [], [], []],
    ["selfie", 12, [], [], []],
    ["salute", 12, [], [], []],
    ["riding", 12, [], ["body"], []],
    ["restrained", 12, [], [], []],
    ["reading, book, holding book, open book", 12, [], [], []],
    ["reaching, reaching towards viewer", 12, [], [], []],
    ["collar tug", 12, [], [], []],
    ["pose", 12, [], [], []],
    ["peace sign", 12, [], [], []],
    ["paw pose", 12, [], [], []],
    ["rabbit pose", 12, [], [], []],
    ["horns pose", 12, [], [], []],
    ["claw pose", 12, [], [], []],
    ["bras d'honneur", 12, [], [], []],
    ["contrapposto", 12, [], [], []],
    ["ghost pose", 12, [], [], []],
    ["ojou-sama pose", 12, [], [], []],
    ["victory pose", 12, [], [], []],
    ["villain pose", 12, [], [], []],
    ["peace sign, gyaru v", 12, [], [], []],
    ["peace sign, v over eye", 12, [], [], []],
    ["peace sign, v over mouth", 12, [], [], []],
    ["peace sign, double peace", 12, [], [], []],
    ["peace sign, inward v", 12, [], [], []],
    ["own hands clasped, own hands together", 12, [], [], []],
    ["outstretched hand", 12, [], [], []],
    ["outstretched arms", 12, [], [], []],
    ["open hand", 12, [], [], []],
    ["lying, on back", 12, [], ["body"], []],
    ["sitting, on bed", 12, [], ["body"], []],
    ["sitting, on chair", 12, [], ["body"], []],
    ["sitting, on couch", 12, [], ["body"], []],
    ["sitting, on floor", 12, [], ["body"], []],
    ["on one knee, kneeling", 12, [], ["body"], []],
    ["lying, on side", 12, [], ["body"], []],
    ["lying, on stomach", 12, [], ["body"], []],
    ["reclining", 12, [], ["body"], []],
    ["looking up", 12, [], [], []],
    ["looking to the side", 12, [], [], []],
    ["looking down", 12, [], [], []],
    ["looking back", 12, [], [], []],
    ["looking away", 12, [], [], []],
    ["looking at viewer", 12, [], [], []],
    ["looking ahead", 12, [], [], []],
    ["looking afar", 12, [], [], []],
    ["looking at another", 12, [], [], []],
    ["licking, licking object", 12, [], [], []],
    ["licking, licking finger", 12, [], [], []],
    ["sitting, legs up", 12, [], ["body"], []],
    ["sitting, knees to chest", 12, [], ["body"], []],
    ["legs together", 12, [], ["body"], []],
    ["legs apart", 12, [], ["body"], []],
    ["leg up, leg lift", 12, [], ["body"], []],
    ["leg up, stepping", 12, [], ["body"], []],
    ["leaning forward", 12, [], [], []],
    ["leaning back", 12, [], [], []],
    ["knees together feet apart", 12, [], ["body"], []],
    ["kneeling", 12, [], ["body"], []],
    ["jumping", 12, [], ["body"], []],
    ["sitting, indian style", 12, [], ["body"], []],
    ["index finger raised", 12, [], [], []],
    ["sitting, knees to chest, hugging own legs", 12, [], [], []],
    ["hugging object", 12, [], [], []],
    ["heart hands, heart", 12, [], [], []],
    ["headpat", 12, [], [], []],
    ["hands up", 12, [], [], []],
    ["hands on own hips", 12, [], [], []],
    ["hands on own face", 12, [], [], []],
    ["hands on own chest", 12, [], [], []],
    ["hands in pockets", 12, [], [], []],
    ["hand up", 12, [], [], []],
    ["hand to own mouth", 12, [], [], []],
    ["hand on own hip", 12, [], [], []],
    ["hand on own head", 12, [], [], []],
    ["hand on own chin", 12, [], [], []],
    ["hand on own chest", 12, [], [], []],
    ["hand on own cheek", 12, [], [], []],
    ["hand in pocket", 12, [], ["body"], []],
    ["hand between legs", 12, [], ["body"], []],
    ["finger to mouth", 12, [], [], []],
    ["fighting stance", 12, [], [], []],
    ["facing viewer", 12, [], [], []],
    ["facing away", 12, [], [], []],
    ["eating, food", 12, [], [], []],
    ["drinking", 12, [], [], []],
    ["dancing", 12, [], [], []],
    ["crossed legs", 12, [], ["body"], []],
    ["crossed arms", 12, [], [], []],
    ["covering mouth", 12, [], [], []],
    ["covering breasts", 12, [], ["breasts"], []],
    ["clenched hands", 12, [], [], []],
    ["clenched hand", 12, [], [], []],
    ["carrying object", 12, [], [], []],
    ["breasts squeezed together", 12, [], ["breasts"], []],
    ["bent over, leaning forward", 12, [], [], []],
    ["arms up", 12, [], [], []],
    ["arms behind head", 12, [], [], []],
    ["arms behind back", 12, [], [], []],
    ["arms at sides", 12, [], [], []],
    ["arm up", 12, [], [], []],
    ["arm support", 12, [], [], []],
    ["grabbing own arm", 12, [], [], []],
    ["one arm behind head", 12, [], [], []],
    ["one arm behind back", 12, [], [], []],
    ["one arm at side", 12, [], [], []],
    ["arched back", 12, [], [], []],
    ["all fours", 12, [], [], []],
    ["against wall", 12, [], [], []],
    ["adjusting hair", 12, [], [], []],
    ["adjusting eyewear", 12, [], [], []],
    ["arm under breasts", 12, [], ["breasts"], []],
    ["tucking hair", 12, [], [], []],
    ["lying, on ground", 12, [], [], []],
    ["pigeon-toed", 12, [], ["body"], []],
    ["thumbs up", 12, [], [], []],
    ["thumbs down", 12, [], [], []],
    ["kicking", 12, [], ["body"], []],
    ["invisible chair", 12, [], [], []],
    ["hand on own thigh", 12, [], [], []],
    ["tiptoes", 12, [], ["feet"], []],
    ["singing", 12, [], [], []],
    ["falling, tripping", 12, [], [], []],
    ["hand on own knee", 12, [], [], []],
    ["gift, holding, holding gift, incoming gift", 12, [], [], []],
    ["music, instrument, playing instrument", 12, [], [], []],
    ["holding, stuffed toy, holding stuffed toy", 12, [], [], []],
    ["pointing at viewer", 12, [], [], []],
    ["broom, broom riding", 12, [], [], []],
    ["leaning to the side", 12, [], [], []],
    ["tying hair", 12, [], [], []],
    ["shouting", 12, [], [], []],
    ["hugging object, pillow, pillow hug", 12, [], [], []],
    ["punching", 12, [], [], []],
    ["yawning", 12, [], [], []],
    ["\\m/", 12, [], [], []],
    ["hand on own stomach", 12, [], ["body"], []],
    ["hands on own cheeks", 12, [], [], []],
    ["hand on own ass", 12, [], ["body"], ["front"]],
    ["weapon, gun, firing", 12, [], [], []],
    ["strap pull", 12, [], ["strapped"], []],
    ["shushing", 12, [], [], []],
    ["breast suppress", 12, [], ["breasts"], []],
    ["peeking, peeking out, door", 12, [], [], []],
    ["squatting", 12, [], [], []],
    ["squatting, slav squatting", 12, [], [], []],
    ["open hands", 12, [], [], []],
    ["waking up", 12, [], [], []],
    ["hands on own knees", 12, [], [], []],
    ["breast lift", 12, [], ["breasts"], []],
    ["hands in hair", 12, [], [], []],
    ["pointing, pointing at self", 12, [], [], []],
    ["pointing, pointing at self with one hand", 12, [], [], []],
    ["pointing, pointing up", 12, [], [], []],
    ["pointing, pointing to the side", 12, [], [], []],
    ["pointing, pointing down", 12, [], [], []],
    ["index finger raised", 12, [], [], []],
    ["against glass", 12, [], [], []],
    ["holding own arm", 12, [], [], []],
    ["elbow rest, leaning", 12, [], [], []],
    ["steepled fingers", 12, [], [], []],
    ["hand on own arm", 12, [], [], []],
    ["staring", 12, [], [], []],
    ["index fingers together", 12, [], [], []],
    ["arms under breasts", 12, [], ["breasts"], []],
    ["clothes grab", 12, [], [], []],
    ["running", 12, [], [], []],
    ["finger to cheek", 12, [], [], []],
    ["covering own eyes", 12, [], [], []],
    ["come hither, beckoning", 12, [], [], []],
    ["rubbing eyes", 12, [], [], []],
    ["praying", 12, [], [], []],
    ["zombie pose", 12, [], [], []],
    ["holding sign with an X on it", 12, [], [], []],
    ["holding sign a symbol on it", 12, [], [], []],
    ["phone, holding phone, looking at phone", 12, [], [], []],
    ["ok sign", 12, [], [], []],
    ["playing with own hair", 12, [], [], []],
    ["sitting, hands on lap", 12, [], [], []],
    ["finger to own chin", 12, [], [], []],
    ["hands on own thighs", 12, [], ["body"], []],
    ["wiping tears", 12, [], [], []],
    ["sleeping", 12, [], [], []],
    ["cupping hands", 12, [], [], []],
    ["double finger gun", 12, [], [], []],
    ["fidgeting", 12, [], [], []],
    ["finger counting", 12, [], [], []],
    ["fist in hand", 12, [], [], []],
    ["heart arms", 12, [], [], []],
    ["x fingers", 12, [], [], []],
    ["akanbe, eyelid pull, tongue out", 12, [], [], []],
    ["middle finger", 12, [], [], []],
    ["finger gun", 12, [], [], []],
    ["fox shadow puppet", 12, [], [], []],
    ["middle w", 12, [], [], []],
    ["money gesture", 12, [], [], []],
    ["raised fist", 12, [], [], []],
    ["stroking own chin", 12, [], [], []],
    ["shrugging", 12, [], [], []],
    ["turning head", 12, [], [], []],
    ["the pose", 12, [], [], []],
    ["standing split", 12, [], [], []],
    ["smoking", 12, [], [], []],
    ["plantar flexion", 12, [], ["feet"], []],
    ["lifting own clothes", 12, [], [], []],
    ["head rest", 12, [], [], []],
    ["skirt tug", 12, [], ["skirt"], []],
    ["spread fingers", 12, [], [], []],
    ["shading eyes", 12, [], [], []],
    ["hands on own head", 12, [], [], []],
    ["spilling", 12, [], [], []],
    ["incoming attack", 12, [], [], []],
    ["kabedon", 12, [], [], []],
    ["knees apart feet together", 12, [], ["legs"], []],
    ["curtain grab", 12, [], [], []],
    ["pole dancing", 12, [], [], []],
    ["cheek poking", 12, [], [], []],
    ["teasing", 12, [], [], []],
    ["stuck", 12, [], [], []],
    ["curled fingers", 12, [], [], []],
    ["against tree", 12, [], [], []],
    ["sparkler", 6, [], [], []],
    ["curtsey", 12, [], ["female"], []],
    ["holding own tail", 6, [], [], []],
    ["head down", 12, [], [], []],
    ["wiping face", 12, [], [], []],
    ["wiping sweat", 12, [], [], []],
    ["fallen down", 12, [], [], []],
    ["party popper, holding party popper", 12, [], [], []],
    ["chewing", 12, [], [], []],
    ["sigh", 12, [], [], []],
    ["ass support", 12, [], [], []],
    ["raised fist", 12, [], [], []],
    ["mouth pull", 12, [], [], []],
    ["toast in mouth", 12, [], [], []],
    ["incoming hug", 12, [], [], []],
    ["self hug", 12, [], [], []],
    ["clapping", 12, [], [], []],
    ["fetal position", 12, [], [], []],
    ["dynamic pose", 12, [], [], []],
    ["elbow on table", 12, [], [], []],
    ["cheek rest", 12, [], [], []],
    ["holding baby", 2, [], [], []],
]
effectsAndPatternsL = [
    ["sparkle", 12, [], [], []],
    ["snowflakes", 12, [], [], []],
    ["petals", 12, [], [], []],
    ["paw print", 12, [], [], []],
    ["musical note", 12, [], [], []],
    ["motion lines", 12, [], [], []],
    ["magic", 12, [], [], []],
    ["light rays", 12, [], [], []],
    ["light particles", 12, [], [], []],
    ["lens flare", 12, [], [], []],
    ["ice", 12, [], [], []],
    ["glowing", 12, [], [], []],
    ["glint", 12, [], [], []],
    ["fire", 12, [], [], []],
    ["fantasy", 12, [], [], []],
    ["falling petals", 12, [], [], []],
    ["emphasis lines", 12, [], [], []],
    ["electricity", 12, [], [], []],
    ["eighth note", 12, [], [], []],
    ["depth of field", 12, [], [], []],
    ["crystal", 12, [], [], []],
    ["crescent", 12, [], [], []],
    ["confetti", 12, [], [], []],
    ["chromatic aberration", 12, [], [], []],
    ["christmas", 12, [], [], []],
    ["chibi", 12, [], [], []],
    ["cherry blossoms", 12, [], [], []],
    ["bubble", 12, [], [], []],
    ["blurry background", 12, [], [], []],
    ["blurry foreground", 12, [], [], []],
    ["autumn leaves", 12, [], [], []],
    ["air bubble", 12, [], [], []],
    ["aura", 12, [], [], []],
    ["halftone", 12, [], [], []],
    ["explosion", 12, [], [], []],
    ["summer", 12, [], [], []],
    ["sunbeam", 12, [], [], []],
    ["magic circle", 12, [], [], []],
    ["fireworks", 12, [], [], []],
    ["winter", 12, [], [], []],
    ["partially colored", 12, [], [], []],
    ["ripples", 12, [], [], []],
    ["rainbow", 12, [], [], []],
    ["sepia", 12, [], [], []],
    ["blood splatter", 12, [], [], []],
    ["autumn", 12, [], [], []],
    ["spring (season)", 12, [], [], []],
    ["rose petals", 12, [], [], []],
    ["danmaku", 12, [], [], []],
    ["shiny", 12, [], [], []],
    ["lightning", 12, [], [], []],
    ["blue fire", 12, [], [], []],
    ["falling leaves", 12, [], [], []],
    ["muted color", 12, [], [], []],
    ["soap bubbles", 12, [], [], []],
    ["horror (theme)", 12, [], [], []],
    ["colorful", 12, [], [], []],
    ["viewfinder", 12, [], [], []],
    ["constellation", 12, [], [], []],
    ["ancient egyptian", 12, [], [], []],
    ["surreal", 12, [], [], []],
    ["darkness", 12, [], [], []],
    ["dark", 12, [], [], []],
    ["paint splatter", 12, [], [], []],
    ["lolita fashion", 12, [], [], []],
    ["bloom", 12, [], [], []],
    ["abstract", 12, [], [], []],
    ["embers", 12, [], [], []],
    ["corruption, dark persona", 12, [], [], []],
    ["stage lights", 12, [], [], []],
    ["fashion", 12, [], [], []],
    ["trick or treat", 12, [], [], []],
    ["fluffy", 12, [], [], []],
    ["symmetry", 12, [], [], []],
    ["reflective water, reflection", 12, [], [], []],
    ["glitch", 12, [], [], []],
    ["border", 12, [], [], []],
    ["framed", 12, [], [], []],
    ["character image", 12, [], [], []],
    ["3d", 12, [], [], []],
    ["lineart", 12, [], [], []],
    ["no lineart", 12, [], [], []],
    ["outline", 12, [], [], []],
    ["pixel art", 12, [], [], []],
    ["oekaki", 12, [], [], []],
    ["anime screencap", 12, [], [], []],
    ["anime screenshot", 12, [], [], []],
    ["game screenshot", 12, [], [], []],
    ["game cg", 12, [], [], []],
    ["fake screenshot", 12, [], [], []],
    ["drop shadow", 12, [], [], []],
    ["gradient", 12, [], [], []],
    ["film grain", 12, [], [], []],
    ["caustics", 12, [], [], []],
    ["bokeh", 12, [], [], []],
    ["backlighting", 12, [], [], []],
    ["dithering", 12, [], [], []],
    ["monochrome", 12, [], [], []],
    ["multiple monochrome", 12, [], [], []],
    ["silhouette", 12, [], [], []],
    ["vignetting", 12, [], [], []],
    ["art deco", 12, [], [], []],
    ["art nouveau", 12, [], [], []],
    ["science fiction", 12, [], [], []],
    ["steampunk", 12, [], [], []],
    ["cyberpunk", 12, [], [], []],
    ["western", 12, [], [], []],
    ["sunlight", 12, [], [], []],
    ["wind", 12, [], [], []],
    ["squiggle", 12, [], [], []],
    ["limited palette", 12, [], [], []],
    ["overgrown", 12, [], [], []],
    ["halloween", 12, [], [], []],
    ["grass", 12, [], [], []],
    ["blood", 12, [], [], []],
    ["tokusatsu", 12, [], [], []],
    ["thorns", 12, [], [], []],
    ["stained glass", 12, [], [], []],
    ["silk", 12, [], [], []],
    ["sidelighting", 12, [], [], []],
    ["reference sheet", 12, [], [], []],
    ["outside border", 12, [], [], []],
    ["hatching (texture)", 12, [], [], []],
    ["goth fashion", 12, [], [], []],
    ["foreshortening", 12, [], [], []],
    ["fisheye", 12, [], [], []],
    ["dappled sunlight", 12, [], [], []],
    ["color guide", 12, [], [], []],
    ["wedding", 12, [], [], []],
    ["melting", 12, [], [], []],
    ["tree shade", 12, [], [], []],
    ["liquid", 12, [], [], []],
    ["unhappy adorable", 12, [], [], []],
    ["disgustingly adorable", 12, [], [], []],
    ["sideways", 12, [], [], []],
    ["pink blood", 12, [], [], []],
    ["window shadow", 12, [], [], []],
    ["i am the king", 12, [], [], []],
    ["pyrokinesis", 12, [], [], []],
    ["pastel colors", 12, [], [], []],
    ["exquisite clothes", 12, [], [], []],
    ["electrokinesis", 12, [], [], []],
    ["neon lights", 12, [], [], []],
    ["fine fabric emphasis", 12, [], [], []],
    ["pale color", 12, [], [], []],
    ["spring (season)", 12, [], [], []],
    ["round image", 12, [], [], []],
    ["partially underwater shot", 12, [], [], []],
    ["key visual", 12, [], [], []],
    ["fireflies", 12, [], [], []],
    ["purple fire", 12, [], [], []],
    ["hydrokinesis", 12, [], [], []],
    ["psychic", 12, [], [], []],
    ["linear hatching", 12, [], [], []],
    ["faux figurine", 12, [], [], []],
    ["dust cloud", 12, [], [], []],
    ["blending", 12, [], [], []],
    ["petals on liquid", 12, [], [], []],
    ["huge moon", 12, [], [], []],
    ["telekinesis", 12, [], [], []],
    ["dark aura", 12, [], [], []],
    ["cursor", 2, [], [], []],
    ["soft and comfy", 12, [], [], []],
    ["post-apocalypse", 12, [], [], []],
    ["galaxy", 12, [], [], []],
    ["plant roots", 12, [], [], []],
    ["dissolving", 12, [], [], []],
    ["nebula", 12, [], [], []],
    ["drawn ears, drawn tail, drawn whiskers", 12, [], [], []],
    ["drawn horns, drawn wings]", 12, [], [], []],
    ["offering hand", 12, [], [], []],
    ["green fire", 12, [], [], []],
    ["digital dissolve", 12, [], [], []],
    ["aliasing", 12, [], [], []],
    ["neon palette", 12, [], [], []],
    ["spiral", 12, [], [], []],
    ["gigantamax", 12, [], [], []],
    ["gleam", 12, [], [], []],
    ["hemokinesis", 12, [], [], []],
]
eyeColorsL = [
    ["aqua eyes", 12, ["eyes"], [], []],
    ["black eyes", 12, ["eyes"], [], []],
    ["blue eyes", 12, ["eyes"], [], []],
    ["brown eyes", 12, ["eyes"], [], []],
    ["green eyes", 12, ["eyes"], [], []],
    ["grey eyes", 12, ["eyes"], [], []],
    ["orange eyes", 12, ["eyes"], [], []],
    ["purple eyes", 12, ["eyes"], [], []],
    ["pink eyes", 12, ["eyes"], [], []],
    ["red eyes", 12, ["eyes"], [], []],
    ["white eyes", 12, ["eyes"], [], []],
    ["yellow eyes", 12, ["eyes"], [], []],
    ["amber eyes", 12, ["eyes"], [], []],
]
hairColorsL = [
    ["aqua hair", 12, [], [], []],
    ["black hair", 12, [], [], []],
    ["blonde hair", 12, [], [], []],
    ["platinum blonde hair", 12, [], [], []],
    ["blue hair", 12, [], [], []],
    ["light blue hair", 12, [], [], []],
    ["dark blue hair", 12, [], [], []],
    ["brown hair", 12, [], [], []],
    ["light brown hair", 12, [], [], []],
    ["green hair", 12, [], [], []],
    ["dark green hair", 12, [], [], []],
    ["light green hair", 12, [], [], []],
    ["grey hair", 12, [], [], []],
    ["orange hair", 12, [], [], []],
    ["pink hair", 12, [], [], []],
    ["purple hair", 12, [], [], []],
    ["light purple hair", 12, [], [], []],
    ["red hair", 12, [], [], []],
    ["white hair", 12, [], [], []],
]
hairStylesAndPatternsL = [
    ["multicolored hair", 12, [], [], []],
    ["colored inner hair", 12, [], [], []],
    ["gradient hair", 12, [], [], []],
    ["rainbow hair", 12, [], [], []],
    ["split-color hair", 4, [], [], []],
    ["streaked hair", 12, [], [], []],
    ["two-tone hair", 12, [], [], []],
    ["colored tips", 12, [], [], []],
    ["glowing hair", 4, [], [], []],
]
colorsL = [
    ["aqua", 12, [], [], []],
    ["black", 12, [], [], []],
    ["blue", 12, [], [], []],
    ["brown", 12, [], [], []],
    ["grey", 12, [], [], []],
    ["orange", 12, [], [], []],
    ["pink", 12, [], [], []],
    ["purple", 12, [], [], []],
    ["red", 12, [], [], []],
    ["white", 12, [], [], []],
    ["yellow", 12, [], [], []],
    ["beige", 12, [], [], []],
    ["two-toned", 12, [], [], []],
    ["multicolored", 12, [], [], []],
    ["silver", 4, [], [], []],
    ["gold", 4, [], [], []],
    ["rainbow", 2, [], [], []],
]


@dataclasses.dataclass
class Conditions:
    tags: List[str]

    def add(self, v: str):
        if v not in self.tags:
            self.tags.append(v)

    def __contains__(self, item):
        return item in self.tags

    def copy(self):
        tags = list(set(self.tags))
        return Conditions(tags.copy())


def random_range(a, b):
    if a == b:
        return a
    if a > b:
        a, b = b, a
    return random.randint(a, b)


def select_weighted_option(
        options: Union[WeightedOptions, WeightedSimpleOptions],
        conditions: Conditions,
) -> Union[str,int]:
    """
    选择一个加权选项
    :param options: 权重
    :param conditions: 条件
    :return: 选项
    """

    # 如果 conditions 的元素存在于最后两个数组中，则不会被选中
    def get_fourth_array(item: WeightedOption) -> List[str]:
        if len(item) < 4:
            return []
        return item[3]

    def get_fifth_array(item: WeightedOption) -> List[str]:
        if len(item) < 5:
            return []
        return item[4]

    filtered_options = []
    for option in options:
        fourth = get_fourth_array(option)
        fifth = get_fifth_array(option)
        # 必须排除的条件
        if len(fifth) != 0:
            for exclusion in fifth:
                if exclusion in conditions:
                    continue
        # 必须包含的条件
        if len(fourth) != 0:
            for requirement in fourth:
                if requirement not in conditions:
                    continue
        filtered_options.append(option)

    # 增加随机性
    random.shuffle(filtered_options)

    # 计算总权重
    def get_weight(item: Union[str,int]) -> int:
        return len(item) if isinstance(item, str) else item

    total_weight = sum(get_weight(option[1]) for option in filtered_options)

    # 随机选择
    random_value = random_range(0, total_weight)
    cumulative_weight = 0
    # 逐个判断
    for option in filtered_options:
        cumulative_weight += get_weight(option[1])
        if random_value <= cumulative_weight:
            required = []
            if len(option) >= 4:
                required = option[3]
            for req in required:
                conditions.add(req)
            return option[0]
    return ""


def generate_appearance(tags: Conditions, gender: str, additional_tags: str, character_limit: int):
    """
    为人物生成外貌描述
    :param tags: 已有标签
    :param gender: 性别
    :param additional_tags: 额外标签
    :param character_limit: 人物数量
    :return: 外貌描述
    """
    selected_attributes = []
    uni_tags = tags.copy()

    if random.random() < 0.1:
        selected_attributes.append(select_weighted_option(animalCharacteristicsL, uni_tags))
    if random.random() < 0.4:
        selected_attributes.append(select_weighted_option(skinTypesL, uni_tags))
    if random.random() < 0.05:
        selected_attributes.append(select_weighted_option(eyeCharacteristicsL, uni_tags))
    if "no eyes" not in uni_tags:
        if random.random() < 0.2:
            selected_attributes.append(select_weighted_option(eyeExpressionsL, uni_tags))
        if random.random() < 0.8 and "nocoloreyes" not in uni_tags:
            selected_attributes.append(select_weighted_option(eyeColorsL, uni_tags))
    # Hair Length
    if random.random() < 0.8:
        selected_attributes.append(select_weighted_option(hairLengthsL, uni_tags))

    # Hair Style
    if random.random() < 0.7:
        selected_attributes.append(select_weighted_option(braidedHairstylesL, uni_tags))

    # Hair Color
    if random.random() < 0.7:
        selected_attributes.append(select_weighted_option(hairColorsL, uni_tags))

    # Hair Style and Pattern
    if random.random() < 0.1:
        selected_attributes.append(select_weighted_option(hairStylesAndPatternsL, uni_tags))
        selected_attributes.append(select_weighted_option(hairColorsL, uni_tags))

    # Hair Accessories
    if random.random() < 0.3:
        selected_attributes.append(select_weighted_option(uniqueHairstylesL, uni_tags))

    # Hair Accessories
    if random.random() < 0.4:
        selected_attributes.append(select_weighted_option(bangsStylesL, uni_tags))
    if gender.startswith("f") and random.random() < 0.8:
        selected_attributes.append(select_weighted_option(breastSizesL, uni_tags))

    if character_limit == 1:
        body_feature_num = select_weighted_option(
            [
                [0, 10],
                [1, 30],
                [2, 15],
                [3, 5],
            ],
            uni_tags
        )
    elif character_limit == 2:
        body_feature_num = select_weighted_option(
            [
                [0, 20],
                [1, 40],
                [2, 10],
            ],
            uni_tags
        )
    else:
        body_feature_num = select_weighted_option(
            [
                [0, 30],
                [1, 30],
            ],
            uni_tags
        )

    for _ in range(body_feature_num):
        selected_attributes.append(select_weighted_option(bodyFeaturesL, uni_tags))

    if random.random() < 0.2:
        selected_attributes.append(select_weighted_option(hatsAndHeadwearL, uni_tags))
        if random.random() < 0.2:
            selected_attributes.append(select_weighted_option(hatDecorationsL, uni_tags))
    elif random.random() < 0.3:
        selected_attributes.append(select_weighted_option(hairAccessoriesL, uni_tags))

    outfit_type = select_weighted_option(
        [
            ["uniform", 25],
            ["swimsuit", 5],
            ["bodysuit", 5],
            ["normal clothes", 40],
        ],
        uni_tags
    )

    if outfit_type == "uniform":
        selected_attributes.append(select_weighted_option(armorsAndUniformsL, uni_tags))
    elif outfit_type == "swimsuit":
        selected_attributes.append(select_weighted_option(swimwearL, uni_tags))
    elif outfit_type == "bodysuit":
        selected_attributes.append(select_weighted_option(zipperedOutfitsL, uni_tags))
    elif outfit_type == "normal clothes":
        # 生产袜子
        if gender.startswith("f") and random.random() < 0.5:
            selected_attributes.append(select_weighted_option(socksAndStockingsL, uni_tags))
            if random.random() < 0.2:
                selected_attributes.append(select_weighted_option(legwearStylesL, uni_tags))
        # 生产套装
        if gender.startswith("f") and random.random() < 0.2:
            use_color = random.random() < 0.5
            color = select_weighted_option(colorsL, uni_tags)
            attire = select_weighted_option(dressesAndAttireL, uni_tags)
            selected_attributes.append(f"{color} {attire}" if use_color and attire else attire)
        else:
            # 生产上衣
            if random.random() < 0.85:
                use_color = random.random() < 0.5
                color = select_weighted_option(colorsL, uni_tags)
                top = select_weighted_option(topsAndShirtsL, uni_tags)
                selected_attributes.append(f"{color} {top}" if use_color and top else top)
            # 生产下衣
            if "legs" in uni_tags:
                if random.random() < 0.85:
                    use_color = random.random() < 0.5
                    color = select_weighted_option(colorsL, uni_tags)
                    bottom = select_weighted_option(pantsAndBottomsL, uni_tags)
                    selected_attributes.append(f"{color} {bottom}" if use_color and bottom else bottom)
                # 生产鞋子
                if "feet" in uni_tags and random.random() < 0.6:
                    use_color = random.random() < 0.5
                    color = select_weighted_option(colorsL, uni_tags)
                    footwear = select_weighted_option(bootsAndFootwearL, uni_tags)
                    selected_attributes.append(f"{color} {footwear}" if use_color and footwear else footwear)

    # 生产面部
    if random.random() < 0.6:
        selected_attributes.append(select_weighted_option(facialExpressionsL, uni_tags))

    # 生产动作
    if random.random() < 0.4:
        selected_attributes.append(select_weighted_option(bodyPosesAndActionsL, uni_tags))

    # 根据人物数量生产配饰
    if character_limit == 1:
        accessory_iterations = select_weighted_option(
            [
                [0, 10],
                [1, 30],
                [2, 15],
                [3, 5],
            ],
            uni_tags
        )
    elif character_limit == 2:
        accessory_iterations = select_weighted_option(
            [
                [0, 20],
                [1, 40],
                [2, 10],
            ],
            uni_tags
        )
    else:
        accessory_iterations = select_weighted_option(
            [
                [0, 30],
                [1, 30],
            ],
            uni_tags
        )

    for _ in range(accessory_iterations):
        selected_attributes.append(select_weighted_option(accessoriesAndOuterwearL, uni_tags))

    return [attribute for attribute in selected_attributes if attribute != ""]


def generate_scene_composition():
    scene_tags = []
    condition_set = Conditions(tags=[])
    character_details = []

    character_count = select_weighted_option(
        [
            [1, 70],
            [2, 20],
            [3, 7],
            [0, 5],
        ],
        condition_set
    )

    if character_count == 0:
        scene_tags.append("no humans")
        if random.random() < 0.5:
            scene_tags.append(select_weighted_option(artStylesL, condition_set))
        scene_tags.append(select_weighted_option(sceneTypesL, condition_set))

        scene_element_count = select_weighted_option(
            [
                [2, 15],
                [3, 50],
                [4, 15],
                [5, 5],
            ],
            condition_set
        )

        for _ in range(scene_element_count):
            scene_tags.append(select_weighted_option(sceneElementsL, condition_set))

        object_count = select_weighted_option(
            [
                [0, 15],
                [1, 10],
                [2, 20],
                [3, 20],
                [4, 20],
                [5, 15],
            ],
            condition_set
        )
        object_count -= character_count
        object_count = max(0, object_count)

        for _ in range(object_count):
            scene_tags.append(select_weighted_option(objectsAndStuffedAnimalsL, condition_set))

        return [", ".join(filter(None, scene_tags))]

    if random.random() < 0.5:
        scene_tags.append(select_weighted_option(artStylesL, condition_set))

    male_count = 0
    female_count = 0
    other_count = 0

    for _ in range(character_count):
        gender = select_weighted_option(
            [
                ["m", 30],
                ["f", 60],
                ["o", 0],
            ],
            condition_set
        )
        if gender == "m":
            male_count += 1
        elif gender == "f":
            female_count += 1
        elif gender == "o":
            other_count += 1

    if female_count >= 1:
        scene_tags.insert(0, f"{female_count}girl{'s' if female_count > 1 else ''}")
    if male_count >= 1:
        scene_tags.insert(0, f"{male_count}boy{'s' if male_count > 1 else ''}")
    if other_count >= 1:
        scene_tags.insert(0, f"{other_count}other{'s' if other_count > 1 else ''}")

    if random.random() < 0.8:
        background_type = select_weighted_option(backgroundTypesL, condition_set)
        scene_tags.append(background_type)
        if background_type == "scenery" and random.random() < 0.5:
            scenery_elements_count = random.randint(1, 3)
            for _ in range(scenery_elements_count):
                # Add scenery elements
                scene_tags.append(select_weighted_option(sceneElementsL, condition_set))

    # 添加镜头角度
    if random.random() < 0.3:
        scene_tags.append(select_weighted_option(cameraAnglesL, condition_set))

    # 添加镜头构图
    framing_type = select_weighted_option(framingTypesL, condition_set) if random.random() < 0.7 else None
    if framing_type:
        scene_tags.append(framing_type)

    # 为女性生成外貌描述
    for _ in range(female_count):
        female_appearance = ["girl"] + generate_appearance(condition_set, "f", framing_type, character_count)
        character_details.append(female_appearance)

    # 为男性生成外貌描述
    for _ in range(male_count):
        male_appearance = ["boy"] + generate_appearance(condition_set, "m", framing_type, character_count)
        character_details.append(male_appearance)

    # 为其他生成外貌描述
    for _ in range(other_count):
        other_appearance = ["other"] + generate_appearance(condition_set, "o", framing_type, character_count)
        character_details.append(other_appearance)

    # 添加场景元素
    if random.random() < 0.2:
        object_count = random.randint(0, 4)
        if character_count == 2:
            object_count = random.randint(0, 3)
        for _ in range(object_count):
            scene_tags.append(select_weighted_option(objectsAndStuffedAnimalsL, condition_set))

    # 添加特效
    if random.random() < 0.25:
        effects_count = random.randint(1, 3)
        for _ in range(effects_count):
            scene_tags.append(select_weighted_option(effectsAndPatternsL, condition_set))

    # 添加年份主题
    if random.random() < 0.2:
        scene_tags.append(select_weighted_option(yearlyThemesL, condition_set))

    # 添加物体焦点
    if random.random() < 0.1:
        scene_tags.append(select_weighted_option(subjectFocusL, condition_set))

    # 去重
    scene_tags = list({tag: True for tag in scene_tags}.keys())
    return [
        ", ".join(scene_tags),
        *[", ".join(details) for details in character_details]
    ]


if __name__ == "__main__":
    print(generate_scene_composition())
