# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['backend',
 'backend.api',
 'backend.api.management',
 'backend.api.management.commands',
 'backend.api.migrations',
 'backend.api.tests',
 'backend.auto_labeling',
 'backend.auto_labeling.migrations',
 'backend.auto_labeling.pipeline',
 'backend.auto_labeling.tests',
 'backend.config',
 'backend.config.settings',
 'backend.data_export',
 'backend.data_export.migrations',
 'backend.data_export.pipeline',
 'backend.data_export.tests',
 'backend.data_import',
 'backend.data_import.migrations',
 'backend.data_import.pipeline',
 'backend.data_import.tests',
 'backend.examples',
 'backend.examples.migrations',
 'backend.examples.tests',
 'backend.examples.views',
 'backend.label_types',
 'backend.label_types.migrations',
 'backend.label_types.tests',
 'backend.labels',
 'backend.labels.migrations',
 'backend.labels.tests',
 'backend.metrics',
 'backend.metrics.migrations',
 'backend.projects',
 'backend.projects.management',
 'backend.projects.management.commands',
 'backend.projects.migrations',
 'backend.projects.tests',
 'backend.projects.views',
 'backend.roles',
 'backend.roles.management',
 'backend.roles.management.commands',
 'backend.roles.migrations',
 'backend.roles.tests',
 'backend.users',
 'backend.users.migrations',
 'backend.users.tests']

package_data = \
{'': ['*'],
 'backend': ['client/dist/*',
             'client/dist/auth/*',
             'client/dist/de/*',
             'client/dist/de/auth/*',
             'client/dist/de/demo/image-classification/*',
             'client/dist/de/demo/intent-detection-and-slot-filling/*',
             'client/dist/de/demo/named-entity-recognition/*',
             'client/dist/de/demo/sentiment-analysis/*',
             'client/dist/de/demo/speech-to-text/*',
             'client/dist/de/demo/text-to-sql/*',
             'client/dist/de/demo/translation/*',
             'client/dist/de/projects/*',
             'client/dist/de/projects/create/*',
             'client/dist/demo/image-classification/*',
             'client/dist/demo/intent-detection-and-slot-filling/*',
             'client/dist/demo/named-entity-recognition/*',
             'client/dist/demo/sentiment-analysis/*',
             'client/dist/demo/speech-to-text/*',
             'client/dist/demo/text-to-sql/*',
             'client/dist/demo/translation/*',
             'client/dist/formats/generic/upload/*',
             'client/dist/formats/seq2seq/download/*',
             'client/dist/formats/seq2seq/upload/*',
             'client/dist/formats/sequence_labeling/download/*',
             'client/dist/formats/sequence_labeling/upload/*',
             'client/dist/formats/text_classification/download/*',
             'client/dist/formats/text_classification/upload/*',
             'client/dist/fr/*',
             'client/dist/fr/auth/*',
             'client/dist/fr/demo/image-classification/*',
             'client/dist/fr/demo/intent-detection-and-slot-filling/*',
             'client/dist/fr/demo/named-entity-recognition/*',
             'client/dist/fr/demo/sentiment-analysis/*',
             'client/dist/fr/demo/speech-to-text/*',
             'client/dist/fr/demo/text-to-sql/*',
             'client/dist/fr/demo/translation/*',
             'client/dist/fr/projects/*',
             'client/dist/fr/projects/create/*',
             'client/dist/images/*',
             'client/dist/projects/*',
             'client/dist/projects/create/*',
             'client/dist/static/_nuxt/*',
             'client/dist/static/_nuxt/assets/examples/*',
             'client/dist/static/_nuxt/fonts/*',
             'client/dist/static/_nuxt/img/*',
             'client/dist/zh/*',
             'client/dist/zh/auth/*',
             'client/dist/zh/demo/image-classification/*',
             'client/dist/zh/demo/intent-detection-and-slot-filling/*',
             'client/dist/zh/demo/named-entity-recognition/*',
             'client/dist/zh/demo/sentiment-analysis/*',
             'client/dist/zh/demo/speech-to-text/*',
             'client/dist/zh/demo/text-to-sql/*',
             'client/dist/zh/demo/translation/*',
             'client/dist/zh/projects/*',
             'client/dist/zh/projects/create/*',
             'staticfiles/_nuxt/*',
             'staticfiles/_nuxt/assets/examples/*',
             'staticfiles/_nuxt/fonts/*',
             'staticfiles/_nuxt/img/*',
             'staticfiles/admin/css/*',
             'staticfiles/admin/css/vendor/select2/*',
             'staticfiles/admin/fonts/*',
             'staticfiles/admin/img/*',
             'staticfiles/admin/img/gis/*',
             'staticfiles/admin/js/*',
             'staticfiles/admin/js/admin/*',
             'staticfiles/admin/js/vendor/jquery/*',
             'staticfiles/admin/js/vendor/select2/*',
             'staticfiles/admin/js/vendor/select2/i18n/*',
             'staticfiles/admin/js/vendor/xregexp/*',
             'staticfiles/drf-yasg/*',
             'staticfiles/drf-yasg/redoc-old/*',
             'staticfiles/drf-yasg/redoc/*',
             'staticfiles/drf-yasg/swagger-ui-dist/*',
             'staticfiles/polymorphic/css/*',
             'staticfiles/polymorphic/js/*',
             'staticfiles/rest_framework/css/*',
             'staticfiles/rest_framework/docs/css/*',
             'staticfiles/rest_framework/docs/img/*',
             'staticfiles/rest_framework/docs/js/*',
             'staticfiles/rest_framework/fonts/*',
             'staticfiles/rest_framework/img/*',
             'staticfiles/rest_framework/js/*'],
 'backend.data_export.pipeline': ['examples/image_classification/*',
                                  'examples/intent_detection/*',
                                  'examples/relation_extraction/*',
                                  'examples/sequence_labeling/*',
                                  'examples/sequence_to_sequence/*',
                                  'examples/speech_to_text/*',
                                  'examples/text_classification/*'],
 'backend.data_import.pipeline': ['examples/image_classification/*',
                                  'examples/intent_detection/*',
                                  'examples/relation_extraction/*',
                                  'examples/sequence_labeling/*',
                                  'examples/sequence_to_sequence/*',
                                  'examples/speech_to_text/*',
                                  'examples/task_agnostic/*',
                                  'examples/text_classification/*'],
 'backend.data_import.tests': ['data/*',
                               'data/images/*',
                               'data/intent/*',
                               'data/relation_extraction/*',
                               'data/seq2seq/*',
                               'data/sequence_labeling/*',
                               'data/text_classification/*'],
 'backend.label_types.tests': ['data/*']}

install_requires = \
['Django>=4.0.2,<5.0.0',
 'SQLAlchemy>=1.4.31,<2.0.0',
 'auto-labeling-pipeline>=0.1.21,<0.2.0',
 'celery>=5.2.3,<6.0.0',
 'chardet>=4.0.0,<5.0.0',
 'dj-database-url>=0.5.0,<0.6.0',
 'dj-rest-auth>=2.2.3,<3.0.0',
 'django-celery-results==2.2.0',
 'django-cleanup>=6.0.0,<7.0.0',
 'django-cors-headers>=3.11.0,<4.0.0',
 'django-drf-filepond>=0.4.1,<0.5.0',
 'django-filter>=21.1,<22.0',
 'django-health-check>=3.16.5,<4.0.0',
 'django-polymorphic>=3.1.0,<4.0.0',
 'django-rest-polymorphic>=0.1.9,<0.2.0',
 'django-storages[google]>=1.12.3,<2.0.0',
 'djangorestframework-xml>=2.0.0,<3.0.0',
 'djangorestframework>=3.13.1,<4.0.0',
 'drf-yasg>=1.20.0,<2.0.0',
 'environs>=9.5.0,<10.0.0',
 'filetype>=1.0.10,<2.0.0',
 'furl>=2.1.3,<3.0.0',
 'gunicorn>=20.1.0,<21.0.0',
 'pandas>=1.4.2,<2.0.0',
 'pyexcel-xlsx>=0.6.0,<0.7.0',
 'pyexcel>=0.7.0,<0.8.0',
 'seqeval>=1.2.2,<2.0.0',
 'waitress>=2.0.0,<3.0.0',
 'whitenoise>=6.0.0,<7.0.0']

entry_points = \
{'console_scripts': ['doccano = backend.cli:main']}

setup_kwargs = {
    'name': 'doccano',
    'version': '1.7.0',
    'description': 'doccano, text annotation tool for machine learning practitioners',
    'long_description': '<div align="center">\n  <img src="https://raw.githubusercontent.com/doccano/doccano/master/docs/images/logo/doccano.png">\n</div>\n\n# doccano\n\n[![Codacy Badge](https://app.codacy.com/project/badge/Grade/35ac8625a2bc4eddbff23dbc61bc6abb)](https://www.codacy.com/gh/doccano/doccano/dashboard?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=doccano/doccano&amp;utm_campaign=Badge_Grade)\n[![doccano CI](https://github.com/doccano/doccano/actions/workflows/ci.yml/badge.svg)](https://github.com/doccano/doccano/actions/workflows/ci.yml)\n\ndoccano is an open source text annotation tool for humans. It provides annotation features for text classification, sequence labeling and sequence to sequence tasks. So, you can create labeled data for sentiment analysis, named entity recognition, text summarization and so on. Just create a project, upload data and start annotating. You can build a dataset in hours.\n\n## Demo\n\nYou can try the [annotation demo](http://doccano.herokuapp.com).\n\n![Demo image](https://raw.githubusercontent.com/doccano/doccano/master/docs/images/demo/demo.gif)\n\n## Documentation\n\nRead the documentation at the <https://doccano.github.io/doccano/>.\n\n## Features\n\n- Collaborative annotation\n- Multi-language support\n- Mobile support\n- Emoji :smile: support\n- Dark theme\n- RESTful API\n\n## Usage\n\nThree options to run doccano:\n\n- pip (Python 3.8+)\n- Docker\n- Docker Compose\n\n### pip\n\nTo install doccano, simply run:\n\n```bash\npip install doccano\n```\n\nBy default, SQLite 3 is used for the default database. If you want to use PostgreSQL, install the additional dependencies:\n\n```bash\npip install \'doccano[postgresql]\'\n```\nand set `DATABASE_URL` environment variable according to your PostgreSQL credentials:\n```bash\nDATABASE_URL="postgres://${POSTGRES_USER}:${POSTGRES_PASSWORD}@${POSTGRES_HOST}:${POSTGRES_PORT}/${POSTGRES_DB}?sslmode=disable"\n```\n\nAfter installation, run the following commands:\n\n```bash\n# Initialize database.\ndoccano init\n# Create a super user.\ndoccano createuser --username admin --password pass\n# Start a web server.\ndoccano webserver --port 8000\n```\n\nIn another terminal, run the following command:\n\n```bash\n# Start the task queue to handle file upload/download.\ndoccano task\n```\n\nGo to <http://127.0.0.1:8000/>.\n\n### Docker\n\nAs a one-time setup, create a Docker container as follows:\n\n```bash\ndocker pull doccano/doccano\ndocker container create --name doccano \\\n  -e "ADMIN_USERNAME=admin" \\\n  -e "ADMIN_EMAIL=admin@example.com" \\\n  -e "ADMIN_PASSWORD=password" \\\n  -v doccano-db:/data \\\n  -p 8000:8000 doccano/doccano\n```\n\nNext, start doccano by running the container:\n\n```bash\ndocker container start doccano\n```\n\nGo to <http://127.0.0.1:8000/>.\n\nTo stop the container, run `docker container stop doccano -t 5`.\nAll data created in the container will persist across restarts.\n\n### Docker Compose\n\nYou need to install Git and to clone the repository:\n\n```bash\ngit clone https://github.com/doccano/doccano.git\ncd doccano\n```\n\n_Note for Windows developers:_ Be sure to configure git to correctly handle line endings or you may encounter `status code 127` errors while running the services in future steps. Running with the git config options below will ensure your git directory correctly handles line endings.\n\n```bash\ngit clone https://github.com/doccano/doccano.git --config core.autocrlf=input\n```\n\nThen, create an `.env` file with variables in the following format (see [./docker/.env.example](https://github.com/doccano/doccano/blob/master/docker/.env.example)):\n\n```plain\n# platform settings\nADMIN_USERNAME=admin\nADMIN_PASSWORD=password\nADMIN_EMAIL=admin@example.com\n\n# rabbit mq settings\nRABBITMQ_DEFAULT_USER=doccano\nRABBITMQ_DEFAULT_PASS=doccano\n\n# database settings\nPOSTGRES_USER=doccano\nPOSTGRES_PASSWORD=doccano\nPOSTGRES_DB=doccano\n```\n\nAfter running the following command, access <http://127.0.0.1/>.\n\n```bash\ndocker-compose -f docker/docker-compose.prod.yml --env-file .env up\n```\n\n### One-click Deployment\n\n| Service | Button |\n|---------|---|\n| AWS[^1]   | [![AWS CloudFormation Launch Stack SVG Button](https://cdn.rawgit.com/buildkite/cloudformation-launch-stack-button-svg/master/launch-stack.svg)](https://console.aws.amazon.com/cloudformation/home?#/stacks/new?stackName=doccano&templateURL=https://doccano.s3.amazonaws.com/public/cloudformation/template.aws.yaml)  |\n| Heroku  | [![Deploy](https://www.herokucdn.com/deploy/button.svg)](https://dashboard.heroku.com/new?template=https%3A%2F%2Fgithub.com%2Fdoccano%2Fdoccano)  |\n<!-- | GCP[^2] | [![GCP Cloud Run PNG Button](https://storage.googleapis.com/gweb-cloudblog-publish/images/run_on_google_cloud.max-300x300.png)](https://console.cloud.google.com/cloudshell/editor?shellonly=true&cloudshell_image=gcr.io/cloudrun/button&cloudshell_git_repo=https://github.com/doccano/doccano.git&cloudshell_git_branch=CloudRunButton)  | -->\n\n> [^1]: (1) EC2 KeyPair cannot be created automatically, so make sure you have an existing EC2 KeyPair in one region. Or [create one yourself](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html#having-ec2-create-your-key-pair). (2) If you want to access doccano via HTTPS in AWS, here is an [instruction](https://github.com/doccano/doccano/wiki/HTTPS-setting-for-doccano-in-AWS).\n<!-- > [^2]: Although this is a very cheap option, it is only suitable for very small teams (up to 80 concurrent requests). Read more on [Cloud Run docs](https://cloud.google.com/run/docs/concepts). -->\n\n## FAQ\n\n- [How to create a user](https://doccano.github.io/doccano/faq/#how-to-create-a-user)\n- [How to add a user to your project](https://doccano.github.io/doccano/faq/#how-to-add-a-user-to-your-project)\n- [How to change the password](https://doccano.github.io/doccano/faq/#how-to-change-the-password)\n\nSee the [documentation](https://doccano.github.io/doccano/) for details.\n\n## Contribution\n\nAs with any software, doccano is under continuous development. If you have requests for features, please file an issue describing your request. Also, if you want to see work towards a specific feature, feel free to contribute by working towards it. The standard procedure is to fork the repository, add a feature, fix a bug, then file a pull request that your changes are to be merged into the main repository and included in the next release.\n\nHere are some tips might be helpful. [How to Contribute to Doccano Project](https://github.com/doccano/doccano/wiki/How-to-Contribute-to-Doccano-Project)\n\n## Citation\n\n```tex\n@misc{doccano,\n  title={{doccano}: Text Annotation Tool for Human},\n  url={https://github.com/doccano/doccano},\n  note={Software available from https://github.com/doccano/doccano},\n  author={\n    Hiroki Nakayama and\n    Takahiro Kubo and\n    Junya Kamura and\n    Yasufumi Taniguchi and\n    Xu Liang},\n  year={2018},\n}\n```\n\n## Contact\n\nFor help and feedback, please feel free to contact [the author](https://github.com/Hironsan).\n',
    'author': 'Hironsan',
    'author_email': 'hiroki.nakayama.py@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://doccano.github.io/doccano/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
