# Generated by Django 3.2.8 on 2022-01-13 01:54

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("roles", "0003_delete_member"),
        ("api", "0028_auto_20220111_0655"),
    ]

    operations = [
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.CreateModel(
                    name="Member",
                    fields=[
                        (
                            "id",
                            models.BigAutoField(
                                auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                            ),
                        ),
                        ("created_at", models.DateTimeField(auto_now_add=True)),
                        ("updated_at", models.DateTimeField(auto_now=True)),
                        (
                            "project",
                            models.ForeignKey(
                                on_delete=django.db.models.deletion.CASCADE,
                                related_name="role_mappings",
                                to="api.project",
                            ),
                        ),
                        ("role", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="roles.role")),
                        (
                            "user",
                            models.ForeignKey(
                                on_delete=django.db.models.deletion.CASCADE,
                                related_name="role_mappings",
                                to=settings.AUTH_USER_MODEL,
                            ),
                        ),
                    ],
                    options={
                        "unique_together": {("user", "project")},
                    },
                ),
            ],
            database_operations=[],
        ),
        migrations.RunSQL(
            sql="ALTER TABLE members_member RENAME TO projects_member",
            reverse_sql="ALTER TABLE projects_member RENAME TO members_member",
        ),
        migrations.RunSQL(
            sql="UPDATE django_content_type SET app_label='projects' WHERE app_label='members'",
            reverse_sql="UPDATE django_content_type SET app_label='members' WHERE app_label='projects'",
        ),
        migrations.RunSQL(
            sql="UPDATE django_migrations SET app='projects' WHERE app='members'",
            reverse_sql="UPDATE django_migrations SET app='members' WHERE app='projects'",
        ),
    ]
