# query-log-tracer

[![PyPI](https://img.shields.io/pypi/v/query-log-tracer)](https://pypi.org/project/query-log-tracer/)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/query-log-tracer)](https://pypi.org/project/query-log-tracer/)
[![GitHub Repo Size](https://img.shields.io/github/repo-size/kotarot/query-log-tracer)](https://github.com/kotarot/query-log-tracer)
[![GitHub Workflow Status](https://img.shields.io/github/workflow/status/kotarot/query-log-tracer/Continuous%20Integration)](https://github.com/kotarot/query-log-tracer/actions?query=workflow%3AContinuous%20Integration)
[![GitHub License](https://img.shields.io/github/license/kotarot/query-log-tracer)](https://github.com/kotarot/query-log-tracer/blob/main/LICENSE)

A Python tool/library that traces a value in MySQL general logs.

## Usage

### Set up

```
$ pip install query-log-tracer
```

### Example usage

`./tests/files/general-query.log` is a sample query log file of MySQL 5.7. Most of the queries are generated by EC-CUBE 4.

```
$ query-log-tracer --log-file=./tests/files/general-query.log --target-table=dtb_customer --target-column=point --filter-column=id --filter-value=1
=== Searching in ./tests/files/general-query.log ===

2020-02-02T07:19:51.127168Z dtb_customer.point (id = 1) is set: '0'
2020-02-02T07:20:19.927027Z dtb_customer.point (id = 1) is set: '0'
2020-02-02T07:20:26.901577Z dtb_customer.point (id = 1) is set: '100'
2020-02-02T07:20:31.034901Z dtb_customer.point (id = 1) is set: '1000'
2020-02-02T07:20:39.396236Z dtb_customer.point (id = 1) is set: '2000'
2020-02-02T07:20:46.379143Z dtb_customer.point (id = 1) is set: '0'
2020-02-02T07:26:37.443522Z dtb_customer.point (id = 1) is set: '0'
2020-02-02T07:26:55.216881Z dtb_customer.point (id = 1) is set: '0'
2020-02-02T07:27:13.008757Z dtb_customer.point (id = 1) is set: '50'
2020-02-02T07:28:01.128957Z dtb_customer.point (id = 1) is set: '0'
2020-02-02T07:28:09.995354Z dtb_customer.point (id = 1) is set: '0'
2020-02-02T07:28:14.172518Z dtb_customer.point (id = 1) is set: '27'
2020-02-02T07:33:41.745400Z dtb_customer.point (id = 1) changes: +500
```

For EC-CUBE 2, try the following command.

```
$ query-log-tracer --log-dir=your-directory --target-table=dtb_customer --target-column=point --filter-column=customer_id --filter-value=1
```
